/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.view;

import androidx.compose.foundation.ClickableKt;
import androidx.compose.foundation.FocusableKt;
import androidx.compose.foundation.layout.BoxKt;
import androidx.compose.foundation.layout.BoxScope;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.focus.FocusRequesterModifierKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.LinkAnnotation;
import fleet.ai.frontend.api.internal.AiChatSource;
import fleet.ai.frontend.api.internal.AiReports;
import fleet.ai.frontend.api.internal.ChatMessageChunk;
import fleet.ai.frontend.markdown.InlineLinkInfo;
import fleet.ai.frontend.markdown.SimpleMarkdownKt;
import fleet.common.FusEntityKt;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.ThemedAnnotatedStringBuilder;
import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.text.FontFeatureTag;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.compose.theme.text.TextSpec;
import fleet.frontend.actions.FleetDataKeysKt;
import fleet.util.UID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.NoriaContext;
import noria.impl.Runtime;
import noria.model.ActionContext;
import noria.model.Theme;
import noria.ui.core.BoundaryKt;
import noria.ui.events.HandlerScope;
import noria.windowManagement.api.WindowManager;
import noria.windowManagement.extensions.WindowManagerKt;
import org.intellij.markdown.ast.ASTNode;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003\u001a\u0014\u0010\u000b\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\fH\u0003\u001a,\u0010\r\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"DOCUMENTATION_LINK_PREFIX", "", "renderMarkdownTextChunk", "", "Lnoria/NoriaContext;", "chunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Markdown;", "session", "Lfleet/util/UID;", "chatSource", "Lfleet/ai/frontend/api/internal/AiChatSource;", "renderPlainTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text$Plain;", "renderTextChunk", "Lfleet/ai/frontend/api/internal/ChatMessageChunk$Text;", "focus", "Landroidx/compose/ui/focus/FocusRequester;", "fleet.plugins.ai.frontend"})
public final class AiChatMessageTextKt {
    @NotNull
    private static final String DOCUMENTATION_LINK_PREFIX = "https://www.jetbrains.com/help/fleet";

    @Composable
    public static final void renderTextChunk(@NotNull NoriaContext $this$renderTextChunk, @NotNull ChatMessageChunk.Text chunk, @NotNull UID session, @NotNull AiChatSource chatSource, @NotNull FocusRequester focus) {
        Intrinsics.checkNotNullParameter((Object)$this$renderTextChunk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)chatSource), (String)"chatSource");
        Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
        Runtime.enterScope((NoriaContext)$this$renderTextChunk, (int)556);
        Object[] objectArray = new Object[]{focus, chunk, session, chatSource};
        BoundaryKt.boundary((NoriaContext)$this$renderTextChunk, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(focus, chunk, session, chatSource){
            final /* synthetic */ FocusRequester $focus;
            final /* synthetic */ ChatMessageChunk.Text $chunk;
            final /* synthetic */ UID $session;
            final /* synthetic */ AiChatSource $chatSource;
            {
                this.$focus = $focus;
                this.$chunk = $chunk;
                this.$session = $session;
                this.$chatSource = $chatSource;
                super(1);
            }

            public final void invoke(@NotNull NoriaContext $this$boundary) {
                Intrinsics.checkNotNullParameter((Object)$this$boundary, (String)"$this$boundary");
                Object[] objectArray = new Object[]{this.$chunk, this.$session, this.$chatSource};
                BoxKt.Box$default((NoriaContext)$this$boundary, (Modifier)ClickableKt.clickable-XHw0xAI$default((Modifier)FocusRequesterModifierKt.focusRequester((Modifier)((Modifier)Modifier.Companion), (FocusRequester)this.$focus), (boolean)false, null, null, (Function0)((Function0)new Function0<Unit>(this.$focus){
                    final /* synthetic */ FocusRequester $focus;
                    {
                        this.$focus = $focus;
                        super(0);
                    }

                    public final void invoke() {
                        this.$focus.requestFocus();
                    }
                }), (int)7, null), null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<BoxScope, Unit>(this.$chunk, this.$session, this.$chatSource){
                    final /* synthetic */ ChatMessageChunk.Text $chunk;
                    final /* synthetic */ UID $session;
                    final /* synthetic */ AiChatSource $chatSource;
                    {
                        this.$chunk = $chunk;
                        this.$session = $session;
                        this.$chatSource = $chatSource;
                        super(1);
                    }

                    public final void invoke(@NotNull BoxScope $this$Box) {
                        Intrinsics.checkNotNullParameter((Object)$this$Box, (String)"$this$Box");
                        ChatMessageChunk.Text text2 = this.$chunk;
                        if (text2 instanceof ChatMessageChunk.Text.Plain) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Box), (int)554);
                            AiChatMessageTextKt.access$renderPlainTextChunk((NoriaContext)$this$Box, (ChatMessageChunk.Text.Plain)this.$chunk);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Box));
                        } else if (text2 instanceof ChatMessageChunk.Text.Markdown) {
                            Runtime.enterScope((NoriaContext)((NoriaContext)$this$Box), (int)555);
                            AiChatMessageTextKt.access$renderMarkdownTextChunk((NoriaContext)$this$Box, (ChatMessageChunk.Text.Markdown)this.$chunk, this.$session, this.$chatSource);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)((NoriaContext)$this$Box));
                        }
                    }
                })), (int)6, null);
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderTextChunk);
    }

    @Composable
    private static final void renderPlainTextChunk(NoriaContext $this$renderPlainTextChunk, ChatMessageChunk.Text.Plain chunk) {
        Runtime.enterScope((NoriaContext)$this$renderPlainTextChunk, (int)557);
        TextKt.UiText-1ODQ_eA$default((NoriaContext)$this$renderPlainTextChunk, (String)((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString(), (long)0L, null, null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, (Modifier)FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null), (int)494, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderPlainTextChunk);
    }

    @Composable
    private static final void renderMarkdownTextChunk(NoriaContext $this$renderMarkdownTextChunk, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        String content2 = ((Object)StringsKt.trim((CharSequence)chunk.getContent())).toString();
        Theme theme = (Theme)$this$renderMarkdownTextChunk.getCurrent((CompositionLocal)CompositionLocalsKt.getLocalTheme());
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)558);
        AnnotatedString annotatedString = SimpleMarkdownKt.markdownToAnnotatedString($this$renderMarkdownTextChunk, content2, (Function2<? super ThemedAnnotatedStringBuilder, ? super ASTNode, Boolean>)((Function2)new Function2<ThemedAnnotatedStringBuilder, ASTNode, Boolean>(content2, theme){
            final /* synthetic */ String $content;
            final /* synthetic */ Theme $theme;
            {
                this.$content = $content;
                this.$theme = $theme;
                super(2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ThemedAnnotatedStringBuilder $this$markdownToAnnotatedString, @NotNull ASTNode node) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)$this$markdownToAnnotatedString, (String)"$this$markdownToAnnotatedString");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                InlineLinkInfo inlineLinkInfo = SimpleMarkdownKt.isInlineLink(node, this.$content);
                if (inlineLinkInfo != null) {
                    InlineLinkInfo inlineLinkInfo2;
                    InlineLinkInfo it = inlineLinkInfo2 = inlineLinkInfo;
                    boolean bl2 = false;
                    inlineLinkInfo = StringsKt.startsWith$default((String)it.getLinkDest(), (String)"https://www.jetbrains.com/help/fleet", (boolean)false, (int)2, null) ? inlineLinkInfo2 : null;
                    if (inlineLinkInfo != null) {
                        InlineLinkInfo inlineLinkInfo3 = inlineLinkInfo;
                        Theme theme = this.$theme;
                        InlineLinkInfo linkInfo = inlineLinkInfo3;
                        boolean bl3 = false;
                        TextSpec defaultSpec = theme.textSpec(TextStyleKeys.INSTANCE.getDefault());
                        TextSpec superscriptTextSpec = TextSpec.copy-76MNOIk$default((TextSpec)defaultSpec, null, null, (long)0L, (long)0L, (float)0.0f, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)FontFeatureTag.box-impl((String)FontFeatureTag.Companion.getSups-yd_S18Q()), (Object)1)), (int)0, (int)95, null);
                        ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$markdownToAnnotatedString, (String)linkInfo.getLinkText(), null, (TextSpec)superscriptTextSpec, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Clickable(linkInfo.getLinkDest())), (int)122, null);
                        bl = true;
                        return bl;
                    }
                }
                InlineLinkInfo inlineLinkInfo4 = SimpleMarkdownKt.isInlineLink(node, this.$content);
                if (inlineLinkInfo4 != null) {
                    InlineLinkInfo linkInfo = inlineLinkInfo4;
                    boolean bl4 = false;
                    ThemedAnnotatedStringBuilder.link-tPsuSCI$default((ThemedAnnotatedStringBuilder)$this$markdownToAnnotatedString, (String)linkInfo.getLinkText(), null, null, null, null, (boolean)false, null, (LinkAnnotation)((LinkAnnotation)new LinkAnnotation.Clickable(linkInfo.getLinkDest())), (int)126, null);
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }));
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
        AnnotatedString text2 = annotatedString;
        Runtime.enterScope((NoriaContext)$this$renderMarkdownTextChunk, (int)559);
        Object[] objectArray = new Object[]{session, chatSource};
        TextKt.UiText-Uas3SEs$default((NoriaContext)$this$renderMarkdownTextChunk, (AnnotatedString)text2, (long)0L, null, null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getMultiline(), null, null, null, null, (Modifier)FocusableKt.focusable$default((Modifier)((Modifier)Modifier.Companion), (boolean)false, null, (int)3, null), null, (Function2)((Function2)Runtime.closure((Object[])objectArray, (Object)new Function2<HandlerScope, LinkAnnotation, Unit>(session, chatSource){
            final /* synthetic */ UID $session;
            final /* synthetic */ AiChatSource $chatSource;
            {
                this.$session = $session;
                this.$chatSource = $chatSource;
                super(2);
            }

            public final void invoke(@NotNull HandlerScope $this$UiText, @NotNull LinkAnnotation linkAnnotation) {
                Intrinsics.checkNotNullParameter((Object)$this$UiText, (String)"$this$UiText");
                Intrinsics.checkNotNullParameter((Object)linkAnnotation, (String)"linkAnnotation");
                if (linkAnnotation instanceof LinkAnnotation.Clickable) {
                    boolean isDocumentationLink = StringsKt.startsWith$default((String)((LinkAnnotation.Clickable)linkAnnotation).getTag(), (String)"https://www.jetbrains.com/help/fleet", (boolean)false, (int)2, null);
                    FusEntityKt.log(AiReports.INSTANCE.getNavigateToLink$fleet_plugins_ai_frontend(), (Object)this.$session.getId(), (Object)((Object)this.$chatSource), (Object)isDocumentationLink);
                    WindowManagerKt.openUrl((WindowManager)FleetDataKeysKt.getWindowManager((ActionContext)$this$UiText.getActionContext()), (String)((LinkAnnotation.Clickable)linkAnnotation).getTag());
                }
            }
        })), (int)1518, null);
        annotatedString = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$renderMarkdownTextChunk);
    }

    public static final /* synthetic */ void access$renderPlainTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Plain chunk) {
        AiChatMessageTextKt.renderPlainTextChunk($receiver, chunk);
    }

    public static final /* synthetic */ void access$renderMarkdownTextChunk(NoriaContext $receiver, ChatMessageChunk.Text.Markdown chunk, UID session, AiChatSource chatSource) {
        AiChatMessageTextKt.renderMarkdownTextChunk($receiver, chunk, session, chatSource);
    }
}

