/*
 * Decompiled with CFR 0.152.
 */
package fleet.ai.frontend.api.internal;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.Modifier;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import fleet.ai.frontend.AiActionIds;
import fleet.ai.frontend.api.AiChatType;
import fleet.ai.frontend.api.internal.AiChatEntity;
import fleet.ai.frontend.api.internal.AiChatLocation;
import fleet.ai.frontend.api.internal.AiChatViewTypeKt;
import fleet.ai.frontend.api.internal.AiReports;
import fleet.ai.frontend.api.internal.GotoRecentAiChat;
import fleet.ai.frontend.api.internal.GotoRecentAiChat$search$;
import fleet.ai.frontend.api.internal.GotoRecentAiChatItem;
import fleet.common.FusEntityKt;
import fleet.compose.theme.components.ButtonKt;
import fleet.compose.theme.components.ButtonStyle;
import fleet.compose.theme.components.modifiers.TooltipModifierKt;
import fleet.frontend.KernelExtKt;
import fleet.frontend.actions.FleetDataKeys;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.layout.ShowOpts;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.navigation.ViewEntity;
import fleet.frontend.navigation.ViewKt;
import fleet.frontend.ui.gotoPanel.GotoProvider;
import fleet.frontend.ui.gotoPanel.GotoProviderFactory;
import fleet.frontend.ui.gotoPanel.GotoProviderSearchOption;
import fleet.frontend.ui.gotoPanel.GotoProviderWithSeparatedGroups;
import fleet.frontend.ui.gotoPanel.GotoProviderWithSeparatedGroupsResult;
import fleet.kernel.SagaKt;
import fleet.kernel.plugins.PluginScope;
import fleet.kernel.rete.QueriesKt;
import fleet.kernel.rete.Query;
import fleet.kernel.rete.ReteKt;
import fleet.navigation.common.api.ViewTypeId;
import fleet.util.DateUtilKt;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import noria.model.ActionContext;
import noria.model.ActionId;
import noria.model.ActionsKt;
import noria.model.FocusDataKey;
import noria.model.ThemeKey;
import noria.model.Trigger;
import noria.ui.events.HandlerScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0002H\u0017\u00a2\u0006\u0002\u0010\u0018J>\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lfleet/ai/frontend/api/internal/GotoRecentAiChat;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithSeparatedGroups;", "Lfleet/ai/frontend/api/internal/GotoRecentAiChatItem;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "(Lfleet/kernel/plugins/PluginScope;)V", "getPluginScope", "()Lfleet/kernel/plugins/PluginScope;", "reactive", "", "getReactive", "()Z", "emptyText", "", "itemName", "item", "onConfirm", "actionContext", "Lnoria/model/ActionContext;", "confirmedItem", "renderSuffixButton", "", "noriaContext", "Lnoria/NoriaContext;", "(Lnoria/NoriaContext;Lfleet/ai/frontend/api/internal/GotoRecentAiChatItem;)Lkotlin/Unit;", "search", "Lkotlinx/coroutines/flow/Flow;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithSeparatedGroupsResult;", "queryText", "options", "", "Lfleet/frontend/ui/gotoPanel/GotoProviderSearchOption;", "limit", "", "(Ljava/lang/String;Ljava/util/Map;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tailText", "Companion", "fleet.plugins.ai.frontend"})
@SourceDebugExtension(value={"SMAP\nGotoRecentChatAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoRecentChatAction.kt\nfleet/ai/frontend/api/internal/GotoRecentAiChat\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,157:1\n49#2:158\n51#2:162\n46#3:159\n51#3:161\n105#4:160\n*S KotlinDebug\n*F\n+ 1 GotoRecentChatAction.kt\nfleet/ai/frontend/api/internal/GotoRecentAiChat\n*L\n145#1:158\n145#1:162\n145#1:159\n145#1:161\n145#1:160\n*E\n"})
final class GotoRecentAiChat
extends GotoProviderWithSeparatedGroups<GotoRecentAiChatItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginScope pluginScope;
    private final boolean reactive;
    @NotNull
    private static final GotoProviderFactory.ID Id = new GotoProviderFactory.ID("go-to-recent-chat");

    public GotoRecentAiChat(@NotNull PluginScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.pluginScope = pluginScope;
        this.reactive = true;
    }

    @NotNull
    public final PluginScope getPluginScope() {
        return this.pluginScope;
    }

    public boolean getReactive() {
        return this.reactive;
    }

    @NotNull
    public String itemName(@NotNull GotoRecentAiChatItem item) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GotoRecentAiChatItem gotoRecentAiChatItem = item;
        if (Intrinsics.areEqual((Object)gotoRecentAiChatItem, (Object)GotoRecentAiChatItem.NewAiAssistantTool.INSTANCE)) {
            object = "New AI Assistant Tool";
        } else if (gotoRecentAiChatItem instanceof GotoRecentAiChatItem.RecentAiChat) {
            object = (AiChatEntity)EntitiesKt.takeIfExists((Entity)((GotoRecentAiChatItem.RecentAiChat)item).getChat());
            if (object == null || (object = ((AiChatEntity)object).getName()) == null) {
                object = "";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public String tailText(@NotNull GotoRecentAiChatItem item) {
        String string;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GotoRecentAiChatItem gotoRecentAiChatItem = item;
        if (Intrinsics.areEqual((Object)gotoRecentAiChatItem, (Object)GotoRecentAiChatItem.NewAiAssistantTool.INSTANCE)) {
            string = null;
        } else if (gotoRecentAiChatItem instanceof GotoRecentAiChatItem.RecentAiChat) {
            AiChatEntity aiChatEntity = (AiChatEntity)EntitiesKt.takeIfExists((Entity)((GotoRecentAiChatItem.RecentAiChat)item).getChat());
            if (aiChatEntity != null) {
                long it = aiChatEntity.getDate();
                boolean bl = false;
                string = DateUtilKt.formatTimestamp((LocalDateTime)DateUtilKt.utcSeconds((long)(it / (long)1000)), (boolean)true);
            } else {
                string = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public boolean onConfirm(@NotNull ActionContext actionContext, @NotNull GotoRecentAiChatItem confirmedItem) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)confirmedItem, (String)"confirmedItem");
        GotoRecentAiChatItem gotoRecentAiChatItem = confirmedItem;
        if (Intrinsics.areEqual((Object)gotoRecentAiChatItem, (Object)GotoRecentAiChatItem.NewAiAssistantTool.INSTANCE)) {
            ActionsKt.performAction((ActionContext)actionContext, (ActionId)AiActionIds.INSTANCE.getNewAssistantTool());
        } else if (gotoRecentAiChatItem instanceof GotoRecentAiChatItem.RecentAiChat) {
            Entity[] entityArray = new Entity[]{((GotoRecentAiChatItem.RecentAiChat)confirmedItem).getChat()};
            SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.pluginScope), (Entity[])entityArray, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ViewEntity<AiChatLocation>>, Object>(confirmedItem, actionContext, null){
                int label;
                final /* synthetic */ GotoRecentAiChatItem $confirmedItem;
                final /* synthetic */ ActionContext $actionContext;
                {
                    this.$confirmedItem = $confirmedItem;
                    this.$actionContext = $actionContext;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ViewTypeId<AiChatLocation> viewTypeId = AiChatViewTypeKt.getAiChatViewType();
                            AiChatLocation aiChatLocation = new AiChatLocation(((GotoRecentAiChatItem.RecentAiChat)this.$confirmedItem).getChat().getUid(), ((GotoRecentAiChatItem.RecentAiChat)this.$confirmedItem).getChat().getSource(), AiChatType.Default);
                            Object object3 = this.$actionContext.get((FocusDataKey)FleetDataKeys.INSTANCE.getWindow());
                            Intrinsics.checkNotNull((Object)object3);
                            this.label = 1;
                            Object object4 = ViewKt.navigate(viewTypeId, (Object)aiChatLocation, (ShowOpts)new ShowOpts(false, false, false, false, false, false, null, false, null, false, false, null, (WindowEntity)object3, 4095, null), (Continuation)((Continuation)this));
                            if (object4 != object2) return object4;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return object4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ViewEntity<AiChatLocation>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)6, null);
        }
        return true;
    }

    @NotNull
    public String emptyText() {
        return "No chats found";
    }

    @Composable
    @Nullable
    public Unit renderSuffixButton(@NotNull NoriaContext noriaContext, @NotNull GotoRecentAiChatItem item) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)noriaContext, (String)"noriaContext");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GotoRecentAiChatItem gotoRecentAiChatItem = item;
        if (Intrinsics.areEqual((Object)gotoRecentAiChatItem, (Object)GotoRecentAiChatItem.NewAiAssistantTool.INSTANCE)) {
            unit = null;
        } else if (gotoRecentAiChatItem instanceof GotoRecentAiChatItem.RecentAiChat) {
            NoriaContext $this$renderSuffixButton_u24lambda_u241 = noriaContext;
            boolean bl = false;
            Runtime.enterScope((NoriaContext)$this$renderSuffixButton_u24lambda_u241, (int)30);
            Modifier modifier = TooltipModifierKt.tooltip$default((Modifier)((Modifier)Modifier.Companion), (String)"Delete Chat", null, (long)0L, (int)6, null);
            ThemeKey themeKey = IconKeys.INSTANCE.getClose();
            Runtime.enterScope((NoriaContext)$this$renderSuffixButton_u24lambda_u241, (int)29);
            Object[] objectArray = ButtonKt.ghostButtonStyle((NoriaContext)$this$renderSuffixButton_u24lambda_u241);
            Runtime.exitScope((NoriaContext)$this$renderSuffixButton_u24lambda_u241);
            Object[] objectArray2 = objectArray;
            objectArray = new Object[]{item, this};
            ButtonKt.Button$default((NoriaContext)$this$renderSuffixButton_u24lambda_u241, (Modifier)modifier, null, (ThemeKey)themeKey, null, (ButtonStyle)objectArray2, (boolean)false, null, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<HandlerScope, Unit>(item, this){
                final /* synthetic */ GotoRecentAiChatItem $item;
                final /* synthetic */ GotoRecentAiChat this$0;
                {
                    this.$item = $item;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull HandlerScope $this$Button) {
                    Intrinsics.checkNotNullParameter((Object)$this$Button, (String)"$this$Button");
                    FusEntityKt.log(AiReports.INSTANCE.getChatDeletedEvent$fleet_plugins_ai_frontend(), (Object)((GotoRecentAiChatItem.RecentAiChat)this.$item).getChat().getUid().getId());
                    this.this$0.getPluginScope().changeAsync((Function1)new Function1<ChangeScope, Unit>(this.$item){
                        final /* synthetic */ GotoRecentAiChatItem $item;
                        {
                            this.$item = $item;
                            super(1);
                        }

                        public final void invoke(@NotNull ChangeScope $this$changeAsync) {
                            Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                            $this$changeAsync.delete((Entity)((GotoRecentAiChatItem.RecentAiChat)this.$item).getChat());
                        }
                    });
                }
            })), (int)234, null);
            Runtime.exitScope((NoriaContext)$this$renderSuffixButton_u24lambda_u241);
            unit = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unit;
    }

    @Nullable
    public Object search(@NotNull String queryText, @NotNull Map<GotoProviderSearchOption, Boolean> options, int limit, @NotNull Continuation<? super Flow<GotoProviderWithSeparatedGroupsResult<GotoRecentAiChatItem>>> $completion) {
        Query chatsQuery2 = QueriesKt.query((Function0)search.chatsQuery.1.INSTANCE);
        Flow $this$map$iv = ReteKt.asValuesFlow((Query)chatsQuery2);
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return (Flow)new Flow<GotoProviderWithSeparatedGroupsResult<GotoRecentAiChatItem>>($this$unsafeTransform$iv$iv, queryText){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ String $queryText$inlined;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.$queryText$inlined = string;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$queryText$inlined){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ String $queryText$inlined;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.$queryText$inlined = string;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof search$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ search$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var9_10 = $this$map_u24lambda_u245;
                                (Continuation)$continuation;
                                chats = (List)value;
                                $i$a$-map-GotoRecentAiChat$search$2 = false;
                                var12_13 = new List[2];
                                var12_13[0] = CollectionsKt.listOf((Object)GotoRecentAiChatItem.NewAiAssistantTool.INSTANCE);
                                var13_14 = chats;
                                var14_15 = 1;
                                var15_16 = var12_13;
                                $i$f$map = false;
                                var17_18 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var22_23 = (AiChatEntity)item$iv$iv;
                                    var23_24 = destination$iv$iv;
                                    $i$a$-map-GotoRecentAiChat$search$2$1 = false;
                                    var23_24.add(new GotoRecentAiChatItem.RecentAiChat((AiChatEntity)e));
                                }
                                var23_24 = (List)destination$iv$iv;
                                var15_16[var14_15] = var23_24;
                                var25_26 = null;
                                var26_27 = this.$queryText$inlined;
                                var27_28 = CollectionsKt.listOf((Object[])var12_13);
                                $continuation.label = 1;
                                v0 = var9_10.emit((Object)new GotoProviderWithSeparatedGroupsResult(var27_28, var26_27, var25_26), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl50
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl50:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\n*\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lfleet/ai/frontend/api/internal/GotoRecentAiChat$Companion;", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithSeparatedGroupsResult;", "Lfleet/ai/frontend/api/internal/GotoRecentAiChatItem;", "()V", "Id", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "getId", "()Lfleet/frontend/ui/gotoPanel/GotoProviderFactory$ID;", "name", "", "getName", "()Ljava/lang/String;", "plaqueText", "getPlaqueText", "trigger", "Lnoria/model/Trigger;", "getTrigger", "()Lnoria/model/Trigger;", "useSelectionForInitialQuery", "", "getUseSelectionForInitialQuery", "()Z", "placeholderText", "Lnoria/ReadScope;", "getPlaceholderText", "(Lnoria/ReadScope;)Ljava/lang/String;", "createProvider", "Lfleet/frontend/ui/gotoPanel/GotoProvider;", "Lnoria/NoriaContext;", "actionContext", "Lnoria/model/ActionContext;", "fleet.plugins.ai.frontend"})
    public static final class Companion
    implements GotoProviderFactory<GotoProviderWithSeparatedGroupsResult<GotoRecentAiChatItem>> {
        private Companion() {
        }

        @NotNull
        public final GotoProviderFactory.ID getId() {
            return Id;
        }

        @NotNull
        public String getName() {
            return "AI Chats";
        }

        @NotNull
        public String getPlaqueText() {
            return "AI Chats";
        }

        @Nullable
        public Trigger getTrigger() {
            return (Trigger)AiActionIds.INSTANCE.getRecentChats();
        }

        public boolean getUseSelectionForInitialQuery() {
            return false;
        }

        @Composable
        @NotNull
        public GotoProvider<GotoProviderWithSeparatedGroupsResult<GotoRecentAiChatItem>> createProvider(@NotNull NoriaContext $this$createProvider, @NotNull ActionContext actionContext) {
            Intrinsics.checkNotNullParameter((Object)$this$createProvider, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            return (GotoProvider)new GotoRecentAiChat((PluginScope)$this$createProvider.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope()));
        }

        @NotNull
        public String getPlaceholderText(@NotNull ReadScope $this$placeholderText) {
            Intrinsics.checkNotNullParameter((Object)$this$placeholderText, (String)"<this>");
            return "Search AI chats";
        }

        @NotNull
        public List<GotoProviderFactory.ID> getChildScopes() {
            return GotoProviderFactory.DefaultImpls.getChildScopes((GotoProviderFactory)this);
        }

        public boolean getReuseQueryFromOtherProviders() {
            return GotoProviderFactory.DefaultImpls.getReuseQueryFromOtherProviders((GotoProviderFactory)this);
        }

        @Composable
        @Nullable
        public String queryHint(@NotNull NoriaContext $this$queryHint) {
            return GotoProviderFactory.DefaultImpls.queryHint((GotoProviderFactory)this, (NoriaContext)$this$queryHint);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

