/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.vim.frontend.ui;

import androidx.compose.runtime.Composable;
import androidx.compose.ui.graphics.Color;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import fleet.common.document.EditorEntity;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.TextSpec;
import fleet.frontend.document.DocumentEntityExtKt;
import fleet.frontend.editor.StatusBarWidget;
import fleet.frontend.editor.WidgetGroup;
import fleet.frontend.editor.WidgetPlacement;
import fleet.plugins.vim.frontend.FleetVimKt;
import fleet.plugins.vim.frontend.SettingsKeyKt;
import fleet.plugins.vim.frontend.model.FleetVimState;
import fleet.plugins.vim.frontend.ui.ShowCmdWidgetKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0005H\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lfleet/plugins/vim/frontend/ui/ShowCmdWidget;", "Lfleet/frontend/editor/StatusBarWidget;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "widgetGroup", "Lfleet/frontend/editor/WidgetGroup;", "getWidgetGroup", "()Lfleet/frontend/editor/WidgetGroup;", "placementRequests", "", "Lfleet/frontend/editor/WidgetPlacement;", "getPlacementRequests", "()Ljava/util/Set;", "render", "", "noriaContext", "Lnoria/NoriaContext;", "editorEntity", "Lfleet/common/document/EditorEntity;", "ShowCmdWidget", "content", "fleet.plugins.vim.frontend"})
public final class ShowCmdWidget
implements StatusBarWidget {
    @NotNull
    private final String id;
    @NotNull
    private final WidgetGroup widgetGroup = WidgetGroup.LEFT;
    @NotNull
    private final Set<WidgetPlacement> placementRequests = SetsKt.emptySet();

    public ShowCmdWidget() {
        this.id = "vim-unhandled-keys";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public WidgetGroup getWidgetGroup() {
        return this.widgetGroup;
    }

    @NotNull
    public Set<WidgetPlacement> getPlacementRequests() {
        return this.placementRequests;
    }

    public void render(@NotNull NoriaContext noriaContext, @Nullable EditorEntity editorEntity) {
        Intrinsics.checkNotNullParameter((Object)noriaContext, (String)"noriaContext");
        if (!((Boolean)DocumentEntityExtKt.querySettingsKey(SettingsKeyKt.getVimEmulationEnabled(), null)).booleanValue()) {
            return;
        }
        FleetVimState state = FleetVimKt.fleet(VimInjectorKt.getInjector()).getVimState();
        if (!state.getShowCmdUI()) {
            return;
        }
        String string = state.getUnhandledKeysUI();
        if (string == null) {
            return;
        }
        String keys = string;
        Runtime.enterScope((NoriaContext)noriaContext, (int)19);
        this.ShowCmdWidget(noriaContext, keys);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)noriaContext);
    }

    @Composable
    private final void ShowCmdWidget(NoriaContext $this$ShowCmdWidget, String content) {
        String visibleContent = content.length() <= 10 ? content : "\u2026" + StringsKt.takeLast((String)content, (int)10);
        TextSpec textSpec = ShowCmdWidgetKt.vimWidgetTextSpec();
        long l = ((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$ShowCmdWidget)).get(ThemeKeys.INSTANCE.getTextPrimary())).unbox-impl();
        Runtime.enterScope((NoriaContext)$this$ShowCmdWidget, (int)20);
        TextKt.UiText-1ODQ_eA$default((NoriaContext)$this$ShowCmdWidget, (String)visibleContent, (long)l, null, (TextSpec)textSpec, null, null, null, null, null, null, (int)1012, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$ShowCmdWidget);
    }
}

