/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.vim.frontend.ui;

import androidx.compose.foundation.BackgroundKt;
import androidx.compose.foundation.BorderKt;
import androidx.compose.foundation.BorderStroke;
import androidx.compose.foundation.BorderStrokeKt;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.foundation.shape.RoundedCornerShapeKt;
import androidx.compose.runtime.Composable;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.unit.Dp;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import fleet.common.document.EditorEntity;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.IconKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.components.modifiers.TooltipModifierKt;
import fleet.compose.theme.text.TextSpec;
import fleet.frontend.document.DocumentEntityExtKt;
import fleet.frontend.editor.StatusBarWidget;
import fleet.frontend.editor.WidgetGroup;
import fleet.frontend.editor.WidgetPlacement;
import fleet.frontend.icons.IconKeys;
import fleet.plugins.vim.frontend.FleetVimKt;
import fleet.plugins.vim.frontend.SettingsKeyKt;
import fleet.plugins.vim.frontend.ui.ShowCmdWidgetKt;
import fleet.plugins.vim.frontend.ui.VimThemeKeys;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import noria.model.ThemeKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u0012*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lfleet/plugins/vim/frontend/ui/MacroRecordingWidget;", "Lfleet/frontend/editor/StatusBarWidget;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "widgetGroup", "Lfleet/frontend/editor/WidgetGroup;", "getWidgetGroup", "()Lfleet/frontend/editor/WidgetGroup;", "placementRequests", "", "Lfleet/frontend/editor/WidgetPlacement;", "getPlacementRequests", "()Ljava/util/Set;", "render", "", "noriaContext", "Lnoria/NoriaContext;", "editorEntity", "Lfleet/common/document/EditorEntity;", "MacroRecordingWidget", "register", "", "fleet.plugins.vim.frontend"})
@SourceDebugExtension(value={"SMAP\nMacroRecordingWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroRecordingWidget.kt\nfleet/plugins/vim/frontend/ui/MacroRecordingWidget\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,55:1\n155#2:56\n155#2:57\n155#2:58\n*S KotlinDebug\n*F\n+ 1 MacroRecordingWidget.kt\nfleet/plugins/vim/frontend/ui/MacroRecordingWidget\n*L\n43#1:56\n44#1:57\n45#1:58\n*E\n"})
public final class MacroRecordingWidget
implements StatusBarWidget {
    @NotNull
    private final String id;
    @NotNull
    private final WidgetGroup widgetGroup = WidgetGroup.RIGHT;
    @NotNull
    private final Set<WidgetPlacement> placementRequests;

    public MacroRecordingWidget() {
        this.id = "vim-macro-recording";
        Object[] objectArray = new WidgetPlacement[]{new WidgetPlacement.Before("vim-mode"), WidgetPlacement.Last.INSTANCE};
        this.placementRequests = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public WidgetGroup getWidgetGroup() {
        return this.widgetGroup;
    }

    @NotNull
    public Set<WidgetPlacement> getPlacementRequests() {
        return this.placementRequests;
    }

    public void render(@NotNull NoriaContext noriaContext, @Nullable EditorEntity editorEntity) {
        Intrinsics.checkNotNullParameter((Object)noriaContext, (String)"noriaContext");
        if (!((Boolean)DocumentEntityExtKt.querySettingsKey(SettingsKeyKt.getVimEmulationEnabled(), null)).booleanValue()) {
            return;
        }
        Character c = FleetVimKt.fleet(VimInjectorKt.getInjector()).getVimState().getRegisterCharUI();
        if (c == null) {
            return;
        }
        char register = c.charValue();
        Runtime.enterScope((NoriaContext)noriaContext, (int)8);
        this.MacroRecordingWidget(noriaContext, register);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)noriaContext);
    }

    @Composable
    private final void MacroRecordingWidget(NoriaContext $this$MacroRecordingWidget, char register) {
        Runtime.enterScope((NoriaContext)$this$MacroRecordingWidget, (int)12);
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        Modifier modifier = BackgroundKt.background-bw27NRU((Modifier)((Modifier)Modifier.Companion), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$MacroRecordingWidget)).get(VimThemeKeys.INSTANCE.getMacroRecordingBackground())).unbox-impl(), (Shape)((Shape)RoundedCornerShapeKt.RoundedCornerShape-0680j_4((float)Dp.constructor-impl((float)$this$dp$iv))));
        $this$dp$iv = 1;
        $i$f$getDp = false;
        BorderStroke borderStroke = BorderStrokeKt.BorderStroke-cXLIe8U((float)Dp.constructor-impl((float)$this$dp$iv), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$MacroRecordingWidget)).get(VimThemeKeys.INSTANCE.getMacroRecordingBorder())).unbox-impl());
        $this$dp$iv = 4;
        $i$f$getDp = false;
        Modifier modifier2 = BorderKt.border((Modifier)modifier, (BorderStroke)borderStroke, (Shape)((Shape)RoundedCornerShapeKt.RoundedCornerShape-0680j_4((float)Dp.constructor-impl((float)$this$dp$iv))));
        $this$dp$iv = 2;
        $i$f$getDp = false;
        Object[] objectArray = new Object[]{Character.valueOf(register)};
        RowKt.Row$default((NoriaContext)$this$MacroRecordingWidget, (Modifier)TooltipModifierKt.tooltip$default((Modifier)PaddingKt.padding-3ABfNKs((Modifier)modifier2, (float)Dp.constructor-impl((float)$this$dp$iv)), (String)("Recording @" + register), null, (long)0L, (int)6, null), null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<RowScope, Unit>(register){
            final /* synthetic */ char $register;
            {
                this.$register = $register;
                super(1);
            }

            public final void invoke(RowScope $this$Row) {
                Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)9);
                IconKt.Icon-USBMPiE$default((NoriaContext)((NoriaContext)$this$Row), (ThemeKey)IconKeys.Plugins.Vim.INSTANCE.getRecording(), (long)0L, null, null, null, (int)30, null);
                Object object = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)10);
                int $this$dp$iv = 2;
                boolean $i$f$getDp = false;
                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Row), (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                object = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
                String string = String.valueOf(this.$register);
                Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                object = string2;
                TextSpec textSpec = ShowCmdWidgetKt.vimWidgetTextSpec();
                long l = ((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Row)).get(VimThemeKeys.INSTANCE.getMacroRecordingText())).unbox-impl();
                int $this$dp$iv2 = 2;
                boolean $i$f$getDp2 = false;
                Modifier modifier = PaddingKt.padding-qDBjuR0$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (float)0.0f, (float)Dp.constructor-impl((float)$this$dp$iv2), (float)0.0f, (int)11, null);
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Row), (int)11);
                TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Row), (String)object, (long)l, null, (TextSpec)textSpec, null, null, null, null, null, (Modifier)modifier, (int)500, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Row));
            }
        })), (int)14, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$MacroRecordingWidget);
    }
}

