/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.vim.frontend;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.EditorCommandType;
import andel.editor.EditorExtKt;
import andel.editor.EditorLayout;
import andel.editor.MutableEditor;
import andel.editor.TextExtKt;
import andel.lines.Line;
import andel.text.Text;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.Entity;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.CaretRegisterStorage;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.LocalMarkStorage;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimCaretBase;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import fleet.plugins.vim.frontend.FleetMutableVimEditor;
import fleet.plugins.vim.frontend.FleetMutableVimEditorKt;
import fleet.plugins.vim.frontend.FleetVimCaretEntity;
import fleet.plugins.vim.frontend.FleetVimCaretKt;
import fleet.plugins.vim.frontend.FleetVimCaretRegisterStorage;
import fleet.plugins.vim.frontend.FleetVimKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import noria.model.components.editor.CaretActionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00102\u001a\u000203H\u0016J\b\u0010:\u001a\u000203H\u0016J\u0018\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\u001dH\u0016J\b\u0010>\u001a\u000203H\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010I\u001a\u00020\u001dH\u0016J\b\u0010J\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020\u000fH\u0016J\u0010\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u001dH\u0016J\u0010\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020CH\u0016J\u0010\u0010R\u001a\u0002032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010S\u001a\u0002032\u0006\u0010Q\u001a\u00020KH\u0016J\u0010\u0010T\u001a\u00020N2\u0006\u0010U\u001a\u00020\u001dH\u0016J\u0013\u0010V\u001a\u00020\u000f2\b\u0010W\u001a\u0004\u0018\u00010XH\u0096\u0002J\b\u0010Y\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001fR\u0014\u0010&\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001fR$\u0010)\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020(8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001d8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u00101R(\u00105\u001a\u0004\u0018\u0001042\b\u0010\u0011\u001a\u0004\u0018\u0001048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010?\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001fR\u0014\u0010A\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0010R$\u0010D\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001d8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\u001f\"\u0004\bF\u00101R\u0014\u0010G\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001f\u00a8\u0006Z"}, d2={"Lfleet/plugins/vim/frontend/FleetVimCaret;", "Lcom/maddyhome/idea/vim/api/VimCaretBase;", "caret", "Landel/editor/Caret;", "editor", "Lfleet/plugins/vim/frontend/FleetMutableVimEditor;", "<init>", "(Landel/editor/Caret;Lfleet/plugins/vim/frontend/FleetMutableVimEditor;)V", "getCaret", "()Landel/editor/Caret;", "getEditor", "()Lfleet/plugins/vim/frontend/FleetMutableVimEditor;", "caretEntity", "Lfleet/plugins/vim/frontend/FleetVimCaretEntity;", "isValid", "", "()Z", "value", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "lastSelectionInfo", "getLastSelectionInfo", "()Lcom/maddyhome/idea/vim/api/SelectionInfo;", "setLastSelectionInfo", "(Lcom/maddyhome/idea/vim/api/SelectionInfo;)V", "markStorage", "Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "getMarkStorage", "()Lcom/maddyhome/idea/vim/api/LocalMarkStorage;", "offset", "", "getOffset", "()I", "registerStorage", "Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "getRegisterStorage", "()Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "selectionEnd", "getSelectionEnd", "selectionStart", "getSelectionStart", "Lcom/maddyhome/idea/vim/common/LiveRange;", "vimInsertStart", "getVimInsertStart", "()Lcom/maddyhome/idea/vim/common/LiveRange;", "setVimInsertStart", "(Lcom/maddyhome/idea/vim/common/LiveRange;)V", "vimLastColumn", "getVimLastColumn", "setVimLastColumn", "(I)V", "resetLastColumn", "", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "vimLastVisualOperatorRange", "getVimLastVisualOperatorRange", "()Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "setVimLastVisualOperatorRange", "(Lcom/maddyhome/idea/vim/group/visual/VisualChange;)V", "vimSelectionStartClear", "setSelection", "start", "end", "removeSelection", "vimLine", "getVimLine", "isPrimary", "getBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "vimSelectionStart", "getVimSelectionStart", "setVimSelectionStart", "visualLineStart", "getVisualLineStart", "getLine", "getVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "hasSelection", "moveToInlayAwareOffset", "Lcom/maddyhome/idea/vim/api/VimCaret;", "newOffset", "moveToBufferPosition", "position", "moveToOffsetNative", "moveToVisualPosition", "setVimLastColumnAndGetCaret", "col", "equals", "other", "", "hashCode", "fleet.plugins.vim.frontend"})
public final class FleetVimCaret
extends VimCaretBase {
    @NotNull
    private final Caret caret;
    @NotNull
    private final FleetMutableVimEditor editor;
    @NotNull
    private final FleetVimCaretEntity caretEntity;
    @NotNull
    private final LocalMarkStorage markStorage;
    @NotNull
    private final CaretRegisterStorage registerStorage;

    public FleetVimCaret(@NotNull Caret caret2, @NotNull FleetMutableVimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)caret2, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)editor), (String)"editor");
        this.caret = caret2;
        this.editor = editor;
        FleetVimCaretEntity fleetVimCaretEntity = FleetVimCaretKt.access$getOrCreateVimCaretEntity(this.caret, this.getEditor());
        Intrinsics.checkNotNull((Object)fleetVimCaretEntity);
        this.caretEntity = fleetVimCaretEntity;
        this.markStorage = new LocalMarkStorage((ImmutableVimCaret)this);
        this.registerStorage = (CaretRegisterStorage)new FleetVimCaretRegisterStorage(this);
    }

    @NotNull
    public final Caret getCaret() {
        return this.caret;
    }

    @NotNull
    public FleetMutableVimEditor getEditor() {
        return this.editor;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public SelectionInfo getLastSelectionInfo() {
        return this.caretEntity.getVimLastSelectionInfo();
    }

    public void setLastSelectionInfo(@NotNull SelectionInfo value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this, value){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ SelectionInfo $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, Unit>(this.this$0, this.$value){
                    final /* synthetic */ FleetVimCaret this$0;
                    final /* synthetic */ SelectionInfo $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(1);
                    }

                    public final void invoke(ChangeScope $this$requireChangeScope) {
                        Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                        $this$requireChangeScope.set((Entity)FleetVimCaret.access$getCaretEntity$p(this.this$0), FleetVimCaretEntity.Companion.getVimLastSelectionInfo(), (Object)this.$value);
                    }
                }));
            }
        }, 1, null);
    }

    @NotNull
    public LocalMarkStorage getMarkStorage() {
        return this.markStorage;
    }

    public int getOffset() {
        return (int)this.caret.getOffset();
    }

    @NotNull
    public CaretRegisterStorage getRegisterStorage() {
        return this.registerStorage;
    }

    public int getSelectionEnd() {
        return (int)this.caret.getSelection().getEnd();
    }

    public int getSelectionStart() {
        return (int)this.caret.getSelection().getStart();
    }

    @NotNull
    public LiveRange getVimInsertStart() {
        if (this.caretEntity.getVimInsertStart() == null) {
            ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, Unit>(this){
                final /* synthetic */ FleetVimCaret this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(ChangeScope $this$requireChangeScope) {
                    Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                    $this$requireChangeScope.set((Entity)FleetVimCaret.access$getCaretEntity$p(this.this$0), FleetVimCaretEntity.Companion.getVimInsertStartAttr(), FleetMutableVimEditorKt.synchronousEdit$default(this.this$0.getEditor(), null, (Function1)new Function1<MutableEditor, LiveRange>(this.this$0){
                        final /* synthetic */ FleetVimCaret this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final LiveRange invoke(MutableEditor $this$synchronousEdit) {
                            Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                            return this.this$0.getEditor().createLiveMarker(this.this$0.getOffset(), this.this$0.getOffset());
                        }
                    }, 1, null));
                }
            }));
        }
        LiveRange liveRange = this.caretEntity.getVimInsertStart();
        Intrinsics.checkNotNull((Object)liveRange);
        return liveRange;
    }

    public void setVimInsertStart(@NotNull LiveRange value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this, value){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ LiveRange $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, Unit>(this.this$0, this.$value){
                    final /* synthetic */ FleetVimCaret this$0;
                    final /* synthetic */ LiveRange $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(1);
                    }

                    public final void invoke(ChangeScope $this$requireChangeScope) {
                        Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                        $this$requireChangeScope.set((Entity)FleetVimCaret.access$getCaretEntity$p(this.this$0), FleetVimCaretEntity.Companion.getVimInsertStartAttr(), (Object)this.$value);
                    }
                }));
            }
        }, 1, null);
    }

    public int getVimLastColumn() {
        if (!Intrinsics.areEqual((Float)this.caret.getVCol(), (Float)this.caretEntity.getLastVCol())) {
            int newColumn = FleetVimCaretKt.access$getColumn(this.caret.getOffset(), this.getEditor());
            this.setVimLastColumn(newColumn);
        }
        return this.caretEntity.getVimLastColumn();
    }

    public void setVimLastColumn(int value) {
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this, value){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ int $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                ChangeScopeKt.requireChangeScope((Function1)((Function1)new Function1<ChangeScope, Unit>(this.this$0, this.$value){
                    final /* synthetic */ FleetVimCaret this$0;
                    final /* synthetic */ int $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(1);
                    }

                    public final void invoke(ChangeScope $this$requireChangeScope) {
                        Intrinsics.checkNotNullParameter((Object)$this$requireChangeScope, (String)"$this$requireChangeScope");
                        $this$requireChangeScope.set((Entity)FleetVimCaret.access$getCaretEntity$p(this.this$0), FleetVimCaretEntity.Companion.getVimLastColumnAttr(), (Object)this.$value);
                        $this$requireChangeScope.set((Entity)FleetVimCaret.access$getCaretEntity$p(this.this$0), FleetVimCaretEntity.Companion.getLastVColAttr(), (Object)this.this$0.getCaret().getVCol());
                    }
                }));
            }
        }, 1, null);
    }

    public void resetLastColumn() {
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this){
            final /* synthetic */ FleetVimCaret this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)Caret.copy$default((Caret)this.this$0.getCaret(), null, null, null, (int)3, null)));
            }
        }, 1, null);
    }

    @Nullable
    public VisualChange getVimLastVisualOperatorRange() {
        FleetVimKt.TODOUNIT();
        return null;
    }

    public void setVimLastVisualOperatorRange(@Nullable VisualChange value) {
    }

    public void vimSelectionStartClear() {
        FleetVimCaretKt.access$set_vimSelectionStart$p(null);
    }

    public void setSelection(int start, int end) {
        int offset2 = RangesKt.coerceIn((int)this.getOffset(), (int)start, (int)end);
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this, offset2, start, end){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $start;
            final /* synthetic */ int $end;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                this.$start = $start;
                this.$end = $end;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)Caret.move$default((Caret)this.this$0.getCaret(), (CaretPosition)new CaretPosition((long)this.$offset, (long)this.$start, (long)this.$end), null, (int)2, null)));
            }
        }, 1, null);
    }

    public void removeSelection() {
        if (!this.caret.hasSelection()) {
            return;
        }
        FleetMutableVimEditorKt.synchronousEdit$default(this.getEditor(), null, (Function1)new Function1<MutableEditor, Unit>(this){
            final /* synthetic */ FleetVimCaret this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.dropSelection((MutableEditor)$this$synchronousEdit, (Caret)this.this$0.getCaret());
            }
        }, 1, null);
    }

    public int getVimLine() {
        return this.getLine() + 1;
    }

    public boolean isPrimary() {
        VimCaret vimCaret = this.getEditor().primaryCaret();
        Intrinsics.checkNotNull((Object)vimCaret, (String)"null cannot be cast to non-null type fleet.plugins.vim.frontend.FleetVimCaret");
        return Intrinsics.areEqual((Object)((FleetVimCaret)vimCaret).caret.getCaretId(), (Object)this.caret.getCaretId());
    }

    @NotNull
    public BufferPosition getBufferPosition() {
        return FleetVimKt.offsetToBufferPosition(this.caret.getOffset(), this.getEditor().getText());
    }

    public int getVimSelectionStart() {
        Integer selectionStart = FleetVimCaretKt.access$get_vimSelectionStart$p();
        if (selectionStart == null) {
            this.setVimSelectionStart(EngineVisualGroupKt.getVimLeadSelectionOffset((ImmutableVimCaret)((ImmutableVimCaret)this)));
            return EngineVisualGroupKt.getVimLeadSelectionOffset((ImmutableVimCaret)((ImmutableVimCaret)this));
        }
        return selectionStart;
    }

    public void setVimSelectionStart(int value) {
        FleetVimCaretKt.access$set_vimSelectionStart$p(value);
    }

    public int getVisualLineStart() {
        FleetVimKt.TODOUNIT();
        return 0;
    }

    public int getLine() {
        return (int)TextViewExtKt.textLineAtOffset$default((TextView)this.getEditor().getText().view(), (int)((int)this.caret.getOffset()), (boolean)false, (int)2, null).getLineNumber();
    }

    @NotNull
    public VimVisualPosition getVisualPosition() {
        Line line = this.getEditor().getLayout().getLinesCache().line(this.caret.getOffset());
        String lineText = TextExtKt.substring((Text)this.getEditor().getText(), (TextRange)new TextRange(line.getFrom(), line.getTo()));
        return new VimVisualPosition((int)line.getLineIdx(), FleetVimKt.graphemeCount(lineText, 0, (int)this.caret.getOffset() - (int)line.getFrom()), false, 4, null);
    }

    public boolean hasSelection() {
        return this.caret.hasSelection();
    }

    @NotNull
    public VimCaret moveToInlayAwareOffset(int newOffset) {
        Text text = this.getEditor().getText();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.getEditor().getLayout(), (Text)text, (long)newOffset, null);
        Caret caretAfterMove = this.caret.move(new CaretPosition((long)newOffset), Float.valueOf(vCol));
        FleetMutableVimEditorKt.synchronousEdit(this.getEditor(), EditorCommandType.NAVIGATION, (Function1)new Function1<MutableEditor, Unit>(caretAfterMove){
            final /* synthetic */ Caret $caretAfterMove;
            {
                this.$caretAfterMove = $caretAfterMove;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)this.$caretAfterMove));
            }
        });
        return (VimCaret)new FleetVimCaret(caretAfterMove, this.getEditor());
    }

    public void moveToBufferPosition(@NotNull BufferPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Text text = this.getEditor().getText();
        long offset2 = TextViewExtKt.textLines$default((TextView)text.view(), (boolean)false, (int)1, null).lineStartOffset((long)position.getLine()) + (long)position.getColumn();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.getEditor().getLayout(), (Text)text, (long)offset2, null);
        FleetMutableVimEditorKt.synchronousEdit(this.getEditor(), EditorCommandType.NAVIGATION, (Function1)new Function1<MutableEditor, Unit>(this, offset2, vCol){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ long $offset;
            final /* synthetic */ float $vCol;
            {
                this.this$0 = $receiver;
                this.$offset = $offset;
                this.$vCol = $vCol;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)this.this$0.getCaret().move(new CaretPosition(this.$offset), Float.valueOf(this.$vCol))));
            }
        });
    }

    public void moveToOffsetNative(int offset2) {
        CaretPosition caretPosition;
        long offsetAsLong = offset2;
        if (EditorExtensionsKt.getInVisualMode((VimEditor)((VimEditor)this.getEditor())) || EditorExtensionsKt.getInSelectMode((VimEditor)((VimEditor)this.getEditor()))) {
            long l;
            long l2 = this.caret.getOffset();
            if (l2 == this.caret.getSelection().getStart()) {
                l = this.caret.getSelection().getEnd();
            } else if (l2 == this.caret.getSelection().getEnd()) {
                l = this.caret.getSelection().getStart();
            } else {
                throw new IllegalStateException("Caret unexpectedly positioned neither at the start nor at the end of the selection".toString());
            }
            long selectionAnchor = l;
            Object[] objectArray = new Long[]{selectionAnchor, offset2};
            List list = CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])objectArray));
            long selectionStart = ((Number)list.get(0)).longValue();
            long selectionEnd = ((Number)list.get(1)).longValue();
            caretPosition = new CaretPosition(offsetAsLong, selectionStart, selectionEnd);
        } else {
            caretPosition = new CaretPosition(offsetAsLong);
        }
        CaretPosition newCaretPosition = caretPosition;
        Text text = this.getEditor().getText();
        float vCol = CaretActionsKt.offsetToVCol((EditorLayout)this.getEditor().getLayout(), (Text)text, (long)offset2, null);
        FleetMutableVimEditorKt.synchronousEdit(this.getEditor(), EditorCommandType.NAVIGATION, (Function1)new Function1<MutableEditor, Unit>(this, newCaretPosition, vCol){
            final /* synthetic */ FleetVimCaret this$0;
            final /* synthetic */ CaretPosition $newCaretPosition;
            final /* synthetic */ float $vCol;
            {
                this.this$0 = $receiver;
                this.$newCaretPosition = $newCaretPosition;
                this.$vCol = $vCol;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)this.this$0.getCaret().move(this.$newCaretPosition, Float.valueOf(this.$vCol))));
            }
        });
    }

    public void moveToVisualPosition(@NotNull VimVisualPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        FleetVimKt.TODOUNIT();
    }

    @NotNull
    public VimCaret setVimLastColumnAndGetCaret(int col) {
        if (this.getEditor().getMonospacedFontMetrics() == null) {
            return (VimCaret)this;
        }
        float vCol = (float)col * this.getEditor().getMonospacedFontMetrics().getCharWidth-D9Ej5fM();
        Caret newCaret = Caret.copy$default((Caret)this.caret, null, null, (Float)Float.valueOf(vCol), (int)3, null);
        FleetMutableVimEditorKt.synchronousEdit(this.getEditor(), EditorCommandType.NAVIGATION, (Function1)new Function1<MutableEditor, Unit>(newCaret){
            final /* synthetic */ Caret $newCaret;
            {
                this.$newCaret = $newCaret;
                super(1);
            }

            public final void invoke(MutableEditor $this$synchronousEdit) {
                Intrinsics.checkNotNullParameter((Object)$this$synchronousEdit, (String)"$this$synchronousEdit");
                EditorExtKt.moveCarets((MutableEditor)$this$synchronousEdit, (List)CollectionsKt.listOf((Object)this.$newCaret));
            }
        });
        return (VimCaret)new FleetVimCaret(newCaret, this.getEditor());
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof FleetVimCaret && Intrinsics.areEqual((Object)this.caret.getCaretId(), (Object)((FleetVimCaret)((Object)other)).caret.getCaretId());
    }

    public int hashCode() {
        return this.caret.getCaretId().hashCode();
    }

    public static final /* synthetic */ FleetVimCaretEntity access$getCaretEntity$p(FleetVimCaret $this) {
        return $this.caretEntity;
    }
}

