module fleet.common {
    requires kotlin.stdlib;
    /* transitive */ requires fleet.protocol;
    /* transitive */ requires fleet.andel;
    requires kotlinx.serialization.core;
    requires kotlinx.serialization.json;
    requires fleet.preferences;
    /* transitive */ requires fleet.kernel;
    requires org.jetbrains.annotations;
    /* transitive */ requires fleet.util.core;
    requires kotlinx.coroutines.core;
    requires bifurcan;
    requires fleet.rpc;
    /* transitive */ requires fleet.schema.common;
    requires fleet.bundles;
    requires fleet.codecache;
    requires fleet.util.network;
    requires fleet.reporting.api;
    requires fleet.dock.api;
    requires fleet.dock.connectors;
    requires fleet.schema.protocol;
    requires fleet.reporting.fus.api;
    requires io.ktor.client.core;
    requires io.ktor.http;
    /* transitive */ requires fleet.kernel.plugins;
    /* transitive */ requires fleet.navigation.common.api;
    requires ec4j.core;

    exports fleet.common.ai;
    exports fleet.common.backend;
    exports fleet.common.cleanup;
    exports fleet.common.document;
    exports fleet.common.document.extensions to fleet.frontend, fleet.plugins.ai.frontend, fleet.frontend.ui, fleet.rhizomedb;
    exports fleet.common.download;
    exports fleet.common.frontend;
    exports fleet.common.language;
    exports fleet.common.fs;
    exports fleet.common.lrp;
    exports fleet.common.notifications;
    exports fleet.common.places;
    exports fleet.common.plugins;
    exports fleet.common.serialization;
    exports fleet.common.services;
    exports fleet.common.settings;
    exports fleet.common.smartMode;
    exports fleet.common.oauth;
    exports fleet.common.topology;
    exports fleet.common.topology.impl to fleet.app.fleet.tests, fleet.frontend, fleet.rhizomedb, fleet.ship.desktop, fleet.supervisor, fleet.workspace;
    exports fleet.common.undo;
    exports fleet.common.user;
    exports fleet.common.util;
    exports fleet.common.project;
    exports fleet.common.ship;
    exports fleet.common.warmup;
    exports fleet.common.workspace;
    exports fleet.common.fus;
    exports fleet.common.fus.validation;
    exports fleet.common;
    exports fleet.common.test;
    exports fleet.common.license;
    exports fleet.common.latency;
    exports fleet.common.region;

    provides Plugin with CommonPlugin;

}

