/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.util;

import fleet.api.Directory;
import fleet.api.FileAddress;
import fleet.api.FileDescriptor;
import fleet.api.LazyLocation;
import fleet.api.Location;
import fleet.api.LocationInFile;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.kernel.DurableEntityKt;
import fleet.util.UID;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"fileAddress", "Lfleet/api/FileAddress;", "Lfleet/api/LocationInFile;", "getFileAddress", "(Lfleet/api/LocationInFile;)Lfleet/api/FileAddress;", "fileOrDirectory", "Lfleet/api/Location;", "getFileOrDirectory", "(Lfleet/api/Location;)Lfleet/api/FileAddress;", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nLocationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationUtil.kt\nfleet/common/util/LocationUtilKt\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,30:1\n22#2:31\n17#3,2:32\n*S KotlinDebug\n*F\n+ 1 LocationUtil.kt\nfleet/common/util/LocationUtilKt\n*L\n25#1:31\n25#1:32,2\n*E\n"})
public final class LocationUtilKt {
    @Nullable
    public static final FileAddress getFileAddress(@NotNull LocationInFile $this$fileAddress) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fileAddress, (String)"<this>");
        FileDescriptor thisFile = $this$fileAddress.getFile();
        if (thisFile instanceof FileDescriptor.Address) {
            object = ((FileDescriptor.Address)thisFile).getFileAddress();
        } else if (thisFile instanceof FileDescriptor.Document) {
            DocumentEntity documentEntity = (DocumentEntity)DurableEntityKt.byUidOrNull((UID)((FileDescriptor.Document)thisFile).getDocumentId());
            object = documentEntity != null ? DocumentEntityKt.getLocationFileAddress(documentEntity) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final FileAddress getFileOrDirectory(@NotNull Location $this$fileOrDirectory) {
        FileAddress fileAddress;
        Intrinsics.checkNotNullParameter((Object)$this$fileOrDirectory, (String)"<this>");
        Location location = $this$fileOrDirectory;
        if (location instanceof LocationInFile) {
            fileAddress = LocationUtilKt.getFileAddress((LocationInFile)$this$fileOrDirectory);
        } else if (location instanceof Directory) {
            fileAddress = ((Directory)$this$fileOrDirectory).getFileAddress();
        } else if (location instanceof Location.Unknown) {
            fileAddress = null;
        } else if (location instanceof LazyLocation) {
            fileAddress = null;
        } else {
            boolean $i$f$logger = false;
            KLogger this_$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(Location.class));
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("file requested from Location " + $this$fileOrDirectory + ", but it's not of any known Location type. Add it here?"));
            }
            fileAddress = null;
        }
        return fileAddress;
    }
}

