/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.topology;

import com.jetbrains.rhizomedb.CachedQuery;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.UtilKt;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.FileAddress;
import fleet.api.HostId;
import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.api.ProtocolPath;
import fleet.common.FsService;
import fleet.common.ServicesImplKt;
import fleet.common.WorkspaceEntity;
import fleet.common.WorkspaceEntityKt;
import fleet.common.topology.Contract;
import fleet.common.topology.Filesystem;
import fleet.common.topology.Host;
import fleet.common.topology.HostEntity;
import fleet.common.topology.HostKt;
import fleet.common.topology.HostServiceEntity;
import fleet.common.topology.HostServiceQuery;
import fleet.common.topology.ServiceProviderEntity;
import fleet.common.topology.TopologyEndpointEntity;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0007H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0007\u001a\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001a\u001a'\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u001d\u001a$\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u000e\b\u0000\u0010\u001f\u0018\u0001*\u0006\u0012\u0002\b\u00030\u000b*\u00020\u0007H\u0086\b\u00a2\u0006\u0002\u0010 \u001a-\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\f\b\u0000\u0010\u001f*\u0006\u0012\u0002\b\u00030\u000b*\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001f0\"\u00a2\u0006\u0002\u0010#\u001a\u0016\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0%*\u00020\u0007H\u0002\u001a(\u0010&\u001a\u0004\u0018\u0001H\u001f\"\u000e\b\u0000\u0010\u001f\u0018\u0001*\u0006\u0012\u0002\b\u00030\u000b*\u0006\u0012\u0002\b\u00030\u000bH\u0087\b\u00a2\u0006\u0002\u0010'\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0019\u0010\n\u001a\u00020\u0002*\u0006\u0012\u0002\b\u00030\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"ServingHostKey", "Lfleet/common/topology/Contract$MetaKey;", "Lfleet/api/HostId;", "getServingHostKey", "()Lfleet/common/topology/Contract$MetaKey;", "fs", "Lfleet/common/FsService;", "Lfleet/common/topology/HostEntity;", "getFs", "(Lfleet/common/topology/HostEntity;)Lfleet/common/FsService;", "servingHostId", "Lfleet/common/topology/HostServiceEntity;", "getServingHostId", "(Lfleet/common/topology/HostServiceEntity;)Lfleet/api/HostId;", "host", "hostId", "hostOrNull", "describeHost", "", "isOrphaned", "", "parseToFileAddress", "Lkotlin/Result;", "Lfleet/api/FileAddress;", "Lfleet/common/topology/Filesystem;", "path", "(Lfleet/common/topology/Filesystem;Ljava/lang/String;)Ljava/lang/Object;", "rawPath", "workingDir", "(Lfleet/common/topology/Filesystem;Ljava/lang/String;Lfleet/api/FileAddress;)Ljava/lang/Object;", "service", "T", "(Lfleet/common/topology/HostEntity;)Lfleet/common/topology/HostServiceEntity;", "serviceClass", "Lkotlin/reflect/KClass;", "(Lfleet/common/topology/HostEntity;Lkotlin/reflect/KClass;)Lfleet/common/topology/HostServiceEntity;", "services", "", "siblingService", "(Lfleet/common/topology/HostServiceEntity;)Lfleet/common/topology/HostServiceEntity;", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Host.kt\nfleet/common/topology/HostKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n*L\n1#1,231:1\n194#1:237\n194#1:238\n1#2:232\n235#3:233\n235#3:234\n316#3:235\n235#3:236\n*S KotlinDebug\n*F\n+ 1 Host.kt\nfleet/common/topology/HostKt\n*L\n215#1:237\n222#1:238\n175#1:233\n176#1:234\n211#1:235\n211#1:236\n*E\n"})
public final class HostKt {
    @NotNull
    private static final Contract.MetaKey<HostId> ServingHostKey = new Contract.MetaKey("fleet.topology.servingHost", HostId.Companion.serializer());

    @NotNull
    public static final Contract.MetaKey<HostId> getServingHostKey() {
        return ServingHostKey;
    }

    @NotNull
    public static final Object parseToFileAddress(@NotNull Filesystem $this$parseToFileAddress, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$parseToFileAddress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ServicesImplKt.parsePath(FileAddress.Companion, $this$parseToFileAddress.getHostId(), $this$parseToFileAddress.getOs(), path);
    }

    @NotNull
    public static final Object parseToFileAddress(@NotNull Filesystem $this$parseToFileAddress, @NotNull String rawPath, @Nullable FileAddress workingDir) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$parseToFileAddress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        if (ProtocolPath.Companion.isAbsolutePath(rawPath, $this$parseToFileAddress.getOs())) {
            v0 = ProtocolPath.Companion.parsePath-gIAlu-s($this$parseToFileAddress.getOs(), rawPath);
        } else if (StringsKt.startsWith$default((CharSequence)rawPath, (char)'~', (boolean)false, (int)2, null)) {
            Object $this$parseToFileAddress_u24lambda_u240;
            object2 = $this$parseToFileAddress;
            try {
                $this$parseToFileAddress_u24lambda_u240 = object2;
                boolean bl = false;
                FileAddress fileAddress = ((Filesystem)$this$parseToFileAddress_u24lambda_u240).getUserHome();
                if (fileAddress == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                $this$parseToFileAddress_u24lambda_u240 = Result.constructor-impl((Object)fileAddress.getPath().resolveChild(StringsKt.substringAfter$default((String)rawPath, (char)PlatformKt.getSeparator((Os)((Filesystem)$this$parseToFileAddress_u24lambda_u240).getOs()), null, (int)2, null)));
            }
            catch (Throwable bl) {
                $this$parseToFileAddress_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            v0 = $this$parseToFileAddress_u24lambda_u240;
        } else {
            v0 = workingDir != null ? Result.constructor-impl((Object)workingDir.getPath().resolveChild(rawPath)) : (object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("Relative path was given without working directory"))));
        }
        if (Result.isSuccess-impl((Object)object2)) {
            ProtocolPath path = (ProtocolPath)object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)new FileAddress($this$parseToFileAddress.getHostId(), path));
        } else {
            object = Result.constructor-impl((Object)object2);
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOrphaned(@NotNull HostEntity $this$isOrphaned) {
        Intrinsics.checkNotNullParameter((Object)$this$isOrphaned, (String)"<this>");
        HostEntity host = $this$isOrphaned;
        boolean bl = false;
        if (!EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)TopologyEndpointEntity.Companion.getRunningOnHostIdAttr$fleet_common()), (Object)host.getHostId()).isEmpty()) return false;
        if (Host.Companion.lookup(host.getHostId()) != null) return false;
        if (Filesystem.Companion.lookup(host.getHostId()) != null) return false;
        KMutableProperty1 property$iv = (KMutableProperty1)isOrphaned.1.1.INSTANCE;
        boolean $i$f$lookup = false;
        if (!EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)host, (KClass)Reflection.getOrCreateKotlinClass(ServiceProviderEntity.class)).isEmpty()) return false;
        property$iv = (KMutableProperty1)isOrphaned.1.2.INSTANCE;
        $i$f$lookup = false;
        if (!EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)host, (KClass)Reflection.getOrCreateKotlinClass(HostServiceEntity.class)).isEmpty()) return false;
        WorkspaceEntity workspaceEntity2 = WorkspaceEntityKt.currentWorkspace();
        if (Intrinsics.areEqual((Object)(workspaceEntity2 != null ? workspaceEntity2.getWorkspaceHostId() : null), (Object)host.getHostId())) return false;
        return true;
    }

    @NotNull
    public static final HostId getServingHostId(@NotNull HostServiceEntity<?> $this$servingHostId) {
        Intrinsics.checkNotNullParameter($this$servingHostId, (String)"<this>");
        return $this$servingHostId.getServingHost().getHostId();
    }

    public static final /* synthetic */ <T extends HostServiceEntity<?>> T service(HostEntity $this$service) {
        Intrinsics.checkNotNullParameter((Object)$this$service, (String)"<this>");
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return HostKt.service($this$service, Reflection.getOrCreateKotlinClass(HostServiceEntity.class));
    }

    @Nullable
    public static final <T extends HostServiceEntity<?>> T service(@NotNull HostEntity $this$service, @NotNull KClass<T> serviceClass) {
        Intrinsics.checkNotNullParameter((Object)$this$service, (String)"<this>");
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        return (T)((HostServiceEntity)UtilKt.cachedQuery((CachedQuery)new HostServiceQuery<T>(serviceClass, $this$service)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<HostServiceEntity<?>> services(HostEntity $this$services) {
        void $this$lookup$iv;
        HostEntity hostEntity = $this$services;
        KMutableProperty1 prop$iv = (KMutableProperty1)services.1.INSTANCE;
        boolean $i$f$lookup = false;
        boolean $i$f$lookup2 = false;
        return EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)prop$iv), (Object)$this$lookup$iv, (KClass)Reflection.getOrCreateKotlinClass(HostServiceEntity.class));
    }

    @Deprecated(message="Use fleet.common.topology.Host or fleet.common.topology.Filesystem depending on the required set of services")
    public static final /* synthetic */ <T extends HostServiceEntity<?>> T siblingService(HostServiceEntity<?> $this$siblingService) {
        Intrinsics.checkNotNullParameter($this$siblingService, (String)"<this>");
        boolean $i$f$siblingService = false;
        HostEntity $this$service$iv = $this$siblingService.getServingHost();
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return HostKt.service($this$service$iv, Reflection.getOrCreateKotlinClass(HostServiceEntity.class));
    }

    private static final String describeHost(HostEntity $this$describeHost) {
        return "Host " + $this$describeHost.getHostId() + "(" + $this$describeHost.getLabel() + "), services: " + HostKt.services($this$describeHost);
    }

    @NotNull
    public static final FsService getFs(@NotNull HostEntity $this$fs) {
        Intrinsics.checkNotNullParameter((Object)$this$fs, (String)"<this>");
        HostEntity $this$service$iv = $this$fs;
        boolean $i$f$service = false;
        Object t = HostKt.service($this$service$iv, Reflection.getOrCreateKotlinClass(FsService.class));
        if (t == null) {
            boolean bl = false;
            String string = "No FsService, " + HostKt.describeHost($this$fs);
            throw new IllegalStateException(string.toString());
        }
        return (FsService)t;
    }

    @Nullable
    public static final HostEntity hostOrNull(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        return (HostEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)HostEntity.Companion.getHostIdAttr()), (Object)hostId);
    }

    @NotNull
    public static final HostEntity host(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        HostEntity hostEntity = HostKt.hostOrNull(hostId);
        if (hostEntity == null) {
            boolean bl = false;
            String string = "Illegal state, file: " + hostId + " is from the host which is not connected to the workspace";
            throw new IllegalStateException(string.toString());
        }
        return hostEntity;
    }

    public static final /* synthetic */ Set access$services(HostEntity $receiver) {
        return HostKt.services($receiver);
    }
}

