/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.license;

import fleet.common.license.FleetLicenseKind;
import fleet.common.license.LicenseHelpersKt;
import fleet.common.license.ProductLicenseData;
import fleet.common.plugins.ShipUpdatingKt;
import fleet.dock.api.DockContextElement;
import fleet.dock.connectors.BaseLicenseRequest;
import fleet.dock.connectors.LicenseData;
import fleet.dock.connectors.LicenseJson;
import fleet.dock.connectors.LicenseJsons;
import fleet.dock.connectors.LicenseTypesKt;
import fleet.dock.connectors.ProductData;
import fleet.util.async.CoroutineUtilsKt;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0004\u001a\"\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0004\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u001a\u001c\u0010\f\u001a\u00020\u0003*\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n\u001a\u0010\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012*\u00020\b\u00a8\u0006\u0013"}, d2={"evictLicenseCacheFor", "", "request", "Lfleet/dock/connectors/BaseLicenseRequest;", "(Lfleet/dock/connectors/BaseLicenseRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchLicenseData", "Lkotlin/Result;", "", "Lfleet/dock/connectors/LicenseData;", "isExpired", "", "Lfleet/common/license/ProductLicenseData;", "toLicenseRequest", "Lfleet/common/license/FleetLicenseKind;", "userId", "", "trial", "toProductLicenseData", "", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nLicenseHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseHelpers.kt\nfleet/common/license/LicenseHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n1#3:124\n*S KotlinDebug\n*F\n+ 1 LicenseHelpers.kt\nfleet/common/license/LicenseHelpersKt\n*L\n32#1:120\n32#1:121,3\n*E\n"})
public final class LicenseHelpersKt {
    public static final boolean isExpired(@NotNull ProductLicenseData $this$isExpired) {
        Intrinsics.checkNotNullParameter((Object)$this$isExpired, (String)"<this>");
        LocalDate localDate = $this$isExpired.getProduct().getPaidUpTo();
        return localDate != null ? localDate.isBefore(LocalDate.now().plusDays($this$isExpired.getGracePeriodDays())) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ProductLicenseData> toProductLicenseData(@NotNull LicenseData $this$toProductLicenseData) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toProductLicenseData, (String)"<this>");
        Iterable $this$map$iv = $this$toProductLicenseData.getProducts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void product;
            ProductData productData = (ProductData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProductLicenseData($this$toProductLicenseData.getLicenseId(), $this$toProductLicenseData.getLicenseeName(), $this$toProductLicenseData.getAssigneeName(), $this$toProductLicenseData.getAssigneeEmail(), $this$toProductLicenseData.getLicenseRestriction(), $this$toProductLicenseData.getCheckConcurrentUse(), $this$toProductLicenseData.getMetadata(), $this$toProductLicenseData.getHash(), $this$toProductLicenseData.getGracePeriodDays(), $this$toProductLicenseData.getAutoProlongated(), (ProductData)product));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final Object evictLicenseCacheFor(@NotNull BaseLicenseRequest request, @NotNull Continuation<? super Unit> $completion) {
        String requestJson = LicenseTypesKt.getLicenseJson().encodeToString((SerializationStrategy)BaseLicenseRequest.Companion.serializer(), (Object)request);
        CoroutineContext.Element element = $completion.getContext().get((CoroutineContext.Key)LicenseTypesKt.getLicenseCacheEvictorKey());
        if (element == null) {
            boolean bl = false;
            String string = "no license cache evictor found in context";
            throw new IllegalArgumentException(string.toString());
        }
        Function2 evictCache = (Function2)((DockContextElement)element).getValue();
        Object object = evictCache.invoke((Object)requestJson, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object fetchLicenseData(@NotNull BaseLicenseRequest var0, @NotNull Continuation<? super Result<? extends Set<LicenseData>>> var1_1) {
        if (!(var1_1 instanceof fetchLicenseData.1)) ** GOTO lbl-1000
        var6_2 = var1_1;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    Object object = LicenseHelpersKt.fetchLicenseData(null, (Continuation<? super Result<? extends Set<LicenseData>>>)((Continuation)this));
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Result.box-impl((Object)object);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                requestJson = LicenseTypesKt.getLicenseJson().encodeToString((SerializationStrategy)BaseLicenseRequest.Companion.serializer(), (Object)request);
                v0 = $continuation.getContext().get((CoroutineContext.Key)LicenseTypesKt.getLicenseFetcherKey());
                if (v0 == null) {
                    $i$a$-requireNotNull-LicenseHelpersKt$fetchLicenseData$fetch$1 = false;
                    var4_7 = "no license fetcher found in context";
                    throw new IllegalArgumentException(var4_7.toString());
                }
                fetch = (Function2)((DockContextElement)v0).getValue();
                $continuation.label = 1;
                v1 = CoroutineUtilsKt.catching((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends LicenseData>>, Object>((Function2<? super String, ? super Continuation<? super Result<String>>, ? extends Object>)fetch, requestJson, null){
                    int label;
                    final /* synthetic */ Function2<String, Continuation<? super Result<String>>, Object> $fetch;
                    final /* synthetic */ String $requestJson;
                    {
                        this.$fetch = $fetch;
                        this.$requestJson = $requestJson;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = this.$fetch.invoke((Object)this.$requestJson, (Object)this);
                                if (v0 == var14_2) {
                                    return var14_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                var3_3 = ((Result)v0).unbox-impl();
                                ResultKt.throwOnFailure((Object)var3_3);
                                licensesString = (String)var3_3;
                                licenseJsons = (LicenseJsons)LicenseTypesKt.getLicenseJson().decodeFromString((DeserializationStrategy)LicenseJsons.Companion.serializer(), licensesString);
                                $this$map$iv = licenseJsons.getLicenses();
                                $i$f$map = false;
                                var6_7 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var11_12 = ((LicenseJson)item$iv$iv).unbox-impl();
                                    var13_14 = destination$iv$iv;
                                    $i$a$-map-LicenseHelpersKt$fetchLicenseData$2$1 = false;
                                    var13_14.add(LicenseJson.decode-impl((String)it));
                                }
                                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Set<LicenseData>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = ((Result)$result).unbox-impl();
lbl27:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final BaseLicenseRequest toLicenseRequest(@NotNull FleetLicenseKind $this$toLicenseRequest, @Nullable String userId, boolean trial) {
        BaseLicenseRequest baseLicenseRequest;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toLicenseRequest), (String)"<this>");
        if (!($this$toLicenseRequest != FleetLicenseKind.JB_AI_LITE || trial)) {
            boolean $i$a$-require-LicenseHelpersKt$toLicenseRequest$42 = false;
            String $i$a$-require-LicenseHelpersKt$toLicenseRequest$42 = FleetLicenseKind.JB_AI_LITE + " must be requested as a trial license";
            throw new IllegalArgumentException($i$a$-require-LicenseHelpersKt$toLicenseRequest$42.toString());
        }
        if (!($this$toLicenseRequest != FleetLicenseKind.JB_AI_PRO || !trial)) {
            boolean $i$a$-require-LicenseHelpersKt$toLicenseRequest$52 = false;
            String $i$a$-require-LicenseHelpersKt$toLicenseRequest$52 = FleetLicenseKind.JB_AI_PRO + " cannot be requested as a trial license";
            throw new IllegalArgumentException($i$a$-require-LicenseHelpersKt$toLicenseRequest$52.toString());
        }
        String shipVersion = ShipUpdatingKt.currentShipVersion().getVersion();
        Comparable<ChronoLocalDateTime<?>> comparable = ShipUpdatingKt.currentShipBuildDate();
        long shipBuildDate = comparable != null && (comparable = comparable.toInstant(ZoneOffset.UTC)) != null ? ((Instant)comparable).toEpochMilli() : 0L;
        if (userId == null) {
            if (!trial) {
                boolean bl = false;
                String string = "cannot request anonymous license that is not a trial license";
                throw new IllegalArgumentException(string.toString());
            }
            baseLicenseRequest = (BaseLicenseRequest)new BaseLicenseRequest.AnonymousTrialLicenseRequest(shipVersion, shipBuildDate, "", $this$toLicenseRequest.getProductCode());
        } else {
            baseLicenseRequest = trial ? (BaseLicenseRequest)new BaseLicenseRequest.TrialLicenseRequest(userId, shipVersion, shipBuildDate, "", $this$toLicenseRequest.getProductCode()) : (BaseLicenseRequest)new BaseLicenseRequest.LicenseRequest(userId, shipVersion, shipBuildDate, "", $this$toLicenseRequest.getProductCode());
        }
        return baseLicenseRequest;
    }
}

