/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.fs;

import fleet.api.FileAddress;
import fleet.api.workspace.document.ContentStorageApi;
import fleet.api.workspace.document.FsApiWithHistory;
import fleet.api.workspace.document.UndoApi;
import fleet.common.FsService;
import fleet.common.fs.FsNonUndoableModel;
import fleet.common.fs.FsUndoableModel;
import fleet.common.fs.FsUndoableModelImpl;
import fleet.common.fs.FsdKt;
import fleet.common.topology.HostKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c2\u0003J\u001b\u0010\u0007\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J$\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\tJ\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfleet/common/fs/FsUndoableModelContext;", "", "changesChannel", "Lkotlinx/coroutines/channels/SendChannel;", "Lfleet/api/workspace/document/UndoApi$FileModificationResult;", "(Lkotlinx/coroutines/channels/SendChannel;)V", "component1", "copy", "equals", "", "other", "fsModel", "Lfleet/common/fs/FsUndoableModel;", "fileAddress", "Lfleet/api/FileAddress;", "undoable", "limitFileSize", "hashCode", "", "toString", "", "fleet.common"})
public final class FsUndoableModelContext {
    @Nullable
    private final SendChannel<UndoApi.FileModificationResult> changesChannel;

    public FsUndoableModelContext(@Nullable SendChannel<? super UndoApi.FileModificationResult> changesChannel) {
        this.changesChannel = changesChannel;
    }

    @Nullable
    public final FsUndoableModel fsModel(@NotNull FileAddress fileAddress, boolean undoable, boolean limitFileSize) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        FsService fsService2 = FsdKt.fsService(fileAddress);
        if (fsService2 == null) {
            return null;
        }
        FsService fsApi = fsService2;
        if (undoable) {
            FsApiWithHistory fsApiWithHistory = FsdKt.fsServiceWithHistory(fileAddress);
            ContentStorageApi contentStorageApi = FsdKt.fsContentStorage(fileAddress);
            if (fsApiWithHistory != null && contentStorageApi != null && this.changesChannel != null) {
                return new FsUndoableModelImpl(fsApi, fsApiWithHistory, this.changesChannel, contentStorageApi, limitFileSize);
            }
        }
        return new FsNonUndoableModel(HostKt.getServingHostId(fsApi), fsApi);
    }

    public static /* synthetic */ FsUndoableModel fsModel$default(FsUndoableModelContext fsUndoableModelContext, FileAddress fileAddress, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return fsUndoableModelContext.fsModel(fileAddress, bl, bl2);
    }

    private final SendChannel<UndoApi.FileModificationResult> component1() {
        return this.changesChannel;
    }

    @NotNull
    public final FsUndoableModelContext copy(@Nullable SendChannel<? super UndoApi.FileModificationResult> changesChannel) {
        return new FsUndoableModelContext(changesChannel);
    }

    public static /* synthetic */ FsUndoableModelContext copy$default(FsUndoableModelContext fsUndoableModelContext, SendChannel sendChannel, int n, Object object) {
        if ((n & 1) != 0) {
            sendChannel = fsUndoableModelContext.changesChannel;
        }
        return fsUndoableModelContext.copy(sendChannel);
    }

    @NotNull
    public String toString() {
        return "FsUndoableModelContext(changesChannel=" + this.changesChannel + ")";
    }

    public int hashCode() {
        return this.changesChannel == null ? 0 : this.changesChannel.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FsUndoableModelContext)) {
            return false;
        }
        FsUndoableModelContext fsUndoableModelContext = (FsUndoableModelContext)other;
        return Intrinsics.areEqual(this.changesChannel, fsUndoableModelContext.changesChannel);
    }
}

