/*
 * Decompiled with CFR 0.152.
 */
package fleet.common;

import fleet.common.SettingsMigrationKt;
import fleet.dock.connectors.ConnectorsKt;
import fleet.util.logging.KLogger;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0011\u001a\f\u0010\u0012\u001a\u00020\f*\u00020\u000eH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0015\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"dsStoreName", "", "entriesToBeMoved", "", "logConfName", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "migratePreferences", "", "currentPath", "Ljava/nio/file/Path;", "targetPath", "migratePreferencesFromUserHomeIfNeeded", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteExistingOrLogError", "moveToOrLogError", "target", "moveWithJsonAndSystemEntries", "populatedWithPreferences", "", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nSettingsMigration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsMigration.kt\nfleet/common/SettingsMigrationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n13#3,2:115\n17#3,2:122\n41#3,2:124\n41#3,2:126\n13#3,2:128\n13#3,2:130\n13#3,2:132\n13#3,2:134\n17#3,2:136\n766#4:117\n857#4,2:118\n1855#4,2:120\n*S KotlinDebug\n*F\n+ 1 SettingsMigration.kt\nfleet/common/SettingsMigrationKt\n*L\n22#1:115,2\n54#1:122,2\n67#1:124,2\n76#1:126,2\n83#1:128,2\n87#1:130,2\n96#1:132,2\n107#1:134,2\n111#1:136,2\n46#1:117\n46#1:118,2\n47#1:120,2\n*E\n"})
public final class SettingsMigrationKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    private static final String logConfName = "log.conf.toml";
    @NotNull
    private static final String dsStoreName = ".DS_Store";
    @NotNull
    private static final Set<String> entriesToBeMoved;

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    @Nullable
    public static final Object migratePreferencesFromUserHomeIfNeeded(@NotNull Continuation<? super Unit> $completion) {
        Path path = ConnectorsKt.getAppConfigPath((CoroutineContext)$completion.getContext());
        if (path == null) {
            boolean $i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$configPath$22 = false;
            String $i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$configPath$22 = "configPath should be set for the migration";
            throw new IllegalArgumentException($i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$configPath$22.toString());
        }
        Path configPath = path;
        Path path2 = ConnectorsKt.getAppUserHomePath((CoroutineContext)$completion.getContext());
        if (path2 == null) {
            boolean $i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$userHome$22 = false;
            String $i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$userHome$22 = "userHome should be set for the migration";
            throw new IllegalArgumentException($i$a$-requireNotNull-SettingsMigrationKt$migratePreferencesFromUserHomeIfNeeded$userHome$22.toString());
        }
        Path userHome2 = path2;
        Path dotFleet = userHome2.resolve(".fleet");
        Intrinsics.checkNotNull((Object)dotFleet);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(dotFleet, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !SettingsMigrationKt.populatedWithPreferences(configPath)) {
            SettingsMigrationKt.migratePreferences(dotFleet, configPath);
        } else {
            KLogger this_$iv = SettingsMigrationKt.getLogger();
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.info((Object)"Settings migration is not needed");
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean populatedWithPreferences(Path $this$populatedWithPreferences) {
        Path path = $this$populatedWithPreferences.resolve("settings.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        Object object = new LinkOption[]{};
        boolean settingsFileExists = Files.exists(path2, Arrays.copyOf(object, ((LinkOption[])object).length));
        Path path3 = $this$populatedWithPreferences.resolve("keymap/user.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        object = path3;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean keymapFileExists = Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        Path $this$populatedWithPreferences_u24lambda_u243 = $this$populatedWithPreferences;
        boolean bl = false;
        Path themeDir = $this$populatedWithPreferences_u24lambda_u243.resolve("themes");
        Intrinsics.checkNotNull((Object)themeDir);
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        boolean customizedThemeExists = Files.exists(themeDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && !((Collection)PathsKt.listDirectoryEntries((Path)themeDir, (String)"*.json")).isEmpty();
        return settingsFileExists || keymapFileExists || customizedThemeExists;
    }

    private static final void moveWithJsonAndSystemEntries(Path $this$moveWithJsonAndSystemEntries, Path targetPath) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory($this$moveWithJsonAndSystemEntries, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Iterator $this$filterTo$iv$iv;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetPath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)$this$moveWithJsonAndSystemEntries, null, (int)1, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                Path entry = (Path)element$iv$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!(!Files.isDirectory(entry, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && (StringsKt.endsWith$default((String)PathsKt.getName((Path)entry), (String)".json", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)PathsKt.getName((Path)entry), (Object)dsStoreName)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path filePath = (Path)element$iv;
                boolean bl = false;
                Path path = targetPath.resolve(PathsKt.getName((Path)filePath));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                SettingsMigrationKt.moveToOrLogError(filePath, path);
            }
            if (PathsKt.listDirectoryEntries$default((Path)$this$moveWithJsonAndSystemEntries, null, (int)1, null).isEmpty()) {
                SettingsMigrationKt.deleteExistingOrLogError($this$moveWithJsonAndSystemEntries);
            } else {
                KLogger this_$iv = SettingsMigrationKt.getLogger();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    kLogger.warn((Object)($this$moveWithJsonAndSystemEntries + " is not deleted because it's left non-empty"));
                }
            }
        } else {
            SettingsMigrationKt.moveToOrLogError($this$moveWithJsonAndSystemEntries, targetPath);
        }
    }

    private static final void moveToOrLogError(Path $this$moveToOrLogError, Path target) {
        block2: {
            try {
                Path path = $this$moveToOrLogError;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, target, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"move(...)");
            }
            catch (Exception e) {
                KLogger this_$iv = SettingsMigrationKt.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block2;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "failed to move " + $this$moveToOrLogError + " to " + target;
                kLogger.error(throwable, (Object)string);
            }
        }
    }

    private static final void deleteExistingOrLogError(Path $this$deleteExistingOrLogError) {
        block2: {
            try {
                Files.delete($this$deleteExistingOrLogError);
            }
            catch (Exception e) {
                KLogger this_$iv = SettingsMigrationKt.getLogger();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break block2;
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "failed to delete " + $this$deleteExistingOrLogError;
                kLogger.error(throwable, (Object)string);
            }
        }
    }

    private static final void migratePreferences(Path currentPath, Path targetPath) {
        Object object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!(Files.isDirectory(currentPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.getName((Path)currentPath), (Object)".fleet"))) {
            boolean $i$a$-require-SettingsMigrationKt$migratePreferences$22 = false;
            String $i$a$-require-SettingsMigrationKt$migratePreferences$22 = "Only .fleet directory is expected to be migrated";
            throw new IllegalArgumentException($i$a$-require-SettingsMigrationKt$migratePreferences$22.toString());
        }
        Object this_$iv = SettingsMigrationKt.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            object = this_$iv;
            boolean bl = false;
            object.info((Object)"migrating preferences from ~/.fleet to configPath");
        }
        for (Path entry : PathsKt.listDirectoryEntries$default((Path)currentPath, null, (int)1, null)) {
            Object this_$iv2 = SettingsMigrationKt.getLogger();
            boolean $i$f$info22 = false;
            if (this_$iv2.isInfoEnabled()) {
                object = this_$iv2;
                boolean bl = false;
                object.info((Object)("moving " + entry));
            }
            if (Intrinsics.areEqual((Object)PathsKt.getName((Path)entry), (Object)logConfName)) {
                Path path = targetPath.resolve(logConfName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                this_$iv2 = path;
                LinkOption[] $i$f$info22 = new LinkOption[]{};
                if (Files.exists((Path)this_$iv2, Arrays.copyOf($i$f$info22, $i$f$info22.length))) {
                    Path path2 = targetPath.resolve("userhome_log.conf.toml");
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    SettingsMigrationKt.moveToOrLogError(entry, path2);
                    continue;
                }
            }
            if (entriesToBeMoved.contains(PathsKt.getName((Path)entry))) {
                Path path = targetPath.resolve(PathsKt.getName((Path)entry));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                SettingsMigrationKt.moveWithJsonAndSystemEntries(entry, path);
                continue;
            }
            this_$iv2 = SettingsMigrationKt.getLogger();
            $i$f$info22 = false;
            if (!this_$iv2.isInfoEnabled()) continue;
            object = this_$iv2;
            boolean bl = false;
            object.info((Object)(PathsKt.getName((Path)entry) + " was skipped due to be not preferences related"));
        }
        if (PathsKt.listDirectoryEntries$default((Path)currentPath, null, (int)1, null).size() == 1) {
            Path path = currentPath.resolve(dsStoreName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            this_$iv = path;
            LinkOption[] entry = new LinkOption[]{};
            if (Files.exists((Path)this_$iv, Arrays.copyOf(entry, entry.length))) {
                Path path3 = currentPath.resolve(dsStoreName);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                SettingsMigrationKt.deleteExistingOrLogError(path3);
            }
        }
        if (PathsKt.listDirectoryEntries$default((Path)currentPath, null, (int)1, null).isEmpty()) {
            this_$iv = SettingsMigrationKt.getLogger();
            $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                object = this_$iv;
                boolean bl = false;
                object.info((Object)"deleting ~/.fleet");
            }
            SettingsMigrationKt.deleteExistingOrLogError(currentPath);
        } else {
            this_$iv = SettingsMigrationKt.getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                object = this_$iv;
                boolean bl = false;
                object.warn((Object)"~/.fleet is still not empty after migration. It can be deleted manually with saving the needed files.");
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"settings.json", "keymap", "themes", logConfName, dsStoreName};
        entriesToBeMoved = SetsKt.setOf((Object[])objectArray);
    }
}

