/*
 * Decompiled with CFR 0.152.
 */
package fleet.org.jetbrains.plugins.groovy.lang.groovydoc.parser.parsing;

import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import fleet.org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import fleet.org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;
import org.jetbrains.annotations.NonNls;

public class GroovyDocParsing {
    @NonNls
    private static final String SEE_TAG = "@see";
    @NonNls
    private static final String LINK_TAG = "@link";
    @NonNls
    private static final String LINKPLAIN_TAG = "@linkplain";
    @NonNls
    private static final String THROWS_TAG = "@throws";
    @NonNls
    private static final String EXCEPTION_TAG = "@exception";
    @NonNls
    private static final String PARAM_TAG = "@param";
    @NonNls
    private static final String VALUE_TAG = "@value";
    private static final TokenSet REFERENCE_BEGIN = TokenSet.create((IElementType[])new IElementType[]{GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN, GroovyDocTokenTypes.mGDOC_TAG_VALUE_SHARP_TOKEN});
    private boolean isInInlinedTag = false;
    private int myBraceCounter = 0;

    public boolean parse(PsiBuilder builder) {
        while (this.parseDataItem(builder)) {
        }
        if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_COMMENT_END) {
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        return true;
    }

    private boolean parseDataItem(PsiBuilder builder) {
        if (GroovyDocParsing.timeToEnd(builder)) {
            return false;
        }
        if (ParserUtils.lookAhead(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_TAG_NAME) && !this.isInInlinedTag) {
            this.isInInlinedTag = true;
            this.parseTag(builder);
        } else if (GroovyDocTokenTypes.mGDOC_TAG_NAME == builder.getTokenType() && !this.isInInlinedTag) {
            this.parseTag(builder);
        } else {
            builder.advanceLexer();
        }
        return true;
    }

    private static boolean timeToEnd(PsiBuilder builder) {
        return builder.eof() || builder.getTokenType() == GroovyDocTokenTypes.mGDOC_COMMENT_END;
    }

    private boolean parseTag(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (this.isInInlinedTag) {
            ParserUtils.getToken(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START);
        }
        assert (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_TAG_NAME);
        String tagName = builder.getTokenText();
        builder.advanceLexer();
        if (this.isInInlinedTag) {
            if (LINK_TAG.equals(tagName) || LINKPLAIN_TAG.equals(tagName) || VALUE_TAG.equals(tagName)) {
                GroovyDocParsing.parseSeeOrLinkTagReference(builder);
            }
        } else if (THROWS_TAG.equals(tagName) || EXCEPTION_TAG.equals(tagName)) {
            GroovyDocParsing.parseReferenceOrType(builder);
        } else if (SEE_TAG.equals(tagName)) {
            GroovyDocParsing.parseSeeOrLinkTagReference(builder);
        } else if (PARAM_TAG.equals(tagName)) {
            GroovyDocParsing.parseParamTagReference(builder);
        }
        while (!GroovyDocParsing.timeToEnd(builder)) {
            if (this.isInInlinedTag) {
                if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_START) {
                    ++this.myBraceCounter;
                    builder.advanceLexer();
                    continue;
                }
                if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_INLINE_TAG_END) {
                    if (this.myBraceCounter > 0) {
                        --this.myBraceCounter;
                        builder.advanceLexer();
                        continue;
                    }
                    builder.advanceLexer();
                    this.isInInlinedTag = false;
                    marker.done((IElementType)GroovyDocElementTypes.GDOC_INLINED_TAG);
                    return true;
                }
                builder.advanceLexer();
                continue;
            }
            if (ParserUtils.lookAhead(builder, GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_TAG_NAME)) {
                this.isInInlinedTag = true;
                this.parseTag(builder);
                continue;
            }
            if (GroovyDocTokenTypes.mGDOC_TAG_NAME == builder.getTokenType()) {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_TAG);
                return true;
            }
            builder.advanceLexer();
        }
        marker.done((IElementType)(this.isInInlinedTag ? GroovyDocElementTypes.GDOC_INLINED_TAG : GroovyDocElementTypes.GDOC_TAG));
        this.isInInlinedTag = false;
        return true;
    }

    private static boolean parseParamTagReference(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
            marker.done((IElementType)GroovyDocElementTypes.GDOC_PARAM_REF);
            return true;
        }
        marker.drop();
        return false;
    }

    private static boolean parseSeeOrLinkTagReference(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        if (!REFERENCE_BEGIN.contains(type)) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == type) {
            builder.advanceLexer();
        }
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_SHARP_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
            RESULT result = GroovyDocParsing.parseFieldOrMethod(builder);
            if (result == RESULT.ERROR) {
                marker.drop();
            } else if (result == RESULT.METHOD) {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_REF);
            } else {
                marker.done((IElementType)GroovyDocElementTypes.GDOC_FIELD_REF);
            }
            return true;
        }
        marker.drop();
        return true;
    }

    private static RESULT parseFieldOrMethod(PsiBuilder builder) {
        if (builder.getTokenType() != GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN) {
            return RESULT.ERROR;
        }
        builder.advanceLexer();
        PsiBuilder.Marker params = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN != builder.getTokenType()) {
            params.drop();
            return RESULT.FIELD;
        }
        builder.advanceLexer();
        while (GroovyDocParsing.parseMethodParameter(builder) && !GroovyDocParsing.timeToEnd(builder)) {
            while (GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA != builder.getTokenType() && GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN != builder.getTokenType() && !GroovyDocParsing.timeToEnd(builder)) {
                builder.advanceLexer();
            }
            while (GroovyDocTokenTypes.mGDOC_TAG_VALUE_COMMA == builder.getTokenType()) {
                builder.advanceLexer();
            }
        }
        if (builder.getTokenType() == GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN) {
            builder.advanceLexer();
        }
        params.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_PARAMS);
        return RESULT.METHOD;
    }

    private static boolean parseMethodParameter(PsiBuilder builder) {
        PsiBuilder.Marker param = builder.mark();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN != builder.getTokenType()) {
            param.drop();
            return false;
        }
        builder.advanceLexer();
        if (GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == builder.getTokenType()) {
            builder.advanceLexer();
        }
        param.done((IElementType)GroovyDocElementTypes.GDOC_METHOD_PARAMETER);
        return true;
    }

    private static boolean parseReferenceOrType(PsiBuilder builder) {
        IElementType type = builder.getTokenType();
        return GroovyDocTokenTypes.mGDOC_TAG_VALUE_TOKEN == type;
    }

    static enum RESULT {
        ERROR,
        METHOD,
        FIELD;

    }
}

