/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.smRunner;

import com.intellij.smRunner.OutputStreamType;
import com.intellij.smRunner.OutputType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001bB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0006H\u0002J\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H&J\u001c\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase;", "T", "", "serviceMessagePrefix", "", "bufferTextUntilNewLine", "", "cutNewLineBeforeServiceMessage", "(Ljava/lang/String;ZZ)V", "newLinePending", "prevRefs", "", "Lcom/intellij/smRunner/OutputStreamType;", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/smRunner/OutputEventSplitterBase$Output;", "findSuffixLengthToPreserve", "", "text", "flush", "", "flushInternal", "outputType", "Lcom/intellij/smRunner/OutputType;", "lastFlush", "onTextAvailable", "process", "processInternal", "Output", "intellij.platform.util.base"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nOutputEventSplitterBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutputEventSplitterBase.kt\ncom/intellij/smRunner/OutputEventSplitterBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n9226#2,2:166\n9376#2,4:168\n1#3:172\n1855#4,2:173\n*S KotlinDebug\n*F\n+ 1 OutputEventSplitterBase.kt\ncom/intellij/smRunner/OutputEventSplitterBase\n*L\n47#1:166,2\n47#1:168,4\n141#1:173,2\n*E\n"})
public abstract class OutputEventSplitterBase<T> {
    @NotNull
    private final String serviceMessagePrefix;
    private final boolean bufferTextUntilNewLine;
    private final boolean cutNewLineBeforeServiceMessage;
    @Nullable
    private String newLinePending;
    @NotNull
    private final Map<OutputStreamType, AtomicReference<Output<T>>> prevRefs;

    /*
     * WARNING - void declaration
     */
    public OutputEventSplitterBase(@NotNull String serviceMessagePrefix, boolean bufferTextUntilNewLine, boolean cutNewLineBeforeServiceMessage) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)serviceMessagePrefix, (String)"serviceMessagePrefix");
        this.serviceMessagePrefix = serviceMessagePrefix;
        this.bufferTextUntilNewLine = bufferTextUntilNewLine;
        this.cutNewLineBeforeServiceMessage = cutNewLineBeforeServiceMessage;
        OutputStreamType[] outputStreamTypeArray = OutputStreamType.values();
        OutputEventSplitterBase outputEventSplitterBase = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateWith$iv).length), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        int n = ((void)$this$associateWithTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void var12_13 = element$iv$iv = $this$associateWithTo$iv$iv[i];
            void var16_16 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            AtomicReference atomicReference = new AtomicReference();
            map.put(var16_16, atomicReference);
        }
        outputEventSplitterBase.prevRefs = result$iv;
    }

    public abstract void onTextAvailable(@NotNull String var1, @NotNull OutputType<T> var2);

    public final void process(@NotNull String text, @NotNull OutputType<T> outputType) {
        block4: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            AtomicReference<Output<T>> atomicReference = this.prevRefs.get((Object)outputType.getStreamType());
            if (atomicReference == null) {
                boolean bl = false;
                String string = "reference to " + (Object)((Object)outputType.getStreamType()) + " stream type is missing";
                throw new IllegalArgumentException(string.toString());
            }
            AtomicReference<Output<T>> prevRef = atomicReference;
            String mergedText = null;
            mergedText = text;
            Output output = prevRef.getAndSet(null);
            if (output != null) {
                it = output;
                boolean bl = false;
                if (Intrinsics.areEqual(((Output)it).getOutputType(), outputType)) {
                    mergedText = ((Output)it).getText() + text;
                } else {
                    OutputEventSplitterBase.flushInternal$default(this, ((Output)it).getText(), ((Output)it).getOutputType(), false, 4, null);
                }
            }
            String string = this.processInternal(mergedText, outputType);
            if (string == null) break block4;
            it = string;
            boolean bl = false;
            prevRef.set(new Output<T>((String)it, outputType));
        }
    }

    private final String processInternal(String text, OutputType<T> outputType) {
        int from = 0;
        boolean processServiceMessages = outputType.getStreamType() == OutputStreamType.STDOUT;
        int newLineInd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)0, (boolean)false, (int)6, null);
        int teamcityMessageStartInd = processServiceMessages ? StringsKt.indexOf$default((CharSequence)text, (String)this.serviceMessagePrefix, (int)0, (boolean)false, (int)6, null) : -1;
        boolean serviceMessageStarted = false;
        while (from < text.length()) {
            boolean bl;
            int nextFrom = Math.min(newLineInd != -1 ? newLineInd + 1 : Integer.MAX_VALUE, teamcityMessageStartInd != -1 ? teamcityMessageStartInd : Integer.MAX_VALUE);
            if (nextFrom == Integer.MAX_VALUE) break;
            if (from < nextFrom) {
                String string = text.substring(from, nextFrom);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                OutputEventSplitterBase.flushInternal$default(this, string, outputType, false, 4, null);
            }
            boolean bl2 = bl = from != nextFrom || from == 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "``from`` is " + from + " and it hasn't been changed since last check. Loop is frozen";
                throw new AssertionError((Object)string);
            }
            from = nextFrom;
            boolean bl4 = serviceMessageStarted = processServiceMessages && nextFrom == teamcityMessageStartInd;
            if (serviceMessageStarted) {
                teamcityMessageStartInd = StringsKt.indexOf$default((CharSequence)text, (String)this.serviceMessagePrefix, (int)(nextFrom + this.serviceMessagePrefix.length()), (boolean)false, (int)4, null);
            }
            if (newLineInd == -1 || nextFrom != newLineInd + 1) continue;
            newLineInd = StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)nextFrom, (boolean)false, (int)4, null);
        }
        if (from < text.length()) {
            int preserveSuffixLength;
            String string = text.substring(from);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String unprocessed = string;
            if (serviceMessageStarted) {
                return unprocessed;
            }
            int n = this.bufferTextUntilNewLine ? unprocessed.length() : (preserveSuffixLength = processServiceMessages ? this.findSuffixLengthToPreserve(unprocessed) : 0);
            if (preserveSuffixLength < unprocessed.length()) {
                String string2 = unprocessed.substring(0, unprocessed.length() - preserveSuffixLength);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                OutputEventSplitterBase.flushInternal$default(this, string2, outputType, false, 4, null);
            }
            if (preserveSuffixLength > 0) {
                String string3 = unprocessed.substring(unprocessed.length() - preserveSuffixLength);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                return string3;
            }
        }
        return null;
    }

    private final int findSuffixLengthToPreserve(String text) {
        for (int suffixSize = this.serviceMessagePrefix.length() - 1; 0 < suffixSize; --suffixSize) {
            if (!StringsKt.regionMatches$default((String)text, (int)(text.length() - suffixSize), (String)this.serviceMessagePrefix, (int)0, (int)suffixSize, (boolean)false, (int)16, null)) continue;
            return suffixSize;
        }
        return 0;
    }

    public final void flush() {
        Iterable $this$forEach$iv = this.prevRefs.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Output output;
            AtomicReference reference = (AtomicReference)element$iv;
            boolean bl = false;
            Output output2 = output = (Output)reference.getAndSet(null);
            if (output2 == null) continue;
            Intrinsics.checkNotNull((Object)output2);
            Output it = output;
            boolean bl2 = false;
            this.flushInternal(it.getText(), it.getOutputType(), true);
        }
    }

    private final void flushInternal(String text, OutputType<T> outputType, boolean lastFlush) {
        if (this.cutNewLineBeforeServiceMessage && outputType.getStreamType() == OutputStreamType.STDOUT) {
            String string = this.newLinePending;
            if (string != null) {
                String newLine = string;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)text, (String)this.serviceMessagePrefix, (boolean)false, (int)2, null) || lastFlush) {
                    this.onTextAvailable(newLine, outputType);
                }
                this.newLinePending = null;
            }
            if ((Intrinsics.areEqual((Object)text, (Object)"\n") || Intrinsics.areEqual((Object)text, (Object)"\r\n")) && !lastFlush) {
                this.newLinePending = text;
                return;
            }
        }
        this.onTextAvailable(text, outputType);
    }

    static /* synthetic */ void flushInternal$default(OutputEventSplitterBase outputEventSplitterBase, String string, OutputType outputType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flushInternal");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        outputEventSplitterBase.flushInternal(string, outputType, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0003J)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/smRunner/OutputEventSplitterBase$Output;", "T", "", "text", "", "outputType", "Lcom/intellij/smRunner/OutputType;", "(Ljava/lang/String;Lcom/intellij/smRunner/OutputType;)V", "getOutputType", "()Lcom/intellij/smRunner/OutputType;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.util.base"})
    private static final class Output<T> {
        @NotNull
        private final String text;
        @NotNull
        private final OutputType<T> outputType;

        public Output(@NotNull String text, @NotNull OutputType<T> outputType) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            this.text = text;
            this.outputType = outputType;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final OutputType<T> getOutputType() {
            return this.outputType;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final OutputType<T> component2() {
            return this.outputType;
        }

        @NotNull
        public final Output<T> copy(@NotNull String text, @NotNull OutputType<T> outputType) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            return new Output<T>(text, outputType);
        }

        public static /* synthetic */ Output copy$default(Output output, String string, OutputType outputType, int n, Object object) {
            if ((n & 1) != 0) {
                string = output.text;
            }
            if ((n & 2) != 0) {
                outputType = output.outputType;
            }
            return output.copy(string, outputType);
        }

        @NotNull
        public String toString() {
            return "Output(text=" + this.text + ", outputType=" + this.outputType + ')';
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + this.outputType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Output)) {
                return false;
            }
            Output output = (Output)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)output.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.outputType, output.outputType);
        }
    }
}

