/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.json;

import fleet.com.intellij.json.JsonElementTypes;
import fleet.com.intellij.json.JsonLanguage;
import fleet.com.intellij.json.JsonLexer;
import fleet.com.intellij.json.JsonParser;
import fleet.com.intellij.lang.ASTNode;
import fleet.com.intellij.lang.ParserDefinition;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiParser;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.openapi.project.Project;
import fleet.com.intellij.psi.FileViewProvider;
import fleet.com.intellij.psi.PsiElement;
import fleet.com.intellij.psi.PsiFile;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IFileElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JsonParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.WHITE_SPACE;
    public static final TokenSet STRING_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING, JsonElementTypes.DOUBLE_QUOTED_STRING});
    public static final IFileElementType FILE = new IFileElementType(JsonLanguage.INSTANCE){

        public void parse(@NotNull PsiBuilder builder) {
            new JsonParser().parse((IElementType)this, builder);
        }
    };
    public static final TokenSet JSON_BRACES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
    public static final TokenSet JSON_BRACKETS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
    public static final TokenSet JSON_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.OBJECT, JsonElementTypes.ARRAY});
    public static final TokenSet JSON_BOOLEANS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
    public static final TokenSet JSON_LITERALS = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.STRING_LITERAL, JsonElementTypes.NUMBER_LITERAL, JsonElementTypes.NULL_LITERAL, JsonElementTypes.TRUE, JsonElementTypes.FALSE});
    public static final TokenSet JSON_VALUES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSON_CONTAINERS, JSON_LITERALS});
    public static final TokenSet JSON_COMMENTARIES = TokenSet.create((IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT, JsonElementTypes.LINE_COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        return new JsonLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new JsonParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return JSON_COMMENTARIES;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return STRING_LITERALS;
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode astNode, ASTNode astNode2) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        throw new IllegalStateException();
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        throw new IllegalStateException();
    }
}

