/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.dotnet.common.features.build;

import fleet.api.FileAddress;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.plugins.dotnet.common.features.build.BuildRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b\u001a&\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"createBuildRequest", "Lfleet/plugins/dotnet/common/features/build/BuildRequest;", "title", "", "target", "root", "Lfleet/common/fs/SharedProjectRootEntity;", "solutionFile", "Lfleet/api/FileAddress;", "projectFiles", "", "projectFile", "createSolutionBuildRequest", "fleet.plugins.dotnet.common"})
public final class BuildRequestKt {
    @NotNull
    public static final BuildRequest createSolutionBuildRequest(@NotNull String title, @NotNull String target, @NotNull SharedProjectRootEntity root, @NotNull FileAddress solutionFile) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)solutionFile, (String)"solutionFile");
        return new BuildRequest.SolutionBuildRequest(title, target, root.getId(), solutionFile);
    }

    @NotNull
    public static final BuildRequest createBuildRequest(@NotNull String title, @NotNull String target, @NotNull SharedProjectRootEntity root, @Nullable FileAddress solutionFile, @NotNull FileAddress projectFile) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)projectFile, (String)"projectFile");
        if (solutionFile == null) {
            return new BuildRequest.SingleProjectBuildRequest(title, target, root.getId(), projectFile);
        }
        return new BuildRequest.ProjectBuildRequest(title, target, root.getId(), solutionFile, CollectionsKt.listOf((Object)projectFile));
    }

    @NotNull
    public static final BuildRequest createBuildRequest(@NotNull String title, @NotNull String target, @NotNull SharedProjectRootEntity root, @NotNull FileAddress solutionFile, @NotNull List<FileAddress> projectFiles) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)solutionFile, (String)"solutionFile");
        Intrinsics.checkNotNullParameter(projectFiles, (String)"projectFiles");
        return new BuildRequest.ProjectBuildRequest(title, target, root.getId(), solutionFile, projectFiles);
    }
}

