/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.SourceLocation;
import org.clang.basic.prec;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.AnnotatingParser;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.ExpressionParser;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.LineType;
import org.clang.format.impl.TokenRole;
import org.clang.format.impl.TokenType;
import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;

public class TokenAnnotator {
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;

    public TokenAnnotator(FormatStyle Style, AdditionalKeywords Keywords) {
        this.Style = Style;
        this.Keywords = Keywords;
    }

    public void setCommentLineLevels(SmallVectorImpl<AnnotatedLine> Lines) {
        AnnotatedLine NextNonCommentLine = null;
        std.reverse_iterator I = Lines.rbegin();
        std.reverse_iterator E = Lines.rend();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            if (NextNonCommentLine != null && ((AnnotatedLine)I.$star()).First.is_TokenKind('\u0004') && ((AnnotatedLine)I.$star()).First.Next == null) {
                ((AnnotatedLine)I.$star()).Level = NextNonCommentLine.Level;
            } else {
                NextNonCommentLine = ((AnnotatedLine)I.$star()).First.isNot('\u0018') ? (AnnotatedLine)I.$star() : null;
            }
            this.setCommentLineLevels((SmallVectorImpl<AnnotatedLine>)((AnnotatedLine)I.$star()).Children);
            I.$preInc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(AnnotatedLine Line) {
        AnnotatingParser Parser = null;
        try {
            type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Line.Children.begin());
            type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Line.Children.end());
            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
                this.annotate((AnnotatedLine)I.$star());
                I.$preInc();
            }
            Parser = new AnnotatingParser(this.Style, Line, this.Keywords);
            Line.Type = Parser.parseLine();
            if (Line.Type == LineType.LT_Invalid) {
                return;
            }
            ExpressionParser ExprParser = new ExpressionParser(this.Style, this.Keywords, Line);
            ExprParser.parse();
            if (Line.startsWith(TokenType.TT_ObjCMethodSpecifier)) {
                Line.Type = LineType.LT_ObjCMethodDecl;
            } else if (Line.startsWith(TokenType.TT_ObjCDecl)) {
                Line.Type = LineType.LT_ObjCDecl;
            } else if (Line.startsWith(TokenType.TT_ObjCProperty)) {
                Line.Type = LineType.LT_ObjCProperty;
            }
            Line.First.SpacesRequiredBefore = 1;
            Line.First.CanBreakBefore = Line.First.MustBreakBefore;
        }
        finally {
            if (Parser != null) {
                Parser.$destroy();
            }
        }
    }

    public void calculateFormattingInformation(AnnotatedLine Line) {
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Line.Children.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Line.Children.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            this.calculateFormattingInformation((AnnotatedLine)I.$star());
            I.$preInc();
        }
        int n = Line.First.TotalLength = Line.First.IsMultiline ? this.Style.ColumnLimit : Line.First.ColumnWidth;
        if (Line.First.Next == null) {
            return;
        }
        FormatToken Current = Line.First.Next;
        boolean InFunctionDecl = Line.MightBeFunctionDecl;
        while (Current != null) {
            if (FormatStatics.isFunctionDeclarationName(Current, Line)) {
                Current.Type = TokenType.TT_FunctionDeclarationName;
            }
            if (Current.is_TokenType(TokenType.TT_LineComment)) {
                Current.SpacesRequiredBefore = Current.Previous.BlockKind == BraceBlockKind.BK_BracedInit && Current.Previous.opensScope() ? (this.Style.Cpp11BracedListStyle ? 0 : 1) : this.Style.SpacesBeforeTrailingComments;
                if (!Current.HasUnescapedNewline) {
                    FormatToken Parameter = Current.Previous;
                    while (Parameter != null && !Parameter.isOneOf('\u0004', '\u0018')) {
                        if (Parameter.Previous != null && Parameter.Previous.is_TokenKind('@')) {
                            if (!Parameter.Previous.is_TokenType(TokenType.TT_CtorInitializerComma) && Parameter.HasUnescapedNewline) {
                                Parameter.MustBreakBefore = true;
                            }
                            break;
                        }
                        Parameter = Parameter.Previous;
                    }
                }
            } else if (Current.SpacesRequiredBefore == 0 && this.spaceRequiredBefore(Line, Current)) {
                Current.SpacesRequiredBefore = 1;
            }
            boolean bl = Current.MustBreakBefore = Current.MustBreakBefore || this.mustBreakBefore(Line, Current);
            if (!Current.MustBreakBefore && InFunctionDecl && Current.is_TokenType(TokenType.TT_FunctionDeclarationName)) {
                Current.MustBreakBefore = this.mustBreakForReturnType(Line);
            }
            Current.CanBreakBefore = Current.MustBreakBefore || this.canBreakBefore(Line, Current);
            int ChildSize = 0;
            if (Current.Previous.Children.size() == 1) {
                FormatToken LastOfChild = ((AnnotatedLine)Current.Previous.Children.$at((int)0)).Last;
                ChildSize = LastOfChild.isTrailingComment() ? this.Style.ColumnLimit : LastOfChild.TotalLength + 1;
            }
            FormatToken Prev = Current.Previous;
            Current.TotalLength = Current.MustBreakBefore || Unsigned.$greater_uint((int)Prev.Children.size(), (int)1) || Prev.Children.size() == 1 && ((AnnotatedLine)Prev.Children.$at$Const((int)0)).First.MustBreakBefore || Current.IsMultiline ? Prev.TotalLength + this.Style.ColumnLimit : Prev.TotalLength + Current.ColumnWidth + ChildSize + Current.SpacesRequiredBefore;
            if (Current.is_TokenType(TokenType.TT_CtorInitializerColon)) {
                InFunctionDecl = false;
            }
            Current.SplitPenalty = 20 * Current.BindingStrength + this.splitPenalty(Line, Current, InFunctionDecl);
            Current = Current.Next;
        }
        this.calculateUnbreakableTailLengths(Line);
        Current = Line.First;
        while (Current != null) {
            if (Current.Role.$bool()) {
                ((TokenRole)Current.Role.$arrow()).precomputeFormattingInfos(Current);
            }
            Current = Current.Next;
        }
    }

    private int splitPenalty(AnnotatedLine Line, FormatToken Tok, boolean InFunctionDecl) {
        FormatToken Left = Tok.Previous;
        FormatToken Right = Tok;
        if (Left.is_TokenKind('=')) {
            return 0;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java) {
            if (Right.isOneOf(this.Keywords.kw_extends, this.Keywords.kw_throws)) {
                return 1;
            }
            if (Right.is(this.Keywords.kw_implements)) {
                return 2;
            }
            if (Left.is_TokenKind('@') && Left.NestingLevel == 0) {
                return 3;
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            if (Right.is(this.Keywords.kw_function) && Left.isNot('@')) {
                return 100;
            }
            if (Left.is_TokenType(TokenType.TT_JsTypeColon)) {
                return 35;
            }
        }
        if (Left.is_TokenKind('@') || Right.is_TokenKind('\u0005') && Right.Next != null && Right.Next.is_TokenType(TokenType.TT_DictLiteral)) {
            return 1;
        }
        if (Right.is_TokenKind('\u0013')) {
            if (this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
                return 1;
            }
            if (Left.is_TokenKind('\u0014')) {
                return 200;
            }
            if (Right.is_TokenType(TokenType.TT_LambdaLSquare) && Left.is_TokenKind('>')) {
                return 35;
            }
            if (!Right.isOneOf(TokenType.TT_ObjCMethodExpr, TokenType.TT_LambdaLSquare, TokenType.TT_ArrayInitializerLSquare)) {
                return 500;
            }
        }
        if (Right.isOneOf(TokenType.TT_StartOfName, TokenType.TT_FunctionDeclarationName) || Right.is_TokenKind('\u0088')) {
            if (Line.startsWith('X') && Right.PartOfMultiVariableDeclStmt) {
                return 3;
            }
            if (Left.is_TokenType(TokenType.TT_StartOfName)) {
                return 110;
            }
            if (InFunctionDecl && Right.NestingLevel == 0) {
                return this.Style.PenaltyReturnTypeOnItsOwnLine;
            }
            return 200;
        }
        if (Right.is_TokenType(TokenType.TT_PointerOrReference)) {
            return 190;
        }
        if (Right.is_TokenType(TokenType.TT_LambdaArrow)) {
            return 110;
        }
        if (Left.is_TokenKind('>') && Right.is_TokenKind('\u0017')) {
            return 150;
        }
        if (Left.is_TokenType(TokenType.TT_CastRParen)) {
            return 100;
        }
        if (Left.is_TokenKind('F') || Right.is_TokenKind('\u0019') && this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
            return 500;
        }
        if (Left.isOneOf('}', 'e')) {
            return 5000;
        }
        if (Left.is_TokenKind('\u0004')) {
            return 1000;
        }
        if (Left.isOneOf(TokenType.TT_RangeBasedForLoopColon, TokenType.TT_InheritanceColon)) {
            return 2;
        }
        if (Right.isMemberAccess()) {
            return Right.NextOperator == null || !Right.NextOperator.Previous.closesScope() ? 150 : 35;
        }
        if (Right.is_TokenType(TokenType.TT_TrailingAnnotation) && (Right.Next == null || Right.Next.isNot('\u0015'))) {
            if (Line.startsWith(TokenType.TT_ObjCMethodSpecifier)) {
                return 10;
            }
            boolean is_short_annotation = Unsigned.$less_uint((int)Right.TokenText.size(), (int)10);
            return (Left.is_TokenKind('\u0016') ? 100 : 120) + (is_short_annotation ? 50 : 0);
        }
        if (Line.startsWith('X') && Left.is_TokenKind('>')) {
            return 4;
        }
        if (Right.is_TokenType(TokenType.TT_SelectorName)) {
            return 0;
        }
        if (Left.is_TokenKind('<') && Left.is_TokenType(TokenType.TT_ObjCMethodExpr)) {
            return Line.MightBeFunctionDecl ? 50 : 500;
        }
        if (Left.is_TokenKind('\u0015') && InFunctionDecl && this.Style.AlignAfterOpenBracket != FormatStyle.BracketAlignmentStyle.BAS_DontAlign) {
            return 100;
        }
        if (Left.is_TokenKind('\u0015') && Left.Previous != null && Left.Previous.isOneOf('Z', 'X')) {
            return 1000;
        }
        if (Left.is_TokenKind('>') && InFunctionDecl) {
            return 110;
        }
        if (Right.is_TokenKind('\u0018')) {
            return 1;
        }
        if (Left.is_TokenType(TokenType.TT_TemplateOpener)) {
            return 100;
        }
        if (Left.opensScope()) {
            if (this.Style.AlignAfterOpenBracket == FormatStyle.BracketAlignmentStyle.BAS_DontAlign) {
                return 0;
            }
            return Unsigned.$greater_uint((int)Left.ParameterCount, (int)1) ? this.Style.PenaltyBreakBeforeFirstCallParameter : 19;
        }
        if (Left.is_TokenType(TokenType.TT_JavaAnnotation)) {
            return 50;
        }
        if (Right.is_TokenKind('/')) {
            if (Left.is_TokenKind('\r') && (Right.NextOperator != null || Right.OperatorIndex != 1)) {
                StringRef Content = new StringRef(Left.TokenText);
                if (Content.startswith("\"")) {
                    Content.$assignMove(Content.drop_front(1));
                }
                if (Content.endswith("\"")) {
                    Content.$assignMove(Content.drop_back(1));
                }
                Content.$assignMove(Content.trim());
                if (Unsigned.$greater_uint((int)Content.size(), (int)1) && (Content.back() == 58 || Content.back() == 61)) {
                    return 25;
                }
            }
            return 1;
        }
        if (Left.is_TokenType(TokenType.TT_ConditionalExpr)) {
            return prec.Level.Conditional.getValue();
        }
        prec.Level Level2 = Left.getPrecedence();
        if (Level2 != prec.Level.Unknown) {
            return Level2.getValue();
        }
        Level2 = Right.getPrecedence();
        if (Level2 != prec.Level.Unknown) {
            return Level2.getValue();
        }
        return 3;
    }

    private boolean spaceRequiredBetween(AnnotatedLine Line, FormatToken Left, FormatToken Right) {
        if (Left.is_TokenKind('`') && Right.isNot('=')) {
            return true;
        }
        if (this.Style.ObjCSpaceAfterProperty && Line.Type == LineType.LT_ObjCProperty && Left.Tok.getObjCKeywordID() == '\u0013') {
            return true;
        }
        if (Right.is_TokenKind('B')) {
            return Left.is_TokenKind('A');
        }
        if (Left.isOneOf('B', 'A')) {
            return Right.is_TokenKind('A');
        }
        if (Left.is_TokenKind('\u0015') && Right.is_TokenKind('\u0016')) {
            return this.Style.SpaceInEmptyParentheses;
        }
        if (Left.is_TokenKind('\u0015') || Right.is_TokenKind('\u0016')) {
            return Right.is_TokenType(TokenType.TT_CastRParen) || Left.MatchingParen != null && Left.MatchingParen.is_TokenType(TokenType.TT_CastRParen) ? this.Style.SpacesInCStyleCastParentheses : this.Style.SpacesInParentheses;
        }
        if (Right.isOneOf('=', '@')) {
            return false;
        }
        if (Right.is_TokenKind('.') && (Left.is_TokenKind('\u008e') || Line.Type == LineType.LT_ObjCDecl && this.Style.ObjCSpaceBeforeProtocolList)) {
            return true;
        }
        if (Left.isOneOf('(', '\'')) {
            return false;
        }
        if (Left.is_TokenKind('G') && Right.isOneOf('\u0005', '\r', '\b', '\u0007', '\u0015', '\u0017', '\u0091', '\u0083')) {
            return false;
        }
        if (Left.is_TokenKind('<')) {
            return !Left.is_TokenType(TokenType.TT_ObjCMethodExpr);
        }
        if (Left.is_TokenKind('F')) {
            return false;
        }
        if (Left.is_TokenKind('.') || Right.isOneOf('2', '.')) {
            return false;
        }
        if (Right.is_TokenKind('\u001a')) {
            return Left.Tok.isLiteral() || Left.is_TokenKind('\u0005') && Left.Previous != null && Left.Previous.is_TokenKind('M');
        }
        if (Left.is_TokenKind('\u0013') && Right.is_TokenKind('\u001b')) {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_PointerOrReference)) {
            return Left.is_TokenKind('\u0016') && Line.MightBeFunctionDecl || Left.Tok.isLiteral() || Left.is_TokenKind('O') && Left.Previous != null && Left.Previous.is_TokenKind('\u0016') || !Left.isOneOf(TokenType.TT_PointerOrReference, '\u0015') && (this.Style.PointerAlignment != FormatStyle.PointerAlignmentStyle.PAS_Left || Line.IsMultiVariableDeclStmt);
        }
        if (Right.is_TokenType(TokenType.TT_FunctionTypeLParen) && Left.isNot('\u0015') && (!Left.is_TokenType(TokenType.TT_PointerOrReference) || this.Style.PointerAlignment != FormatStyle.PointerAlignmentStyle.PAS_Right && !Line.IsMultiVariableDeclStmt)) {
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_PointerOrReference)) {
            return Right.Tok.isLiteral() || Right.isOneOf(TokenType.TT_BlockComment, this.Keywords.kw_final, this.Keywords.kw_override) || Right.is_TokenKind('\u0017') && Right.BlockKind == BraceBlockKind.BK_Block || !Right.isOneOf(TokenType.TT_PointerOrReference, TokenType.TT_ArraySubscriptLSquare, '\u0015') && this.Style.PointerAlignment != FormatStyle.PointerAlignmentStyle.PAS_Right && !Line.IsMultiVariableDeclStmt && Left.Previous != null && !Left.Previous.isOneOf('\u0015', 'F');
        }
        if (Right.is_TokenKind('\u001e') && Left.is_TokenKind('\u0015')) {
            return false;
        }
        if (Left.is_TokenKind('\u0013')) {
            return Left.is_TokenType(TokenType.TT_ArrayInitializerLSquare) && this.Style.SpacesInContainerLiterals && Right.isNot('\u0014') || Left.is_TokenType(TokenType.TT_ArraySubscriptLSquare) && this.Style.SpacesInSquareBrackets && Right.isNot('\u0014');
        }
        if (Right.is_TokenKind('\u0014')) {
            return Right.MatchingParen != null && (this.Style.SpacesInContainerLiterals && Right.MatchingParen.is_TokenType(TokenType.TT_ArrayInitializerLSquare) || this.Style.SpacesInSquareBrackets && Right.MatchingParen.is_TokenType(TokenType.TT_ArraySubscriptLSquare));
        }
        if (Right.is_TokenKind('\u0013') && !Right.isOneOf(TokenType.TT_ObjCMethodExpr, TokenType.TT_LambdaLSquare) && !Left.isOneOf('\u0007', TokenType.TT_DictLiteral)) {
            return false;
        }
        if (Left.is_TokenKind('\u0017') && Right.is_TokenKind('\u0018')) {
            return !Left.Children.empty();
        }
        if (Left.is_TokenKind('\u0017') && Left.BlockKind != BraceBlockKind.BK_Block || Right.is_TokenKind('\u0018') && Right.MatchingParen != null && Right.MatchingParen.BlockKind != BraceBlockKind.BK_Block) {
            return !this.Style.Cpp11BracedListStyle;
        }
        if (Left.is_TokenType(TokenType.TT_BlockComment)) {
            return !Left.TokenText.endswith("=*/");
        }
        if (Right.is_TokenKind('\u0015')) {
            if (Left.is_TokenKind('\u0016') && Left.is_TokenType(TokenType.TT_AttributeParen)) {
                return true;
            }
            return Line.Type == LineType.LT_ObjCDecl || Left.is_TokenKind('=') || this.Style.SpaceBeforeParens != FormatStyle.SpaceBeforeParensOptions.SBPO_Never && (Left.isOneOf('Z', '\u0004', 'X', 'l', 'f', 'M', TokenType.TT_ForEachMacro, TokenType.TT_ObjCForIn) || Left.isOneOf('\u0092', this.Keywords.kw___except, '|', '\u0087', '\u007f') && (Left.Previous == null || Left.Previous.isNot('\u0019'))) || this.Style.SpaceBeforeParens == FormatStyle.SpaceBeforeParensOptions.SBPO_Always && (Left.is_TokenKind('\u0005') || Left.isFunctionLikeKeyword() || Left.is_TokenKind('\u0016')) && Line.Type != LineType.LT_PreprocessorDirective;
        }
        if (Left.is_TokenKind('G') && Right.Tok.getObjCKeywordID() != '\u0000') {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_UnaryOperator)) {
            return !Left.isOneOf('\u0015', '\u0013', 'G') && (Left.isNot('<') || Left.isNot(TokenType.TT_ObjCMethodExpr));
        }
        if ((Left.isOneOf('\u0005', '2', '\u0014', '\u0016') || Left.isSimpleTypeSpecifier()) && Right.is_TokenKind('\u0017') && Right.getNextNonComment() != null && Right.BlockKind != BraceBlockKind.BK_Block) {
            return false;
        }
        if (Left.is_TokenKind('\u0019') || Right.is_TokenKind('\u0019')) {
            return false;
        }
        if (Right.is_TokenKind('A') && Left.is_TokenKind('\u0005') && llvm.$eq_StringRef((StringRef)Left.TokenText, (String)"L")) {
            return false;
        }
        if (Left.is_TokenType(TokenType.TT_TemplateCloser) && Left.MatchingParen != null && Left.MatchingParen.Previous != null && Left.MatchingParen.Previous.is_TokenKind('\u0019')) {
            return false;
        }
        return !Left.is_TokenType(TokenType.TT_TemplateCloser) || !Right.is_TokenKind('\u0013');
    }

    private boolean spaceRequiredBefore(AnnotatedLine Line, FormatToken Right) {
        FormatToken Left = Right.Previous;
        if (Right.Tok.getIdentifierInfo() != null && Left.Tok.getIdentifierInfo() != null) {
            return true;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Cpp) {
            if (Left.is_TokenKind('\u0088')) {
                return Right.is_TokenKind('F');
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
            if (Right.is_TokenKind('\u0019') && Left.isOneOf(this.Keywords.kw_optional, this.Keywords.kw_required, this.Keywords.kw_repeated, this.Keywords.kw_extend)) {
                return true;
            }
            if (Right.is_TokenKind('\u0015') && Left.isOneOf(this.Keywords.kw_returns, this.Keywords.kw_option)) {
                return true;
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            if (Left.is_TokenType(TokenType.TT_JsFatArrow)) {
                return true;
            }
            if (Right.is_TokenKind('\u001e') && Left.isOneOf(this.Keywords.kw_function, this.Keywords.kw_yield)) {
                return false;
            }
            if (Left.isOneOf(this.Keywords.kw_let, this.Keywords.kw_var, this.Keywords.kw_in, this.Keywords.kw_of, 'O') && (Left.Previous == null || !Left.Previous.is_TokenKind('\u0019'))) {
                return true;
            }
            if (Left.is_TokenKind('Q') && Left.Previous != null && Left.Previous.is_TokenKind('\u0082')) {
                return true;
            }
            if (Left.is(this.Keywords.kw_is) && Right.is_TokenKind('\u0017')) {
                return true;
            }
            if (Right.isOneOf(TokenType.TT_JsTypeColon, TokenType.TT_JsTypeOptionalQuestion)) {
                return false;
            }
            if (Left.is_TokenType(TokenType.TT_JsTypeOperator) || Right.is_TokenType(TokenType.TT_JsTypeOperator)) {
                return false;
            }
            if ((Left.is_TokenKind('\u0017') || Right.is_TokenKind('\u0018')) && Line.First.isOneOf(this.Keywords.kw_import, '\u0082')) {
                return false;
            }
            if (Left.is_TokenKind('\u001a')) {
                return false;
            }
            if (Left.is_TokenType(TokenType.TT_TemplateCloser) && !Right.isOneOf('>', '\u0017', '@', '\u0013', this.Keywords.kw_implements, this.Keywords.kw_extends)) {
                return false;
            }
            if (Right.is_TokenKind('(') && (Left.isOneOf('\u0005', '\u0016', '\u0014', '\u0018') || Left.Tok.isLiteral())) {
                return false;
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_Java) {
            if (Left.is_TokenKind('\u0014') && Right.is_TokenKind('\u0017')) {
                return true;
            }
            if (Left.is(this.Keywords.kw_synchronized) && Right.is_TokenKind('\u0015')) {
                return this.Style.SpaceBeforeParens != FormatStyle.SpaceBeforeParensOptions.SBPO_Never;
            }
            if ((Left.isOneOf('d', '\u008b', '\u0089', '\u008a') || Left.isOneOf(this.Keywords.kw_final, this.Keywords.kw_abstract, this.Keywords.kw_native)) && Right.is_TokenType(TokenType.TT_TemplateOpener)) {
                return true;
            }
        }
        if (Left.is_TokenType(TokenType.TT_ImplicitStringLiteral)) {
            return BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)Right.WhitespaceRange.getBegin(), (SourceLocation)Right.WhitespaceRange.getEnd());
        }
        if (Line.Type == LineType.LT_ObjCMethodDecl) {
            if (Left.is_TokenType(TokenType.TT_ObjCMethodSpecifier)) {
                return true;
            }
            if (Left.is_TokenKind('\u0016') && Right.is_TokenKind('\u0005')) {
                return false;
            }
        }
        if (Line.Type == LineType.LT_ObjCProperty && (Right.is_TokenKind('>') || Left.is_TokenKind('>'))) {
            return false;
        }
        if (Right.isOneOf(TokenType.TT_TrailingReturnArrow, TokenType.TT_LambdaArrow) || Left.isOneOf(TokenType.TT_TrailingReturnArrow, TokenType.TT_LambdaArrow)) {
            return true;
        }
        if (Right.is_TokenType(TokenType.TT_OverloadedOperatorLParen)) {
            return this.Style.SpaceBeforeParens == FormatStyle.SpaceBeforeParensOptions.SBPO_Always;
        }
        if (Left.is_TokenKind('@')) {
            return true;
        }
        if (Right.is_TokenKind('@')) {
            return false;
        }
        if (Right.isOneOf(TokenType.TT_CtorInitializerColon, TokenType.TT_ObjCBlockLParen)) {
            return true;
        }
        if (Right.is_TokenKind('<')) {
            if (Line.First.isOneOf('M', 'Q') || Right.getNextNonComment() == null || Right.getNextNonComment().is_TokenKind('=')) {
                return false;
            }
            if (Right.is_TokenType(TokenType.TT_ObjCMethodExpr)) {
                return false;
            }
            if (Left.is_TokenKind(';')) {
                return false;
            }
            if (Right.is_TokenType(TokenType.TT_InlineASMColon) && Left.is_TokenKind('F')) {
                return false;
            }
            if (Right.is_TokenType(TokenType.TT_DictLiteral)) {
                return this.Style.SpacesInContainerLiterals;
            }
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_UnaryOperator)) {
            return Right.is_TokenType(TokenType.TT_BinaryOperator);
        }
        if (Left.is_TokenType(TokenType.TT_CastRParen)) {
            return this.Style.SpaceAfterCStyleCast || Right.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_SelectorName);
        }
        if (Left.is_TokenKind('2') && Right.is_TokenKind('2')) {
            return Right.is_TokenType(TokenType.TT_TemplateCloser) && Left.is_TokenType(TokenType.TT_TemplateCloser) && (this.Style.Standard != FormatStyle.LanguageStandard.LS_Cpp11 || this.Style.SpacesInAngles);
        }
        if (Right.isOneOf('$', '\u0019', 'E', 'D') || Left.isOneOf('$', '\u0019', 'E', 'D')) {
            return false;
        }
        if (!this.Style.SpaceBeforeAssignmentOperators && Right.getPrecedence() == prec.Level.Assignment) {
            return false;
        }
        if (Right.is_TokenKind('F') && !Left.isOneOf('\u0017', '\u0004')) {
            return Left.is_TokenType(TokenType.TT_TemplateOpener) && this.Style.Standard == FormatStyle.LanguageStandard.LS_Cpp03 || !Left.isOneOf('\u0005', '\u0015', '\u0016', '\u0013') && !Left.isOneOf(TokenType.TT_TemplateCloser, TokenType.TT_TemplateOpener);
        }
        if (Left.is_TokenType(TokenType.TT_TemplateOpener) != Right.is_TokenType(TokenType.TT_TemplateCloser)) {
            return this.Style.SpacesInAngles;
        }
        if (Right.is_TokenType(TokenType.TT_BinaryOperator) && !Left.is_TokenKind('\u0015') || Left.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_ConditionalExpr) && !Right.is_TokenKind('\u0016')) {
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_TemplateCloser) && Right.is_TokenKind('\u0015') && Right.isNot(TokenType.TT_FunctionTypeLParen)) {
            return this.Style.SpaceBeforeParens == FormatStyle.SpaceBeforeParensOptions.SBPO_Always;
        }
        if (Right.is_TokenType(TokenType.TT_TemplateOpener) && Left.is_TokenKind('\u0016') && Left.MatchingParen != null && Left.MatchingParen.is_TokenType(TokenType.TT_OverloadedOperatorLParen)) {
            return false;
        }
        if (Right.is_TokenKind('.') && Left.isNot('\u0015') && Line.startsWith('A')) {
            return true;
        }
        if (Right.is_TokenType(TokenType.TT_TrailingUnaryOperator)) {
            return false;
        }
        if (Left.is_TokenType(TokenType.TT_RegexLiteral)) {
            return false;
        }
        return this.spaceRequiredBetween(Line, Left, Right);
    }

    private boolean mustBreakBefore(AnnotatedLine Line, FormatToken Right) {
        FormatToken Left = Right.Previous;
        if (Unsigned.$greater_uint((int)Right.NewlinesBefore, (int)1) && Unsigned.$greater_uint((int)this.Style.MaxEmptyLinesToKeep, (int)0)) {
            return true;
        }
        if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            if (Right.is_TokenKind('\r') && Left.is_TokenKind(' ') && Left.Previous != null && Left.Previous.is_TokenKind('\r')) {
                return true;
            }
            if (Left.is_TokenType(TokenType.TT_DictLiteral) && Left.is_TokenKind('\u0017') && Line.Level == 0 && Left.Previous != null && Left.Previous.is_TokenKind('>') && Line.First.isOneOf('\u0005', this.Keywords.kw_import, '\u0082', 'O') && !Line.First.isOneOf(this.Keywords.kw_var, this.Keywords.kw_let)) {
                return true;
            }
            if (Left.is_TokenKind('\u0017') && Line.Level == 0 && (Line.startsWith('U') || Line.startsWith('\u0082', 'U'))) {
                return true;
            }
            if (Right.is_TokenKind('\u0018') && Left.is_TokenKind('\u0017') && !Left.Children.empty()) {
                return this.Style.AllowShortFunctionsOnASingleLine == FormatStyle.ShortFunctionStyle.SFS_None || this.Style.AllowShortFunctionsOnASingleLine == FormatStyle.ShortFunctionStyle.SFS_Empty || Left.NestingLevel == 0 && Line.Level == 0 && this.Style.AllowShortFunctionsOnASingleLine == FormatStyle.ShortFunctionStyle.SFS_Inline;
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_Java && Right.is_TokenKind(' ') && Left.is_TokenKind('\r') && Right.Next != null && Right.Next.is_TokenKind('\r')) {
            return true;
        }
        FormatToken BeforeClosingBrace = null;
        if (Left.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare) && Left.BlockKind != BraceBlockKind.BK_Block && Left.MatchingParen != null) {
            BeforeClosingBrace = Left.MatchingParen.Previous;
        } else if (Right.MatchingParen != null && Right.MatchingParen.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare)) {
            BeforeClosingBrace = Left;
        }
        if (BeforeClosingBrace != null && (BeforeClosingBrace.is_TokenKind('@') || BeforeClosingBrace.isTrailingComment())) {
            return true;
        }
        if (Right.is_TokenKind('\u0004')) {
            return Left.BlockKind != BraceBlockKind.BK_BracedInit && Left.isNot(TokenType.TT_CtorInitializerColon) && Unsigned.$greater_uint((int)Right.NewlinesBefore, (int)0) && Right.HasUnescapedNewline;
        }
        if (Left.isTrailingComment()) {
            return true;
        }
        if (Left.isStringLiteral() && (Right.isStringLiteral() || Right.is_TokenType(TokenType.TT_ObjCStringLiteral))) {
            return true;
        }
        if (Right.Previous.IsUnterminatedLiteral) {
            return true;
        }
        if (Right.is_TokenKind('/') && Right.Next != null && Right.Previous.is_TokenKind('\r') && Right.Next.is_TokenKind('\r')) {
            return true;
        }
        if (Right.Previous.ClosesTemplateDeclaration && Right.Previous.MatchingParen != null && Right.Previous.MatchingParen.NestingLevel == 0 && this.Style.AlwaysBreakTemplateDeclarations) {
            return true;
        }
        if (Right.isOneOf(TokenType.TT_CtorInitializerComma, TokenType.TT_CtorInitializerColon) && this.Style.BreakConstructorInitializersBeforeComma && !this.Style.ConstructorInitializerAllOnOneLineOrOnePerLine) {
            return true;
        }
        if (Right.is_TokenKind('\r') && Right.TokenText.startswith("R\"")) {
            return Unsigned.$greater_uint((int)Right.NewlinesBefore, (int)0);
        }
        if (Right.Previous.is_TokenKind('\u0017') && Right.NestingLevel == 1 && this.Style.Language == FormatStyle.LanguageKind.LK_Proto) {
            return true;
        }
        if (Right.is_TokenType(TokenType.TT_InlineASMBrace)) {
            return Right.HasUnescapedNewline;
        }
        if (FormatStatics.isAllmanBrace(Left) || FormatStatics.isAllmanBrace(Right)) {
            return Line.startsWith('U') && this.Style.BraceWrapping.AfterEnum || Line.startsWith('}') && this.Style.BraceWrapping.AfterClass || Line.startsWith('e') && this.Style.BraceWrapping.AfterStruct;
        }
        if (Left.is_TokenType(TokenType.TT_ObjCBlockLBrace) && !this.Style.AllowShortBlocksOnASingleLine) {
            return true;
        }
        return !(this.Style.Language != FormatStyle.LanguageKind.LK_Java && this.Style.Language != FormatStyle.LanguageKind.LK_JavaScript || !Left.is_TokenType(TokenType.TT_LeadingJavaAnnotation) || !Right.isNot(TokenType.TT_LeadingJavaAnnotation) || !Right.isNot('\u0015') || !Line.Last.is_TokenKind('\u0017') && !this.Style.BreakAfterJavaFieldAnnotations);
    }

    private boolean canBreakBefore(AnnotatedLine Line, FormatToken Right) {
        FormatToken Left = Right.Previous;
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java) {
            if (Left.isOneOf(this.Keywords.kw_throws, this.Keywords.kw_extends, this.Keywords.kw_implements)) {
                return false;
            }
            if (Right.isOneOf(this.Keywords.kw_throws, this.Keywords.kw_extends, this.Keywords.kw_implements)) {
                return true;
            }
        } else if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            if (Left.is_TokenKind('`')) {
                return false;
            }
            if (Left.is_TokenType(TokenType.TT_JsFatArrow) && Right.is_TokenKind('\u0017')) {
                return false;
            }
            if (Left.is_TokenType(TokenType.TT_JsTypeColon)) {
                return true;
            }
            if (Right.NestingLevel == 0 && Right.is(this.Keywords.kw_is)) {
                return false;
            }
            if (Left.is(this.Keywords.kw_in)) {
                return this.Style.BreakBeforeBinaryOperators == FormatStyle.BinaryOperatorStyle.BOS_None;
            }
            if (Right.is(this.Keywords.kw_in)) {
                return this.Style.BreakBeforeBinaryOperators != FormatStyle.BinaryOperatorStyle.BOS_None;
            }
            if (Right.is(this.Keywords.kw_as)) {
                return false;
            }
        }
        if (Left.is_TokenKind('G')) {
            return false;
        }
        if (Left.Tok.getObjCKeywordID() == '\u0007') {
            return false;
        }
        if (Left.isOneOf(TokenType.TT_JavaAnnotation, TokenType.TT_LeadingJavaAnnotation)) {
            return !Right.is_TokenKind('\u0015');
        }
        if (Right.is_TokenType(TokenType.TT_PointerOrReference)) {
            return Line.IsMultiVariableDeclStmt || this.Style.PointerAlignment == FormatStyle.PointerAlignmentStyle.PAS_Right && (Right.Next == null || Right.Next.isNot(TokenType.TT_FunctionDeclarationName));
        }
        if (Right.isOneOf(TokenType.TT_StartOfName, TokenType.TT_FunctionDeclarationName) || Right.is_TokenKind('\u0088')) {
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_PointerOrReference)) {
            return false;
        }
        if (Right.isTrailingComment()) {
            return Left.BlockKind == BraceBlockKind.BK_BracedInit;
        }
        if (Left.is_TokenKind(';') && Right.is_TokenKind('<')) {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_ConditionalExpr) || Right.is_TokenKind(';')) {
            return this.Style.BreakBeforeTernaryOperators;
        }
        if (Left.is_TokenType(TokenType.TT_ConditionalExpr) || Left.is_TokenKind(';')) {
            return !this.Style.BreakBeforeTernaryOperators;
        }
        if (Right.is_TokenType(TokenType.TT_InheritanceColon)) {
            return true;
        }
        if (Right.is_TokenKind('<') && !Right.isOneOf(TokenType.TT_CtorInitializerColon, TokenType.TT_InlineASMColon)) {
            return false;
        }
        if (Left.is_TokenKind('<') && Left.isOneOf(TokenType.TT_DictLiteral, TokenType.TT_ObjCMethodExpr)) {
            return true;
        }
        if (Right.is_TokenType(TokenType.TT_SelectorName) || Right.is_TokenKind('\u0005') && Right.Next != null && Right.Next.is_TokenType(TokenType.TT_ObjCMethodExpr)) {
            return Left.isNot('\u0019');
        }
        if (Left.is_TokenKind('\u0016') && Line.Type == LineType.LT_ObjCProperty) {
            return true;
        }
        if (Left.ClosesTemplateDeclaration || Left.is_TokenType(TokenType.TT_FunctionAnnotationRParen)) {
            return true;
        }
        if (Right.isOneOf(TokenType.TT_RangeBasedForLoopColon, TokenType.TT_OverloadedOperatorLParen, TokenType.TT_OverloadedOperator)) {
            return false;
        }
        if (Left.is_TokenType(TokenType.TT_RangeBasedForLoopColon)) {
            return true;
        }
        if (Right.is_TokenType(TokenType.TT_RangeBasedForLoopColon)) {
            return false;
        }
        if (Left.isOneOf(TokenType.TT_TemplateCloser, TokenType.TT_UnaryOperator) || Left.is_TokenKind('\u0088')) {
            return false;
        }
        if (Left.is_TokenKind('>') && !Right.isOneOf('Q', '\u007f') && Line.Type == LineType.LT_VirtualFunctionDecl && Left.NestingLevel == 0) {
            return false;
        }
        if (Left.is_TokenKind('\u0015') && Left.is_TokenType(TokenType.TT_AttributeParen)) {
            return false;
        }
        if (Left.is_TokenKind('\u0015') && Left.Previous != null && Left.Previous.isOneOf(TokenType.TT_BinaryOperator, TokenType.TT_CastRParen)) {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_ImplicitStringLiteral)) {
            return false;
        }
        if (Right.is_TokenKind('\u0016') || Right.is_TokenType(TokenType.TT_TemplateCloser)) {
            return false;
        }
        if (Right.is_TokenKind('\u0014') && Right.MatchingParen != null && Right.MatchingParen.is_TokenType(TokenType.TT_LambdaLSquare)) {
            return false;
        }
        if (Right.is_TokenKind('\u0018')) {
            return Right.MatchingParen != null && Right.MatchingParen.BlockKind == BraceBlockKind.BK_Block;
        }
        if (Left.is_TokenType(TokenType.TT_TrailingAnnotation)) {
            return !Right.isOneOf('\u0017', '=', '>', '\u0015', '.', 'F');
        }
        if (Right.is_TokenKind('\u00ac')) {
            return true;
        }
        if (Left.is_TokenKind('\u0005') && Right.is_TokenKind('\r')) {
            return true;
        }
        if (Right.is_TokenKind('\u0005') && Right.Next != null && Right.Next.is_TokenType(TokenType.TT_DictLiteral)) {
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_CtorInitializerComma) && this.Style.BreakConstructorInitializersBeforeComma) {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_CtorInitializerComma) && this.Style.BreakConstructorInitializersBeforeComma) {
            return true;
        }
        if (Left.is_TokenKind('2') && Right.is_TokenKind('2') || Left.is_TokenKind('.') && Right.is_TokenKind('.')) {
            return false;
        }
        if (Right.is_TokenType(TokenType.TT_BinaryOperator) && this.Style.BreakBeforeBinaryOperators != FormatStyle.BinaryOperatorStyle.BOS_None && (this.Style.BreakBeforeBinaryOperators == FormatStyle.BinaryOperatorStyle.BOS_All || Right.getPrecedence() != prec.Level.Assignment)) {
            return true;
        }
        if (Left.is_TokenType(TokenType.TT_ArrayInitializerLSquare)) {
            return true;
        }
        if (Right.is_TokenKind('\u0093') && Left.isNot('O')) {
            return true;
        }
        if (!(!Left.isBinaryOperator() && !Left.is_TokenType(TokenType.TT_BinaryOperator) || Left.isOneOf('E', '/') || this.Style.BreakBeforeBinaryOperators == FormatStyle.BinaryOperatorStyle.BOS_All || this.Style.BreakBeforeBinaryOperators != FormatStyle.BinaryOperatorStyle.BOS_None && Left.getPrecedence() != prec.Level.Assignment)) {
            return true;
        }
        return Left.isOneOf('@', 'F', '=', '\u0017', '}', 'e', '\u0004') || Right.isMemberAccess() || Right.isOneOf(TokenType.TT_TrailingReturnArrow, TokenType.TT_LambdaArrow, '/', '<', '\u0013', 'G') || Left.is_TokenKind('\u0016') && Right.isOneOf('\u0005', 'O') || Left.is_TokenKind('\u0015') && !Right.is_TokenKind('\u0016');
    }

    private boolean mustBreakForReturnType(AnnotatedLine Line) {
        assert (Line.MightBeFunctionDecl);
        if ((this.Style.AlwaysBreakAfterReturnType == FormatStyle.ReturnTypeBreakingStyle.RTBS_TopLevel || this.Style.AlwaysBreakAfterReturnType == FormatStyle.ReturnTypeBreakingStyle.RTBS_TopLevelDefinitions) && Unsigned.$greater_uint((int)Line.Level, (int)0)) {
            return false;
        }
        switch (this.Style.AlwaysBreakAfterReturnType) {
            case RTBS_None: {
                return false;
            }
            case RTBS_All: 
            case RTBS_TopLevel: {
                return true;
            }
            case RTBS_AllDefinitions: 
            case RTBS_TopLevelDefinitions: {
                return Line.mightBeFunctionDefinition();
            }
        }
        return false;
    }

    private void printDebugInfo(AnnotatedLine Line) {
        llvm.errs().$out("AnnotatedTokens:\n");
        FormatToken Tok = Line.First;
        while (Tok != null) {
            llvm.errs().$out(" M=").$out_int(Tok.MustBreakBefore ? 1 : 0).$out(" C=").$out_int(Tok.CanBreakBefore ? 1 : 0).$out(" T=").$out(FormatStatics.getTokenTypeName(Tok.Type)).$out(" S=").$out_uint(Tok.SpacesRequiredBefore).$out(" B=").$out_uint(Tok.BlockParameterCount).$out(" P=").$out_uint(Tok.SplitPenalty).$out(" Name=").$out(Tok.Tok.getName()).$out(" L=").$out_uint(Tok.TotalLength).$out(" PPK=").$out_int(Tok.PackingKind.getValue()).$out(" FakeLParens=");
            int e = Tok.FakeLParens.size();
            for (int i = 0; i != e; ++i) {
                llvm.errs().$out_int(((prec.Level)Tok.FakeLParens.$at$Const(i)).getValue()).$out(NativePointer.$SLASH);
            }
            llvm.errs().$out(" FakeRParens=").$out_uint(Tok.FakeRParens).$out(NativePointer.$LF);
            if (Tok.Next == null) assert (Tok == Line.Last);
            Tok = Tok.Next;
        }
        llvm.errs().$out("----\n");
    }

    private void calculateUnbreakableTailLengths(AnnotatedLine Line) {
        int UnbreakableTailLength = 0;
        FormatToken Current = Line.Last;
        while (Current != null) {
            Current.UnbreakableTailLength = UnbreakableTailLength;
            UnbreakableTailLength = Current.CanBreakBefore || Current.isOneOf('\u0004', '\r') ? 0 : (UnbreakableTailLength += Current.ColumnWidth + Current.SpacesRequiredBefore);
            Current = Current.Previous;
        }
    }

    public String toString() {
        return "Style=" + this.Style + ", Keywords=" + this.Keywords;
    }
}

