/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Comparator;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.ContinuationIndenter;
import org.clang.format.impl.FormatDecision;
import org.clang.format.impl.LineFormatter;
import org.clang.format.impl.LineState;
import org.clang.format.impl.LineType;
import org.clang.format.impl.ParenState;
import org.clang.format.impl.UnwrappedLineFormatter;
import org.clang.format.impl.WhitespaceManager;
import org.clank.java.std;
import org.clank.java.std_deque;
import org.clank.java.std_functional;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.uint;
import org.llvm.support.SpecificBumpPtrAllocator;

public class OptimizingLineFormatter
extends LineFormatter
implements Destructors.ClassWithDestructor {
    private SpecificBumpPtrAllocator<StateNode> Allocator = new SpecificBumpPtrAllocator(StateNode.class);

    public OptimizingLineFormatter(ContinuationIndenter Indenter, WhitespaceManager Whitespaces, FormatStyle Style, UnwrappedLineFormatter BlockFormatter) {
        super(Indenter, Whitespaces, Style, BlockFormatter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int formatLine(AnnotatedLine Line, int FirstIndent, boolean DryRun) {
        LineState State = null;
        try {
            State = this.Indenter.getInitialState(FirstIndent, Line, DryRun);
            if (State.Line.Type == LineType.LT_ObjCMethodDecl) {
                ((ParenState)State.Stack.back()).BreakBeforeParameter = true;
            }
            int n = this.analyzeSolutionSpace(State, DryRun);
            return n;
        }
        finally {
            if (State != null) {
                State.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int analyzeSolutionSpace(LineState InitialState, boolean DryRun) {
        std.setPtr Seen = null;
        std.priority_queue Queue = null;
        try {
            Seen = new std.setPtr((std_functional.binary_functionArgArg2Bool)new CompareLineStatePointers());
            uint.ptr Count = NativePointer.create_uint$ptr((int)0);
            Queue = new std.priority_queue((Comparator)new Comparator<std_pair.pair<std_pair.pairUIntUInt, StateNode>>(){

                @Override
                public int compare(std_pair.pair<std_pair.pairUIntUInt, StateNode> left, std_pair.pair<std_pair.pairUIntUInt, StateNode> right) {
                    int res = ((std_pair.pairUIntUInt)left.first).first - ((std_pair.pairUIntUInt)right.first).first;
                    if (res != 0 || (res = ((std_pair.pairUIntUInt)left.first).second - ((std_pair.pairUIntUInt)right.first).second) == 0) {
                        // empty if block
                    }
                    return res;
                }
            });
            StateNode Node = (StateNode)Native.$new_uint_voidPtr((Object)this.Allocator.Allocate(), New$Mem -> new StateNode(InitialState, false, null));
            Queue.push_value_type((Object)new std_pair.pairTypePtr(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, 0, Count.$star()), (Object)Node));
            Count.$set$preInc(0);
            int Penalty = 0;
            while (!Queue.empty()) {
                Penalty = ((std_pair.pairUIntUInt)((std_pair.pair)Queue.top()).first).first;
                StateNode Node$1 = (StateNode)((std_pair.pair)Queue.top()).second;
                if (Node$1.State.NextToken == null) break;
                Queue.pop();
                if (Unsigned.$greater_uint((int)Count.$star(), (int)50000)) {
                    Node$1.State.IgnoreStackForComparison = true;
                }
                if (!Seen.insert_T$RR((Object)Node$1.State).second) continue;
                FormatDecision LastFormat = Node$1.State.NextToken.Decision;
                if (LastFormat == FormatDecision.FD_Unformatted || LastFormat == FormatDecision.FD_Continue) {
                    this.addNextStateToQueue(Penalty, Node$1, false, Count, (std.priority_queue<std_pair.pair<std_pair.pairUIntUInt, StateNode>>)Queue);
                }
                if (LastFormat != FormatDecision.FD_Unformatted && LastFormat != FormatDecision.FD_Break) continue;
                this.addNextStateToQueue(Penalty, Node$1, true, Count, (std.priority_queue<std_pair.pair<std_pair.pairUIntUInt, StateNode>>)Queue);
            }
            if (Queue.empty()) {
                int n = 0;
                return n;
            }
            if (!DryRun) {
                this.reconstructPath(InitialState, (StateNode)((std_pair.pair)Queue.top()).second);
            }
            int n = Penalty;
            return n;
        }
        finally {
            if (Queue != null) {
                Queue.$destroy();
            }
            if (Seen != null) {
                Seen.$destroy();
            }
        }
    }

    private void addNextStateToQueue(int Penalty, StateNode PreviousNode, boolean NewLine, uint.ptr Count, std.priority_queue<std_pair.pair<std_pair.pairUIntUInt, StateNode>> Queue) {
        if (NewLine && !this.Indenter.canBreak(PreviousNode.State)) {
            return;
        }
        if (!NewLine && this.Indenter.mustBreak(PreviousNode.State)) {
            return;
        }
        uint.ref Penalty_ref = NativePointer.create_uint$ref((int)Penalty);
        StateNode Node = (StateNode)Native.$new_uint_voidPtr((Object)this.Allocator.Allocate(), New$Mem -> new StateNode(PreviousNode.State, NewLine, PreviousNode));
        if (!this.formatChildren(Node.State, NewLine, true, Penalty_ref)) {
            return;
        }
        Penalty_ref.$set$addassign(this.Indenter.addTokenToState(Node.State, NewLine, true));
        Queue.push_value_type((Object)new std_pair.pairTypePtr(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, (Object)new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, Penalty_ref.$deref(), Count.$star()), (Object)Node));
        Count.$set$preInc(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconstructPath(LineState State, StateNode Best) {
        std_deque.deque Path = null;
        try {
            Path = new std_deque.deque(true);
            while (Best.Previous != null) {
                Path.push_front_T$C$R((Object)Best);
                Best = Best.Previous;
            }
            std_deque.deque.iterator I = Path.begin();
            std_deque.deque.iterator E = Path.end();
            while (std.$noteq__Deque_iterator$_Tp$_Ref$_Ptr$C((std_deque.deque.iterator)I, (std_deque.deque.iterator)E)) {
                uint.ref Penalty = NativePointer.create_uint$ref((int)0);
                this.formatChildren(State, ((StateNode)I.$star()).NewLine, false, Penalty);
                Penalty.$set$addassign(this.Indenter.addTokenToState(State, ((StateNode)I.$star()).NewLine, false));
                I.$preInc();
            }
        }
        finally {
            if (Path != null) {
                Path.$destroy();
            }
        }
    }

    @Override
    public void $destroy() {
        this.Allocator.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Allocator=" + this.Allocator + super.toString();
    }

    private static class StateNode
    implements Destructors.ClassWithDestructor {
        public LineState State;
        public boolean NewLine;
        public StateNode Previous;

        public StateNode(LineState State, boolean NewLine, StateNode Previous) {
            this.State = new LineState(State);
            this.NewLine = NewLine;
            this.Previous = Previous;
        }

        public void $destroy() {
            this.State.$destroy();
        }

        public String toString() {
            return "State=" + this.State + ", NewLine=" + this.NewLine + ", Previous=" + this.Previous;
        }
    }

    private static class CompareLineStatePointers
    implements std.Compare<LineState> {
        public boolean $call(LineState obj1, LineState obj2) {
            return obj1.$less(obj2);
        }

        public boolean compare(LineState a, LineState b) {
            return this.$call(a, b);
        }

        public String toString() {
            return "";
        }
    }
}

