/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.LevelIndentTracker;
import org.clang.format.impl.LineType;
import org.clang.format.impl.TokenType;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.aliases.SmallVectorImpl;

public class LineJoiner {
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private type.ptr<AnnotatedLine> End;
    private type.ptr<AnnotatedLine> Next;

    public LineJoiner(FormatStyle Style, AdditionalKeywords Keywords, SmallVectorImpl<AnnotatedLine> Lines) {
        this.Style = Style;
        this.Keywords = Keywords;
        this.End = (type.ptr)Native.$tryClone((NativeCloneable)Lines.end$Const());
        this.Next = (type.ptr)Native.$tryClone((NativeCloneable)Lines.begin$Const());
    }

    public AnnotatedLine getNextMergedLine(boolean DryRun, LevelIndentTracker IndentTracker) {
        int i;
        if (Native.$eq_ptr(this.Next, this.End)) {
            return null;
        }
        AnnotatedLine Current = (AnnotatedLine)this.Next.$star();
        IndentTracker.nextLine(Current);
        int MergedLines = this.tryFitMultipleLinesInOne(IndentTracker.getIndent(), this.Next, this.End);
        if (Unsigned.$greater_uint((int)MergedLines, (int)0) && this.Style.ColumnLimit == 0) {
            i = 0;
            while (Unsigned.$less_uint((int)i, (int)MergedLines)) {
                if (Unsigned.$greater_uint((int)((AnnotatedLine)this.Next.$at((int)(i + 1))).First.NewlinesBefore, (int)0)) {
                    MergedLines = 0;
                }
                ++i;
            }
        }
        if (!DryRun) {
            i = 0;
            while (Unsigned.$less_uint((int)i, (int)MergedLines)) {
                this.join((AnnotatedLine)this.Next.$at(i), (AnnotatedLine)this.Next.$at(i + 1));
                ++i;
            }
        }
        this.Next = (type.ptr)Native.$tryClone((NativeCloneable)((type.ptr)this.Next.$add(MergedLines)).$add(1));
        return Current;
    }

    private int tryFitMultipleLinesInOne(int Indent, type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E) {
        boolean MergeShortFunctions;
        if (Native.$eq_ptr((void.ptr)((void.ptr)I.$add(1)), E)) {
            return 0;
        }
        AnnotatedLine TheLine = (AnnotatedLine)I.$star();
        if (TheLine.Last.is_TokenType(TokenType.TT_LineComment)) {
            return 0;
        }
        if (((AnnotatedLine)I.$at((int)1)).Type == LineType.LT_Invalid || ((AnnotatedLine)I.$at((int)1)).First.MustBreakBefore) {
            return 0;
        }
        if (TheLine.InPPDirective && (!((AnnotatedLine)I.$at((int)1)).InPPDirective || ((AnnotatedLine)I.$at((int)1)).First.HasUnescapedNewline)) {
            return 0;
        }
        if (Unsigned.$greater_uint((int)this.Style.ColumnLimit, (int)0) && Unsigned.$greater_uint((int)Indent, (int)this.Style.ColumnLimit)) {
            return 0;
        }
        int Limit = this.Style.ColumnLimit == 0 ? -1 : this.Style.ColumnLimit - Indent;
        Limit = Unsigned.$greater_uint((int)TheLine.Last.TotalLength, (int)Limit) ? 0 : Limit - TheLine.Last.TotalLength;
        boolean bl = MergeShortFunctions = this.Style.AllowShortFunctionsOnASingleLine == FormatStyle.ShortFunctionStyle.SFS_All || this.Style.AllowShortFunctionsOnASingleLine.getValue() >= FormatStyle.ShortFunctionStyle.SFS_Empty.getValue() && ((AnnotatedLine)I.$at((int)1)).First.is_TokenKind('\u0018') || this.Style.AllowShortFunctionsOnASingleLine == FormatStyle.ShortFunctionStyle.SFS_Inline && TheLine.Level != 0;
        if (TheLine.Last.is_TokenType(TokenType.TT_FunctionLBrace) && TheLine.First != TheLine.Last) {
            return MergeShortFunctions ? this.tryMergeSimpleBlock(I, E, Limit) : 0;
        }
        if (TheLine.Last.is_TokenKind('\u0017')) {
            return !this.Style.BraceWrapping.AfterFunction ? this.tryMergeSimpleBlock(I, E, Limit) : 0;
        }
        if (((AnnotatedLine)I.$at((int)1)).First.is_TokenType(TokenType.TT_FunctionLBrace) && this.Style.BraceWrapping.AfterFunction) {
            if (((AnnotatedLine)I.$at((int)1)).Last.is_TokenType(TokenType.TT_LineComment)) {
                return 0;
            }
            if (Unsigned.$lesseq_uint((int)Limit, (int)2) || this.Style.ColumnLimit == 0 && this.containsMustBreak(TheLine)) {
                return 0;
            }
            int MergedLines = 0;
            if (MergeShortFunctions && Unsigned.$greater_uint((int)(MergedLines = this.tryMergeSimpleBlock((type.ptr<AnnotatedLine>)((type.ptr)I.$add(1)), E, Limit -= 2)), (int)0)) {
                ++MergedLines;
            }
            return MergedLines;
        }
        if (TheLine.First.is_TokenKind('Z')) {
            return this.Style.AllowShortIfStatementsOnASingleLine ? this.tryMergeSimpleControlStatement(I, E, Limit) : 0;
        }
        if (TheLine.First.isOneOf('X', 'l')) {
            return this.Style.AllowShortLoopsOnASingleLine ? this.tryMergeSimpleControlStatement(I, E, Limit) : 0;
        }
        if (TheLine.First.isOneOf('M', 'Q')) {
            return this.Style.AllowShortCaseLabelsOnASingleLine ? this.tryMergeShortCaseLabels(I, E, Limit) : 0;
        }
        if (TheLine.InPPDirective && (TheLine.First.HasUnescapedNewline || TheLine.First.IsFirst)) {
            return this.tryMergeSimplePPDirective(I, E, Limit);
        }
        return 0;
    }

    private int tryMergeSimplePPDirective(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E, int Limit) {
        if (Limit == 0) {
            return 0;
        }
        if (Native.$noteq_ptr((void.ptr)((void.ptr)I.$add(2)), E) && ((AnnotatedLine)I.$at((int)2)).InPPDirective && !((AnnotatedLine)I.$at((int)2)).First.HasUnescapedNewline) {
            return 0;
        }
        if (Unsigned.$greater_uint((int)(1 + ((AnnotatedLine)I.$at((int)1)).Last.TotalLength), (int)Limit)) {
            return 0;
        }
        return 1;
    }

    private int tryMergeSimpleControlStatement(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E, int Limit) {
        if (Limit == 0) {
            return 0;
        }
        if (this.Style.BraceWrapping.AfterControlStatement && ((AnnotatedLine)I.$at((int)1)).First.is_TokenKind('\u0017') && !this.Style.AllowShortBlocksOnASingleLine) {
            return 0;
        }
        if (((AnnotatedLine)I.$at((int)1)).InPPDirective != ((AnnotatedLine)I.$star()).InPPDirective || ((AnnotatedLine)I.$at((int)1)).InPPDirective && ((AnnotatedLine)I.$at((int)1)).First.HasUnescapedNewline) {
            return 0;
        }
        Limit = this.limitConsideringMacros((type.ptr<AnnotatedLine>)((type.ptr)I.$add(1)), E, Limit);
        AnnotatedLine Line = (AnnotatedLine)I.$star();
        if (Line.Last.isNot('\u0016')) {
            return 0;
        }
        if (Unsigned.$greater_uint((int)(1 + ((AnnotatedLine)I.$at((int)1)).Last.TotalLength), (int)Limit)) {
            return 0;
        }
        if (((AnnotatedLine)I.$at((int)1)).First.isOneOf('=', 'Z', 'X', 'l') || ((AnnotatedLine)I.$at((int)1)).First.isOneOf(TokenType.TT_LineComment, new TokenType[0])) {
            return 0;
        }
        if (Native.$noteq_ptr((void.ptr)((void.ptr)I.$add(2)), E) && Line.startsWith('Z') && ((AnnotatedLine)I.$at((int)2)).First.is_TokenKind('T')) {
            return 0;
        }
        return 1;
    }

    private int tryMergeShortCaseLabels(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E, int Limit) {
        if (Limit == 0 || Native.$eq_ptr((void.ptr)((void.ptr)I.$add(1)), E) || ((AnnotatedLine)I.$at((int)1)).First.isOneOf('M', 'Q')) {
            return 0;
        }
        int NumStmts = 0;
        int Length = 0;
        boolean InPPDirective = ((AnnotatedLine)I.$at((int)0)).InPPDirective;
        while (Unsigned.$less_uint((int)NumStmts, (int)3) && !Native.$eq_ptr((void.ptr)((void.ptr)((type.ptr)I.$add(1)).$add(NumStmts)), E)) {
            AnnotatedLine Line = (AnnotatedLine)I.$at(1 + NumStmts);
            if (Line.InPPDirective != InPPDirective || Line.First.isOneOf('M', 'Q', '\u0018')) break;
            if (Line.First.isOneOf('Z', 'X', 'f', 'l', '\u0004') || Line.Last.is_TokenKind('\u0004')) {
                return 0;
            }
            Length += ((AnnotatedLine)I.$at((int)(1 + NumStmts))).Last.TotalLength + 1;
            ++NumStmts;
        }
        if (NumStmts == 0 || NumStmts == 3 || Unsigned.$greater_uint((int)Length, (int)Limit)) {
            return 0;
        }
        return NumStmts;
    }

    private int tryMergeSimpleBlock(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E, int Limit) {
        FormatToken Tok;
        AnnotatedLine Line = (AnnotatedLine)I.$star();
        if (this.Style.Language != FormatStyle.LanguageKind.LK_Java && Line.First.isOneOf('G', '#', ' ')) {
            return 0;
        }
        if (Line.First.isOneOf('T', 'M') || Line.First.Next != null && Line.First.Next.is_TokenKind('T')) {
            return 0;
        }
        if (Line.First.isOneOf('Z', 'l', 'R', '\u0092', '\u0138', '|', '\u0139', 'X', '\u0018') || Line.First.is(this.Keywords.kw___except)) {
            if (!this.Style.AllowShortBlocksOnASingleLine) {
                return 0;
            }
            if (!this.Style.AllowShortIfStatementsOnASingleLine && Line.startsWith('Z')) {
                return 0;
            }
            if (!this.Style.AllowShortLoopsOnASingleLine && Line.First.isOneOf('l', 'R', 'X')) {
                return 0;
            }
            if (Line.First.isOneOf('\u0092', '\u0138', '|') || Line.First.isOneOf(this.Keywords.kw___except, '\u0139')) {
                return 0;
            }
        }
        if ((Tok = ((AnnotatedLine)I.$at((int)1)).First).is_TokenKind('\u0018') && !Tok.MustBreakBefore && (Tok.getNextNonComment() == null || Tok.getNextNonComment().is_TokenKind('='))) {
            Tok.SpacesRequiredBefore = 0;
            Tok.CanBreakBefore = true;
            return 1;
        }
        if (Limit != 0 && !Line.startsWith('\u0086') && !FormatStatics.startsExternCBlock(Line)) {
            if (Line.First.isOneOf('}', 'h', 'e') || Line.First.is(this.Keywords.kw_interface)) {
                return 0;
            }
            if (Native.$eq_ptr((void.ptr)((void.ptr)I.$add(2)), E) || ((AnnotatedLine)I.$at((int)2)).Type == LineType.LT_Invalid) {
                return 0;
            }
            Limit = this.limitConsideringMacros((type.ptr<AnnotatedLine>)((type.ptr)I.$add(2)), E, Limit);
            if (!this.nextTwoLinesFitInto(I, Limit)) {
                return 0;
            }
            if (((AnnotatedLine)I.$at((int)1)).Last.is_TokenType(TokenType.TT_LineComment)) {
                return 0;
            }
            do {
                if (!Tok.is_TokenKind('\u0017') || Tok.BlockKind == BraceBlockKind.BK_BracedInit) continue;
                return 0;
            } while ((Tok = Tok.Next) != null);
            Tok = ((AnnotatedLine)I.$at((int)2)).First;
            if (Tok.isNot('\u0018')) {
                return 0;
            }
            if (Tok.Next != null && Tok.Next.is_TokenKind('T')) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    private int limitConsideringMacros(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E, int Limit) {
        if (((AnnotatedLine)I.$at((int)0)).InPPDirective && Native.$noteq_ptr((void.ptr)((void.ptr)I.$add(1)), E) && !((AnnotatedLine)I.$at((int)1)).First.HasUnescapedNewline && !((AnnotatedLine)I.$at((int)1)).First.is_TokenKind('\u0001')) {
            return Unsigned.$less_uint((int)Limit, (int)2) ? 0 : Limit - 2;
        }
        return Limit;
    }

    private boolean nextTwoLinesFitInto(type.ptr<AnnotatedLine> I, int Limit) {
        if (((AnnotatedLine)I.$at((int)1)).First.MustBreakBefore || ((AnnotatedLine)I.$at((int)2)).First.MustBreakBefore) {
            return false;
        }
        return Unsigned.$lesseq_uint((int)(1 + ((AnnotatedLine)I.$at((int)1)).Last.TotalLength + 1 + ((AnnotatedLine)I.$at((int)2)).Last.TotalLength), (int)Limit);
    }

    private boolean containsMustBreak(AnnotatedLine Line) {
        FormatToken Tok = Line.First;
        while (Tok != null) {
            if (Tok.MustBreakBefore) {
                return true;
            }
            Tok = Tok.Next;
        }
        return false;
    }

    private void join(AnnotatedLine A, AnnotatedLine B) {
        assert (A.Last.Next == null);
        assert (B.First.Previous == null);
        if (B.Affected) {
            A.Affected = true;
        }
        A.Last.Next = B.First;
        B.First.Previous = A.Last;
        B.First.CanBreakBefore = true;
        int LengthA = A.Last.TotalLength + B.First.SpacesRequiredBefore;
        FormatToken Tok = B.First;
        while (Tok != null) {
            Tok.TotalLength += LengthA;
            A.Last = Tok;
            Tok = Tok.Next;
        }
    }

    public String toString() {
        return "Style=" + this.Style + ", Keywords=" + this.Keywords + ", End=" + this.End + ", Next=" + this.Next;
    }
}

