/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.Regex;
import org.llvm.support.llvm;
import org.llvm.support.sys.path;

public class IncludeCategoryManager
implements Destructors.ClassWithDestructor {
    private final FormatStyle Style;
    private boolean IsMainFile;
    private StringRef FileName;
    private StringRef FileStem;
    private SmallVector<Regex> CategoryRegexs;

    public IncludeCategoryManager(FormatStyle Style, StringRef FileName) {
        this.Style = Style;
        this.FileName = new StringRef(FileName);
        this.FileStem = new StringRef();
        this.CategoryRegexs = new SmallVector(4, null);
        this.FileStem.$assignMove(path.stem((StringRef)FileName));
        for (FormatStyle.IncludeCategory Category : Style.IncludeCategories) {
            this.CategoryRegexs.emplace_back((Object)new Regex(new StringRef(Category.Regex)));
        }
        this.IsMainFile = FileName.endswith(".c") || FileName.endswith(".cc") || FileName.endswith(".cpp") || FileName.endswith(".c++") || FileName.endswith(".cxx") || FileName.endswith(".m") || FileName.endswith(".mm");
    }

    public int getIncludePriority(StringRef IncludeName, boolean CheckMainHeader) {
        int Ret = Integer.MAX_VALUE;
        int e = this.CategoryRegexs.size();
        for (int i = 0; i != e; ++i) {
            if (!((Regex)this.CategoryRegexs.$at(i)).find(IncludeName)) continue;
            Ret = ((FormatStyle.IncludeCategory)this.Style.IncludeCategories.$at$Const((int)i)).Priority;
            break;
        }
        if (CheckMainHeader && this.IsMainFile && Ret > 0 && this.isMainHeader(new StringRef(IncludeName))) {
            Ret = 0;
        }
        return Ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMainHeader(StringRef IncludeName) {
        if (!IncludeName.startswith("\"")) {
            return false;
        }
        StringRef HeaderStem = path.stem((StringRef)IncludeName.drop_front(1).drop_back(1));
        if (this.FileStem.startswith(HeaderStem)) {
            Regex MainIncludeRegex = null;
            try {
                MainIncludeRegex = new Regex(new StringRef(llvm.$add_Twine$C((Twine)new Twine(HeaderStem), (Twine)new Twine(this.Style.IncludeIsMainRegex)).str()));
                if (MainIncludeRegex.find(this.FileStem)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (MainIncludeRegex != null) {
                    MainIncludeRegex.$destroy();
                }
            }
        }
        return false;
    }

    public void $destroy() {
        this.CategoryRegexs.$destroy();
    }

    public String toString() {
        return "Style=" + this.Style + ", IsMainFile=" + this.IsMainFile + ", FileName=" + this.FileName + ", FileStem=" + this.FileStem + ", CategoryRegexs=" + this.CategoryRegexs;
    }
}

