/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.SourceLocation;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.ContinuationIndenter;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.FormatTokenLexer;
import org.clang.format.impl.ParameterPackingKind;
import org.clang.format.impl.TokenAnalyzer;
import org.clang.format.impl.TokenAnnotator;
import org.clang.format.impl.TokenType;
import org.clang.format.impl.UnwrappedLineFormatter;
import org.clang.format.impl.WhitespaceManager;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;

public class Formatter
extends TokenAnalyzer
implements Destructors.ClassWithDestructor {
    private boolean BinPackInconclusiveFunctions;
    private bool.ptr IncompleteFormat;

    public Formatter(Environment Env, FormatStyle Style, bool.ptr IncompleteFormat) {
        super(Env, Style);
        this.IncompleteFormat = (bool.ptr)Native.$tryClone((NativeCloneable)IncompleteFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public std.setType<Replacement> analyze(TokenAnnotator Annotator, SmallVectorImpl<AnnotatedLine> AnnotatedLines, FormatTokenLexer Tokens, std.setType<Replacement> Result) {
        WhitespaceManager Whitespaces = null;
        ContinuationIndenter Indenter = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.deriveLocalStyle(AnnotatedLines);
            this.AffectedRangeMgr.computeAffectedLines((type.ptr<AnnotatedLine>)AnnotatedLines.begin(), (type.ptr<AnnotatedLine>)AnnotatedLines.end());
            if (this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript && this.Style.JavaScriptQuotes != FormatStyle.JavaScriptQuoteStyle.JSQS_Leave) {
                this.requoteJSStringLiteral(AnnotatedLines, Result);
            }
            int e = AnnotatedLines.size();
            for (int i = 0; i != e; ++i) {
                Annotator.calculateFormattingInformation((AnnotatedLine)AnnotatedLines.$at(i));
            }
            Annotator.setCommentLineLevels(AnnotatedLines);
            Whitespaces = new WhitespaceManager(this.Env.getSourceManager(), this.Style, Formatter.inputUsesCRLF(this.Env.getSourceManager().getBufferData(this.Env.getFileID())));
            Indenter = new ContinuationIndenter(this.Style, Tokens.getKeywords(), this.Env.getSourceManager(), Whitespaces, this.Encoding, this.BinPackInconclusiveFunctions);
            $c$.clean(((UnwrappedLineFormatter)$c$.track((Object)new UnwrappedLineFormatter(Indenter, Whitespaces, this.Style, Tokens.getKeywords(), this.IncompleteFormat))).format(AnnotatedLines));
            std.setType setType2 = new std.setType(Whitespaces.generateReplacements());
            return setType2;
        }
        finally {
            if (Indenter != null) {
                Indenter.$destroy();
            }
            if (Whitespaces != null) {
                Whitespaces.$destroy();
            }
            $c$.$destroy();
        }
    }

    private void requoteJSStringLiteral(SmallVectorImpl<AnnotatedLine> Lines, std.setType<Replacement> Result) {
        for (AnnotatedLine Line : Lines) {
            this.requoteJSStringLiteral((SmallVectorImpl<AnnotatedLine>)Line.Children, Result);
            if (!Line.Affected) continue;
            FormatToken FormatTok = Line.First;
            while (FormatTok != null) {
                StringRef Input2 = new StringRef(FormatTok.TokenText);
                if (!FormatTok.Finalized && FormatTok.isStringLiteral() && (this.Style.JavaScriptQuotes != FormatStyle.JavaScriptQuoteStyle.JSQS_Single || Input2.startswith("\"")) && (this.Style.JavaScriptQuotes != FormatStyle.JavaScriptQuoteStyle.JSQS_Double || Input2.startswith("'"))) {
                    boolean IsSingle = this.Style.JavaScriptQuotes == FormatStyle.JavaScriptQuoteStyle.JSQS_Single;
                    SourceLocation Start = FormatTok.Tok.getLocation();
                    FormatFunctionPointers.SourceLocationUIntStringRef2Void Replace = (Start$1, Length, ReplacementText) -> {
                        JavaCleaner $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)Result.insert_T$RR($c$.track((Object)new Replacement(this.Env.getSourceManager(), new SourceLocation(Start$1), Length, new StringRef(ReplacementText)))));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    };
                    Replace.$call(new SourceLocation(Start), 1, IsSingle ? new StringRef(NativePointer.$SGL_QUOTE) : new StringRef(NativePointer.$DBL_QUOTE));
                    Replace.$call(FormatTok.Tok.getEndLoc().getLocWithOffset(-1), 1, IsSingle ? new StringRef(NativePointer.$SGL_QUOTE) : new StringRef(NativePointer.$DBL_QUOTE));
                    int ColumnWidth = FormatTok.TokenText.size();
                    boolean Escaped = false;
                    int i = 1;
                    while (Unsigned.$less_uint((int)i, (int)(Input2.size() - 1))) {
                        switch (Input2.$at(i)) {
                            case 92: {
                                if (!Escaped && Unsigned.$less_uint((int)(i + 1), (int)Input2.size()) && (IsSingle && Input2.$at(i + 1) == 34 || !IsSingle && Input2.$at(i + 1) == 39)) {
                                    --ColumnWidth;
                                    Replace.$call(Start.getLocWithOffset(i), 1, new StringRef(""));
                                    break;
                                }
                                Escaped = !Escaped;
                                break;
                            }
                            case 34: 
                            case 39: {
                                if (!Escaped && IsSingle == (Input2.$at(i) == 39)) {
                                    Replace.$call(Start.getLocWithOffset(i), 0, new StringRef("\\"));
                                    ++ColumnWidth;
                                }
                                Escaped = false;
                                break;
                            }
                            default: {
                                Escaped = false;
                            }
                        }
                        ++i;
                    }
                    FormatTok.ColumnWidth = ColumnWidth;
                }
                FormatTok = FormatTok.Next;
            }
        }
    }

    private static boolean inputUsesCRLF(StringRef Text) {
        return Unsigned.$greater_uint((int)(Text.count((byte)13) * 2), (int)Text.count((byte)10));
    }

    private boolean hasCpp03IncompatibleFormat(SmallVectorImpl<AnnotatedLine> Lines) {
        for (AnnotatedLine Line : Lines) {
            if (this.hasCpp03IncompatibleFormat((SmallVectorImpl<AnnotatedLine>)Line.Children)) {
                return true;
            }
            FormatToken Tok = Line.First.Next;
            while (Tok != null) {
                if (BasicClangGlobals.$eq_SourceLocation$C((SourceLocation)Tok.WhitespaceRange.getBegin(), (SourceLocation)Tok.WhitespaceRange.getEnd())) {
                    if (Tok.is_TokenKind('F') && Tok.Previous.is_TokenType(TokenType.TT_TemplateOpener)) {
                        return true;
                    }
                    if (Tok.is_TokenType(TokenType.TT_TemplateCloser) && Tok.Previous.is_TokenType(TokenType.TT_TemplateCloser)) {
                        return true;
                    }
                }
                Tok = Tok.Next;
            }
        }
        return false;
    }

    private int countVariableAlignments(SmallVectorImpl<AnnotatedLine> Lines) {
        int AlignmentDiff = 0;
        for (AnnotatedLine Line : Lines) {
            AlignmentDiff += this.countVariableAlignments((SmallVectorImpl<AnnotatedLine>)Line.Children);
            FormatToken Tok = Line.First;
            while (Tok != null && Tok.Next != null) {
                if (Tok.is_TokenType(TokenType.TT_PointerOrReference)) {
                    boolean SpaceBefore = BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)Tok.WhitespaceRange.getBegin(), (SourceLocation)Tok.WhitespaceRange.getEnd());
                    boolean SpaceAfter = BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)Tok.Next.WhitespaceRange.getBegin(), (SourceLocation)Tok.Next.WhitespaceRange.getEnd());
                    if (SpaceBefore && !SpaceAfter) {
                        ++AlignmentDiff;
                    }
                    if (!SpaceBefore && SpaceAfter) {
                        --AlignmentDiff;
                    }
                }
                Tok = Tok.Next;
            }
        }
        return AlignmentDiff;
    }

    private void deriveLocalStyle(SmallVectorImpl<AnnotatedLine> AnnotatedLines) {
        boolean HasBinPackedFunction = false;
        boolean HasOnePerLineFunction = false;
        int e = AnnotatedLines.size();
        for (int i = 0; i != e; ++i) {
            if (((AnnotatedLine)AnnotatedLines.$at$Const((int)i)).First.Next == null) continue;
            FormatToken Tok = ((AnnotatedLine)AnnotatedLines.$at$Const((int)i)).First.Next;
            while (Tok.Next != null) {
                if (Tok.PackingKind == ParameterPackingKind.PPK_BinPacked) {
                    HasBinPackedFunction = true;
                }
                if (Tok.PackingKind == ParameterPackingKind.PPK_OnePerLine) {
                    HasOnePerLineFunction = true;
                }
                Tok = Tok.Next;
            }
        }
        if (this.Style.DerivePointerAlignment) {
            FormatStyle.PointerAlignmentStyle pointerAlignmentStyle = this.Style.PointerAlignment = this.countVariableAlignments(AnnotatedLines) <= 0 ? FormatStyle.PointerAlignmentStyle.PAS_Left : FormatStyle.PointerAlignmentStyle.PAS_Right;
        }
        if (this.Style.Standard == FormatStyle.LanguageStandard.LS_Auto) {
            this.Style.Standard = this.hasCpp03IncompatibleFormat(AnnotatedLines) ? FormatStyle.LanguageStandard.LS_Cpp11 : FormatStyle.LanguageStandard.LS_Cpp03;
        }
        this.BinPackInconclusiveFunctions = HasBinPackedFunction || !HasOnePerLineFunction;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "BinPackInconclusiveFunctions=" + this.BinPackInconclusiveFunctions + ", IncompleteFormat=" + this.IncompleteFormat + super.toString();
    }
}

