/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.TokenType;

public final class ContinuationIndenterFormatStatics {
    public static int getLengthToMatchingParen(FormatToken Tok) {
        if (Tok.MatchingParen == null) {
            return 0;
        }
        FormatToken End = Tok.MatchingParen;
        while (End.Next != null && !End.Next.CanBreakBefore) {
            End = End.Next;
        }
        return End.TotalLength - Tok.TotalLength + 1;
    }

    public static int getLengthToNextOperator(FormatToken Tok) {
        if (Tok.NextOperator == null) {
            return 0;
        }
        return Tok.NextOperator.TotalLength - Tok.TotalLength;
    }

    public static boolean startsSegmentOfBuilderTypeCall(FormatToken Tok) {
        return Tok.isMemberAccess() && Tok.Previous != null && Tok.Previous.closesScope();
    }

    public static boolean startsNextParameter(FormatToken Current, FormatStyle Style) {
        FormatToken Previous = Current.Previous;
        if (Current.is_TokenType(TokenType.TT_CtorInitializerComma) && Style.BreakConstructorInitializersBeforeComma) {
            return true;
        }
        return Previous.is_TokenKind('@') && !Current.isTrailingComment() && (Previous.isNot(TokenType.TT_CtorInitializerComma) || !Style.BreakConstructorInitializersBeforeComma);
    }
}

