/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.ContinuationIndenter;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.LineState;
import org.clang.format.impl.ParenState;
import org.clang.format.impl.TokenRole;
import org.clang.format.impl.TokenType;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorBool;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;

public class CommaSeparatedList
extends TokenRole
implements Destructors.ClassWithDestructor {
    private SmallVector<FormatToken> Commas = new SmallVector(8, (Object)null);
    private SmallVectorUInt ItemLengths = new SmallVectorUInt(8, 0);
    private SmallVector<ColumnFormat> Formats = new SmallVector(4, (Object)new ColumnFormat());
    private boolean HasNestedBracedList = false;

    public CommaSeparatedList(FormatStyle Style) {
        super(Style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void precomputeFormattingInfos(FormatToken Token2) {
        std.vectorUInt MinSizeInColumn = null;
        try {
            if (Token2.MatchingParen == null || !Token2.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare)) {
                return;
            }
            if (this.Style.Cpp11BracedListStyle && !this.Style.BinPackArguments && Unsigned.$less_uint((int)this.Commas.size(), (int)19)) {
                return;
            }
            if (Token2.is_TokenType(TokenType.TT_ArrayInitializerLSquare) && Unsigned.$less_uint((int)this.Commas.size(), (int)19)) {
                return;
            }
            if (this.Style.AlignAfterOpenBracket == FormatStyle.BracketAlignmentStyle.BAS_DontAlign) {
                return;
            }
            FormatToken ItemBegin = Token2.Next;
            while (ItemBegin.isTrailingComment()) {
                ItemBegin = ItemBegin.Next;
            }
            SmallVectorBool MustBreakBeforeItem = new SmallVectorBool(8, false);
            SmallVectorUInt EndOfLineItemLength = new SmallVectorUInt(8, 0);
            boolean HasSeparatingComment = false;
            int e = this.Commas.size() + 1;
            for (int i = 0; i != e; ++i) {
                while (ItemBegin.HasUnescapedNewline && ItemBegin.isTrailingComment()) {
                    ItemBegin = ItemBegin.Next;
                    HasSeparatingComment = Unsigned.$greater_uint((int)i, (int)0);
                }
                MustBreakBeforeItem.push_back(ItemBegin.MustBreakBefore);
                if (ItemBegin.is_TokenKind('\u0017')) {
                    this.HasNestedBracedList = true;
                }
                FormatToken ItemEnd = null;
                if (i == this.Commas.size()) {
                    ItemEnd = Token2.MatchingParen;
                    FormatToken NonCommentEnd = ItemEnd.getPreviousNonComment();
                    this.ItemLengths.push_back(FormatStatics.CodePointsBetween(ItemBegin, NonCommentEnd));
                    if (this.Style.Cpp11BracedListStyle && !ItemEnd.Previous.isTrailingComment()) {
                        while (ItemEnd.Next != null && !ItemEnd.Next.CanBreakBefore) {
                            ItemEnd = ItemEnd.Next;
                        }
                    } else {
                        ItemEnd = Token2.MatchingParen.Previous;
                    }
                } else {
                    ItemEnd = (FormatToken)this.Commas.$at(i);
                    this.ItemLengths.push_back(FormatStatics.CodePointsBetween(ItemBegin, ItemEnd));
                    if (ItemEnd.Next != null && !ItemEnd.Next.HasUnescapedNewline && ItemEnd.Next.isTrailingComment()) {
                        ItemEnd = ItemEnd.Next;
                    }
                }
                EndOfLineItemLength.push_back(FormatStatics.CodePointsBetween(ItemBegin, ItemEnd));
                if (ItemEnd.getNextNonComment() == Token2.MatchingParen) break;
                ItemBegin = ItemEnd.Next;
            }
            if (Unsigned.$less_uint((int)this.Commas.size(), (int)5) || HasSeparatingComment) {
                return;
            }
            if (Token2.NestingLevel != 0 && Token2.is_TokenKind('\u0017') && Unsigned.$less_uint((int)this.Commas.size(), (int)19)) {
                return;
            }
            int MaxItems = Unsigned.$div_uint((int)this.Style.ColumnLimit, (int)3);
            MinSizeInColumn = new std.vectorUInt();
            MinSizeInColumn.reserve(MaxItems);
            int Columns = 1;
            while (Unsigned.$lesseq_uint((int)Columns, (int)MaxItems)) {
                ColumnFormat Format = null;
                try {
                    int i;
                    Format = new ColumnFormat();
                    Format.Columns = Columns;
                    Format.ColumnSizes.resize(Columns);
                    MinSizeInColumn.assign(Columns, -1);
                    Format.LineCount = 1;
                    boolean HasRowWithSufficientColumns = false;
                    int Column = 0;
                    int e2 = this.ItemLengths.size();
                    for (i = 0; i != e2; ++i) {
                        assert (Unsigned.$less_uint((int)i, (int)MustBreakBeforeItem.size()));
                        if (MustBreakBeforeItem.$at(i) || Column == Columns) {
                            ++Format.LineCount;
                            Column = 0;
                        }
                        if (Column == Columns - 1) {
                            HasRowWithSufficientColumns = true;
                        }
                        int Length = Column == Columns - 1 ? EndOfLineItemLength.$at(i) : this.ItemLengths.$at(i);
                        Format.ColumnSizes.$set(Column, std.max((int)Format.ColumnSizes.$at(Column), (int)Length));
                        MinSizeInColumn.$set(Column, std.min_uint((int)MinSizeInColumn.$at(Column), (int)Length));
                        ++Column;
                    }
                    if (!HasRowWithSufficientColumns) break;
                    Format.TotalWidth = Columns - 1;
                    i = 0;
                    while (Unsigned.$less_uint((int)i, (int)Columns)) {
                        Format.TotalWidth += Format.ColumnSizes.$at(i);
                        ++i;
                    }
                    int Columns_final = Columns;
                    ColumnFormat Format_final = Format;
                    std.vectorUInt MinSizeInColumn_final = MinSizeInColumn;
                    NativeCallback.VoidBoolPredicate preficate = () -> {
                        int i = 0;
                        while (Unsigned.$less_uint((int)i, (int)(Columns_final - 1))) {
                            if (Unsigned.$greater_uint((int)(Format_final.ColumnSizes.$at(i) - MinSizeInColumn_final.$at(i)), (int)10)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    };
                    if (!preficate.$call() && !Unsigned.$greater_uint((int)Format.TotalWidth, (int)this.Style.ColumnLimit)) {
                        this.Formats.push_back_T$C$R((Object)Format);
                    }
                }
                finally {
                    if (Format != null) {
                        Format.$destroy();
                    }
                }
                ++Columns;
            }
        }
        finally {
            if (MinSizeInColumn != null) {
                MinSizeInColumn.$destroy();
            }
        }
    }

    @Override
    public int formatAfterToken(LineState State, ContinuationIndenter Indenter, boolean DryRun) {
        if (State.NextToken == null || State.NextToken.Previous == null) {
            return 0;
        }
        FormatToken LBrace = State.NextToken.Previous.getPreviousNonComment();
        if (LBrace == null || !LBrace.isOneOf('\u0017', TokenType.TT_ArrayInitializerLSquare) || LBrace.BlockKind == BraceBlockKind.BK_Block || LBrace.Type == TokenType.TT_DictLiteral || LBrace.Next.Type == TokenType.TT_DesignatedInitializerPeriod) {
            return 0;
        }
        int RemainingCodePoints = this.Style.ColumnLimit - State.Column + State.NextToken.Previous.ColumnWidth;
        ColumnFormat Format = this.getColumnFormat(RemainingCodePoints);
        if (Format == null) {
            return 10000;
        }
        int Penalty = 0;
        int Column = 0;
        int Item = 0;
        while (State.NextToken != LBrace.MatchingParen) {
            boolean NewLine = false;
            int ExtraSpaces = 0;
            if (Unsigned.$less_uint((int)Item, (int)this.Commas.size()) && State.NextToken.Previous == this.Commas.$at(Item)) {
                if (!State.NextToken.isTrailingComment()) {
                    ExtraSpaces += Format.ColumnSizes.$at$Const(Column) - this.ItemLengths.$at(Item);
                    ++Column;
                }
                ++Item;
            }
            if (Column == Format.Columns || State.NextToken.MustBreakBefore) {
                Column = 0;
                NewLine = true;
            }
            Penalty += Indenter.addTokenToState(State, NewLine, DryRun, ExtraSpaces);
        }
        return Penalty;
    }

    @Override
    public int formatFromToken(LineState State, ContinuationIndenter Indenter, boolean DryRun) {
        if (this.HasNestedBracedList) {
            ((ParenState)State.Stack.back()).AvoidBinPacking = true;
        }
        return 0;
    }

    @Override
    public void CommaFound(FormatToken Token2) {
        this.Commas.push_back((Object)Token2);
    }

    private ColumnFormat getColumnFormat(int RemainingCharacters) {
        ColumnFormat BestFormat = null;
        std.reverse_iterator I = this.Formats.rbegin$Const();
        std.reverse_iterator E = this.Formats.rend$Const();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            if (Unsigned.$lesseq_uint((int)((ColumnFormat)I.$arrow()).TotalWidth, (int)RemainingCharacters)) {
                if (BestFormat != null && Unsigned.$greater_uint((int)((ColumnFormat)I.$arrow()).LineCount, (int)BestFormat.LineCount)) break;
                BestFormat = (ColumnFormat)I.$star();
            }
            I.$preInc();
        }
        return BestFormat;
    }

    @Override
    public void $destroy() {
        this.Formats.$destroy();
        this.ItemLengths.$destroy();
        this.Commas.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Commas=" + this.Commas + ", ItemLengths=" + this.ItemLengths + ", Formats=" + this.Formats + ", HasNestedBracedList=" + this.HasNestedBracedList + super.toString();
    }

    private static class ColumnFormat
    implements Native.NativePOD<ColumnFormat>,
    Destructors.ClassWithDestructor {
        public int Columns;
        public int TotalWidth;
        public int LineCount;
        public SmallVectorUInt ColumnSizes;

        public ColumnFormat(JavaDifferentiators.JD$Move _dparam, ColumnFormat $Prm0) {
            this.Columns = $Prm0.Columns;
            this.TotalWidth = $Prm0.TotalWidth;
            this.LineCount = $Prm0.LineCount;
            this.ColumnSizes = new SmallVectorUInt(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.ColumnSizes);
        }

        public ColumnFormat() {
            this.ColumnSizes = new SmallVectorUInt(8, 0);
        }

        public ColumnFormat(ColumnFormat $Prm0) {
            this.Columns = $Prm0.Columns;
            this.TotalWidth = $Prm0.TotalWidth;
            this.LineCount = $Prm0.LineCount;
            this.ColumnSizes = new SmallVectorUInt($Prm0.ColumnSizes);
        }

        public void $destroy() {
            this.ColumnSizes.$destroy();
        }

        public ColumnFormat $assign(ColumnFormat other) {
            this.ColumnSizes.$assign((SmallVectorImplUInt)other.ColumnSizes);
            this.Columns = other.Columns;
            this.LineCount = other.LineCount;
            this.TotalWidth = other.TotalWidth;
            return this;
        }

        public ColumnFormat clone() {
            return new ColumnFormat(this);
        }

        public String toString() {
            return "Columns=" + this.Columns + ", TotalWidth=" + this.TotalWidth + ", LineCount=" + this.LineCount + ", ColumnSizes=" + this.ColumnSizes;
        }
    }
}

