/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Iterator;
import org.clang.basic.CharSourceRange;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.FormatTokenLexer;
import org.clang.format.impl.TokenAnalyzer;
import org.clang.format.impl.TokenAnnotator;
import org.clang.format.impl.TokenType;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.java.std_functional;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.NativeContainer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorImpl;

public class Cleaner
extends TokenAnalyzer
implements Destructors.ClassWithDestructor {
    private std.setPtr<FormatToken> DeletedTokens;
    private std.setUInt DeletedLines;

    public Cleaner(Environment Env, FormatStyle Style) {
        super(Env, Style);
        this.DeletedTokens = new std.setPtr((std_functional.binary_functionArgArg2Bool)new FormatTokenLess(Env.getSourceManager()));
        this.DeletedLines = new std.setUInt();
    }

    @Override
    public std.setType<Replacement> analyze(TokenAnnotator Annotator, SmallVectorImpl<AnnotatedLine> AnnotatedLines, FormatTokenLexer Tokens, std.setType<Replacement> Result) {
        this.AffectedRangeMgr.computeAffectedLines((type.ptr<AnnotatedLine>)AnnotatedLines.begin(), (type.ptr<AnnotatedLine>)AnnotatedLines.end());
        this.checkEmptyNamespace(AnnotatedLines);
        for (AnnotatedLine Line : AnnotatedLines) {
            if (!Line.Affected) continue;
            this.cleanupRight(Line.First, '@', '@');
            this.cleanupRight(Line.First, TokenType.TT_CtorInitializerColon, '@');
            this.cleanupLeft(Line.First, TokenType.TT_CtorInitializerComma, '\u0017');
            this.cleanupLeft(Line.First, TokenType.TT_CtorInitializerColon, '\u0017');
        }
        return this.generateFixes();
    }

    private boolean containsOnlyComments(AnnotatedLine Line) {
        FormatToken Tok = Line.First;
        while (Tok != null) {
            if (Tok.isNot('\u0004')) {
                return false;
            }
            Tok = Tok.Next;
        }
        return true;
    }

    private void checkEmptyNamespace(SmallVectorImpl<AnnotatedLine> AnnotatedLines) {
        int e = AnnotatedLines.size();
        for (int i = 0; i != e; ++i) {
            AnnotatedLine Line = (AnnotatedLine)AnnotatedLines.$at(i);
            if (!Line.startsWith('\u0086') && !Line.startsWith('[', '\u0086')) continue;
            uint.ref i_ref = NativePointer.create_uint$ref((int)i);
            this.checkEmptyNamespace(AnnotatedLines, i, i_ref);
            i = i_ref.$deref();
        }
        Iterator iterator2 = this.DeletedLines.iterator();
        while (iterator2.hasNext()) {
            int Line = (Integer)iterator2.next();
            FormatToken Tok = ((AnnotatedLine)AnnotatedLines.$at((int)Line)).First;
            while (Tok != null) {
                this.deleteToken(Tok);
                Tok = Tok.Next;
            }
        }
    }

    private boolean checkEmptyNamespace(SmallVectorImpl<AnnotatedLine> AnnotatedLines, int CurrentLine, uint.ref NewLine) {
        int InitLine = CurrentLine++;
        int End = AnnotatedLines.size();
        if (this.Style.BraceWrapping.AfterNamespace) {
            if (!((AnnotatedLine)AnnotatedLines.$at(CurrentLine)).startsWith('\u0017')) {
                NewLine.$set(CurrentLine);
                return false;
            }
        } else if (!((AnnotatedLine)AnnotatedLines.$at(CurrentLine)).endsWith('\u0017')) {
            return false;
        }
        while (Unsigned.$less_uint((int)(++CurrentLine), (int)End) && !((AnnotatedLine)AnnotatedLines.$at(CurrentLine)).startsWith('\u0018')) {
            if (((AnnotatedLine)AnnotatedLines.$at(CurrentLine)).startsWith('\u0086') || ((AnnotatedLine)AnnotatedLines.$at(CurrentLine)).startsWith('[', '\u0086')) {
                if (!this.checkEmptyNamespace(AnnotatedLines, CurrentLine, NewLine)) {
                    return false;
                }
                CurrentLine = NewLine.$deref();
                continue;
            }
            if (this.containsOnlyComments((AnnotatedLine)AnnotatedLines.$at(CurrentLine))) continue;
            NewLine.$set(CurrentLine);
            return false;
        }
        NewLine.$set(CurrentLine);
        if (Unsigned.$greatereq_uint((int)CurrentLine, (int)End)) {
            return false;
        }
        if (!this.AffectedRangeMgr.affectsCharSourceRange(CharSourceRange.getCharRange((SourceLocation)((AnnotatedLine)AnnotatedLines.$at((int)InitLine)).First.Tok.getLocation(), (SourceLocation)((AnnotatedLine)AnnotatedLines.$at((int)CurrentLine)).Last.Tok.getEndLoc()))) {
            return false;
        }
        int i = InitLine;
        while (Unsigned.$lesseq_uint((int)i, (int)CurrentLine)) {
            this.DeletedLines.insert_T$C$R(i);
            ++i;
        }
        return true;
    }

    private void cleanupPair(FormatToken Start, char LK, char RK, boolean DeleteLeft) {
        FormatToken Right;
        FormatFunctionPointers.FormatToken2FormatToken NextNotDeleted = Tok -> {
            FormatToken Res = Tok.Next;
            while (Res != null) {
                if (!Res.is_TokenKind('\u0004') && this.DeletedTokens.find((Object)Res).$eq((Object)this.DeletedTokens.end())) {
                    return Res;
                }
                Res = Res.Next;
            }
            return null;
        };
        FormatToken Left = Start;
        while (Left != null && (Right = NextNotDeleted.$call(Left)) != null) {
            if (Left.is_TokenKind(LK) && Right.is_TokenKind(RK)) {
                this.deleteToken(DeleteLeft ? Left : Right);
                if (!DeleteLeft) continue;
            }
            Left = Right;
        }
    }

    private void cleanupPair(FormatToken Start, TokenType LK, char RK, boolean DeleteLeft) {
        FormatToken Right;
        FormatFunctionPointers.FormatToken2FormatToken NextNotDeleted = Tok -> {
            FormatToken Res = Tok.Next;
            while (Res != null) {
                if (!Res.is_TokenKind('\u0004') && this.DeletedTokens.find((Object)Res).$eq((Object)this.DeletedTokens.end())) {
                    return Res;
                }
                Res = Res.Next;
            }
            return null;
        };
        FormatToken Left = Start;
        while (Left != null && (Right = NextNotDeleted.$call(Left)) != null) {
            if (Left.is_TokenType(LK) && Right.is_TokenKind(RK)) {
                this.deleteToken(DeleteLeft ? Left : Right);
                if (!DeleteLeft) continue;
            }
            Left = Right;
        }
    }

    private void cleanupLeft(FormatToken Start, TokenType LK, char RK) {
        this.cleanupPair(Start, LK, RK, true);
    }

    private void cleanupRight(FormatToken Start, char LK, char RK) {
        this.cleanupPair(Start, LK, RK, false);
    }

    private void cleanupRight(FormatToken Start, TokenType LK, char RK) {
        this.cleanupPair(Start, LK, RK, false);
    }

    private void deleteToken(FormatToken Tok) {
        if (Tok != null) {
            this.DeletedTokens.insert_T$C$R((Object)Tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private std.setType<Replacement> generateFixes() {
        std.setType Fixes = null;
        std.vector Tokens = null;
        try {
            Fixes = new std.setType();
            Tokens = new std.vector((Object)null);
            std.copy((type.iterator)this.DeletedTokens.begin(), (type.iterator)this.DeletedTokens.end(), (type.iterator)std.back_inserter((NativeContainer)Tokens));
            int Idx = 0;
            while (Unsigned.$less_uint((int)Idx, (int)Tokens.size())) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    int St = Idx;
                    int End = Idx;
                    while (Unsigned.$less_uint((int)(End + 1), (int)Tokens.size()) && ((FormatToken)Tokens.$at((int)End)).Next == Tokens.$at(End + 1)) {
                        ++End;
                    }
                    CharSourceRange SR = CharSourceRange.getCharRange((SourceLocation)((FormatToken)Tokens.$at((int)St)).Tok.getLocation(), (SourceLocation)((FormatToken)Tokens.$at((int)End)).Tok.getEndLoc());
                    $c$.clean((Object)Fixes.insert_T$RR($c$.track((Object)new Replacement(this.Env.getSourceManager(), SR, new StringRef(NativePointer.$EMPTY)))));
                    Idx = End + 1;
                }
                finally {
                    $c$.$destroy();
                }
            }
            std.setType setType2 = new std.setType(JavaDifferentiators.JD$Move.INSTANCE, Fixes);
            return setType2;
        }
        finally {
            if (Tokens != null) {
                Tokens.$destroy();
            }
            if (Fixes != null) {
                Fixes.$destroy();
            }
        }
    }

    @Override
    public void $destroy() {
        this.DeletedLines.$destroy();
        this.DeletedTokens.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "DeletedTokens=" + this.DeletedTokens + ", DeletedLines=" + this.DeletedLines + super.toString();
    }

    private static class FormatTokenLess
    implements std_functional.binary_functionArgArg2Bool<FormatToken, FormatToken> {
        public final SourceManager SM;

        public FormatTokenLess(SourceManager SM) {
            this.SM = SM;
        }

        public boolean $call(FormatToken LHS, FormatToken RHS) {
            return this.SM.isBeforeInTranslationUnit(LHS.Tok.getLocation(), RHS.Tok.getLocation());
        }

        public FormatTokenLess(FormatTokenLess $Prm0) {
            this.SM = $Prm0.SM;
        }

        public String toString() {
            return "SM=[SourceManager]";
        }
    }
}

