/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.BreakableToken;
import org.clang.format.impl.BreakableTokenFormatStatics;
import org.clang.format.impl.EncodingStatics;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.WhitespaceManager;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorInt;
import org.llvm.adt.aliases.SmallVectorUInt;

public class BreakableBlockComment
extends BreakableToken
implements Destructors.ClassWithDestructor {
    private SmallVector<StringRef> Lines = new SmallVector(16, (Object)new StringRef());
    private SmallVectorUInt LeadingWhitespace = new SmallVectorUInt(16, 0);
    private SmallVectorInt StartOfLineColumn = new SmallVectorInt(16);
    private int IndentAtLineBreak;
    private boolean LastLineNeedsDecoration;
    private StringRef Decoration = new StringRef();

    public BreakableBlockComment(FormatToken Token2, int IndentLevel, int StartColumn, int OriginalStartColumn, boolean FirstInLine, boolean InPPDirective, EncodingStatics.Encoding $Encoding, FormatStyle Style) {
        super(Token2, IndentLevel, InPPDirective, $Encoding, Style);
        StringRef TokenText = new StringRef(Token2.TokenText);
        assert (TokenText.startswith("/*") && TokenText.endswith("*/"));
        TokenText.substr(2, TokenText.size() - 4).split(this.Lines, "\n");
        int IndentDelta = StartColumn - OriginalStartColumn;
        this.LeadingWhitespace.resize(this.Lines.size());
        this.StartOfLineColumn.resize(this.Lines.size());
        this.StartOfLineColumn.$set(0, StartColumn + 2);
        int i = 1;
        while (Unsigned.$less_uint((int)i, (int)this.Lines.size())) {
            this.adjustWhitespace(i, IndentDelta);
            ++i;
        }
        this.Decoration.$assignMove("* ");
        if (this.Lines.size() == 1 && !FirstInLine) {
            this.Decoration.$assignMove(NativePointer.$EMPTY);
        }
        i = 1;
        int e = this.Lines.size();
        while (!(!Unsigned.$less_uint((int)i, (int)e) || this.Decoration.empty() || i + 1 == e && ((StringRef)this.Lines.$at(i)).empty())) {
            if (((StringRef)this.Lines.$at(i)).empty() || i + 1 == e || !this.Decoration.startswith((StringRef)this.Lines.$at(i))) {
                while (!((StringRef)this.Lines.$at(i)).startswith(this.Decoration)) {
                    this.Decoration.$assignMove(this.Decoration.substr(0, this.Decoration.size() - 1));
                }
            }
            ++i;
        }
        this.LastLineNeedsDecoration = true;
        this.IndentAtLineBreak = this.StartOfLineColumn.$at(0) + 1;
        i = 1;
        while (Unsigned.$less_uint((int)i, (int)this.Lines.size())) {
            if (((StringRef)this.Lines.$at(i)).empty()) {
                if (i + 1 == this.Lines.size()) {
                    this.LastLineNeedsDecoration = false;
                } else if (this.Decoration.empty()) {
                    this.StartOfLineColumn.$set(i, 0);
                }
            } else {
                int DecorationSize = this.Decoration.startswith((StringRef)this.Lines.$at(i)) ? ((StringRef)this.Lines.$at(i)).size() : this.Decoration.size();
                this.StartOfLineColumn.$set(i, this.StartOfLineColumn.$at(i) + DecorationSize);
                ((StringRef)this.Lines.$at(i)).$assignMove(((StringRef)this.Lines.$at(i)).substr(DecorationSize));
                this.LeadingWhitespace.$set(i, this.LeadingWhitespace.$at(i) + DecorationSize);
                if (!this.Decoration.startswith((StringRef)this.Lines.$at(i))) {
                    this.IndentAtLineBreak = std.min((int)this.IndentAtLineBreak, (int)std.max((int)0, (int)this.StartOfLineColumn.$at(i)));
                }
            }
            ++i;
        }
        this.IndentAtLineBreak = std.max((int)this.IndentAtLineBreak, (int)this.Decoration.size());
    }

    @Override
    public int getLineCount() {
        return this.Lines.size();
    }

    @Override
    public int getLineLengthAfterSplit(int LineIndex, int Offset, int Length) {
        int ContentStartColumn = this.getContentStartColumn(LineIndex, Offset);
        return ContentStartColumn + EncodingStatics.columnWidthWithTabs(((StringRef)this.Lines.$at$Const(LineIndex)).substr(Offset, Length), ContentStartColumn, this.Style.TabWidth, this.Encoding) + (LineIndex + 1 == this.Lines.size() ? 2 : 0);
    }

    @Override
    public std_pair.pairUIntUInt getSplit(int LineIndex, int TailOffset, int ColumnLimit) {
        return BreakableTokenFormatStatics.getCommentSplit(((StringRef)this.Lines.$at$Const(LineIndex)).substr(TailOffset), this.getContentStartColumn(LineIndex, TailOffset), ColumnLimit, this.Style.TabWidth, this.Encoding);
    }

    @Override
    public void insertBreak(int LineIndex, int TailOffset, std_pair.pairUIntUInt Split, WhitespaceManager Whitespaces) {
        StringRef Text = ((StringRef)this.Lines.$at(LineIndex)).substr(TailOffset);
        StringRef Prefix = new StringRef(this.Decoration);
        if (LineIndex + 1 == this.Lines.size() && Text.size() == Split.first + Split.second) {
            Prefix.$assignMove(NativePointer.$EMPTY);
        }
        int BreakOffsetInToken = Text.data().$sub((abstract_iterator)this.Tok.TokenText.data()) + Split.first;
        int CharsToRemove = Split.second;
        assert (Unsigned.$greatereq_uint((int)this.IndentAtLineBreak, (int)this.Decoration.size()));
        Whitespaces.replaceWhitespaceInToken(this.Tok, BreakOffsetInToken, CharsToRemove, new StringRef(NativePointer.$EMPTY), new StringRef(Prefix), this.InPPDirective, 1, this.IndentLevel, this.IndentAtLineBreak - this.Decoration.size());
    }

    @Override
    public void replaceWhitespace(int LineIndex, int TailOffset, std_pair.pairUIntUInt Split, WhitespaceManager Whitespaces) {
        StringRef Text = ((StringRef)this.Lines.$at(LineIndex)).substr(TailOffset);
        int BreakOffsetInToken = Text.data().$sub((abstract_iterator)this.Tok.TokenText.data()) + Split.first;
        int CharsToRemove = Split.second;
        Whitespaces.replaceWhitespaceInToken(this.Tok, BreakOffsetInToken, CharsToRemove, new StringRef(NativePointer.$EMPTY), new StringRef(NativePointer.$EMPTY), false, 0, 0, 1);
    }

    @Override
    public void replaceWhitespaceBefore(int LineIndex, WhitespaceManager Whitespaces) {
        if (LineIndex == 0) {
            return;
        }
        StringRef Prefix = new StringRef(this.Decoration);
        if (((StringRef)this.Lines.$at(LineIndex)).empty()) {
            if (LineIndex + 1 == this.Lines.size()) {
                if (!this.LastLineNeedsDecoration) {
                    Prefix.$assignMove(NativePointer.$EMPTY);
                }
            } else if (!this.Decoration.empty()) {
                Prefix.$assignMove(Prefix.substr(0, 1));
            }
        } else if (this.StartOfLineColumn.$at(LineIndex) == 1) {
            Prefix.$assignMove(Prefix.substr(0, 1));
        }
        int WhitespaceOffsetInToken = ((StringRef)this.Lines.$at(LineIndex)).data().$sub((abstract_iterator)this.Tok.TokenText.data()) - this.LeadingWhitespace.$at(LineIndex);
        Whitespaces.replaceWhitespaceInToken(this.Tok, WhitespaceOffsetInToken, this.LeadingWhitespace.$at(LineIndex), new StringRef(NativePointer.$EMPTY), new StringRef(Prefix), this.InPPDirective, 1, this.IndentLevel, this.StartOfLineColumn.$at(LineIndex) - Prefix.size());
    }

    private void adjustWhitespace(int LineIndex, int IndentDelta) {
        int EndOfPreviousLine = ((StringRef)this.Lines.$at(LineIndex - 1)).size();
        if (this.InPPDirective && ((StringRef)this.Lines.$at(LineIndex - 1)).endswith("\\")) {
            --EndOfPreviousLine;
        }
        EndOfPreviousLine = (EndOfPreviousLine = ((StringRef)this.Lines.$at(LineIndex - 1)).find_last_not_of(FormatStatics.Blanks, EndOfPreviousLine)) == StringRef.npos ? 0 : ++EndOfPreviousLine;
        int StartOfLine = ((StringRef)this.Lines.$at(LineIndex)).find_first_not_of(FormatStatics.Blanks);
        if (StartOfLine == StringRef.npos) {
            StartOfLine = ((StringRef)this.Lines.$at(LineIndex)).rtrim("\r\n").size();
        }
        StringRef Whitespace = ((StringRef)this.Lines.$at(LineIndex)).substr(0, StartOfLine);
        ((StringRef)this.Lines.$at(LineIndex - 1)).$assignMove(((StringRef)this.Lines.$at(LineIndex - 1)).substr(0, EndOfPreviousLine));
        ((StringRef)this.Lines.$at(LineIndex)).$assignMove(((StringRef)this.Lines.$at(LineIndex)).substr(StartOfLine));
        this.LeadingWhitespace.$set(LineIndex, ((StringRef)this.Lines.$at(LineIndex)).begin().$sub((abstract_iterator)((StringRef)this.Lines.$at(LineIndex - 1)).end()));
        this.StartOfLineColumn.$set(LineIndex, EncodingStatics.columnWidthWithTabs(new StringRef(Whitespace), 0, this.Style.TabWidth, this.Encoding) + IndentDelta);
    }

    private int getContentStartColumn(int LineIndex, int TailOffset) {
        if (TailOffset != 0) {
            return this.IndentAtLineBreak;
        }
        return std.max((int)0, (int)this.StartOfLineColumn.$at$Const(LineIndex));
    }

    @Override
    public void $destroy() {
        this.StartOfLineColumn.$destroy();
        this.LeadingWhitespace.$destroy();
        this.Lines.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Lines=" + this.Lines + ", LeadingWhitespace=" + this.LeadingWhitespace + ", StartOfLineColumn=" + this.StartOfLineColumn + ", IndentAtLineBreak=" + this.IndentAtLineBreak + ", LastLineNeedsDecoration=" + this.LastLineNeedsDecoration + ", Decoration=" + this.Decoration + super.toString();
    }
}

