/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileID;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceManager;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.VfsGlobals;
import org.clang.format.FormatGlobals$getParseCategory$$;
import org.clang.format.FormatStyle;
import org.clang.format.ParseError;
import org.clang.format.ParseErrorCategory;
import org.clang.format.impl.Cleaner;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.Formatter;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.format.llvm.yaml.impl.DocumentListTraitsVector$FormatStyle;
import org.clang.format.llvm.yaml.impl.MappingTraitsFormatStyle;
import org.clang.tooling.core.Range;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Sequence;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.Error;
import org.llvm.support.ErrorOr;
import org.llvm.support.Expected;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.yaml.DocumentListTraits;
import org.llvm.support.yaml.Input;
import org.llvm.support.yaml.MappingTraits;
import org.llvm.support.yaml.Output;
import org.llvm.support.yaml.YamlGlobals;

public final class FormatGlobals {
    public static char.ptr StyleOptionHelpDescription = NativePointer.$((String)"Coding style, currently supports:\n  LLVM, Google, Chromium, Mozilla, WebKit.\nUse -style=file to load style configuration from\n.clang-format file located in one of the parent\ndirectories of the source file (or current\ndirectory for stdin).\nUse -style=\"{key: value, ...}\" to set specific\nparameters, e.g.:\n  -style=\"{BasedOnStyle: llvm, IndentWidth: 8}\"");

    public static std_errors.error_category getParseCategory() {
        ParseErrorCategory C = FormatGlobals$getParseCategory$$.C;
        return C;
    }

    public static std_errors.error_code make_error_code(ParseError e) {
        return new std_errors.error_code(e.getValue(), FormatGlobals.getParseCategory());
    }

    public static FormatStyle getLLVMStyle() {
        FormatStyle LLVMStyle = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            LLVMStyle = new FormatStyle();
            LLVMStyle.Language = FormatStyle.LanguageKind.LK_Cpp;
            LLVMStyle.AccessModifierOffset = -2;
            LLVMStyle.AlignEscapedNewlinesLeft = false;
            LLVMStyle.AlignAfterOpenBracket = FormatStyle.BracketAlignmentStyle.BAS_Align;
            LLVMStyle.AlignOperands = true;
            LLVMStyle.AlignTrailingComments = true;
            LLVMStyle.AlignConsecutiveAssignments = false;
            LLVMStyle.AlignConsecutiveDeclarations = false;
            LLVMStyle.AllowAllParametersOfDeclarationOnNextLine = true;
            LLVMStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_All;
            LLVMStyle.AllowShortBlocksOnASingleLine = false;
            LLVMStyle.AllowShortCaseLabelsOnASingleLine = false;
            LLVMStyle.AllowShortIfStatementsOnASingleLine = false;
            LLVMStyle.AllowShortLoopsOnASingleLine = false;
            LLVMStyle.AlwaysBreakAfterReturnType = FormatStyle.ReturnTypeBreakingStyle.RTBS_None;
            LLVMStyle.AlwaysBreakAfterDefinitionReturnType = FormatStyle.DefinitionReturnTypeBreakingStyle.DRTBS_None;
            LLVMStyle.AlwaysBreakBeforeMultilineStrings = false;
            LLVMStyle.AlwaysBreakTemplateDeclarations = false;
            LLVMStyle.BinPackParameters = true;
            LLVMStyle.BinPackArguments = true;
            LLVMStyle.BreakBeforeBinaryOperators = FormatStyle.BinaryOperatorStyle.BOS_None;
            LLVMStyle.BreakBeforeTernaryOperators = true;
            LLVMStyle.BreakBeforeBraces = FormatStyle.BraceBreakingStyle.BS_Attach;
            LLVMStyle.BraceWrapping.$assignMove(new FormatStyle.BraceWrappingFlags(false, false, false, false, false, false, false, false, false, false, false));
            LLVMStyle.BreakAfterJavaFieldAnnotations = false;
            LLVMStyle.BreakConstructorInitializersBeforeComma = false;
            LLVMStyle.BreakStringLiterals = true;
            LLVMStyle.ColumnLimit = 80;
            LLVMStyle.CommentPragmas.$assign_T$C$P((CharSequence)"^ IWYU pragma:");
            LLVMStyle.ConstructorInitializerAllOnOneLineOrOnePerLine = false;
            LLVMStyle.ConstructorInitializerIndentWidth = 4;
            LLVMStyle.ContinuationIndentWidth = 4;
            LLVMStyle.Cpp11BracedListStyle = true;
            LLVMStyle.DerivePointerAlignment = false;
            LLVMStyle.ExperimentalAutoDetectBinPacking = false;
            LLVMStyle.ForEachMacros.push_back_T$RR(new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"foreach"));
            LLVMStyle.ForEachMacros.push_back_T$RR(new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"Q_FOREACH"));
            LLVMStyle.ForEachMacros.push_back_T$RR(new std.string(JavaDifferentiators.JD$T$C$P_T2$C$R.INSTANCE, (CharSequence)"BOOST_FOREACH"));
            $c$.clean((Object)LLVMStyle.IncludeCategories.$assign($c$.track((Object[])new FormatStyle.IncludeCategory[]{new FormatStyle.IncludeCategory(new std.string(NativePointer.$((String)"^\"(llvm|llvm-c|clang|clang-c)/")), 2), new FormatStyle.IncludeCategory(new std.string(NativePointer.$((String)"^(<|\"(gtest|isl|json)/)")), 3), new FormatStyle.IncludeCategory(new std.string(NativePointer.$DOT_STAR), 1)})));
            LLVMStyle.IncludeIsMainRegex.$assign_T$C$P((CharSequence)"$");
            LLVMStyle.IndentCaseLabels = false;
            LLVMStyle.IndentWrappedFunctionNames = false;
            LLVMStyle.IndentWidth = 2;
            LLVMStyle.JavaScriptQuotes = FormatStyle.JavaScriptQuoteStyle.JSQS_Leave;
            LLVMStyle.JavaScriptWrapImports = true;
            LLVMStyle.TabWidth = 8;
            LLVMStyle.MaxEmptyLinesToKeep = 1;
            LLVMStyle.KeepEmptyLinesAtTheStartOfBlocks = true;
            LLVMStyle.NamespaceIndentation = FormatStyle.NamespaceIndentationKind.NI_None;
            LLVMStyle.ObjCBlockIndentWidth = 2;
            LLVMStyle.ObjCSpaceAfterProperty = false;
            LLVMStyle.ObjCSpaceBeforeProtocolList = true;
            LLVMStyle.PointerAlignment = FormatStyle.PointerAlignmentStyle.PAS_Right;
            LLVMStyle.SpacesBeforeTrailingComments = 1;
            LLVMStyle.Standard = FormatStyle.LanguageStandard.LS_Cpp11;
            LLVMStyle.UseTab = FormatStyle.UseTabStyle.UT_Never;
            LLVMStyle.JavaScriptQuotes = FormatStyle.JavaScriptQuoteStyle.JSQS_Leave;
            LLVMStyle.ReflowComments = true;
            LLVMStyle.SpacesInParentheses = false;
            LLVMStyle.SpacesInSquareBrackets = false;
            LLVMStyle.SpaceInEmptyParentheses = false;
            LLVMStyle.SpacesInContainerLiterals = true;
            LLVMStyle.SpacesInCStyleCastParentheses = false;
            LLVMStyle.SpaceAfterCStyleCast = false;
            LLVMStyle.SpaceBeforeParens = FormatStyle.SpaceBeforeParensOptions.SBPO_ControlStatements;
            LLVMStyle.SpaceBeforeAssignmentOperators = true;
            LLVMStyle.SpacesInAngles = false;
            LLVMStyle.PenaltyBreakComment = 300;
            LLVMStyle.PenaltyBreakFirstLessLess = 120;
            LLVMStyle.PenaltyBreakString = 1000;
            LLVMStyle.PenaltyExcessCharacter = 1000000;
            LLVMStyle.PenaltyReturnTypeOnItsOwnLine = 60;
            LLVMStyle.PenaltyBreakBeforeFirstCallParameter = 19;
            LLVMStyle.DisableFormat = false;
            LLVMStyle.SortIncludes = true;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, LLVMStyle);
            return formatStyle;
        }
        finally {
            if (LLVMStyle != null) {
                LLVMStyle.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormatStyle getGoogleStyle(FormatStyle.LanguageKind Language) {
        FormatStyle GoogleStyle = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            GoogleStyle = FormatGlobals.getLLVMStyle();
            GoogleStyle.Language = Language;
            GoogleStyle.AccessModifierOffset = -1;
            GoogleStyle.AlignEscapedNewlinesLeft = true;
            GoogleStyle.AllowShortIfStatementsOnASingleLine = true;
            GoogleStyle.AllowShortLoopsOnASingleLine = true;
            GoogleStyle.AlwaysBreakBeforeMultilineStrings = true;
            GoogleStyle.AlwaysBreakTemplateDeclarations = true;
            GoogleStyle.ConstructorInitializerAllOnOneLineOrOnePerLine = true;
            GoogleStyle.DerivePointerAlignment = true;
            $c$.clean((Object)GoogleStyle.IncludeCategories.$assign($c$.track((Object[])new FormatStyle.IncludeCategory[]{new FormatStyle.IncludeCategory(new std.string(NativePointer.$((String)"^<.*\\.h>")), 1), new FormatStyle.IncludeCategory(new std.string(NativePointer.$((String)"^<.*")), 2), new FormatStyle.IncludeCategory(new std.string(NativePointer.$DOT_STAR), 3)})));
            GoogleStyle.IncludeIsMainRegex.$assign_T$C$P((CharSequence)"([-_](test|unittest))?$");
            GoogleStyle.IndentCaseLabels = true;
            GoogleStyle.KeepEmptyLinesAtTheStartOfBlocks = false;
            GoogleStyle.ObjCSpaceAfterProperty = false;
            GoogleStyle.ObjCSpaceBeforeProtocolList = false;
            GoogleStyle.PointerAlignment = FormatStyle.PointerAlignmentStyle.PAS_Left;
            GoogleStyle.SpacesBeforeTrailingComments = 2;
            GoogleStyle.Standard = FormatStyle.LanguageStandard.LS_Auto;
            GoogleStyle.PenaltyReturnTypeOnItsOwnLine = 200;
            GoogleStyle.PenaltyBreakBeforeFirstCallParameter = 1;
            if (Language == FormatStyle.LanguageKind.LK_Java) {
                GoogleStyle.AlignAfterOpenBracket = FormatStyle.BracketAlignmentStyle.BAS_DontAlign;
                GoogleStyle.AlignOperands = false;
                GoogleStyle.AlignTrailingComments = false;
                GoogleStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_Empty;
                GoogleStyle.AllowShortIfStatementsOnASingleLine = false;
                GoogleStyle.AlwaysBreakBeforeMultilineStrings = false;
                GoogleStyle.BreakBeforeBinaryOperators = FormatStyle.BinaryOperatorStyle.BOS_NonAssignment;
                GoogleStyle.ColumnLimit = 100;
                GoogleStyle.SpaceAfterCStyleCast = true;
                GoogleStyle.SpacesBeforeTrailingComments = 1;
            } else if (Language == FormatStyle.LanguageKind.LK_JavaScript) {
                GoogleStyle.AlignAfterOpenBracket = FormatStyle.BracketAlignmentStyle.BAS_AlwaysBreak;
                GoogleStyle.AlignOperands = false;
                GoogleStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_Inline;
                GoogleStyle.AlwaysBreakBeforeMultilineStrings = false;
                GoogleStyle.BreakBeforeTernaryOperators = false;
                GoogleStyle.CommentPragmas.$assign_T$C$P((CharSequence)"@(export|requirecss|return|see|visibility) ");
                GoogleStyle.MaxEmptyLinesToKeep = 3;
                GoogleStyle.NamespaceIndentation = FormatStyle.NamespaceIndentationKind.NI_All;
                GoogleStyle.SpacesInContainerLiterals = false;
                GoogleStyle.JavaScriptQuotes = FormatStyle.JavaScriptQuoteStyle.JSQS_Single;
                GoogleStyle.JavaScriptWrapImports = false;
            } else if (Language == FormatStyle.LanguageKind.LK_Proto) {
                GoogleStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_None;
                GoogleStyle.SpacesInContainerLiterals = false;
            }
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, GoogleStyle);
            return formatStyle;
        }
        finally {
            if (GoogleStyle != null) {
                GoogleStyle.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static FormatStyle getChromiumStyle(FormatStyle.LanguageKind Language) {
        FormatStyle ChromiumStyle = null;
        try {
            ChromiumStyle = FormatGlobals.getGoogleStyle(Language);
            if (Language == FormatStyle.LanguageKind.LK_Java) {
                ChromiumStyle.AllowShortIfStatementsOnASingleLine = true;
                ChromiumStyle.BreakAfterJavaFieldAnnotations = true;
                ChromiumStyle.ContinuationIndentWidth = 8;
                ChromiumStyle.IndentWidth = 4;
            } else {
                ChromiumStyle.AllowAllParametersOfDeclarationOnNextLine = false;
                ChromiumStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_Inline;
                ChromiumStyle.AllowShortIfStatementsOnASingleLine = false;
                ChromiumStyle.AllowShortLoopsOnASingleLine = false;
                ChromiumStyle.BinPackParameters = false;
                ChromiumStyle.DerivePointerAlignment = false;
            }
            ChromiumStyle.SortIncludes = false;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, ChromiumStyle);
            return formatStyle;
        }
        finally {
            if (ChromiumStyle != null) {
                ChromiumStyle.$destroy();
            }
        }
    }

    public static FormatStyle getMozillaStyle() {
        FormatStyle MozillaStyle = null;
        try {
            MozillaStyle = FormatGlobals.getLLVMStyle();
            MozillaStyle.AllowAllParametersOfDeclarationOnNextLine = false;
            MozillaStyle.AllowShortFunctionsOnASingleLine = FormatStyle.ShortFunctionStyle.SFS_Inline;
            MozillaStyle.AlwaysBreakAfterReturnType = FormatStyle.ReturnTypeBreakingStyle.RTBS_TopLevelDefinitions;
            MozillaStyle.AlwaysBreakAfterDefinitionReturnType = FormatStyle.DefinitionReturnTypeBreakingStyle.DRTBS_TopLevel;
            MozillaStyle.AlwaysBreakTemplateDeclarations = true;
            MozillaStyle.BreakBeforeBraces = FormatStyle.BraceBreakingStyle.BS_Mozilla;
            MozillaStyle.BreakConstructorInitializersBeforeComma = true;
            MozillaStyle.ConstructorInitializerIndentWidth = 2;
            MozillaStyle.ContinuationIndentWidth = 2;
            MozillaStyle.Cpp11BracedListStyle = false;
            MozillaStyle.IndentCaseLabels = true;
            MozillaStyle.ObjCSpaceAfterProperty = true;
            MozillaStyle.ObjCSpaceBeforeProtocolList = false;
            MozillaStyle.PenaltyReturnTypeOnItsOwnLine = 200;
            MozillaStyle.PointerAlignment = FormatStyle.PointerAlignmentStyle.PAS_Left;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, MozillaStyle);
            return formatStyle;
        }
        finally {
            if (MozillaStyle != null) {
                MozillaStyle.$destroy();
            }
        }
    }

    public static FormatStyle getWebKitStyle() {
        FormatStyle Style = null;
        try {
            Style = FormatGlobals.getLLVMStyle();
            Style.AccessModifierOffset = -4;
            Style.AlignAfterOpenBracket = FormatStyle.BracketAlignmentStyle.BAS_DontAlign;
            Style.AlignOperands = false;
            Style.AlignTrailingComments = false;
            Style.BreakBeforeBinaryOperators = FormatStyle.BinaryOperatorStyle.BOS_All;
            Style.BreakBeforeBraces = FormatStyle.BraceBreakingStyle.BS_WebKit;
            Style.BreakConstructorInitializersBeforeComma = true;
            Style.Cpp11BracedListStyle = false;
            Style.ColumnLimit = 0;
            Style.IndentWidth = 4;
            Style.NamespaceIndentation = FormatStyle.NamespaceIndentationKind.NI_Inner;
            Style.ObjCBlockIndentWidth = 4;
            Style.ObjCSpaceAfterProperty = true;
            Style.PointerAlignment = FormatStyle.PointerAlignmentStyle.PAS_Left;
            Style.Standard = FormatStyle.LanguageStandard.LS_Cpp03;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
            return formatStyle;
        }
        finally {
            if (Style != null) {
                Style.$destroy();
            }
        }
    }

    public static FormatStyle getGNUStyle() {
        FormatStyle Style = null;
        try {
            Style = FormatGlobals.getLLVMStyle();
            Style.AlwaysBreakAfterDefinitionReturnType = FormatStyle.DefinitionReturnTypeBreakingStyle.DRTBS_All;
            Style.AlwaysBreakAfterReturnType = FormatStyle.ReturnTypeBreakingStyle.RTBS_AllDefinitions;
            Style.BreakBeforeBinaryOperators = FormatStyle.BinaryOperatorStyle.BOS_All;
            Style.BreakBeforeBraces = FormatStyle.BraceBreakingStyle.BS_GNU;
            Style.BreakBeforeTernaryOperators = true;
            Style.Cpp11BracedListStyle = false;
            Style.ColumnLimit = 79;
            Style.SpaceBeforeParens = FormatStyle.SpaceBeforeParensOptions.SBPO_Always;
            Style.Standard = FormatStyle.LanguageStandard.LS_Cpp03;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
            return formatStyle;
        }
        finally {
            if (Style != null) {
                Style.$destroy();
            }
        }
    }

    public static FormatStyle getNoStyle() {
        FormatStyle NoStyle = null;
        try {
            NoStyle = FormatGlobals.getLLVMStyle();
            NoStyle.DisableFormat = true;
            NoStyle.SortIncludes = false;
            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, NoStyle);
            return formatStyle;
        }
        finally {
            if (NoStyle != null) {
                NoStyle.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getPredefinedStyle(StringRef Name, FormatStyle.LanguageKind Language, FormatStyle Style) {
        if (Name.equals_lower("llvm")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getLLVMStyle())));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("chromium")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getChromiumStyle(Language))));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("mozilla")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getMozillaStyle())));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("google")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getGoogleStyle(Language))));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("webkit")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getWebKitStyle())));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("gnu")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getGNUStyle())));
            }
            finally {
                $c$.$destroy();
            }
        } else if (Name.equals_lower("none")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)Style.$assignMove((FormatStyle)$c$.track((Object)FormatGlobals.getNoStyle())));
            }
            finally {
                $c$.$destroy();
            }
        } else {
            return false;
        }
        Style.Language = Language;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code parseConfiguration(StringRef Text, FormatStyle Style) {
        std.vector Styles = null;
        Input $Input = null;
        try {
            assert (Native.$bool((Object)Style));
            FormatStyle.LanguageKind Language = Style.Language;
            assert (Language != FormatStyle.LanguageKind.LK_None);
            if (Text.trim().empty()) {
                std_errors.error_code error_code2 = FormatGlobals.make_error_code(ParseError.Error);
                return error_code2;
            }
            Styles = new std.vector((Object)new FormatStyle());
            $Input = new Input(new StringRef(Text));
            $Input.setContext((Object)Style);
            YamlGlobals.$in$HasDocumentListTraits((Input)$Input, (DocumentListTraits)new DocumentListTraitsVector$FormatStyle(), (Sequence)Styles);
            if ($Input.error().$bool()) {
                std_errors.error_code error_code3 = $Input.error();
                return error_code3;
            }
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)Styles.size())) {
                if (((FormatStyle)Styles.$at((int)i)).Language == FormatStyle.LanguageKind.LK_None && i != 0) {
                    std_errors.error_code error_code4 = FormatGlobals.make_error_code(ParseError.Error);
                    return error_code4;
                }
                int j = 0;
                while (Unsigned.$less_uint((int)j, (int)i)) {
                    if (((FormatStyle)Styles.$at((int)i)).Language == ((FormatStyle)Styles.$at((int)j)).Language) {
                        std_errors.error_code error_code5 = FormatGlobals.make_error_code(ParseError.Error);
                        return error_code5;
                    }
                    ++j;
                }
                ++i;
            }
            for (i = Styles.size() - 1; i >= 0; --i) {
                if (((FormatStyle)Styles.$at((int)i)).Language != Language && ((FormatStyle)Styles.$at((int)i)).Language != FormatStyle.LanguageKind.LK_None) continue;
                Style.$assign((FormatStyle)Styles.$at(i));
                Style.Language = Language;
                std_errors.error_code error_code6 = FormatGlobals.make_error_code(ParseError.Success);
                return error_code6;
            }
            std_errors.error_code error_code7 = FormatGlobals.make_error_code(ParseError.Unsuitable);
            return error_code7;
        }
        finally {
            if ($Input != null) {
                $Input.$destroy();
            }
            if (Styles != null) {
                Styles.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string configurationAsText(FormatStyle Style) {
        raw_string_ostream Stream = null;
        Output $Output = null;
        FormatStyle NonConstStyle = null;
        try {
            std.string Text = new std.string();
            Stream = new raw_string_ostream(Text);
            $Output = new Output((raw_ostream)Stream);
            NonConstStyle = FormatStatics.expandPresets(Style);
            YamlGlobals.$out$HasMappingTraits((Output)$Output, (MappingTraits)new MappingTraitsFormatStyle(), (Object)NonConstStyle);
            std.string string2 = new std.string(Stream.str());
            return string2;
        }
        finally {
            if (NonConstStyle != null) {
                NonConstStyle.$destroy();
            }
            if ($Output != null) {
                $Output.$destroy();
            }
            if (Stream != null) {
                Stream.$destroy();
            }
        }
    }

    public static std.setType<Replacement> sortIncludes(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName) {
        return FormatGlobals.sortIncludes(Style, Code, Ranges, FileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> sortIncludes(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName, uint.ptr Cursor) {
        std.setType Replaces = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Replaces = new std.setType();
            if (!Style.SortIncludes) {
                std.setType setType2 = new std.setType(JavaDifferentiators.JD$Move.INSTANCE, Replaces);
                return setType2;
            }
            if (Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
                std.setType<Replacement> setType3 = FormatStatics.sortJavaScriptImports(Style, new StringRef(Code), (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName));
                return setType3;
            }
            $c$.clean($c$.track(FormatStatics.sortCppIncludes(Style, new StringRef(Code), (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName), (std.setType<Replacement>)Replaces, Cursor)));
            std.setType setType4 = new std.setType(JavaDifferentiators.JD$Move.INSTANCE, Replaces);
            return setType4;
        }
        finally {
            if (Replaces != null) {
                Replaces.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Expected<std.setType<Replacement>> formatReplacements(StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        Expected<std.setType<Replacement>> SortedReplaces = null;
        FormatFunctionPointers.FormatStyleStringRefvectorStringRef2Replacements SortIncludes = (Style$1, Code$1, Ranges, FileName) -> FormatGlobals.sortIncludes(Style$1, new StringRef(Code$1), (ArrayRef<Range>)new ArrayRef(Ranges, false), new StringRef(FileName));
        SortedReplaces = FormatStatics.processReplacements(SortIncludes, new StringRef(Code), Replaces, Style);
        if (!SortedReplaces.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Expected expected = (Expected)$c$.clean((Object)new Expected((Error)$c$.track((Object)SortedReplaces.takeError())));
                return expected;
            }
            finally {
                $c$.$destroy();
            }
        }
        FormatFunctionPointers.FormatStyleStringRefvectorStringRef2Replacements Reformat = (Style$1, Code$1, Ranges, FileName) -> FormatGlobals.reformat(Style$1, new StringRef(Code$1), (ArrayRef<Range>)new ArrayRef(Ranges, false), new StringRef(FileName));
        Expected<std.setType<Replacement>> expected = FormatStatics.processReplacements(Reformat, new StringRef(Code), (std.setType<Replacement>)((std.setType)SortedReplaces.$star()), Style);
        return expected;
        finally {
            if (SortedReplaces != null) {
                SortedReplaces.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Expected<std.setType<Replacement>> cleanupAroundReplacements(StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        std.setType<Replacement> NewReplaces = null;
        try {
            FormatFunctionPointers.FormatStyleStringRefvectorStringRef2Replacements Cleanup = (Style$1, Code$1, Ranges, FileName) -> FormatGlobals.cleanup(Style$1, new StringRef(Code$1), (ArrayRef<Range>)new ArrayRef(Ranges, false), new StringRef(FileName));
            NewReplaces = FormatStatics.fixCppIncludeInsertions(new StringRef(Code), Replaces, Style);
            Expected<std.setType<Replacement>> expected = FormatStatics.processReplacements(Cleanup, new StringRef(Code), NewReplaces, Style);
            return expected;
        }
        finally {
            if (NewReplaces != null) {
                NewReplaces.$destroy();
            }
        }
    }

    public static std.setType<Replacement> reformat(FormatStyle Style, SourceManager SM, FileID ID, ArrayRef<CharSourceRange> Ranges) {
        return FormatGlobals.reformat(Style, SM, ID, Ranges, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> reformat(FormatStyle Style, SourceManager SM, FileID ID, ArrayRef<CharSourceRange> Ranges, bool.ptr IncompleteFormat) {
        FormatStyle Expanded = null;
        Environment Env = null;
        Formatter Format = null;
        try {
            Expanded = FormatStatics.expandPresets(Style);
            if (Expanded.DisableFormat) {
                std.setType setType2 = new std.setType();
                return setType2;
            }
            Env = new Environment(SM, new FileID(ID), (ArrayRef<CharSourceRange>)new ArrayRef(Ranges));
            Format = new Formatter(Env, Expanded, IncompleteFormat);
            std.setType<Replacement> setType3 = Format.process();
            return setType3;
        }
        finally {
            if (Format != null) {
                Format.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
            if (Expanded != null) {
                Expanded.$destroy();
            }
        }
    }

    public static std.setType<Replacement> reformat(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges) {
        return FormatGlobals.reformat(Style, Code, Ranges, new StringRef("<stdin>"), (bool.ptr)null);
    }

    public static std.setType<Replacement> reformat(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName) {
        return FormatGlobals.reformat(Style, Code, Ranges, FileName, (bool.ptr)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> reformat(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName, bool.ptr IncompleteFormat) {
        FormatStyle Expanded = null;
        std_ptr.unique_ptr<Environment> Env = null;
        Formatter Format = null;
        try {
            Expanded = FormatStatics.expandPresets(Style);
            if (Expanded.DisableFormat) {
                std.setType setType2 = new std.setType();
                return setType2;
            }
            Env = Environment.CreateVirtualEnvironment(new StringRef(Code), new StringRef(FileName), (ArrayRef<Range>)new ArrayRef(Ranges));
            Format = new Formatter((Environment)Env.$star(), Expanded, IncompleteFormat);
            std.setType<Replacement> setType3 = Format.process();
            return setType3;
        }
        finally {
            if (Format != null) {
                Format.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
            if (Expanded != null) {
                Expanded.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> cleanup(FormatStyle Style, SourceManager SM, FileID ID, ArrayRef<CharSourceRange> Ranges) {
        Environment Env = null;
        Cleaner Clean = null;
        try {
            Env = new Environment(SM, new FileID(ID), (ArrayRef<CharSourceRange>)new ArrayRef(Ranges));
            Clean = new Cleaner(Env, Style);
            std.setType<Replacement> setType2 = Clean.process();
            return setType2;
        }
        finally {
            if (Clean != null) {
                Clean.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
        }
    }

    public static std.setType<Replacement> cleanup(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges) {
        return FormatGlobals.cleanup(Style, Code, Ranges, new StringRef("<stdin>"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> cleanup(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName) {
        std_ptr.unique_ptr<Environment> Env = null;
        Cleaner Clean = null;
        try {
            Env = Environment.CreateVirtualEnvironment(new StringRef(Code), new StringRef(FileName), (ArrayRef<Range>)new ArrayRef(Ranges));
            Clean = new Cleaner((Environment)Env.$star(), Style);
            std.setType<Replacement> setType2 = Clean.process();
            return setType2;
        }
        finally {
            if (Clean != null) {
                Clean.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
        }
    }

    public static LangOptions getFormattingLangOpts() {
        return FormatGlobals.getFormattingLangOpts(FormatGlobals.getLLVMStyle());
    }

    public static LangOptions getFormattingLangOpts(FormatStyle Style) {
        LangOptions LangOpts = new LangOptions();
        LangOpts.CPlusPlus = true;
        LangOpts.CPlusPlus11 = Unsigned.$uint2uint_1bit((int)(Style.Standard == FormatStyle.LanguageStandard.LS_Cpp03 ? 0 : 1));
        LangOpts.CPlusPlus14 = Unsigned.$uint2uint_1bit((int)(Style.Standard == FormatStyle.LanguageStandard.LS_Cpp03 ? 0 : 1));
        LangOpts.LineComment = true;
        boolean AlternativeOperators = Style.Language == FormatStyle.LanguageKind.LK_Cpp;
        LangOpts.CXXOperatorNames = Unsigned.$uint2uint_1bit((int)(AlternativeOperators ? 1 : 0));
        LangOpts.Bool = true;
        LangOpts.ObjC1 = true;
        LangOpts.ObjC2 = true;
        LangOpts.MicrosoftExt = true;
        LangOpts.DeclSpecKeyword = true;
        return LangOpts;
    }

    public static FormatStyle getStyle(StringRef StyleName, StringRef FileName, StringRef FallbackStyle) {
        return FormatGlobals.getStyle(StyleName, FileName, FallbackStyle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FormatStyle getStyle(StringRef StyleName, StringRef FileName, StringRef FallbackStyle, FileSystem FS) {
        Object ec;
        Object $c$;
        FormatStyle Style = null;
        if (FS == null) {
            $c$ = Native.$createJavaCleaner();
            try {
                FS = (FileSystem)((IntrusiveRefCntPtr)$c$.track((Object)VfsGlobals.getRealFileSystem())).get();
                $c$.clean((Object)FS);
            }
            finally {
                $c$.$destroy();
            }
        }
        Style = FormatGlobals.getLLVMStyle();
        Style.Language = FormatStatics.getLanguageByFileName(new StringRef(FileName));
        if (!FormatGlobals.getPredefinedStyle(new StringRef(FallbackStyle), Style.Language, Style)) {
            llvm.errs().$out("Invalid fallback style \"").$out(FallbackStyle).$out("\" using LLVM style\n");
            $c$ = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
            return $c$;
        }
        if (StyleName.startswith("{")) {
            ec = FormatGlobals.parseConfiguration(new StringRef(StyleName), Style);
            if (ec.$bool()) {
                llvm.errs().$out("Error parsing -style: ").$out(ec.message()).$out(", using ").$out(FallbackStyle).$out(" style\n");
            }
            ec = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
            return ec;
        }
        if (!StyleName.equals_lower("file")) {
            if (!FormatGlobals.getPredefinedStyle(new StringRef(StyleName), Style.Language, Style)) {
                llvm.errs().$out("Invalid value for -style, using ").$out(FallbackStyle).$out(" style\n");
            }
            ec = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
            return ec;
        }
        SmallString UnsuitableConfigFiles = new SmallString(128);
        SmallString Path = new SmallString(new StringRef(FileName), 128);
        fs.make_absolute((SmallString)Path);
        StringRef Directory = Path.$StringRef();
        while (!Directory.empty()) {
            block34: {
                ErrorOr Status2 = FS.status(new Twine(Directory));
                if (Status2.$bool() && ((Status)Status2.$arrow()).getType() == fs.file_type.directory_file) {
                    boolean IsFile;
                    SmallString ConfigFile = new SmallString(new StringRef(Directory), 128);
                    path.append((SmallString)ConfigFile, (Twine)new Twine(".clang-format"));
                    Status2.$assignMove(FS.status(new Twine(ConfigFile.str())));
                    boolean bl = IsFile = Status2.$bool() && ((Status)Status2.$arrow()).getType() == fs.file_type.regular_file;
                    if (!IsFile) {
                        ConfigFile.$assign(Directory);
                        path.append((SmallString)ConfigFile, (Twine)new Twine("_clang-format"));
                        Status2.$assignMove(FS.status(new Twine(ConfigFile.str())));
                        boolean bl2 = IsFile = Status2.$bool() && ((Status)Status2.$arrow()).getType() == fs.file_type.regular_file;
                    }
                    if (IsFile) {
                        ErrorOr Text = null;
                        try {
                            Text = FS.getBufferForFile(new Twine(ConfigFile.str()));
                            std_errors.error_code EC = Text.getError();
                            if (EC.$bool()) {
                                llvm.errs().$out(EC.message()).$out(NativePointer.$LF);
                                break;
                            }
                            std_errors.error_code ec2 = FormatGlobals.parseConfiguration(((MemoryBuffer)((std_ptr.unique_ptr)Text.get()).$arrow()).getBuffer(), Style);
                            if (ec2.$bool()) {
                                if (std.$eq_error_code$C((std_errors.error_code)ec2, (std_errors.error_code)new std_errors.error_code((std_errors.is_error_code_enum)ParseError.Unsuitable))) {
                                    if (!UnsuitableConfigFiles.empty()) {
                                        UnsuitableConfigFiles.append(new StringRef(NativePointer.$COMMA_SPACE));
                                    }
                                    UnsuitableConfigFiles.append((SmallVectorImplChar)ConfigFile);
                                    break block34;
                                } else {
                                    llvm.errs().$out("Error reading ").$out(ConfigFile).$out(": ").$out(ec2.message()).$out(NativePointer.$LF);
                                    break;
                                }
                            }
                            FormatStyle formatStyle = new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
                            return formatStyle;
                        }
                        finally {
                            if (Text != null) {
                                Text.$destroy();
                            }
                        }
                    }
                }
            }
            Directory.$assignMove(path.parent_path((StringRef)Directory));
        }
        if (UnsuitableConfigFiles.empty()) return new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
        llvm.errs().$out("Configuration file(s) do(es) not support ").$out(FormatGlobals.getLanguageName(Style.Language)).$out(": ").$out(UnsuitableConfigFiles).$out(NativePointer.$LF);
        return new FormatStyle(JavaDifferentiators.JD$Move.INSTANCE, Style);
        finally {
            if (Style != null) {
                Style.$destroy();
            }
        }
    }

    public static StringRef getLanguageName(FormatStyle.LanguageKind Language) {
        switch (Language) {
            case LK_Cpp: {
                return new StringRef("C++");
            }
            case LK_Java: {
                return new StringRef("Java");
            }
            case LK_JavaScript: {
                return new StringRef("JavaScript");
            }
            case LK_Proto: {
                return new StringRef("Proto");
            }
        }
        return new StringRef("Unknown");
    }
}

