/*
 * Decompiled with CFR 0.152.
 */
package fleet.imageviewer.frontend;

import androidx.compose.foundation.BackgroundKt;
import androidx.compose.foundation.layout.BoxKt;
import androidx.compose.foundation.layout.BoxScope;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.runtime.Composable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.BiasAlignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusModifierKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.IOError;
import fleet.api.RpcResult;
import fleet.api.workspace.document.MediaType;
import fleet.common.document.FileSize;
import fleet.common.language.MediaTypeKt;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.components.DelayedKt;
import fleet.compose.theme.components.ImageKt;
import fleet.compose.theme.components.ProgressIndicatorKt;
import fleet.compose.theme.components.TextKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.navigation.FileNavigationKt;
import fleet.frontend.navigation.NavigationParameters;
import fleet.frontend.navigation.ViewDslKt;
import fleet.frontend.ui.editor.EditorEntityViewKt;
import fleet.frontend.ui.navigation.ViewDslViewKt;
import fleet.frontend.util.ValidationErrorKt;
import fleet.imageviewer.frontend.ImageEditorViewKt;
import fleet.imageviewer.frontend.ImageFileEntity;
import fleet.imageviewer.frontend.ImageViewLocation;
import fleet.kernel.plugins.ContributionScope;
import fleet.navigation.common.api.ViewLocation;
import fleet.navigation.common.api.ViewTypeId;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import noria.model.ThemeKey;
import noria.ui.ApplyModifierKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003\u001a\u001c\u0010\n\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0003\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ImageViewTypeId", "Lfleet/navigation/common/api/ViewTypeId;", "Lfleet/imageviewer/frontend/ImageViewLocation;", "binaryImageView", "", "Lfleet/kernel/plugins/ContributionScope;", "imageView", "Lnoria/NoriaContext;", "image", "Lfleet/imageviewer/frontend/ImageFileEntity;", "showImageInCenter", "pictureBytes", "", "imageFileEntity", "fleet.plugins.imageviewer.frontend"})
@SourceDebugExtension(value={"SMAP\nImageEditorView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageEditorView.kt\nfleet/imageviewer/frontend/ImageEditorViewKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,149:1\n1251#2,2:150\n*S KotlinDebug\n*F\n+ 1 ImageEditorView.kt\nfleet/imageviewer/frontend/ImageEditorViewKt\n*L\n43#1:150,2\n*E\n"})
public final class ImageEditorViewKt {
    @NotNull
    private static final ViewTypeId<ImageViewLocation> ImageViewTypeId = new ViewTypeId("image");

    public static final void binaryImageView(@NotNull ContributionScope $this$binaryImageView) {
        Intrinsics.checkNotNullParameter((Object)$this$binaryImageView, (String)"<this>");
        FileNavigationKt.fileNavigationDispatcher((ContributionScope)$this$binaryImageView, (int)90, ImageEditorViewKt::binaryImageView$lambda$2);
        ViewDslKt.viewType((ContributionScope)$this$binaryImageView, ImageViewTypeId, ImageViewLocation.Companion.serializer(), (Function1)binaryImageView.2.INSTANCE);
    }

    @Composable
    private static final void imageView(NoriaContext $this$imageView, ImageFileEntity image2) {
        Runtime.enterScope((NoriaContext)$this$imageView, (int)12);
        Object[] objectArray = new Object[]{image2};
        EditorEntityViewKt.distractionFreeModeView((NoriaContext)$this$imageView, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(image2){
            final /* synthetic */ ImageFileEntity $image;
            {
                this.$image = $image;
                super(1);
            }

            public final void invoke(NoriaContext $this$distractionFreeModeView) {
                Intrinsics.checkNotNullParameter((Object)$this$distractionFreeModeView, (String)"$this$distractionFreeModeView");
                Runtime.enterScope((NoriaContext)$this$distractionFreeModeView, (int)11);
                int $this$dp$iv = 20;
                boolean $i$f$getDp = false;
                Object[] objectArray = new Object[]{this.$image};
                ApplyModifierKt.withModifier((NoriaContext)$this$distractionFreeModeView, (Modifier)FocusModifierKt.focusTarget((Modifier)PaddingKt.padding-3ABfNKs((Modifier)BackgroundKt.background-bw27NRU$default((Modifier)((Modifier)Modifier.Companion), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$distractionFreeModeView)).get(ThemeKeys.INSTANCE.getEditorBackground())).unbox-impl(), null, (int)2, null), (float)Dp.constructor-impl((float)$this$dp$iv))), (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$image){
                    final /* synthetic */ ImageFileEntity $image;
                    {
                        this.$image = $image;
                        super(1);
                    }

                    public final void invoke(NoriaContext $this$withModifier) {
                        Intrinsics.checkNotNullParameter((Object)$this$withModifier, (String)"$this$withModifier");
                        RpcResult<byte[], IOError> content = this.$image.getContent();
                        if (content instanceof RpcResult.Success) {
                            Runtime.enterScope((NoriaContext)$this$withModifier, (int)3);
                            ImageEditorViewKt.access$showImageInCenter($this$withModifier, (byte[])((RpcResult.Success)content).getValue(), this.$image);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)$this$withModifier);
                        } else if (content instanceof RpcResult.Failure) {
                            Runtime.enterScope((NoriaContext)$this$withModifier, (int)4);
                            ViewDslViewKt.errorViewView-jzV_Hc0$default((NoriaContext)$this$withModifier, (ThemeKey)IconKeys.EmptyState.INSTANCE.getError(), null, (String)(ValidationErrorKt.fileError((IOError)((IOError)((RpcResult.Failure)content).getError())) + "\n" + this.$image.getFileEntity().getFileAddress().getPath().joinToString()), (long)0L, null, (int)26, null);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)$this$withModifier);
                        } else if (content == null) {
                            Runtime.enterScope((NoriaContext)$this$withModifier, (int)10);
                            Object[] objectArray = new Object[]{this.$image};
                            DelayedKt.Delayed-dWUq8MI$default((NoriaContext)$this$withModifier, (long)0L, null, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<NoriaContext, Unit>(this.$image){
                                final /* synthetic */ ImageFileEntity $image;
                                {
                                    this.$image = $image;
                                    super(1);
                                }

                                public final void invoke(NoriaContext $this$Delayed) {
                                    Intrinsics.checkNotNullParameter((Object)$this$Delayed, (String)"$this$Delayed");
                                    int $this$dp$iv = 320;
                                    boolean $i$f$getDp = false;
                                    Object[] objectArray = new Object[]{this.$image};
                                    BoxKt.Box$default((NoriaContext)$this$Delayed, (Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)), (Alignment)((Alignment)new BiasAlignment(0.0f, -0.2f)), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<BoxScope, Unit>(this.$image){
                                        final /* synthetic */ ImageFileEntity $image;
                                        {
                                            this.$image = $image;
                                            super(1);
                                        }

                                        public final void invoke(BoxScope $this$Box) {
                                            Intrinsics.checkNotNullParameter((Object)$this$Box, (String)"$this$Box");
                                            Integer loadedBytes = this.$image.getLoadedBytes();
                                            Integer totalBytes = this.$image.getTotalBytes();
                                            if (loadedBytes != null && totalBytes != null) {
                                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Box), (int)8);
                                                Object[] objectArray = new Object[]{loadedBytes, totalBytes};
                                                ColumnKt.Column$default((NoriaContext)((NoriaContext)$this$Box), null, null, null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(loadedBytes, totalBytes){
                                                    final /* synthetic */ Integer $loadedBytes;
                                                    final /* synthetic */ Integer $totalBytes;
                                                    {
                                                        this.$loadedBytes = $loadedBytes;
                                                        this.$totalBytes = $totalBytes;
                                                        super(1);
                                                    }

                                                    public final void invoke(ColumnScope $this$Column) {
                                                        Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
                                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)5);
                                                        int $this$dp$iv = 4;
                                                        boolean $i$f$getDp = false;
                                                        ProgressIndicatorKt.DeterminateProgress-wH6b6FI((NoriaContext)((NoriaContext)$this$Column), (float)((float)this.$loadedBytes.intValue() / (float)this.$totalBytes.intValue() * (float)100), (float)Dp.constructor-impl((float)$this$dp$iv));
                                                        Unit unit = Unit.INSTANCE;
                                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)6);
                                                        $this$dp$iv = 8;
                                                        $i$f$getDp = false;
                                                        SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.height-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)));
                                                        unit = Unit.INSTANCE;
                                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                                                        Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)7);
                                                        TextKt.UiText-1ODQ_eA$default((NoriaContext)((NoriaContext)$this$Column), (String)(FileSize.toString-impl((long)FileSize.constructor-impl((long)this.$loadedBytes.intValue())) + " of " + FileSize.toString-impl((long)FileSize.constructor-impl((long)this.$totalBytes.intValue()))), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Column)).get(ThemeKeys.INSTANCE.getTextDimmed())).unbox-impl(), null, null, (NoriaParagraphStyle)NoriaParagraphStyle.Companion.getCentered(), null, null, null, null, null, (int)1004, null);
                                                        unit = Unit.INSTANCE;
                                                        Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
                                                    }
                                                })), (int)15, null);
                                                Unit unit = Unit.INSTANCE;
                                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Box));
                                            } else {
                                                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Box), (int)9);
                                                int $this$dp$iv = 4;
                                                boolean $i$f$getDp = false;
                                                ProgressIndicatorKt.IndeterminateProgress-lG28NQ4$default((NoriaContext)((NoriaContext)$this$Box), (float)Dp.constructor-impl((float)$this$dp$iv), (int)0, (int)2, null);
                                                Unit unit = Unit.INSTANCE;
                                                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Box));
                                            }
                                        }
                                    })), (int)4, null);
                                }
                            })), (int)3, null);
                            Unit unit = Unit.INSTANCE;
                            Runtime.exitScope((NoriaContext)$this$withModifier);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                })));
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)$this$distractionFreeModeView);
            }
        })));
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$imageView);
    }

    @Composable
    private static final void showImageInCenter(NoriaContext $this$showImageInCenter, byte[] pictureBytes, ImageFileEntity imageFileEntity) {
        Object[] objectArray = new Object[]{pictureBytes, imageFileEntity};
        BoxKt.Box$default((NoriaContext)$this$showImageInCenter, (Modifier)SizeKt.fillMaxSize$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (int)1, null), (Alignment)Alignment.Companion.getCenter(), (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<BoxScope, Unit>(pictureBytes, imageFileEntity){
            final /* synthetic */ byte[] $pictureBytes;
            final /* synthetic */ ImageFileEntity $imageFileEntity;
            {
                this.$pictureBytes = $pictureBytes;
                this.$imageFileEntity = $imageFileEntity;
                super(1);
            }

            public final void invoke(BoxScope $this$Box) {
                Intrinsics.checkNotNullParameter((Object)$this$Box, (String)"$this$Box");
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Box), (int)13);
                ImageKt.Image$default((NoriaContext)((NoriaContext)$this$Box), (byte[])this.$pictureBytes, (String)FileAddressKt.getExtension((FileAddress)this.$imageFileEntity.getFileEntity().getFileAddress()), null, null, null, (float)0.0f, null, (int)124, null);
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Box));
            }
        })), (int)4, null);
    }

    private static final ViewLocation binaryImageView$lambda$2(NavigationParameters parameters) {
        ViewLocation viewLocation;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        FileAddress fileAddress = parameters.getFileAddress();
        if (fileAddress != null) {
            boolean isPictureExtension;
            FileAddress fileAddress2;
            block3: {
                boolean bl;
                fileAddress2 = fileAddress;
                boolean bl2 = false;
                Sequence $this$any$iv = MediaTypeKt.detectMediaType((FileAddress)fileAddress2);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    MediaType mediaType = (MediaType)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)mediaType.getMainType(), (Object)"image") && mediaType.getSyntax() == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = isPictureExtension = false;
            }
            viewLocation = isPictureExtension ? new ViewLocation(ImageViewTypeId, (Object)new ImageViewLocation(fileAddress2)) : null;
        } else {
            viewLocation = null;
        }
        return viewLocation;
    }

    public static final /* synthetic */ void access$imageView(NoriaContext $receiver, ImageFileEntity image2) {
        ImageEditorViewKt.imageView($receiver, image2);
    }

    public static final /* synthetic */ void access$showImageInCenter(NoriaContext $receiver, byte[] pictureBytes, ImageFileEntity imageFileEntity) {
        ImageEditorViewKt.showImageInCenter($receiver, pictureBytes, imageFileEntity);
    }
}

