/*
 * Decompiled with CFR 0.152.
 */
package fleet.mercury.workspace.logcat;

import fleet.mercury.protocol.logcat.LogLevel;
import fleet.mercury.workspace.logcat.LogcatHeader;
import fleet.mercury.workspace.logcat.LogcatRow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0000\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"ANSI_COLOR", "", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "MILLI", "TIMESTAMP", "PID", "TID", "LEVEL", "TAG_THREADTIME", "TAG_FIREBASE", "MESSAGE", "THREADTIME_REGEX", "Lkotlin/text/Regex;", "getTHREADTIME_REGEX", "()Lkotlin/text/Regex;", "parseLevel", "Lfleet/mercury/protocol/logcat/LogLevel;", "char", "", "parseLogcatRow", "Lfleet/mercury/workspace/logcat/LogcatRow;", "line", "toRecord", "Lfleet/mercury/workspace/logcat/LogcatRow$LogcatRecord;", "Lkotlin/text/MatchResult;", "getGroup", "group", "fleet.plugins.mercury.workspace"})
@SourceDebugExtension(value={"SMAP\nLogcatRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatRecord.kt\nfleet/mercury/workspace/logcat/LogcatRecordKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n295#2,2:55\n*S KotlinDebug\n*F\n+ 1 LogcatRecord.kt\nfleet/mercury/workspace/logcat/LogcatRecordKt\n*L\n35#1:55,2\n*E\n"})
public final class LogcatRecordKt {
    @NotNull
    private static final String ANSI_COLOR = "(?<color>\\033\\[\\d+(;\\d+)*m)?";
    @NotNull
    private static final String MONTH = "(?<month>\\d\\d)";
    @NotNull
    private static final String DAY = "(?<day>\\d\\d)";
    @NotNull
    private static final String HOUR = "(?<hour>\\d\\d)";
    @NotNull
    private static final String MINUTE = "(?<minute>\\d\\d)";
    @NotNull
    private static final String SECOND = "(?<second>\\d\\d)";
    @NotNull
    private static final String MILLI = "(?<milli>\\d\\d\\d)";
    @NotNull
    private static final String TIMESTAMP = "(?<timestamp>(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d))";
    @NotNull
    private static final String PID = "(?<pid>\\d+)";
    @NotNull
    private static final String TID = "(?<tid>\\d+)";
    @NotNull
    private static final String LEVEL = "(?<level>[VDIWEA])";
    @NotNull
    private static final String TAG_THREADTIME = "(?<tag>.+?(?=: ))";
    @NotNull
    private static final String TAG_FIREBASE = "(?<tag>.+?(?=\\())";
    @NotNull
    private static final String MESSAGE = "(?<message>.*)";
    @NotNull
    private static final Regex THREADTIME_REGEX = new Regex("^(?<color>\\033\\[\\d+(;\\d+)*m)?(?<timestamp>(?<month>\\d\\d)-(?<day>\\d\\d) (?<hour>\\d\\d):(?<minute>\\d\\d):(?<second>\\d\\d)\\.(?<milli>\\d\\d\\d)) +(?<pid>\\d+) +(?<tid>\\d+) (?<level>[VDIWEA]) (?<tag>.+?(?=: )): (?<message>.*)$");

    @NotNull
    public static final Regex getTHREADTIME_REGEX() {
        return THREADTIME_REGEX;
    }

    private static final LogLevel parseLevel(char c) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)LogLevel.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LogLevel it = (LogLevel)element$iv;
                boolean bl = false;
                if (!(it.getChar() == c)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final LogcatRow parseLogcatRow(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Object object = Regex.find$default((Regex)THREADTIME_REGEX, (CharSequence)line, (int)0, (int)2, null);
        return object != null && (object = LogcatRecordKt.toRecord(object)) != null ? (LogcatRow)object : (LogcatRow)new LogcatRow.Miscellaneous(line);
    }

    private static final LogcatRow.LogcatRecord toRecord(MatchResult $this$toRecord) {
        Object object;
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$toRecord.getGroups(), (String)"color");
        if (object2 == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        LogLevel logLevel = LogcatRecordKt.parseLevel(StringsKt.first((CharSequence)LogcatRecordKt.getGroup($this$toRecord, "level")));
        if (logLevel == null) {
            throw new IllegalArgumentException("Invalid log level: " + StringsKt.first((CharSequence)LogcatRecordKt.getGroup($this$toRecord, "level")));
        }
        return new LogcatRow.LogcatRecord(new LogcatHeader((String)object2, LogcatRecordKt.getGroup($this$toRecord, "timestamp"), Integer.parseInt(LogcatRecordKt.getGroup($this$toRecord, "pid")), (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$toRecord.getGroups(), (String)"tid")) != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0, logLevel, ((Object)StringsKt.trim((CharSequence)LogcatRecordKt.getGroup($this$toRecord, "tag"))).toString()), LogcatRecordKt.getGroup($this$toRecord, "message"));
    }

    private static final String getGroup(MatchResult $this$getGroup, String group) {
        Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getGroup.getGroups(), (String)group);
        if (object == null || (object = object.getValue()) == null) {
            throw new IllegalArgumentException("Group '" + group + "' not found in " + $this$getGroup.getValue());
        }
        return object;
    }
}

