/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model.hyperlinks;

import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.HyperlinkFilter;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(TextProcessing.class);
    private final List<HyperlinkFilter> myHyperlinkFilter;
    private TextStyle myHyperlinkColor;
    private HyperlinkStyle.HighlightMode myHighlightMode;
    private TerminalTextBuffer myTerminalTextBuffer;

    public TextProcessing(@NotNull TextStyle hyperlinkColor, @NotNull HyperlinkStyle.HighlightMode highlightMode) {
        this.myHyperlinkColor = hyperlinkColor;
        this.myHighlightMode = highlightMode;
        this.myHyperlinkFilter = new ArrayList<HyperlinkFilter>();
    }

    public void setTerminalTextBuffer(@NotNull TerminalTextBuffer terminalTextBuffer) {
        this.myTerminalTextBuffer = terminalTextBuffer;
    }

    public void processHyperlinks(@NotNull LinesBuffer buffer, @NotNull TerminalLine updatedLine) {
        if (this.myHyperlinkFilter.isEmpty()) {
            return;
        }
        this.doProcessHyperlinks(buffer, updatedLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessHyperlinks(@NotNull LinesBuffer buffer, @NotNull TerminalLine updatedLine) {
        this.myTerminalTextBuffer.lock();
        try {
            int startLineInd;
            int updatedLineInd = TextProcessing.findLineInd(buffer, updatedLine);
            if (updatedLineInd == -1) {
                updatedLineInd = this.findHistoryLineInd(this.myTerminalTextBuffer.getHistoryBuffer(), updatedLine);
                if (updatedLineInd == -1) {
                    LOG.debug("Cannot find line for links processing");
                    return;
                }
                buffer = this.myTerminalTextBuffer.getHistoryBuffer();
            }
            for (startLineInd = updatedLineInd; startLineInd > 0 && buffer.getLine(startLineInd - 1).isWrapped(); --startLineInd) {
            }
            String lineStr = this.joinLines(buffer, startLineInd, updatedLineInd);
            for (HyperlinkFilter filter : this.myHyperlinkFilter) {
                LinkResult result = filter.apply(lineStr);
                if (result == null) continue;
                for (LinkResultItem item : result.getItems()) {
                    HyperlinkStyle style = new HyperlinkStyle(this.myHyperlinkColor.getForeground(), this.myHyperlinkColor.getBackground(), item.getLinkInfo(), this.myHighlightMode, null);
                    if (item.getStartOffset() < 0 || item.getEndOffset() > lineStr.length()) continue;
                    int prevLinesLength = 0;
                    for (int lineInd = startLineInd; lineInd <= updatedLineInd; ++lineInd) {
                        int endLineOffset;
                        int startLineOffset = Math.max(prevLinesLength, item.getStartOffset());
                        if (startLineOffset < (endLineOffset = Math.min(prevLinesLength + this.myTerminalTextBuffer.getWidth(), item.getEndOffset()))) {
                            buffer.getLine(lineInd).writeString(startLineOffset - prevLinesLength, new CharBuffer(lineStr.substring(startLineOffset, endLineOffset)), style);
                        }
                        prevLinesLength += this.myTerminalTextBuffer.getWidth();
                    }
                }
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
    }

    private int findHistoryLineInd(@NotNull LinesBuffer historyBuffer, @NotNull TerminalLine line) {
        int lastLineInd = Math.max(0, historyBuffer.getLineCount() - 200);
        for (int i = historyBuffer.getLineCount() - 1; i >= lastLineInd; --i) {
            if (historyBuffer.getLine(i) != line) continue;
            return i;
        }
        return -1;
    }

    private static int findLineInd(@NotNull LinesBuffer buffer, @NotNull TerminalLine line) {
        for (int i = 0; i < buffer.getLineCount(); ++i) {
            TerminalLine l = buffer.getLine(i);
            if (l != line) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private String joinLines(@NotNull LinesBuffer buffer, int startLineInd, int updatedLineInd) {
        StringBuilder result = new StringBuilder();
        for (int i = startLineInd; i <= updatedLineInd; ++i) {
            Object text = buffer.getLine(i).getText();
            if (i < updatedLineInd && ((String)text).length() < this.myTerminalTextBuffer.getWidth()) {
                text = (String)text + new CharBuffer('\u0000', this.myTerminalTextBuffer.getWidth() - ((String)text).length());
            }
            result.append((String)text);
        }
        return result.toString();
    }

    public void addHyperlinkFilter(@NotNull HyperlinkFilter filter) {
        this.myHyperlinkFilter.add(filter);
    }

    @NotNull
    public List<LinkResultItem> applyFilter(@NotNull String line) {
        ArrayList<LinkResultItem> links = new ArrayList<LinkResultItem>();
        for (HyperlinkFilter filter : this.myHyperlinkFilter) {
            LinkResult result = filter.apply(line);
            if (result == null) continue;
            links.addAll(result.getItems());
        }
        return links;
    }
}

