/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.swift;

import fleet.com.intellij.openapi.util.Version;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class SwiftCompilerSettings {
    private static final Version latest = new Version(5, 8, 0);
    private static Supplier<Version> swiftVersionProvider = () -> latest;

    public static void setSwiftVersionProvider(Supplier<Version> newVersionStrategy) {
        swiftVersionProvider = newVersionStrategy;
    }

    public static boolean isCompilerVersion(int major, int minor) {
        return SwiftCompilerSettings.getCompilerVersion().isOrGreaterThan(Integer.valueOf(major), Integer.valueOf(minor));
    }

    @NotNull
    public static Version getCompilerVersion() {
        return swiftVersionProvider.get();
    }

    public static boolean supportsBareSlashRegex(Version swiftVersion) {
        return swiftVersion.isOrGreaterThan(Integer.valueOf(5), Integer.valueOf(7));
    }
}

