/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.parser.visitors;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptParser;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Address;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.parser.generated.VimscriptBaseVisitor;
import com.maddyhome.idea.vim.parser.generated.VimscriptParser;
import com.maddyhome.idea.vim.vimscript.model.commands.CallCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.DelfunctionCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.EchoCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.ExecuteCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.GlobalCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.GoToLineCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.LetCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.ShiftLeftCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.ShiftRightCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.SplitCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.SplitType;
import com.maddyhome.idea.vim.vimscript.model.commands.SubstituteCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.UnknownCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.mapping.MapClearCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.mapping.MapCommand;
import com.maddyhome.idea.vim.vimscript.model.commands.mapping.UnMapCommand;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.expressions.SimpleExpression;
import com.maddyhome.idea.vim.vimscript.model.expressions.operators.AssignmentOperator;
import com.maddyhome.idea.vim.vimscript.parser.visitors.ExpressionVisitor;
import com.maddyhome.idea.vim.vimscript.parser.visitors.VisitorHelperKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KClassifiers;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010H\u0002J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020+H\u0016J(\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010\u000b\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010\u000b\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020=H\u0016J\u0018\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020?2\u0006\u0010/\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/maddyhome/idea/vim/vimscript/parser/visitors/CommandVisitor;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptBaseVisitor;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "expressionVisitor", "Lcom/maddyhome/idea/vim/vimscript/parser/visitors/ExpressionVisitor;", "parseRangeOffset", "", "ctx", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$RangeOffsetContext;", "parseRangeExpression", "Lkotlin/Pair;", "", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$RangeExpressionContext;", "parseRangeUnit", "", "Lcom/maddyhome/idea/vim/ex/ranges/Address;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$RangeUnitContext;", "(Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$RangeUnitContext;)[Lcom/maddyhome/idea/vim/ex/ranges/Address;", "parseRange", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$RangeContext;", "visitLet1Command", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$Let1CommandContext;", "visitLet2Command", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$Let2CommandContext;", "visitEchoCommand", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$EchoCommandContext;", "visitCallCommand", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$CallCommandContext;", "visitDelfunctionCommand", "Lcom/maddyhome/idea/vim/vimscript/model/commands/DelfunctionCommand;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$DelfunctionCommandContext;", "visitGoToLineCommand", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$GoToLineCommandContext;", "visitCommandWithComment", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$CommandWithCommentContext;", "visitCommandWithoutComments", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$CommandWithoutCommentsContext;", "visitCommandWithBars", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$CommandWithBarsContext;", "createCommandByCommandContext", "range", "argument", "commandName", "Lorg/antlr/v4/runtime/ParserRuleContext;", "visitShiftLeftCommand", "Lcom/maddyhome/idea/vim/vimscript/model/commands/ShiftLeftCommand;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$ShiftLeftCommandContext;", "visitShiftRightCommand", "Lcom/maddyhome/idea/vim/vimscript/model/commands/ShiftRightCommand;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$ShiftRightCommandContext;", "visitExecuteCommand", "Lcom/maddyhome/idea/vim/vimscript/model/commands/ExecuteCommand;", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$ExecuteCommandContext;", "visitLetCommand", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$LetCommandContext;", "visitOtherCommand", "Lcom/maddyhome/idea/vim/parser/generated/VimscriptParser$OtherCommandContext;", "getCommandByName", "Lkotlin/reflect/KClass;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandVisitor.kt\ncom/maddyhome/idea/vim/vimscript/parser/visitors/CommandVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,280:1\n1#2:281\n774#3:282\n865#3,2:283\n295#3,2:285\n38#4:287\n*S KotlinDebug\n*F\n+ 1 CommandVisitor.kt\ncom/maddyhome/idea/vim/vimscript/parser/visitors/CommandVisitor\n*L\n269#1:282\n269#1:283,2\n270#1:285,2\n56#1:287\n*E\n"})
public final class CommandVisitor
extends VimscriptBaseVisitor<Command> {
    @NotNull
    public static final CommandVisitor INSTANCE = new CommandVisitor();
    @NotNull
    private static final VimLogger logger;
    @NotNull
    private static final ExpressionVisitor expressionVisitor;

    private CommandVisitor() {
    }

    private final int parseRangeOffset(VimscriptParser.RangeOffsetContext ctx) {
        int offset = 0;
        if (ctx != null) {
            offset += ctx.plusOneOffset().size();
            offset -= ctx.minusOneOffset().size();
            for (VimscriptParser.NumberInOffsetContext number : ctx.numberInOffset()) {
                offset += Integer.parseInt(number.getText());
            }
        }
        return offset;
    }

    private final Pair<String, Integer> parseRangeExpression(VimscriptParser.RangeExpressionContext ctx) {
        Pair pair;
        VimscriptParser.RangeExpressionContext rangeExpressionContext = ctx;
        int offset = this.parseRangeOffset(rangeExpressionContext != null ? rangeExpressionContext.rangeOffset() : null);
        if (ctx == null) {
            return new Pair((Object)".", (Object)offset);
        }
        if (ctx.rangeMember() == null) {
            pair = new Pair((Object)".", (Object)offset);
        } else if (ctx.rangeMember().search() == null || ctx.rangeMember().search().isEmpty()) {
            pair = new Pair((Object)ctx.rangeMember().getText(), (Object)offset);
        } else {
            List<VimscriptParser.SearchContext> list = ctx.rangeMember().search();
            Intrinsics.checkNotNullExpressionValue(list, (String)"search(...)");
            String memberString = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\u0000", null, null, (int)0, null, CommandVisitor::parseRangeExpression$lambda$0, (int)30, null);
            pair = new Pair((Object)memberString, (Object)offset);
        }
        return pair;
    }

    private final Address[] parseRangeUnit(VimscriptParser.RangeUnitContext ctx) {
        Pair<String, Integer> valueAndOffset = this.parseRangeExpression(ctx.rangeExpression());
        VimscriptParser.RangeSeparatorContext rangeSeparatorContext = ctx.rangeSeparator();
        boolean move = Intrinsics.areEqual((Object)(rangeSeparatorContext != null ? rangeSeparatorContext.getText() : null), (Object)";");
        Address[] addresses = Address.Companion.createRangeAddresses((String)valueAndOffset.getFirst(), ((Number)valueAndOffset.getSecond()).intValue(), move);
        if (addresses == null) {
            logger.warn("Could not create an address for node " + ctx.getText());
            throw new ExException("Could not create an address " + ctx.getText());
        }
        return addresses;
    }

    private final Range parseRange(VimscriptParser.RangeContext ctx) {
        Range range;
        block3: {
            range = new Range();
            VimscriptParser.RangeContext rangeContext = ctx;
            if ((rangeContext != null ? rangeContext.rangeUnit() : null) == null) break block3;
            List<VimscriptParser.RangeUnitContext> addresses = ctx.rangeUnit();
            for (VimscriptParser.RangeUnitContext unit : addresses) {
                Intrinsics.checkNotNull((Object)((Object)unit));
                range.addAddresses(this.parseRangeUnit(unit));
            }
            Intrinsics.checkNotNull(addresses);
            VimscriptParser.RangeSeparatorContext rangeSeparatorContext = ((VimscriptParser.RangeUnitContext)((Object)CollectionsKt.last(addresses))).rangeSeparator();
            if (Intrinsics.areEqual((Object)(rangeSeparatorContext != null ? rangeSeparatorContext.getText() : null), (Object)",")) {
                Address[] addressArray = Address.Companion.createRangeAddresses(".", 0, false);
                if (addressArray != null) {
                    Address[] it = addressArray;
                    boolean bl = false;
                    range.addAddresses(it);
                }
            }
        }
        return range;
    }

    @Override
    @NotNull
    public Command visitLet1Command(@NotNull VimscriptParser.Let1CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range range = this.parseRange(ctx.range());
        Object object = expressionVisitor.visit((ParseTree)ctx.expr(0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visit(...)");
        Expression variable = (Expression)object;
        String string = ctx.assignmentOperator().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        AssignmentOperator operator = AssignmentOperator.Companion.getByValue(string);
        Object object2 = expressionVisitor.visit((ParseTree)ctx.expr(1));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"visit(...)");
        Expression expression = (Expression)object2;
        LetCommand command = new LetCommand(range, variable, operator, expression, true);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitLet2Command(@NotNull VimscriptParser.Let2CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        LetCommand command = new LetCommand(new Range(), new SimpleExpression(0), AssignmentOperator.ASSIGNMENT, new SimpleExpression(0), false);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitEchoCommand(@NotNull VimscriptParser.EchoCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range range = this.parseRange(ctx.range());
        List expressions = ctx.expr().stream().map(arg_0 -> CommandVisitor.visitEchoCommand$lambda$3(CommandVisitor::visitEchoCommand$lambda$2, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNull(expressions);
        EchoCommand command = new EchoCommand(range, expressions);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitCallCommand(@NotNull VimscriptParser.CallCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range range = this.parseRange(ctx.range());
        Expression functionCall = (Expression)ExpressionVisitor.INSTANCE.visit((ParseTree)ctx.expr());
        Intrinsics.checkNotNull((Object)functionCall);
        CallCommand command = new CallCommand(range, functionCall);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public DelfunctionCommand visitDelfunctionCommand(@NotNull VimscriptParser.DelfunctionCommandContext ctx) {
        Scope scope;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range range = this.parseRange(ctx.range());
        if (ctx.functionScope() != null) {
            String string = ctx.functionScope().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            scope = Scope.Companion.getByValue(string);
        } else {
            scope = null;
        }
        Scope functionScope = scope;
        String functionName = ctx.functionName().getText();
        boolean ignoreIfMissing = ctx.replace != null;
        Intrinsics.checkNotNull((Object)functionName);
        DelfunctionCommand command = new DelfunctionCommand(range, functionScope, functionName, ignoreIfMissing);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitGoToLineCommand(@NotNull VimscriptParser.GoToLineCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range range = null;
        if (ctx.range() != null) {
            range = this.parseRange(ctx.range());
        } else {
            range = new Range();
            String string = ctx.shortRange().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Address[] addressArray = Address.Companion.createRangeAddresses(string, 0, false);
            if (addressArray == null) {
                throw new ExException("Could not create a range");
            }
            range.addAddresses(addressArray);
        }
        GoToLineCommand command = new GoToLineCommand(range);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitCommandWithComment(@NotNull VimscriptParser.CommandWithCommentContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        String commandName = ctx.name.getText();
        Object object = ctx.commandArgumentWithoutBars();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object argument = object;
        Intrinsics.checkNotNull((Object)commandName);
        return this.createCommandByCommandContext(ranges, (String)argument, commandName, ctx);
    }

    @Override
    @NotNull
    public Command visitCommandWithoutComments(@NotNull VimscriptParser.CommandWithoutCommentsContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        String commandName = ctx.name.getText();
        Object object = ctx.commandArgumentWithoutBars();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object argument = object;
        Intrinsics.checkNotNull((Object)commandName);
        return this.createCommandByCommandContext(ranges, (String)argument, commandName, ctx);
    }

    @Override
    @NotNull
    public Command visitCommandWithBars(@NotNull VimscriptParser.CommandWithBarsContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        String commandName = ctx.name.getText();
        Object object = ctx.commandArgumentWithBars();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object argument = object;
        Intrinsics.checkNotNull((Object)commandName);
        return this.createCommandByCommandContext(ranges, (String)argument, commandName, ctx);
    }

    private final Command createCommandByCommandContext(Range range, String argument, String commandName, ParserRuleContext ctx) {
        Command command;
        KClass<? extends Command> kClass = this.getCommandByName(commandName);
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(MapCommand.class))) {
            command = new MapCommand(range, argument, commandName);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(MapClearCommand.class))) {
            command = new MapClearCommand(range, argument, commandName);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UnMapCommand.class))) {
            command = new UnMapCommand(range, argument, commandName);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(GlobalCommand.class))) {
            GlobalCommand globalCommand;
            if (StringsKt.startsWith$default((String)commandName, (String)"v", (boolean)false, (int)2, null)) {
                globalCommand = new GlobalCommand(range, argument, true);
            } else if (StringsKt.startsWith$default((String)argument, (String)"!", (boolean)false, (int)2, null)) {
                String string = argument.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                globalCommand = new GlobalCommand(range, string, true);
            } else {
                globalCommand = new GlobalCommand(range, argument, false);
            }
            command = globalCommand;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(SplitCommand.class))) {
            command = StringsKt.startsWith$default((String)commandName, (String)"v", (boolean)false, (int)2, null) ? new SplitCommand(range, argument, SplitType.VERTICAL) : new SplitCommand(range, argument, SplitType.HORIZONTAL);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(SubstituteCommand.class))) {
            command = new SubstituteCommand(range, argument, commandName);
        } else {
            KFunction kFunction = KClasses.getPrimaryConstructor(this.getCommandByName(commandName));
            Intrinsics.checkNotNull((Object)kFunction);
            Object[] objectArray = new Object[]{range, argument};
            command = (Command)kFunction.call(objectArray);
        }
        Command command2 = command;
        command2.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command2;
    }

    @Override
    @NotNull
    public ShiftLeftCommand visitShiftLeftCommand(@NotNull VimscriptParser.ShiftLeftCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        Object object = ctx.commandArgumentWithoutBars();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object argument = object;
        int length = ctx.lShift().getText().length();
        ShiftLeftCommand command = new ShiftLeftCommand(ranges, (String)argument, length);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public ShiftRightCommand visitShiftRightCommand(@NotNull VimscriptParser.ShiftRightCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        Object object = ctx.commandArgumentWithoutBars();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object argument = object;
        int length = ctx.rShift().getText().length();
        ShiftRightCommand command = new ShiftRightCommand(ranges, (String)argument, length);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public ExecuteCommand visitExecuteCommand(@NotNull VimscriptParser.ExecuteCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        Range ranges = this.parseRange(ctx.range());
        List expressions = ctx.expr().stream().map(arg_0 -> CommandVisitor.visitExecuteCommand$lambda$5(CommandVisitor::visitExecuteCommand$lambda$4, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNull(expressions);
        ExecuteCommand command = new ExecuteCommand(ranges, expressions);
        command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    @Override
    @NotNull
    public Command visitLetCommand(@NotNull VimscriptParser.LetCommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        VimscriptParser vimscriptParser = VimInjectorKt.getInjector().getVimscriptParser();
        String string = ctx.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Command command = vimscriptParser.parseLetCommand(string);
        if (command == null) {
            command = new LetCommand(new Range(), new SimpleExpression(0), AssignmentOperator.ASSIGNMENT, new SimpleExpression(0), false);
        }
        Command command2 = command;
        command2.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Command visitOtherCommand(@NotNull VimscriptParser.OtherCommandContext ctx) {
        KFunction commandConstructor;
        Object object;
        Object v1;
        Object[] objectArray;
        Object argument;
        String name;
        Range range;
        block5: {
            void $this$firstOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
            range = this.parseRange(ctx.range());
            name = ctx.commandName().getText();
            Object object2 = ctx.commandArgumentWithBars();
            if (object2 == null || (object2 = object2.getText()) == null) {
                object2 = "";
            }
            argument = object2;
            Intrinsics.checkNotNull((Object)name);
            Object[] objectArray2 = (Object[])name;
            Object object3 = new Regex("\\P{Alpha}");
            int n = 0;
            String alphabeticPart = (String)object3.split((CharSequence)objectArray2, n).get(0);
            objectArray2 = new String[]{"s", "su", "sub", "subs", "subst", "substi", "substit", "substitu", "substitut", "substitut", "substitute"};
            if (SetsKt.setOf((Object[])objectArray2).contains(alphabeticPart)) {
                SubstituteCommand command = new SubstituteCommand(range, StringsKt.replaceFirst$default((String)name, (String)alphabeticPart, (String)"", (boolean)false, (int)4, null) + (String)argument, alphabeticPart);
                command.setRangeInScript(VisitorHelperKt.getTextRange(ctx));
                return command;
            }
            object3 = this.getCommandByName(name).getConstructors();
            boolean $i$f$filter = false;
            objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KFunction it = (KFunction)element$iv$iv;
                boolean bl = false;
                if (!(it.getParameters().size() == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            objectArray = $this$firstOrNull$iv.iterator();
            while (objectArray.hasNext()) {
                Object element$iv = objectArray.next();
                KFunction it = (KFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)((KParameter)it.getParameters().get(0)).getType(), (Object)KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(Range.class)), null, (boolean)false, null, (int)7, null)) && Intrinsics.areEqual((Object)((KParameter)it.getParameters().get(1)).getType(), (Object)KClassifiers.createType$default((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(String.class)), null, (boolean)false, null, (int)7, null)))) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((object = (commandConstructor = (KFunction)v1)) == null || (object = (Command)object.call(objectArray = new Object[]{range, argument})) == null) {
            object = new UnknownCommand(range, name, (String)argument);
        }
        Object command = object;
        ((Command)command).setRangeInScript(VisitorHelperKt.getTextRange(ctx));
        return command;
    }

    private final KClass<? extends Command> getCommandByName(String commandName) {
        KClass kClass = VimInjectorKt.getInjector().getVimscriptParser().getExCommands().getCommand(commandName);
        if (kClass == null || (kClass = kClass.getKClass()) == null) {
            kClass = Reflection.getOrCreateKotlinClass(UnknownCommand.class);
        }
        return kClass;
    }

    private static final CharSequence parseRangeExpression$lambda$0(VimscriptParser.SearchContext it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Expression visitEchoCommand$lambda$2(VimscriptParser.ExprContext tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        return (Expression)expressionVisitor.visit((ParseTree)tree);
    }

    private static final Expression visitEchoCommand$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Expression)$tmp0.invoke(p0);
    }

    private static final Expression visitExecuteCommand$lambda$4(VimscriptParser.ExprContext tree) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        return (Expression)expressionVisitor.visit((ParseTree)tree);
    }

    private static final Expression visitExecuteCommand$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Expression)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandVisitor.class);
        expressionVisitor = ExpressionVisitor.INSTANCE;
    }
}

