/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.expressions;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDictionary;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimList;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0001H\u00c6\u0003J+\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/expressions/SublistExpression;", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "from", "to", "expression", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;)V", "getFrom", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getTo", "getExpression", "evaluate", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "vim-engine"})
public final class SublistExpression
extends Expression {
    @Nullable
    private final Expression from;
    @Nullable
    private final Expression to;
    @NotNull
    private final Expression expression;

    public SublistExpression(@Nullable Expression from, @Nullable Expression to, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.from = from;
        this.to = to;
        this.expression = expression;
    }

    @Nullable
    public final Expression getFrom() {
        return this.from;
    }

    @Nullable
    public final Expression getTo() {
        return this.to;
    }

    @NotNull
    public final Expression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public VimDataType evaluate(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull VimLContext vimContext) {
        VimDataType vimDataType;
        int toInt;
        Object object;
        int fromInt;
        VimDataType expressionValue;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        VimDataType vimDataType2 = expressionValue = this.expression.evaluate(editor, context, vimContext);
        if (vimDataType2 instanceof VimDictionary) {
            throw new ExException("E719: Cannot slice a Dictionary");
        }
        int arraySize = vimDataType2 instanceof VimList ? ((VimList)expressionValue).getValues().size() : expressionValue.asString().length();
        Object object2 = this.from;
        if (object2 == null || (object2 = ((Expression)object2).evaluate(editor, context, vimContext)) == null || (object2 = ((VimDataType)object2).asString()) == null) {
            object2 = "0";
        }
        if ((fromInt = Integer.parseInt((String)object2)) < 0) {
            fromInt += arraySize;
        }
        if ((object = this.to) == null || (object = ((Expression)object).evaluate(editor, context, vimContext)) == null || (object = ((VimDataType)object).asString()) == null) {
            object = String.valueOf(arraySize - 1);
        }
        if ((toInt = Integer.parseInt((String)object)) < 0) {
            toInt += arraySize;
        }
        if (expressionValue instanceof VimList) {
            vimDataType = fromInt > arraySize ? (VimDataType)new VimList(new ArrayList()) : (fromInt == toInt ? ((VimList)expressionValue).getValues().get(fromInt) : (fromInt <= toInt ? (VimDataType)new VimList(((VimList)expressionValue).getValues().subList(fromInt, toInt + 1)) : (VimDataType)new VimList(new ArrayList())));
        } else {
            VimString vimString;
            if (fromInt > arraySize) {
                vimString = new VimString("");
            } else if (fromInt <= toInt) {
                if (toInt > expressionValue.asString().length() - 1) {
                    String string = expressionValue.asString().substring(fromInt);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    vimString = new VimString(string);
                } else {
                    String string = expressionValue.asString().substring(fromInt, toInt + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    vimString = new VimString(string);
                }
            } else {
                vimString = new VimString("");
            }
            vimDataType = vimString;
        }
        return vimDataType;
    }

    @Nullable
    public final Expression component1() {
        return this.from;
    }

    @Nullable
    public final Expression component2() {
        return this.to;
    }

    @NotNull
    public final Expression component3() {
        return this.expression;
    }

    @NotNull
    public final SublistExpression copy(@Nullable Expression from, @Nullable Expression to, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return new SublistExpression(from, to, expression);
    }

    public static /* synthetic */ SublistExpression copy$default(SublistExpression sublistExpression, Expression expression, Expression expression2, Expression expression3, int n, Object object) {
        if ((n & 1) != 0) {
            expression = sublistExpression.from;
        }
        if ((n & 2) != 0) {
            expression2 = sublistExpression.to;
        }
        if ((n & 4) != 0) {
            expression3 = sublistExpression.expression;
        }
        return sublistExpression.copy(expression, expression2, expression3);
    }

    @NotNull
    public String toString() {
        return "SublistExpression(from=" + this.from + ", to=" + this.to + ", expression=" + this.expression + ")";
    }

    public int hashCode() {
        int result = this.from == null ? 0 : this.from.hashCode();
        result = result * 31 + (this.to == null ? 0 : this.to.hashCode());
        result = result * 31 + this.expression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SublistExpression)) {
            return false;
        }
        SublistExpression sublistExpression = (SublistExpression)other;
        if (!Intrinsics.areEqual((Object)this.from, (Object)sublistExpression.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)sublistExpression.to)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.expression, (Object)sublistExpression.expression);
    }
}

