/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands.mapping;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptParser;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import com.maddyhome.idea.vim.vimscript.model.commands.mapping.CommandInfo;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SimpleExpression;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0003,-.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J'\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "cmd", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "getCmd", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "executeCommand", "", "extractActionId", "parseCommandArguments", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$CommandArguments;", "input", "processBars", "fromString", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "SpecialArgument", "CommandArguments", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMapCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,200:1\n1#2:201\n739#3,9:202\n1863#3,2:211\n38#4:213\n*S KotlinDebug\n*F\n+ 1 MapCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand\n*L\n165#1:202,9\n165#1:211,2\n156#1:213\n*E\n"})
public final class MapCommand
extends Command.SingleExecution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final String cmd;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;
    private static final char CTRL_V = '\u0016';
    @NotNull
    private static final CommandInfo[] COMMAND_INFOS;
    private static final EnumSet<SpecialArgument> UNSUPPORTED_SPECIAL_ARGUMENTS;
    @NotNull
    private static final VimLogger logger;

    public MapCommand(@NotNull Range range, @NotNull String argument, @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        super(range, argument);
        this.range = range;
        this.argument = argument;
        this.cmd = cmd;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @NotNull
    public final String getCmd() {
        return this.cmd;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return this.executeCommand(editor) ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
    }

    private final boolean executeCommand(VimEditor editor) throws ExException {
        MappingOwner mappingOwner;
        CommandInfo commandInfo;
        Object object;
        block11: {
            object = COMMAND_INFOS;
            int n = ((CommandInfo[])object).length;
            for (int i = 0; i < n; ++i) {
                CommandInfo commandInfo2;
                CommandInfo it = commandInfo2 = object[i];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)this.cmd, (String)it.getPrefix(), (boolean)false, (int)2, null)) continue;
                commandInfo = commandInfo2;
                break block11;
            }
            commandInfo = null;
        }
        if (commandInfo == null) {
            return false;
        }
        CommandInfo commandInfo3 = commandInfo;
        Set<MappingMode> modes = commandInfo3.getMappingModes();
        if (((CharSequence)this.argument).length() == 0) {
            return editor != null && VimInjectorKt.getInjector().getKeyGroup().showKeyMappings(modes, editor);
        }
        try {
            CommandArguments commandArguments = this.parseCommandArguments(this.argument);
            if (commandArguments == null) {
                return false;
            }
            object = commandArguments;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
        Object arguments = object;
        Iterator iterator = UNSUPPORTED_SPECIAL_ARGUMENTS.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            SpecialArgument unsupportedArgument = (SpecialArgument)((Object)object.next());
            if (!((CommandArguments)arguments).getSpecialArguments().contains((Object)unsupportedArgument)) continue;
            throw new ExException("Unsupported map argument: " + unsupportedArgument);
        }
        MappingOwner mappingOwner2 = mappingOwner = VimInjectorKt.getInjector().getVimscriptExecutor().getExecutingIdeaVimRcConfiguration() ? (MappingOwner)MappingOwner.IdeaVim.InitScript.INSTANCE : (MappingOwner)MappingOwner.IdeaVim.Other.INSTANCE;
        if (((CommandArguments)arguments).getSpecialArguments().contains((Object)SpecialArgument.EXPR)) {
            VimInjectorKt.getInjector().getStatisticsService().setIfMapExprUsed(true);
            VimInjectorKt.getInjector().getKeyGroup().putKeyMapping(modes, ((CommandArguments)arguments).getFromKeys(), mappingOwner, ((CommandArguments)arguments).getToExpr(), ((CommandArguments)arguments).getSecondArgument(), commandInfo3.isRecursive());
        } else {
            String actionId = this.extractActionId(((CommandArguments)arguments).getSecondArgument());
            if (actionId != null) {
                String newMapping = "<Action>(" + actionId + ")";
                List<KeyStroke> toKeys = VimInjectorKt.getInjector().getParser().parseKeys(newMapping);
                VimInjectorKt.getInjector().getKeyGroup().putKeyMapping(modes, ((CommandArguments)arguments).getFromKeys(), mappingOwner, toKeys, true);
                logger.debug("Replaced " + ((CommandArguments)arguments).getSecondArgument() + " with " + newMapping);
            } else {
                List<KeyStroke> toKeys = VimInjectorKt.getInjector().getParser().parseKeys(((CommandArguments)arguments).getSecondArgument());
                VimInjectorKt.getInjector().getKeyGroup().putKeyMapping(modes, ((CommandArguments)arguments).getFromKeys(), mappingOwner, toKeys, commandInfo3.isRecursive());
            }
        }
        return true;
    }

    private final String extractActionId(String argument) {
        String string;
        String patternStart = "^:+\\s*action\\s+";
        String patternEnd = "\\s*((<CR>)|(<Cr>)|(<cr>)|(<ENTER>)|(<Enter>)|(<enter>)|(<C-M>)|(<C-m>)|(<c-m>)|\n|\r|(\r\n))$";
        CharSequence charSequence = argument;
        if (new Regex(patternStart + "\\w+" + patternEnd).matches(charSequence)) {
            charSequence = argument;
            Regex regex = new Regex(patternStart);
            String string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex(patternEnd);
            string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final CommandArguments parseCommandArguments(String input) {
        CommandArguments commandArguments;
        char c;
        void $this$forEach$iv;
        List list;
        HashSet<SpecialArgument> specialArguments = new HashSet<SpecialArgument>();
        StringBuilder toKeysBuilder = new StringBuilder();
        List<KeyStroke> fromKeys = null;
        String preprocessedInput = this.processBars(input);
        String[] stringArray = new String[]{" "};
        Iterable $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)preprocessedInput, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            Iterator<Object> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String part = (String)element$iv;
            boolean bl = false;
            if (fromKeys != null) {
                toKeysBuilder.append(" ");
                toKeysBuilder.append(part);
                continue;
            }
            SpecialArgument specialArgument = SpecialArgument.Companion.fromString(part);
            if (specialArgument != null) {
                specialArguments.add(specialArgument);
                continue;
            }
            fromKeys = VimInjectorKt.getInjector().getParser().parseKeys(this.processBars(part));
        }
        for (int i = preprocessedInput.length() - 1; -1 < i && (c = preprocessedInput.charAt(i)) == ' '; --i) {
            toKeysBuilder.append(c);
        }
        List<KeyStroke> list2 = fromKeys;
        if (list2 != null) {
            Expression expression;
            List<KeyStroke> it = list2;
            boolean bl = false;
            if (specialArguments.contains((Object)SpecialArgument.EXPR)) {
                VimscriptParser vimscriptParser = VimInjectorKt.getInjector().getVimscriptParser();
                String string = toKeysBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                expression = vimscriptParser.parseExpression(((Object)StringsKt.trim((CharSequence)string)).toString());
                if (expression == null) {
                    String string2 = toKeysBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    throw new ExException("E15: Invalid expression: " + ((Object)StringsKt.trim((CharSequence)string2)).toString());
                }
            } else {
                String string = toKeysBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                expression = new SimpleExpression(((Object)StringsKt.trimStart((CharSequence)string)).toString());
            }
            Expression toExpr = expression;
            Set set = specialArguments;
            String string = toKeysBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            commandArguments = new CommandArguments(set, it, toExpr, ((Object)StringsKt.trimStart((CharSequence)string)).toString());
        } else {
            commandArguments = null;
        }
        return commandArguments;
    }

    private final String processBars(String fromString) {
        return StringsKt.replace$default((String)fromString, (String)"\\|", (String)"|", (boolean)false, (int)4, null);
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final String component3() {
        return this.cmd;
    }

    @NotNull
    public final MapCommand copy(@NotNull Range range, @NotNull String argument, @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        return new MapCommand(range, argument, cmd);
    }

    public static /* synthetic */ MapCommand copy$default(MapCommand mapCommand, Range range, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            range = mapCommand.range;
        }
        if ((n & 2) != 0) {
            string = mapCommand.argument;
        }
        if ((n & 4) != 0) {
            string2 = mapCommand.cmd;
        }
        return mapCommand.copy(range, string, string2);
    }

    @NotNull
    public String toString() {
        return "MapCommand(range=" + this.range + ", argument=" + this.argument + ", cmd=" + this.cmd + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        result = result * 31 + this.cmd.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapCommand)) {
            return false;
        }
        MapCommand mapCommand = (MapCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)mapCommand.range)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.argument, (Object)mapCommand.argument)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cmd, (Object)mapCommand.cmd);
    }

    static {
        CommandInfo[] commandInfoArray = new CommandInfo[]{new CommandInfo("map", "", (Set<? extends MappingMode>)MappingMode.NVO, true), new CommandInfo("nm", "ap", (Set<? extends MappingMode>)MappingMode.N, true), new CommandInfo("vm", "ap", (Set<? extends MappingMode>)MappingMode.Companion.getV(), true), new CommandInfo("xm", "ap", (Set<? extends MappingMode>)MappingMode.Companion.getX(), true), new CommandInfo("om", "ap", (Set<? extends MappingMode>)MappingMode.Companion.getO(), true), new CommandInfo("im", "ap", (Set<? extends MappingMode>)MappingMode.Companion.getI(), true), new CommandInfo("cm", "ap", (Set<? extends MappingMode>)MappingMode.Companion.getC(), true), new CommandInfo("no", "remap", (Set<? extends MappingMode>)MappingMode.NVO, false), new CommandInfo("nn", "oremap", (Set<? extends MappingMode>)MappingMode.N, false), new CommandInfo("vn", "oremap", (Set<? extends MappingMode>)MappingMode.Companion.getV(), false), new CommandInfo("xn", "oremap", (Set<? extends MappingMode>)MappingMode.Companion.getX(), false), new CommandInfo("ono", "remap", (Set<? extends MappingMode>)MappingMode.Companion.getO(), false), new CommandInfo("ino", "remap", (Set<? extends MappingMode>)MappingMode.Companion.getI(), false), new CommandInfo("cno", "remap", (Set<? extends MappingMode>)MappingMode.Companion.getC(), false)};
        COMMAND_INFOS = commandInfoArray;
        UNSUPPORTED_SPECIAL_ARGUMENTS = EnumSet.of((Enum)SpecialArgument.SCRIPT);
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(MapCommand.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$CommandArguments;", "", "specialArguments", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "fromKeys", "", "Ljavax/swing/KeyStroke;", "toExpr", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "secondArgument", "", "<init>", "(Ljava/util/Set;Ljava/util/List;Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;Ljava/lang/String;)V", "getSpecialArguments", "()Ljava/util/Set;", "getFromKeys", "()Ljava/util/List;", "getToExpr", "()Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "getSecondArgument", "()Ljava/lang/String;", "vim-engine"})
    private static final class CommandArguments {
        @NotNull
        private final Set<SpecialArgument> specialArguments;
        @NotNull
        private final List<KeyStroke> fromKeys;
        @NotNull
        private final Expression toExpr;
        @NotNull
        private final String secondArgument;

        public CommandArguments(@NotNull Set<? extends SpecialArgument> specialArguments, @NotNull List<? extends KeyStroke> fromKeys, @NotNull Expression toExpr, @NotNull String secondArgument) {
            Intrinsics.checkNotNullParameter(specialArguments, (String)"specialArguments");
            Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
            Intrinsics.checkNotNullParameter((Object)toExpr, (String)"toExpr");
            Intrinsics.checkNotNullParameter((Object)secondArgument, (String)"secondArgument");
            this.specialArguments = specialArguments;
            this.fromKeys = fromKeys;
            this.toExpr = toExpr;
            this.secondArgument = secondArgument;
        }

        @NotNull
        public final Set<SpecialArgument> getSpecialArguments() {
            return this.specialArguments;
        }

        @NotNull
        public final List<KeyStroke> getFromKeys() {
            return this.fromKeys;
        }

        @NotNull
        public final Expression getToExpr() {
            return this.toExpr;
        }

        @NotNull
        public final String getSecondArgument() {
            return this.secondArgument;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR4\u0010\n\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$Companion;", "", "<init>", "()V", "CTRL_V", "", "COMMAND_INFOS", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/CommandInfo;", "[Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/CommandInfo;", "UNSUPPORTED_SPECIAL_ARGUMENTS", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "kotlin.jvm.PlatformType", "Ljava/util/EnumSet;", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0083\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "", "myName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getMyName", "()Ljava/lang/String;", "BUFFER", "NOWAIT", "SILENT", "SPECIAL", "SCRIPT", "EXPR", "UNIQUE", "toString", "Companion", "vim-engine"})
    @NonNls
    private static final class SpecialArgument
    extends Enum<SpecialArgument> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String myName;
        public static final /* enum */ SpecialArgument BUFFER;
        public static final /* enum */ SpecialArgument NOWAIT;
        public static final /* enum */ SpecialArgument SILENT;
        public static final /* enum */ SpecialArgument SPECIAL;
        public static final /* enum */ SpecialArgument SCRIPT;
        public static final /* enum */ SpecialArgument EXPR;
        public static final /* enum */ SpecialArgument UNIQUE;
        private static final /* synthetic */ SpecialArgument[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SpecialArgument(String myName) {
            this.myName = myName;
        }

        @NotNull
        public final String getMyName() {
            return this.myName;
        }

        @NotNull
        public String toString() {
            return this.myName;
        }

        public static SpecialArgument[] values() {
            return (SpecialArgument[])$VALUES.clone();
        }

        public static SpecialArgument valueOf(String value) {
            return Enum.valueOf(SpecialArgument.class, value);
        }

        @NotNull
        public static EnumEntries<SpecialArgument> getEntries() {
            return $ENTRIES;
        }

        static {
            BUFFER = new SpecialArgument("<buffer>");
            NOWAIT = new SpecialArgument("<nowait>");
            SILENT = new SpecialArgument("<silent>");
            SPECIAL = new SpecialArgument("<special>");
            SCRIPT = new SpecialArgument("<script>");
            EXPR = new SpecialArgument("<expr>");
            UNIQUE = new SpecialArgument("<unique>");
            $VALUES = specialArgumentArray = new SpecialArgument[]{SpecialArgument.BUFFER, SpecialArgument.NOWAIT, SpecialArgument.SILENT, SpecialArgument.SPECIAL, SpecialArgument.SCRIPT, SpecialArgument.EXPR, SpecialArgument.UNIQUE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument$Companion;", "", "<init>", "()V", "fromString", "Lcom/maddyhome/idea/vim/vimscript/model/commands/mapping/MapCommand$SpecialArgument;", "s", "", "vim-engine"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SpecialArgument fromString(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                for (SpecialArgument argument : SpecialArgument.getEntries()) {
                    if (!Intrinsics.areEqual((Object)s, (Object)argument.getMyName())) continue;
                    return argument;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

