/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.SelectionInfo;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VirtualFile;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.InvalidRangeException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.LineRangeKt;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.mark.VimMark;
import com.maddyhome.idea.vim.put.PutData;
import com.maddyhome.idea.vim.put.VimPut;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J \u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002JA\u0010#\u001a\u00020\u00192\u0006\u0010 \u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u001d2\b\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0002J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0005H\u00c6\u0003J\u001d\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u000108H\u00d6\u0003J\t\u00109\u001a\u00020\u001dH\u00d6\u0001J\t\u0010:\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006;"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "shiftGlobalMark", "", "markAndLine", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/mark/Mark;", "", "shift", "shiftLocalMark", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "mark", "shiftSelectionInfo", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "startOffset", "endOffset", "selectionInfo", "Lcom/maddyhome/idea/vim/api/SelectionInfo;", "Lcom/maddyhome/idea/vim/common/TextRange;", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;Ljava/lang/Integer;Ljava/lang/Integer;Lcom/maddyhome/idea/vim/api/SelectionInfo;ILcom/maddyhome/idea/vim/common/TextRange;)V", "shiftBufferPosition", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "bufferPosition", "normalizeAddress", "address0", "lineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMoveTextCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n774#2:166\n865#2,2:167\n774#2:169\n865#2,2:170\n774#2:172\n865#2,2:173\n1557#2:175\n1628#2,3:176\n1863#2,2:180\n1863#2,2:182\n1#3:179\n*S KotlinDebug\n*F\n+ 1 MoveTextCommand.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/MoveTextCommand\n*L\n72#1:166\n72#1:167,2\n73#1:169\n73#1:170,2\n76#1:172\n76#1:173,2\n77#1:175\n77#1:176,3\n104#1:180,2\n105#1:182,2\n*E\n"})
public final class MoveTextCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public MoveTextCommand(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, argument);
        this.range = range;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_REQUIRED, Command.Access.WRITABLE, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) throws ExException {
        Object it;
        PutData putData;
        Integer n;
        Integer n2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Mark it2;
        Iterable $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        int caretCount = editor.nativeCarets().size();
        if (caretCount > 1) {
            throw new ExException("Move command supported only for one caret at the moment");
        }
        VimCaret caret = editor.primaryCaret();
        BufferPosition caretPosition = caret.getBufferPosition();
        LineRange lineRange = this.getLineRange(editor, caret);
        TextRange range = LineRangeKt.toTextRange(lineRange, editor);
        int address1 = this.getAddressFromArgument(editor);
        int line = Math.min((int)editor.fileSize(), this.normalizeAddress(address1 - 1, lineRange));
        int linesMoved = lineRange.getSize();
        if (line < -1 || line + linesMoved >= editor.lineCount()) {
            throw ExExceptionsKt.exExceptionMessage("e_invrange", new Object[0]);
        }
        int shift = line - editor.offsetToBufferPosition(range.getStartOffset()).getLine() + 1;
        Iterable iterable = VimInjectorKt.getInjector().getMarkService().getAllLocalMarks(caret);
        boolean $i$f$filter = false;
        void var16_16 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!range.contains(it2.offset(editor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!(it2.getKey() != '<' && it2.getKey() != '>')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set localMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$filter2 = VimInjectorKt.getInjector().getMarkService().getGlobalMarks(editor);
        boolean $i$f$filter3 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mark it3 = (Mark)element$iv$iv;
            boolean bl = false;
            if (!range.contains(it3.offset(editor))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Mark it3 = (Mark)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new Pair((Object)it3, (Object)it3.getLine()));
        }
        Set globalMarks = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        SelectionInfo lastSelectionInfo = caret.getLastSelectionInfo();
        BufferPosition bufferPosition = lastSelectionInfo.getStart();
        if (bufferPosition != null) {
            BufferPosition it4 = bufferPosition;
            boolean bl = false;
            n2 = editor.bufferPositionToOffset(it4);
        } else {
            n2 = null;
        }
        Integer selectionStartOffset = n2;
        BufferPosition bufferPosition2 = lastSelectionInfo.getEnd();
        if (bufferPosition2 != null) {
            BufferPosition it5 = bufferPosition2;
            boolean bl = false;
            n = editor.bufferPositionToOffset(it5);
        } else {
            n = null;
        }
        Integer selectionEndOffset = n;
        String text = EngineEditorHelperKt.getText(editor, range);
        PutData.TextData textData = new PutData.TextData(text, SelectionType.LINE_WISE, CollectionsKt.emptyList(), null);
        boolean dropNewLineInEnd = line + linesMoved == editor.lineCount() - 1 && StringsKt.last((CharSequence)text) == '\n' || lineRange.endLine == editor.lineCount() - 1;
        editor.deleteString(range);
        if (line == -1) {
            caret.moveToOffset(0);
            putData = new PutData(textData, null, 1, true, true, false, 0, 64, null);
        } else {
            putData = new PutData(textData, null, 1, false, true, false, line);
        }
        PutData putData2 = putData;
        VimPut.putTextForCaret$default(VimInjectorKt.getInjector().getPut(), editor, caret, context, putData2, false, false, 48, null);
        if (dropNewLineInEnd) {
            boolean it6;
            boolean bl = it6 = StringsKt.last((CharSequence)editor.text()) == '\n';
            if (_Assertions.ENABLED && !it6) {
                String bl2 = "Assertion failed";
                throw new AssertionError((Object)bl2);
            }
            editor.deleteString(new TextRange(editor.text().length() - 1, editor.text().length()));
        }
        Iterable $this$forEach$iv = globalMarks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl = false;
            this.shiftGlobalMark(editor, (Pair<? extends Mark, Integer>)it, shift);
        }
        $this$forEach$iv = localMarks;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Mark)element$iv;
            boolean bl = false;
            this.shiftLocalMark(caret, (Mark)it, shift);
        }
        this.shiftSelectionInfo(caret, selectionStartOffset, selectionEndOffset, lastSelectionInfo, shift, range);
        BufferPosition newCaretPosition = this.shiftBufferPosition(caretPosition, shift);
        caret.moveToBufferPosition(newCaretPosition);
        return ExecutionResult.Success.INSTANCE;
    }

    private final void shiftGlobalMark(VimEditor editor, Pair<? extends Mark, Integer> markAndLine, int shift) {
        int newOffset = editor.bufferPositionToOffset(new BufferPosition(((Number)markAndLine.getSecond()).intValue() + shift, ((Mark)markAndLine.getFirst()).getCol(), false, 4, null));
        VimInjectorKt.getInjector().getMarkService().setGlobalMark(editor, ((Mark)markAndLine.getFirst()).getKey(), newOffset);
    }

    private final void shiftLocalMark(VimCaret caret, Mark mark, int shift) {
        VirtualFile virtualFile = caret.getEditor().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        String path = virtualFile2.getPath();
        String protocol = virtualFile2.getProtocol();
        VimMark mark2 = new VimMark(mark.getKey(), mark.getLine() + shift, mark.getCol(), path, protocol);
        VimInjectorKt.getInjector().getMarkService().setMark(caret, mark2);
    }

    private final void shiftSelectionInfo(ImmutableVimCaret caret, Integer startOffset, Integer endOffset, SelectionInfo selectionInfo, int shift, TextRange range) {
        BufferPosition newStartPosition = selectionInfo.getStart();
        if (startOffset != null && selectionInfo.getStart() != null && range.contains(startOffset)) {
            BufferPosition bufferPosition = selectionInfo.getStart();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newStartPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        BufferPosition newEndPosition = selectionInfo.getEnd();
        if (endOffset != null && selectionInfo.getEnd() != null && range.contains(endOffset)) {
            BufferPosition bufferPosition = selectionInfo.getEnd();
            Intrinsics.checkNotNull((Object)bufferPosition);
            newEndPosition = this.shiftBufferPosition(bufferPosition, shift);
        }
        if (!Intrinsics.areEqual((Object)newStartPosition, (Object)selectionInfo.getStart()) || !Intrinsics.areEqual((Object)newEndPosition, (Object)selectionInfo.getEnd())) {
            caret.setLastSelectionInfo(new SelectionInfo(newStartPosition, newEndPosition, selectionInfo.getSelectionType()));
        }
    }

    private final BufferPosition shiftBufferPosition(BufferPosition bufferPosition, int shift) {
        return new BufferPosition(bufferPosition.getLine() + shift, bufferPosition.getColumn(), bufferPosition.getLeansForward());
    }

    private final int normalizeAddress(int address0, LineRange lineRange) {
        if (address0 >= lineRange.endLine) {
            return address0 - lineRange.getSize();
        }
        if (address0 >= lineRange.startLine) {
            throw new InvalidRangeException(VimInjectorKt.getInjector().getMessages().message("e_backrange", new Object[0]));
        }
        return address0;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final MoveTextCommand copy(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new MoveTextCommand(range, argument);
    }

    public static /* synthetic */ MoveTextCommand copy$default(MoveTextCommand moveTextCommand, Range range, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = moveTextCommand.range;
        }
        if ((n & 2) != 0) {
            string = moveTextCommand.argument;
        }
        return moveTextCommand.copy(range, string);
    }

    @NotNull
    public String toString() {
        return "MoveTextCommand(range=" + this.range + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoveTextCommand)) {
            return false;
        }
        MoveTextCommand moveTextCommand = (MoveTextCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)moveTextCommand.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)moveTextCommand.argument);
    }
}

