/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/FindFileCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "getRange", "()Lcom/maddyhome/idea/vim/ex/ranges/Range;", "getArgument", "()Ljava/lang/String;", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "vim-engine"})
public final class FindFileCommand
extends Command.SingleExecution {
    @NotNull
    private final Range range;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public FindFileCommand(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(range, argument);
        this.range = range;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_FORBIDDEN, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.READ_ONLY, new Command.Flag[0]);
    }

    @NotNull
    public final Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    protected Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        String arg = this.argument;
        if (((CharSequence)arg).length() > 0) {
            boolean res = VimInjectorKt.getInjector().getFile().openFile(arg, context);
            if (res) {
                VimInjectorKt.getInjector().getJumpService().saveJumpLocation(editor);
            }
            return res ? (ExecutionResult)ExecutionResult.Success.INSTANCE : (ExecutionResult)ExecutionResult.Error.INSTANCE;
        }
        VimInjectorKt.getInjector().getApplication().invokeLater((Function0<Unit>)((Function0)() -> FindFileCommand.processCommand$lambda$0(editor, context)));
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final FindFileCommand copy(@NotNull Range range, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new FindFileCommand(range, argument);
    }

    public static /* synthetic */ FindFileCommand copy$default(FindFileCommand findFileCommand, Range range, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = findFileCommand.range;
        }
        if ((n & 2) != 0) {
            string = findFileCommand.argument;
        }
        return findFileCommand.copy(range, string);
    }

    @NotNull
    public String toString() {
        return "FindFileCommand(range=" + this.range + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FindFileCommand)) {
            return false;
        }
        FindFileCommand findFileCommand = (FindFileCommand)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)findFileCommand.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)findFileCommand.argument);
    }

    private static final Unit processCommand$lambda$0(VimEditor $editor, ExecutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        VimInjectorKt.getInjector().getActionExecutor().executeAction($editor, "GotoFile", $context);
        return Unit.INSTANCE;
    }
}

