/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.ex.MissingRangeException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Range;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007JKLMNOPB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J \u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020,H\u0002J9\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020706\"\u000207H\u0004\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020,2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010:\u001a\u00020\u0005H\u0002J\b\u0010;\u001a\u00020<H\u0004J\u0018\u0010=\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0004J\u000f\u0010@\u001a\u0004\u0018\u00010\u001fH\u0004\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020CH\u0004J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0004J\u0010\u0010E\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0004J\u0018\u0010E\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0004J\u0010\u0010F\u001a\u00020G2\u0006\u0010$\u001a\u00020%H\u0004J\u0018\u0010F\u001a\u00020G2\u0006\u0010$\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0004J\u0010\u0010H\u001a\u0004\u0018\u00010G2\u0006\u0010$\u001a\u00020%J\u0018\u0010I\u001a\u00020G2\u0006\u0010$\u001a\u00020%2\u0006\u0010>\u001a\u00020?H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002QR\u00a8\u0006S"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "Lcom/maddyhome/idea/vim/vimscript/model/Executable;", "commandRange", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "commandArgument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "getCommandArgument", "()Ljava/lang/String;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getVimContext", "()Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "setVimContext", "(Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)V", "rangeInScript", "Lcom/maddyhome/idea/vim/common/TextRange;", "getRangeInScript", "()Lcom/maddyhome/idea/vim/common/TextRange;", "setRangeInScript", "(Lcom/maddyhome/idea/vim/common/TextRange;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "defaultRange", "getDefaultRange", "setDefaultRange", "(Ljava/lang/String;)V", "nextArgumentTokenOffset", "", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "execute", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "runCommand", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "validate", "", "checkRanges", "checkArgument", "flags", "rangeFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "argumentFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "access", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "(Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;[Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;)Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "setNextArgumentTokenOffset", "getNextArgumentToken", "isRangeSpecified", "", "getCountFromRange", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "getCountFromArgument", "()Ljava/lang/Integer;", "consumeRegisterFromArgument", "", "getAddressFromArgument", "getLine", "getLineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "getLineRangeSafe", "getLineRangeWithCount", "ForEachCaret", "SingleExecution", "RangeFlag", "ArgumentFlag", "Access", "Flag", "CommandHandlerFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/Command\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n38#2:363\n1863#3,2:364\n*S KotlinDebug\n*F\n+ 1 Command.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/Command\n*L\n42#1:363\n80#1:364,2\n*E\n"})
public abstract class Command
implements Executable {
    @NotNull
    private final Range commandRange;
    @NotNull
    private final String commandArgument;
    public VimLContext vimContext;
    public TextRange rangeInScript;
    @NotNull
    private String defaultRange;
    private int nextArgumentTokenOffset;
    @NotNull
    private final VimLogger logger;

    private Command(Range commandRange, String commandArgument) {
        this.commandRange = commandRange;
        this.commandArgument = commandArgument;
        this.defaultRange = ".";
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(Command.class);
    }

    @NotNull
    public final String getCommandArgument() {
        return this.commandArgument;
    }

    @Override
    @NotNull
    public VimLContext getVimContext() {
        VimLContext vimLContext = this.vimContext;
        if (vimLContext != null) {
            return vimLContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vimContext");
        return null;
    }

    @Override
    public void setVimContext(@NotNull VimLContext vimLContext) {
        Intrinsics.checkNotNullParameter((Object)vimLContext, (String)"<set-?>");
        this.vimContext = vimLContext;
    }

    @Override
    @NotNull
    public TextRange getRangeInScript() {
        TextRange textRange = this.rangeInScript;
        if (textRange != null) {
            return textRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rangeInScript");
        return null;
    }

    @Override
    public void setRangeInScript(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.rangeInScript = textRange;
    }

    @NotNull
    protected abstract CommandHandlerFlags getArgFlags();

    @NotNull
    protected final String getDefaultRange() {
        return this.defaultRange;
    }

    protected final void setDefaultRange(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultRange = string;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull VimEditor editor, @NotNull ExecutionContext context) throws ExException {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.validate(editor);
        StrictMode.INSTANCE.assertTrue(EditorExtensionsKt.getInNormalMode(editor), "Command execution should only occur in normal mode");
        if (!this.getArgFlags().getFlags().contains((Object)Flag.SAVE_VISUAL)) {
            if (editor.primaryCaret().hasSelection() && ModeExtensionsKt.isBlock(editor.primaryCaret().getLastSelectionInfo().getSelectionType())) {
                editor.removeSecondaryCarets();
            }
            Iterable $this$forEach$iv = editor.nativeCarets();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VimCaret it = (VimCaret)element$iv;
                boolean bl = false;
                if (!it.hasSelection()) continue;
                int offset = it.getSelectionStart();
                it.removeSelection();
                it.moveToOffset(offset);
            }
        }
        if (this.getArgFlags().getAccess() == Access.WRITABLE && !editor.isDocumentWritable()) {
            this.logger.info("Trying to modify readonly document");
            return ExecutionResult.Error.INSTANCE;
        }
        KeyHandler keyHandler = KeyHandler.Companion.getInstance();
        KeyHandlerState keyState = keyHandler.getKeyHandlerState();
        OperatorArguments operatorArguments = new OperatorArguments(keyHandler.isOperatorPending(editor.getMode(), keyState), 0, editor.getMode());
        Function0 runCommand = () -> Command.execute$lambda$1(this, editor, context, operatorArguments);
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getArgFlags().getAccess().ordinal()]) {
            case 1 -> (ExecutionResult)VimInjectorKt.getInjector().getApplication().runWriteAction(runCommand);
            case 2 -> (ExecutionResult)VimInjectorKt.getInjector().getApplication().runReadAction(runCommand);
            case 3 -> (ExecutionResult)runCommand.invoke();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ExecutionResult runCommand(VimEditor editor, ExecutionContext context, OperatorArguments operatorArguments) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = ExecutionResult.Success.INSTANCE;
        Command command = this;
        if (command instanceof ForEachCaret) {
            editor.forEachNativeCaret((Function1<? super VimCaret, Unit>)((Function1)arg_0 -> Command.runCommand$lambda$2(result, this, editor, context, operatorArguments, arg_0)), true);
        } else if (command instanceof SingleExecution) {
            result.element = ((SingleExecution)this).processCommand(editor, context, operatorArguments);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (ExecutionResult)result.element;
    }

    private final void validate(VimEditor editor) {
        this.checkRanges(editor);
        this.checkArgument();
    }

    private final void checkRanges(VimEditor editor) {
        if (RangeFlag.RANGE_FORBIDDEN == this.getArgFlags().getRangeFlag() && this.commandRange.size() != 0) {
            throw ExExceptionsKt.exExceptionMessage("E481", new Object[0]);
        }
        if (RangeFlag.RANGE_REQUIRED == this.getArgFlags().getRangeFlag() && this.commandRange.size() == 0) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("e_rangereq", new Object[0]));
            throw new MissingRangeException();
        }
        if (RangeFlag.RANGE_IS_COUNT == this.getArgFlags().getRangeFlag()) {
            this.commandRange.setDefaultRange("1");
        } else {
            this.commandRange.setDefaultRange(this.defaultRange);
        }
    }

    private final void checkArgument() {
        if (ArgumentFlag.ARGUMENT_FORBIDDEN == this.getArgFlags().getArgumentFlag() && !StringsKt.isBlank((CharSequence)this.commandArgument)) {
            Object[] objectArray = new Object[]{this.commandArgument};
            throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
        }
        if (ArgumentFlag.ARGUMENT_REQUIRED == this.getArgFlags().getArgumentFlag() && StringsKt.isBlank((CharSequence)this.commandArgument)) {
            throw ExExceptionsKt.exExceptionMessage("E471", new Object[0]);
        }
    }

    @NotNull
    protected final CommandHandlerFlags flags(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, Flag ... flags) {
        Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
        Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        return new CommandHandlerFlags(rangeFlag, argumentFlag, access, ArraysKt.toSet((Object[])flags));
    }

    private final void setNextArgumentTokenOffset(int nextArgumentTokenOffset) {
        this.nextArgumentTokenOffset = nextArgumentTokenOffset;
    }

    private final String getNextArgumentToken() {
        String string = this.commandArgument.substring(this.nextArgumentTokenOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return ((Object)StringsKt.trimStart((CharSequence)string)).toString();
    }

    protected final boolean isRangeSpecified() {
        return this.commandRange.size() > 0;
    }

    protected final int getCountFromRange(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRange.getCount(editor, caret);
    }

    @Nullable
    protected final Integer getCountFromArgument() {
        Integer n;
        MatchResult matchResult = new Regex("(?<count>\\d+)\\s*(?<trailing>.*)?(\".*)?").matchEntire((CharSequence)this.getNextArgumentToken());
        if (matchResult != null) {
            Object object;
            MatchResult match = matchResult;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"trailing");
            if (matchGroup != null) {
                MatchGroup trailing = matchGroup;
                boolean bl2 = false;
                if (((CharSequence)trailing.getValue()).length() > 0) {
                    Object[] objectArray = new Object[]{trailing.getValue()};
                    throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
                }
            }
            n = (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"count")) != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
        } else {
            n = null;
        }
        return n;
    }

    protected final char consumeRegisterFromArgument() {
        char c;
        String argument = this.getNextArgumentToken();
        if (((CharSequence)argument).length() > 0 && !Character.isDigit(argument.charAt(0))) {
            if (!VimInjectorKt.getInjector().getRegisterGroup().isValid(argument.charAt(0)) || !VimInjectorKt.getInjector().getRegisterGroup().isRegisterWritable(argument.charAt(0))) {
                Object[] objectArray = new Object[]{argument};
                throw ExExceptionsKt.exExceptionMessage("E488", objectArray);
            }
            this.setNextArgumentTokenOffset(1);
            c = argument.charAt(0);
        } else {
            c = VimInjectorKt.getInjector().getRegisterGroup().getDefaultRegister();
        }
        return c;
    }

    protected final int getAddressFromArgument(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = VimInjectorKt.getInjector().getVimscriptParser().parseCommand(this.getNextArgumentToken());
        if (object == null || (object = ((Command)object).getLineRange(editor)) == null) {
            throw ExExceptionsKt.exExceptionMessage("e_invrange", new Object[0]);
        }
        return ((LineRange)object).getStartLine1();
    }

    protected final int getLine(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getLine(editor, editor.currentCaret());
    }

    protected final int getLine(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRange.getLine(editor, caret);
    }

    @NotNull
    protected final LineRange getLineRange(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getLineRange(editor, editor.currentCaret());
    }

    @NotNull
    protected final LineRange getLineRange(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRange.getLineRange(editor, caret);
    }

    @Nullable
    public final LineRange getLineRangeSafe(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            this.validate(editor);
        }
        catch (Throwable t) {
            return null;
        }
        return this.getLineRange(editor);
    }

    @NotNull
    protected final LineRange getLineRangeWithCount(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        LineRange lineRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        LineRange lineRange2 = this.getLineRange(editor, caret);
        Integer n = this.getCountFromArgument();
        if (n != null) {
            int count = ((Number)n).intValue();
            boolean bl = false;
            lineRange = new LineRange(lineRange2.endLine, lineRange2.endLine + count - 1);
        } else {
            lineRange = lineRange2;
        }
        return lineRange;
    }

    private static final ExecutionResult execute$lambda$1(Command this$0, VimEditor $editor, ExecutionContext $context, OperatorArguments $operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$operatorArguments, (String)"$operatorArguments");
        return this$0.runCommand($editor, $context, $operatorArguments);
    }

    private static final Unit runCommand$lambda$2(Ref.ObjectRef $result, Command this$0, VimEditor $editor, ExecutionContext $context, OperatorArguments $operatorArguments, VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$operatorArguments, (String)"$operatorArguments");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if ($result.element instanceof ExecutionResult.Success) {
            $result.element = ((ForEachCaret)this$0).processCommand($editor, caret, $context, $operatorArguments);
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ Command(Range commandRange, String commandArgument, DefaultConstructorMarker $constructor_marker) {
        this(commandRange, commandArgument);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "", "<init>", "(Ljava/lang/String;I)V", "WRITABLE", "READ_ONLY", "SELF_SYNCHRONIZED", "vim-engine"})
    public static final class Access
    extends Enum<Access> {
        public static final /* enum */ Access WRITABLE = new Access();
        public static final /* enum */ Access READ_ONLY = new Access();
        public static final /* enum */ Access SELF_SYNCHRONIZED = new Access();
        private static final /* synthetic */ Access[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Access[] values() {
            return (Access[])$VALUES.clone();
        }

        public static Access valueOf(String value) {
            return Enum.valueOf(Access.class, value);
        }

        @NotNull
        public static EnumEntries<Access> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accessArray = new Access[]{Access.WRITABLE, Access.READ_ONLY, Access.SELF_SYNCHRONIZED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "", "<init>", "(Ljava/lang/String;I)V", "ARGUMENT_REQUIRED", "ARGUMENT_OPTIONAL", "ARGUMENT_FORBIDDEN", "vim-engine"})
    public static final class ArgumentFlag
    extends Enum<ArgumentFlag> {
        public static final /* enum */ ArgumentFlag ARGUMENT_REQUIRED = new ArgumentFlag();
        public static final /* enum */ ArgumentFlag ARGUMENT_OPTIONAL = new ArgumentFlag();
        public static final /* enum */ ArgumentFlag ARGUMENT_FORBIDDEN = new ArgumentFlag();
        private static final /* synthetic */ ArgumentFlag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ArgumentFlag[] values() {
            return (ArgumentFlag[])$VALUES.clone();
        }

        public static ArgumentFlag valueOf(String value) {
            return Enum.valueOf(ArgumentFlag.class, value);
        }

        @NotNull
        public static EnumEntries<ArgumentFlag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = argumentFlagArray = new ArgumentFlag[]{ArgumentFlag.ARGUMENT_REQUIRED, ArgumentFlag.ARGUMENT_OPTIONAL, ArgumentFlag.ARGUMENT_FORBIDDEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "", "rangeFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "argumentFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "access", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "flags", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "<init>", "(Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;Ljava/util/Set;)V", "getRangeFlag", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "getArgumentFlag", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "getAccess", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "getFlags", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vim-engine"})
    public static final class CommandHandlerFlags {
        @NotNull
        private final RangeFlag rangeFlag;
        @NotNull
        private final ArgumentFlag argumentFlag;
        @NotNull
        private final Access access;
        @NotNull
        private final Set<Flag> flags;

        public CommandHandlerFlags(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, @NotNull Set<? extends Flag> flags) {
            Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            Intrinsics.checkNotNullParameter(flags, (String)"flags");
            this.rangeFlag = rangeFlag;
            this.argumentFlag = argumentFlag;
            this.access = access;
            this.flags = flags;
        }

        @NotNull
        public final RangeFlag getRangeFlag() {
            return this.rangeFlag;
        }

        @NotNull
        public final ArgumentFlag getArgumentFlag() {
            return this.argumentFlag;
        }

        @NotNull
        public final Access getAccess() {
            return this.access;
        }

        @NotNull
        public final Set<Flag> getFlags() {
            return this.flags;
        }

        @NotNull
        public final RangeFlag component1() {
            return this.rangeFlag;
        }

        @NotNull
        public final ArgumentFlag component2() {
            return this.argumentFlag;
        }

        @NotNull
        public final Access component3() {
            return this.access;
        }

        @NotNull
        public final Set<Flag> component4() {
            return this.flags;
        }

        @NotNull
        public final CommandHandlerFlags copy(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, @NotNull Set<? extends Flag> flags) {
            Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            Intrinsics.checkNotNullParameter(flags, (String)"flags");
            return new CommandHandlerFlags(rangeFlag, argumentFlag, access, flags);
        }

        public static /* synthetic */ CommandHandlerFlags copy$default(CommandHandlerFlags commandHandlerFlags, RangeFlag rangeFlag, ArgumentFlag argumentFlag, Access access, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                rangeFlag = commandHandlerFlags.rangeFlag;
            }
            if ((n & 2) != 0) {
                argumentFlag = commandHandlerFlags.argumentFlag;
            }
            if ((n & 4) != 0) {
                access = commandHandlerFlags.access;
            }
            if ((n & 8) != 0) {
                set = commandHandlerFlags.flags;
            }
            return commandHandlerFlags.copy(rangeFlag, argumentFlag, access, set);
        }

        @NotNull
        public String toString() {
            return "CommandHandlerFlags(rangeFlag=" + this.rangeFlag + ", argumentFlag=" + this.argumentFlag + ", access=" + this.access + ", flags=" + this.flags + ")";
        }

        public int hashCode() {
            int result = this.rangeFlag.hashCode();
            result = result * 31 + this.argumentFlag.hashCode();
            result = result * 31 + this.access.hashCode();
            result = result * 31 + ((Object)this.flags).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandHandlerFlags)) {
                return false;
            }
            CommandHandlerFlags commandHandlerFlags = (CommandHandlerFlags)other;
            if (this.rangeFlag != commandHandlerFlags.rangeFlag) {
                return false;
            }
            if (this.argumentFlag != commandHandlerFlags.argumentFlag) {
                return false;
            }
            if (this.access != commandHandlerFlags.access) {
                return false;
            }
            return Intrinsics.areEqual(this.flags, commandHandlerFlags.flags);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "", "<init>", "(Ljava/lang/String;I)V", "SAVE_VISUAL", "vim-engine"})
    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag SAVE_VISUAL = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String value) {
            return Enum.valueOf(Flag.class, value);
        }

        @NotNull
        public static EnumEntries<Flag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = flagArray = new Flag[]{Flag.SAVE_VISUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class ForEachCaret
    extends Command {
        public ForEachCaret(@NotNull Range range, @NotNull String argument) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            super(range, argument, null);
        }

        public /* synthetic */ ForEachCaret(Range range, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(range, string);
        }

        @NotNull
        public abstract ExecutionResult processCommand(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull OperatorArguments var4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "", "<init>", "(Ljava/lang/String;I)V", "RANGE_REQUIRED", "RANGE_OPTIONAL", "RANGE_FORBIDDEN", "RANGE_IS_COUNT", "vim-engine"})
    public static final class RangeFlag
    extends Enum<RangeFlag> {
        public static final /* enum */ RangeFlag RANGE_REQUIRED = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_OPTIONAL = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_FORBIDDEN = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_IS_COUNT = new RangeFlag();
        private static final /* synthetic */ RangeFlag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RangeFlag[] values() {
            return (RangeFlag[])$VALUES.clone();
        }

        public static RangeFlag valueOf(String value) {
            return Enum.valueOf(RangeFlag.class, value);
        }

        @NotNull
        public static EnumEntries<RangeFlag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rangeFlagArray = new RangeFlag[]{RangeFlag.RANGE_REQUIRED, RangeFlag.RANGE_OPTIONAL, RangeFlag.RANGE_FORBIDDEN, RangeFlag.RANGE_IS_COUNT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/Range;", "argument", "", "<init>", "(Lcom/maddyhome/idea/vim/ex/ranges/Range;Ljava/lang/String;)V", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class SingleExecution
    extends Command {
        public SingleExecution(@NotNull Range range, @NotNull String argument) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            super(range, argument, null);
        }

        public /* synthetic */ SingleExecution(Range range, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(range, string);
        }

        @NotNull
        public abstract ExecutionResult processCommand(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull OperatorArguments var3);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Access.values().length];
            try {
                nArray[Access.WRITABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Access.READ_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Access.SELF_SYNCHRONIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

