/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.state;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.MappingMode;
import com.maddyhome.idea.vim.command.MappingState;
import com.maddyhome.idea.vim.common.DigraphSequence;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.impl.state.VimStateMachineImplKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J3\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0011\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006-"}, d2={"Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "", "mappingState", "Lcom/maddyhome/idea/vim/command/MappingState;", "digraphSequence", "Lcom/maddyhome/idea/vim/common/DigraphSequence;", "editorCommandBuilder", "Lcom/maddyhome/idea/vim/command/CommandBuilder;", "commandLineCommandBuilder", "<init>", "(Lcom/maddyhome/idea/vim/command/MappingState;Lcom/maddyhome/idea/vim/common/DigraphSequence;Lcom/maddyhome/idea/vim/command/CommandBuilder;Lcom/maddyhome/idea/vim/command/CommandBuilder;)V", "()V", "getMappingState", "()Lcom/maddyhome/idea/vim/command/MappingState;", "getDigraphSequence", "()Lcom/maddyhome/idea/vim/common/DigraphSequence;", "getEditorCommandBuilder", "()Lcom/maddyhome/idea/vim/command/CommandBuilder;", "getCommandLineCommandBuilder", "setCommandLineCommandBuilder", "(Lcom/maddyhome/idea/vim/command/CommandBuilder;)V", "commandBuilder", "getCommandBuilder", "enterCommandLine", "", "leaveCommandLine", "partialReset", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "reset", "clone", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeyHandlerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyHandlerState.kt\ncom/maddyhome/idea/vim/state/KeyHandlerState\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,91:1\n38#2:92\n*S KotlinDebug\n*F\n+ 1 KeyHandlerState.kt\ncom/maddyhome/idea/vim/state/KeyHandlerState\n*L\n29#1:92\n*E\n"})
public final class KeyHandlerState
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MappingState mappingState;
    @NotNull
    private final DigraphSequence digraphSequence;
    @NotNull
    private final CommandBuilder editorCommandBuilder;
    @Nullable
    private CommandBuilder commandLineCommandBuilder;
    @NotNull
    private static final VimLogger logger;

    public KeyHandlerState(@NotNull MappingState mappingState, @NotNull DigraphSequence digraphSequence, @NotNull CommandBuilder editorCommandBuilder, @Nullable CommandBuilder commandLineCommandBuilder) {
        Intrinsics.checkNotNullParameter((Object)mappingState, (String)"mappingState");
        Intrinsics.checkNotNullParameter((Object)digraphSequence, (String)"digraphSequence");
        Intrinsics.checkNotNullParameter((Object)editorCommandBuilder, (String)"editorCommandBuilder");
        this.mappingState = mappingState;
        this.digraphSequence = digraphSequence;
        this.editorCommandBuilder = editorCommandBuilder;
        this.commandLineCommandBuilder = commandLineCommandBuilder;
    }

    @NotNull
    public final MappingState getMappingState() {
        return this.mappingState;
    }

    @NotNull
    public final DigraphSequence getDigraphSequence() {
        return this.digraphSequence;
    }

    @NotNull
    public final CommandBuilder getEditorCommandBuilder() {
        return this.editorCommandBuilder;
    }

    @Nullable
    public final CommandBuilder getCommandLineCommandBuilder() {
        return this.commandLineCommandBuilder;
    }

    public final void setCommandLineCommandBuilder(@Nullable CommandBuilder commandBuilder) {
        this.commandLineCommandBuilder = commandBuilder;
    }

    public KeyHandlerState() {
        this(new MappingState(), new DigraphSequence(), new CommandBuilder(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(MappingMode.NORMAL), 0, 2, null), null);
    }

    @NotNull
    public final CommandBuilder getCommandBuilder() {
        CommandBuilder commandBuilder = this.commandLineCommandBuilder;
        if (commandBuilder == null) {
            commandBuilder = this.editorCommandBuilder;
        }
        return commandBuilder;
    }

    public final void enterCommandLine() {
        this.commandLineCommandBuilder = new CommandBuilder(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(MappingMode.CMD_LINE), this.editorCommandBuilder.getCount());
    }

    public final void leaveCommandLine() {
        this.commandLineCommandBuilder = null;
    }

    public final void partialReset(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        logger.trace("entered partialReset. mode: " + mode);
        this.mappingState.resetMappingSequence();
        this.getCommandBuilder().resetInProgressCommandPart(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(VimStateMachineImplKt.toMappingMode(mode)));
    }

    public final void reset(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        logger.trace("entered reset. mode: " + mode);
        this.digraphSequence.reset();
        this.mappingState.resetMappingSequence();
        this.commandLineCommandBuilder = null;
        this.editorCommandBuilder.resetAll(VimInjectorKt.getInjector().getKeyGroup().getKeyRoot(VimStateMachineImplKt.toMappingMode(mode)));
    }

    @NotNull
    public KeyHandlerState clone() {
        CommandBuilder commandBuilder = this.commandLineCommandBuilder;
        return new KeyHandlerState(this.mappingState.clone(), this.digraphSequence.clone(), this.editorCommandBuilder.clone(), commandBuilder != null ? commandBuilder.clone() : null);
    }

    @NotNull
    public String toString() {
        return StringsKt.trimMargin$default((String)("\n      KeyHandlerState:\n      Mapping state:\n      " + this.mappingState + "\n      Digraph sequence:\n      " + this.digraphSequence + "\n      Editor command builder:\n      " + this.editorCommandBuilder + "\n      Command line command builder:\n      " + this.commandLineCommandBuilder + "\n      "), null, (int)1, null);
    }

    @NotNull
    public final MappingState component1() {
        return this.mappingState;
    }

    @NotNull
    public final DigraphSequence component2() {
        return this.digraphSequence;
    }

    @NotNull
    public final CommandBuilder component3() {
        return this.editorCommandBuilder;
    }

    @Nullable
    public final CommandBuilder component4() {
        return this.commandLineCommandBuilder;
    }

    @NotNull
    public final KeyHandlerState copy(@NotNull MappingState mappingState, @NotNull DigraphSequence digraphSequence, @NotNull CommandBuilder editorCommandBuilder, @Nullable CommandBuilder commandLineCommandBuilder) {
        Intrinsics.checkNotNullParameter((Object)mappingState, (String)"mappingState");
        Intrinsics.checkNotNullParameter((Object)digraphSequence, (String)"digraphSequence");
        Intrinsics.checkNotNullParameter((Object)editorCommandBuilder, (String)"editorCommandBuilder");
        return new KeyHandlerState(mappingState, digraphSequence, editorCommandBuilder, commandLineCommandBuilder);
    }

    public static /* synthetic */ KeyHandlerState copy$default(KeyHandlerState keyHandlerState, MappingState mappingState, DigraphSequence digraphSequence, CommandBuilder commandBuilder, CommandBuilder commandBuilder2, int n, Object object) {
        if ((n & 1) != 0) {
            mappingState = keyHandlerState.mappingState;
        }
        if ((n & 2) != 0) {
            digraphSequence = keyHandlerState.digraphSequence;
        }
        if ((n & 4) != 0) {
            commandBuilder = keyHandlerState.editorCommandBuilder;
        }
        if ((n & 8) != 0) {
            commandBuilder2 = keyHandlerState.commandLineCommandBuilder;
        }
        return keyHandlerState.copy(mappingState, digraphSequence, commandBuilder, commandBuilder2);
    }

    public int hashCode() {
        int result = this.mappingState.hashCode();
        result = result * 31 + this.digraphSequence.hashCode();
        result = result * 31 + this.editorCommandBuilder.hashCode();
        result = result * 31 + (this.commandLineCommandBuilder == null ? 0 : this.commandLineCommandBuilder.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyHandlerState)) {
            return false;
        }
        KeyHandlerState keyHandlerState = (KeyHandlerState)other;
        if (!Intrinsics.areEqual((Object)this.mappingState, (Object)keyHandlerState.mappingState)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.digraphSequence, (Object)keyHandlerState.digraphSequence)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.editorCommandBuilder, (Object)keyHandlerState.editorCommandBuilder)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.commandLineCommandBuilder, (Object)keyHandlerState.commandLineCommandBuilder);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(KeyHandlerState.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/state/KeyHandlerState$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

