/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.register;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\u000eB9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\u0010J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u001f\u001a\u00020\u001e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0 R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/maddyhome/idea/vim/register/Register;", "", "name", "", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "keys", "", "Ljavax/swing/KeyStroke;", "<init>", "(CLcom/maddyhome/idea/vim/state/mode/SelectionType;Ljava/util/List;)V", "text", "", "transferableData", "(CLcom/maddyhome/idea/vim/state/mode/SelectionType;Ljava/lang/String;Ljava/util/List;)V", "rawText", "(CLcom/maddyhome/idea/vim/state/mode/SelectionType;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getName", "()C", "setName", "(C)V", "getType", "()Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "getKeys", "()Ljava/util/List;", "getTransferableData", "getRawText", "()Ljava/lang/String;", "getText", "addTextAndResetTransferableData", "", "addKeys", "", "KeySorter", "vim-engine"})
public final class Register {
    private char name;
    @NotNull
    private final SelectionType type;
    @NotNull
    private final List<KeyStroke> keys;
    @NotNull
    private final List<? extends Object> transferableData;
    @Nullable
    private final String rawText;

    public final char getName() {
        return this.name;
    }

    public final void setName(char c) {
        this.name = c;
    }

    @NotNull
    public final SelectionType getType() {
        return this.type;
    }

    @NotNull
    public final List<KeyStroke> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<? extends Object> getTransferableData() {
        return this.transferableData;
    }

    @Nullable
    public final String getRawText() {
        return this.rawText;
    }

    public Register(char name, @NotNull SelectionType type, @NotNull List<KeyStroke> keys) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.name = name;
        this.type = type;
        this.keys = keys;
        this.transferableData = new ArrayList();
        this.rawText = this.getText();
    }

    public Register(char name, @NotNull SelectionType type, @NotNull String text, @NotNull List<? extends Object> transferableData) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(transferableData, (String)"transferableData");
        this.name = name;
        this.type = type;
        this.keys = CollectionsKt.toMutableList((Collection)VimInjectorKt.getInjector().getParser().stringToKeys(text));
        this.transferableData = transferableData;
        this.rawText = text;
    }

    public Register(char name, @NotNull SelectionType type, @NotNull String text, @NotNull List<? extends Object> transferableData, @NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(transferableData, (String)"transferableData");
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        this.name = name;
        this.type = type;
        this.keys = CollectionsKt.toMutableList((Collection)VimInjectorKt.getInjector().getParser().stringToKeys(text));
        this.transferableData = transferableData;
        this.rawText = rawText;
    }

    @Nullable
    public final String getText() {
        StringBuilder builder = new StringBuilder();
        for (KeyStroke key : this.keys) {
            char c = key.getKeyChar();
            if (c == '\uffff') {
                return null;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public final void addTextAndResetTransferableData(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addKeys(VimInjectorKt.getInjector().getParser().stringToKeys(text));
        this.transferableData.clear();
    }

    public final void addKeys(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.keys.addAll((Collection<KeyStroke>)keys);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0003j\b\u0012\u0004\u0012\u00020\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/register/Register$KeySorter;", "Lkotlin/Comparator;", "Lcom/maddyhome/idea/vim/register/Register;", "Ljava/util/Comparator;", "<init>", "()V", "ORDER", "", "compare", "", "o1", "o2", "vim-engine"})
    public static final class KeySorter
    implements Comparator<Register> {
        @NotNull
        public static final KeySorter INSTANCE = new KeySorter();
        @NonNls
        @NotNull
        private static final String ORDER = "\"0123456789abcdefghijklmnopqrstuvwxyz-*+.:%#/=";

        private KeySorter() {
        }

        @Override
        public int compare(@NotNull Register o1, @NotNull Register o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return StringsKt.indexOf$default((CharSequence)ORDER, (char)Character.toLowerCase(o1.getName()), (int)0, (boolean)false, (int)6, null) - StringsKt.indexOf$default((CharSequence)ORDER, (char)Character.toLowerCase(o2.getName()), (int)0, (boolean)false, (int)6, null);
        }
    }
}

