/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.key.KeyMappingLayer;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingInfoLayer;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.key.ToActionMappingInfo;
import com.maddyhome.idea.vim.key.ToExpressionMappingInfo;
import com.maddyhome.idea.vim.key.ToHandlerMappingInfo;
import com.maddyhome.idea.vim.key.ToKeysMappingInfo;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00020\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\rH\u0096\u0002J\u0019\u0010\u000e\u001a\u0004\u0018\u00010\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0086\u0002J,\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J2\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J4\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u001f\u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0006\u0010\u001f\u001a\u00020\u0011J\u0016\u0010 \u001a\u00020\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J&\u0010!\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\"0\u00022\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010#\u001a\u00020\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0016J\u0016\u0010$\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002J\u0016\u0010%\u001a\u00020\u00182\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002J.\u0010&\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\"0\u00022\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010(2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001H\u0016R \u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/maddyhome/idea/vim/key/KeyMapping;", "", "", "Ljavax/swing/KeyStroke;", "Lcom/maddyhome/idea/vim/key/KeyMappingLayer;", "<init>", "()V", "myKeys", "", "Lcom/maddyhome/idea/vim/key/MappingInfo;", "myPrefixes", "", "iterator", "", "get", "keys", "put", "", "fromKeys", "owner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "extensionHandler", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "recursive", "", "toKeys", "toExpression", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Expression;", "originalString", "", "fillPrefixes", "delete", "removePrefixes", "getByOwner", "Lkotlin/Pair;", "isPrefix", "hasmapto", "hasmapfrom", "getMapTo", "getLayer", "Lcom/maddyhome/idea/vim/key/MappingInfoLayer;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nKeyMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyMapping.kt\ncom/maddyhome/idea/vim/key/KeyMapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1557#3:188\n1628#3,3:189\n1863#3,2:192\n*S KotlinDebug\n*F\n+ 1 KeyMapping.kt\ncom/maddyhome/idea/vim/key/KeyMapping\n*L\n111#1:188\n111#1:189,3\n111#1:192,2\n*E\n"})
public final class KeyMapping
implements Iterable<List<? extends KeyStroke>>,
KeyMappingLayer,
KMappedMarker {
    @NotNull
    private final Map<List<KeyStroke>, MappingInfo> myKeys = new HashMap();
    @NotNull
    private final Map<List<KeyStroke>, Integer> myPrefixes = new HashMap();

    @Override
    @NotNull
    public Iterator<List<KeyStroke>> iterator() {
        Iterator<List<KeyStroke>> iterator = new ArrayList(this.myKeys.keySet()).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return iterator;
    }

    @Nullable
    public final MappingInfo get(@NotNull Iterable<? extends KeyStroke> keys) {
        MappingInfo mappingInfo;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean bl = keys instanceof List;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KeyMapping$get$22 = false;
            String $i$a$-assert-KeyMapping$get$22 = "keys must be of type List<KeyStroke>";
            throw new AssertionError((Object)$i$a$-assert-KeyMapping$get$22);
        }
        List keyStrokes = (List)keys;
        MappingInfo mappingInfo2 = mappingInfo = this.myKeys.get(keys);
        if (mappingInfo2 != null) {
            return mappingInfo2;
        }
        if (keyStrokes.size() > 3 && ((KeyStroke)keyStrokes.get(0)).getKeyCode() == VimInjectorKt.getInjector().getParser().getActionKeyStroke().getKeyCode() && ((KeyStroke)keyStrokes.get(1)).getKeyChar() == '(' && ((KeyStroke)keyStrokes.get(keyStrokes.size() - 1)).getKeyChar() == ')') {
            StringBuilder builder = new StringBuilder();
            int n = keyStrokes.size() - 1;
            for (int i = 2; i < n; ++i) {
                builder.append(((KeyStroke)keyStrokes.get(i)).getKeyChar());
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new ToActionMappingInfo(string, keyStrokes, false, MappingOwner.IdeaVim.System.INSTANCE);
        }
        return null;
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull MappingOwner owner, @NotNull ExtensionHandler extensionHandler, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)extensionHandler, (String)"extensionHandler");
        this.myKeys.put(new ArrayList(fromKeys), new ToHandlerMappingInfo(extensionHandler, fromKeys, recursive, owner));
        this.fillPrefixes(fromKeys);
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull List<? extends KeyStroke> toKeys, @NotNull MappingOwner owner, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.myKeys.put(new ArrayList(fromKeys), new ToKeysMappingInfo(toKeys, fromKeys, recursive, owner));
        this.fillPrefixes(fromKeys);
    }

    public final void put(@NotNull List<? extends KeyStroke> fromKeys, @NotNull Expression toExpression, @NotNull MappingOwner owner, @NotNull String originalString, boolean recursive) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)toExpression, (String)"toExpression");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        this.myKeys.put(new ArrayList(fromKeys), new ToExpressionMappingInfo(toExpression, fromKeys, recursive, owner, originalString));
        this.fillPrefixes(fromKeys);
    }

    private final void fillPrefixes(List<? extends KeyStroke> fromKeys) {
        List prefix = new ArrayList();
        int prefixLength = fromKeys.size() - 1;
        for (int i = 0; i < prefixLength; ++i) {
            prefix.add(fromKeys.get(i));
            Map<List<KeyStroke>, Integer> map = this.myPrefixes;
            ArrayList arrayList = new ArrayList(prefix);
            Integer n = this.myPrefixes.get(new ArrayList(prefix));
            Integer n2 = (n != null ? n : 0) + 1;
            map.put(arrayList, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void delete(@NotNull MappingOwner owner) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List<Map.Entry> toRemove = this.myKeys.entrySet().stream().filter(arg_0 -> KeyMapping.delete$lambda$2(arg_0 -> KeyMapping.delete$lambda$1(owner, arg_0), arg_0)).collect(Collectors.toList());
        toRemove.forEach(arg_0 -> KeyMapping.delete$lambda$3(this, arg_0));
        Intrinsics.checkNotNull(toRemove);
        Iterable $this$map$iv = toRemove;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((List)it.getKey());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List p0 = (List)element$iv;
            boolean bl = false;
            this.removePrefixes(p0);
        }
    }

    public final void delete(@NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (this.myKeys.remove(keys) == null) {
            return;
        }
        this.removePrefixes(keys);
    }

    public final void delete() {
        this.myKeys.clear();
        this.myPrefixes.clear();
    }

    private final void removePrefixes(List<? extends KeyStroke> keys) {
        List prefix = new ArrayList();
        int prefixLength = keys.size() - 1;
        for (int i = 0; i < prefixLength; ++i) {
            Integer existingCount;
            prefix.add(keys.get(i));
            Integer n = existingCount = this.myPrefixes.get(prefix);
            int n2 = 1;
            if (n != null && n == n2 || existingCount == null) {
                this.myPrefixes.remove(prefix);
                continue;
            }
            this.myPrefixes.put(prefix, existingCount - 1);
        }
    }

    @NotNull
    public final List<Pair<List<KeyStroke>, MappingInfo>> getByOwner(@NotNull MappingOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        List<Pair<List<KeyStroke>, MappingInfo>> list = this.myKeys.entrySet().stream().filter(arg_0 -> KeyMapping.getByOwner$lambda$6(arg_0 -> KeyMapping.getByOwner$lambda$5(owner, arg_0), arg_0)).map(arg_0 -> KeyMapping.getByOwner$lambda$8(KeyMapping::getByOwner$lambda$7, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    @Override
    public boolean isPrefix(@NotNull Iterable<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        boolean bl = keys instanceof List;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KeyMapping$isPrefix$22 = false;
            String $i$a$-assert-KeyMapping$isPrefix$22 = "keys must be of type List<KeyStroke>";
            throw new AssertionError((Object)$i$a$-assert-KeyMapping$isPrefix$22);
        }
        List keyList = (List)keys;
        if (keyList.isEmpty()) {
            return false;
        }
        if (this.myPrefixes.containsKey(keys)) {
            return true;
        }
        int firstChar = ((KeyStroke)keyList.get(0)).getKeyCode();
        char lastChar = ((KeyStroke)keyList.get(keyList.size() - 1)).getKeyChar();
        return firstChar == VimInjectorKt.getInjector().getParser().getActionKeyStroke().getKeyCode() && lastChar != ')';
    }

    public final boolean hasmapto(@NotNull List<? extends KeyStroke> toKeys) {
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        return this.myKeys.values().stream().anyMatch(arg_0 -> KeyMapping.hasmapto$lambda$11(arg_0 -> KeyMapping.hasmapto$lambda$10(toKeys, arg_0), arg_0));
    }

    public final boolean hasmapfrom(@NotNull List<? extends KeyStroke> fromKeys) {
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        return this.myKeys.values().stream().anyMatch(arg_0 -> KeyMapping.hasmapfrom$lambda$13(arg_0 -> KeyMapping.hasmapfrom$lambda$12(fromKeys, arg_0), arg_0));
    }

    @NotNull
    public final List<Pair<List<KeyStroke>, MappingInfo>> getMapTo(@NotNull List<? extends KeyStroke> toKeys) {
        Intrinsics.checkNotNullParameter(toKeys, (String)"toKeys");
        List<Pair<List<KeyStroke>, MappingInfo>> list = this.myKeys.entrySet().stream().filter(arg_0 -> KeyMapping.getMapTo$lambda$15(arg_0 -> KeyMapping.getMapTo$lambda$14(toKeys, arg_0), arg_0)).map(arg_0 -> KeyMapping.getMapTo$lambda$17(KeyMapping::getMapTo$lambda$16, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    @Override
    @Nullable
    public MappingInfoLayer getLayer(@NotNull Iterable<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        return this.get(keys);
    }

    private static final boolean delete$lambda$1(MappingOwner $owner, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MappingInfo value = (MappingInfo)entry.getValue();
        return Intrinsics.areEqual((Object)value.getOwner(), (Object)$owner);
    }

    private static final boolean delete$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void delete$lambda$3(KeyMapping this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        List key = (List)entry.getKey();
        MappingInfo value = (MappingInfo)entry.getValue();
        this$0.myKeys.remove(key, value);
    }

    private static final boolean getByOwner$lambda$5(MappingOwner $owner, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MappingInfo value = (MappingInfo)entry.getValue();
        return Intrinsics.areEqual((Object)value.getOwner(), (Object)$owner);
    }

    private static final boolean getByOwner$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair getByOwner$lambda$7(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        List key = (List)entry.getKey();
        MappingInfo value = (MappingInfo)entry.getValue();
        return new Pair((Object)key, (Object)value);
    }

    private static final Pair getByOwner$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final boolean hasmapto$lambda$10(List $toKeys, MappingInfo o) {
        Intrinsics.checkNotNullParameter((Object)$toKeys, (String)"$toKeys");
        return o instanceof ToKeysMappingInfo && Intrinsics.areEqual(((ToKeysMappingInfo)o).getToKeys(), (Object)$toKeys);
    }

    private static final boolean hasmapto$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean hasmapfrom$lambda$12(List $fromKeys, MappingInfo o) {
        Intrinsics.checkNotNullParameter((Object)$fromKeys, (String)"$fromKeys");
        return o instanceof ToKeysMappingInfo && Intrinsics.areEqual(((ToKeysMappingInfo)o).getFromKeys(), (Object)$fromKeys);
    }

    private static final boolean hasmapfrom$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getMapTo$lambda$14(List $toKeys, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)$toKeys, (String)"$toKeys");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MappingInfo value = (MappingInfo)entry.getValue();
        return value instanceof ToKeysMappingInfo && Intrinsics.areEqual(((ToKeysMappingInfo)value).getToKeys(), (Object)$toKeys);
    }

    private static final boolean getMapTo$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Pair getMapTo$lambda$16(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        List key = (List)entry.getKey();
        MappingInfo value = (MappingInfo)entry.getValue();
        return new Pair((Object)key, (Object)value);
    }

    private static final Pair getMapTo$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }
}

