/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.group.visual;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.group.visual.VimVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/group/visual/VisualOperation;", "", "<init>", "()V", "getRange", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "cmdFlags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "calculateRange", "", "range", "count", "vim-engine"})
public final class VisualOperation {
    @NotNull
    public static final VisualOperation INSTANCE = new VisualOperation();

    private VisualOperation() {
    }

    @NotNull
    public final VisualChange getRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull EnumSet<CommandFlags> cmdFlags) {
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter(cmdFlags, (String)"cmdFlags");
        ImmutableVimCaret $this$getRange_u24lambda_u240 = caret;
        boolean bl = false;
        Pair<Comparable, Comparable> pair = EditorExtensionsKt.getInBlockSelection(editor) ? VimVisualGroupKt.sort($this$getRange_u24lambda_u240.getVimSelectionStart(), $this$getRange_u24lambda_u240.getOffset()) : VimVisualGroupKt.sort($this$getRange_u24lambda_u240.getSelectionStart(), $this$getRange_u24lambda_u240.getSelectionEnd());
        int start = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        SelectionType selectionType = ModeExtensionsKt.getSelectionType(editor.getMode());
        if (selectionType == null) {
            selectionType = SelectionType.CHARACTER_WISE;
        }
        SelectionType type = selectionType;
        start = EngineEditorHelperKt.normalizeOffset(editor, start, false);
        end = EngineEditorHelperKt.normalizeOffset(editor, end, false);
        BufferPosition sp = editor.offsetToBufferPosition(start);
        BufferPosition ep = editor.offsetToBufferPosition(end);
        int lines = ep.getLine() - sp.getLine() + 1;
        if (type == SelectionType.LINE_WISE && ep.getColumn() == 0 && lines > 0) {
            --lines;
        }
        if (cmdFlags.contains((Object)CommandFlags.FLAG_MOT_LINEWISE)) {
            return new VisualChange(lines, ep.getColumn(), SelectionType.LINE_WISE);
        }
        if (editor.primaryCaret().getVimLastColumn() == 9999) {
            n = 9999;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    n = ep.getColumn();
                    break;
                }
                case 2: {
                    if (lines > 1) {
                        n = ep.getColumn() - VimInjectorKt.getInjector().getVisualMotionGroup().getSelectionAdj();
                        break;
                    }
                    n = ep.getColumn() - sp.getColumn();
                    break;
                }
                case 3: {
                    n = ep.getColumn() - sp.getColumn() + 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        int chars = n;
        return new VisualChange(lines, chars, type);
    }

    public final int calculateRange(@NotNull VimEditor editor, @NotNull VisualChange range, int count, @NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int lines = range.component1();
        int chars = range.component2();
        SelectionType type = range.component3();
        if (type == SelectionType.LINE_WISE || type == SelectionType.BLOCK_WISE || lines > 1) {
            lines *= count;
        }
        if (type == SelectionType.CHARACTER_WISE && lines == 1 || type == SelectionType.BLOCK_WISE) {
            chars *= count;
        }
        BufferPosition sp = caret.getBufferPosition();
        int linesDiff = RangesKt.coerceAtLeast((int)(lines - 1), (int)0);
        int endLine = RangesKt.coerceAtMost((int)(sp.getLine() + linesDiff), (int)(editor.lineCount() - 1));
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> VimInjectorKt.getInjector().getMotion().moveCaretToLineWithSameColumn(editor, endLine, caret);
            case 2 -> {
                if (lines > 1) {
                    yield VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, endLine) + Math.min(EngineEditorHelperKt.lineLength(editor, endLine), chars);
                }
                yield EngineEditorHelperKt.normalizeOffset(editor, sp.getLine(), caret.getOffset() + chars - 1, true);
            }
            case 3 -> {
                int endColumn = Math.min(EngineEditorHelperKt.lineLength(editor, endLine), sp.getColumn() + chars - 1);
                yield editor.bufferPositionToOffset(new BufferPosition(endLine, endColumn, false, 4, null));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SelectionType.values().length];
            try {
                nArray[SelectionType.LINE_WISE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.CHARACTER_WISE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SelectionType.BLOCK_WISE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

