/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.CommandAliasHandler;
import com.maddyhome.idea.vim.common.GoalCommand;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0003H&J\b\u0010\u0014\u001a\u00020\u0006H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/maddyhome/idea/vim/common/CommandAlias;", "", "minimumNumberOfArguments", "", "maximumNumberOfArguments", "name", "", "<init>", "(IILjava/lang/String;)V", "getMinimumNumberOfArguments", "()I", "getMaximumNumberOfArguments", "getName", "()Ljava/lang/String;", "numberOfArguments", "getNumberOfArguments", "getCommand", "Lcom/maddyhome/idea/vim/common/GoalCommand;", "input", "count", "printValue", "Ex", "Call", "Companion", "Lcom/maddyhome/idea/vim/common/CommandAlias$Call;", "Lcom/maddyhome/idea/vim/common/CommandAlias$Ex;", "vim-engine"})
public abstract class CommandAlias {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final int minimumNumberOfArguments;
    private final int maximumNumberOfArguments;
    @NotNull
    private final String name;
    @NotNull
    private final String numberOfArguments;
    @Deprecated
    @NonNls
    @NotNull
    public static final String LessThan = "<lt>";
    @Deprecated
    @NonNls
    @NotNull
    public static final String Count = "<count>";
    @Deprecated
    @NonNls
    @NotNull
    public static final String Arguments = "<args>";
    @Deprecated
    @NonNls
    @NotNull
    public static final String QuotedArguments = "<q-args>";

    private CommandAlias(int minimumNumberOfArguments, int maximumNumberOfArguments, String name) {
        this.minimumNumberOfArguments = minimumNumberOfArguments;
        this.maximumNumberOfArguments = maximumNumberOfArguments;
        this.name = name;
        this.numberOfArguments = this.minimumNumberOfArguments == 0 && this.maximumNumberOfArguments == 0 ? "0" : (this.minimumNumberOfArguments == 0 && this.maximumNumberOfArguments == -1 ? "*" : (this.minimumNumberOfArguments == 0 && this.maximumNumberOfArguments == 1 ? "?" : (this.minimumNumberOfArguments == 1 && this.maximumNumberOfArguments == -1 ? "+" : String.valueOf(this.minimumNumberOfArguments))));
    }

    protected final int getMinimumNumberOfArguments() {
        return this.minimumNumberOfArguments;
    }

    protected final int getMaximumNumberOfArguments() {
        return this.maximumNumberOfArguments;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNumberOfArguments() {
        return this.numberOfArguments;
    }

    @NotNull
    public abstract GoalCommand getCommand(@NotNull String var1, int var2);

    @NotNull
    public abstract String printValue();

    public /* synthetic */ CommandAlias(int minimumNumberOfArguments, int maximumNumberOfArguments, String name, DefaultConstructorMarker $constructor_marker) {
        this(minimumNumberOfArguments, maximumNumberOfArguments, name);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/common/CommandAlias$Call;", "Lcom/maddyhome/idea/vim/common/CommandAlias;", "minimumNumberOfArguments", "", "maximumNumberOfArguments", "name", "", "handler", "Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "<init>", "(IILjava/lang/String;Lcom/maddyhome/idea/vim/common/CommandAliasHandler;)V", "getHandler", "()Lcom/maddyhome/idea/vim/common/CommandAliasHandler;", "getCommand", "Lcom/maddyhome/idea/vim/common/GoalCommand;", "input", "count", "printValue", "vim-engine"})
    public static final class Call
    extends CommandAlias {
        @NotNull
        private final CommandAliasHandler handler;

        public Call(int minimumNumberOfArguments, int maximumNumberOfArguments, @NotNull String name, @NotNull CommandAliasHandler handler) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            super(minimumNumberOfArguments, maximumNumberOfArguments, name, null);
            this.handler = handler;
        }

        @NotNull
        public final CommandAliasHandler getHandler() {
            return this.handler;
        }

        @Override
        @NotNull
        public GoalCommand getCommand(@NotNull String input, int count) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new GoalCommand.Call(this.handler);
        }

        @Override
        @NotNull
        public String printValue() {
            String string = this.handler.getClass().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/common/CommandAlias$Companion;", "", "<init>", "()V", "LessThan", "", "Count", "Arguments", "QuotedArguments", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/common/CommandAlias$Ex;", "Lcom/maddyhome/idea/vim/common/CommandAlias;", "minimumNumberOfArguments", "", "maximumNumberOfArguments", "name", "", "command", "<init>", "(IILjava/lang/String;Ljava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "Lcom/maddyhome/idea/vim/common/GoalCommand;", "input", "count", "printValue", "vim-engine"})
    public static final class Ex
    extends CommandAlias {
        @NotNull
        private final String command;

        public Ex(int minimumNumberOfArguments, int maximumNumberOfArguments, @NotNull String name, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            super(minimumNumberOfArguments, maximumNumberOfArguments, name, null);
            this.command = command;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @Override
        @NotNull
        public GoalCommand getCommand(@NotNull String input, int count) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (this.getMaximumNumberOfArguments() == 0 && this.getMaximumNumberOfArguments() == 0) {
                return new GoalCommand.Ex(this.command);
            }
            String compiledCommand = this.command;
            String cleanedInput = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)input)).toString(), (CharSequence)this.getName()))).toString();
            if (this.getMinimumNumberOfArguments() > 0 && ((CharSequence)cleanedInput).length() == 0) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, VimInjectorKt.getInjector().getMessages().message("E471", new Object[0]));
                VimInjectorKt.getInjector().getMessages().indicateError();
                return GoalCommand.Ex.Companion.getEMPTY();
            }
            String[] stringArray = new String[]{CommandAlias.Count, CommandAlias.Arguments, CommandAlias.QuotedArguments};
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String symbol;
                compiledCommand = StringsKt.replace$default((String)compiledCommand, (String)symbol, (String)ArraysKt.joinToString$default((Object[])(switch (symbol = stringArray2[i]) {
                    case CommandAlias.Count -> {
                        String[] var10_11 = new String[]{String.valueOf(count)};
                        yield var10_11;
                    }
                    case CommandAlias.Arguments -> {
                        String[] var10_11 = new String[]{cleanedInput};
                        yield var10_11;
                    }
                    case CommandAlias.QuotedArguments -> {
                        String[] var10_11 = new String[]{"'" + cleanedInput + "'"};
                        yield var10_11;
                    }
                    default -> new String[]{};
                }), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null);
            }
            compiledCommand = StringsKt.replace$default((String)compiledCommand, (String)CommandAlias.LessThan, (String)"<", (boolean)false, (int)4, null);
            return new GoalCommand.Ex(compiledCommand);
        }

        @Override
        @NotNull
        public String printValue() {
            return this.command;
        }
    }
}

