/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.command;

import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.DuplicableOperatorAction;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.key.CommandPartNode;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.key.RootNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 Q2\u00020\u0001:\u0001QB9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB!\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000fJ\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u000e\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020!J\u0006\u00103\u001a\u000200J\u000e\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\nJ\u000e\u00106\u001a\u0002002\u0006\u00105\u001a\u00020\nJ\u0006\u00107\u001a\u000200J\u0014\u00108\u001a\u0002002\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0016\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010;2\u0006\u00105\u001a\u00020\nJ\u0006\u0010<\u001a\u00020*J\u0006\u0010=\u001a\u00020*J\u0006\u0010>\u001a\u00020*J\u000e\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020*2\u0006\u00105\u001a\u00020\nJ\u0006\u0010C\u001a\u00020*J\u0006\u0010D\u001a\u00020\u0007J\u0014\u0010E\u001a\u0002002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0006\u0010G\u001a\u000200J\u0014\u0010H\u001a\u0002002\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0007J\u0013\u0010J\u001a\u00020*2\b\u0010K\u001a\u0004\u0018\u00010LH\u0096\u0002J\b\u0010M\u001a\u00020\fH\u0016J\b\u0010N\u001a\u00020\u0000H\u0016J\b\u0010O\u001a\u00020PH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010+R\u0011\u0010,\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010+R\u0011\u0010-\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010+R\u0011\u0010.\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010+\u00a8\u0006R"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder;", "", "currentCommandPartNode", "Lcom/maddyhome/idea/vim/key/CommandPartNode;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "commandParts", "Lkotlin/collections/ArrayDeque;", "Lcom/maddyhome/idea/vim/command/Command;", "keyList", "", "Ljavax/swing/KeyStroke;", "initialUncommittedRawCount", "", "<init>", "(Lcom/maddyhome/idea/vim/key/CommandPartNode;Lkotlin/collections/ArrayDeque;Ljava/util/List;I)V", "(Lcom/maddyhome/idea/vim/key/CommandPartNode;I)V", "commandState", "Lcom/maddyhome/idea/vim/common/CurrentCommandState;", "getCommandState", "()Lcom/maddyhome/idea/vim/common/CurrentCommandState;", "setCommandState", "(Lcom/maddyhome/idea/vim/common/CurrentCommandState;)V", "value", "count", "getCount", "()I", "aggregatedUncommittedCount", "getAggregatedUncommittedCount", "keys", "", "getKeys", "()Ljava/lang/Iterable;", "register", "", "getRegister", "()Ljava/lang/Character;", "expectedArgumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "getExpectedArgumentType", "()Lcom/maddyhome/idea/vim/command/Argument$Type;", "fallbackArgumentType", "isReady", "", "()Z", "isEmpty", "isAtDefaultState", "isExpectingCount", "pushCommandPart", "", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "fallbackToCharacterArgument", "addKey", "key", "addCountCharacter", "deleteCountCharacter", "setCurrentCommandPartNode", "newNode", "getChildNode", "Lcom/maddyhome/idea/vim/key/Node;", "isAwaitingCharOrDigraphArgument", "isBuildingMultiKeyCommand", "isDone", "completeCommandPart", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "isDuplicateOperatorKeyStroke", "hasCurrentCommandPartArgument", "buildCommand", "resetAll", "commandPartNode", "resetCount", "resetInProgressCommandPart", "getCurrentTrie", "equals", "other", "", "hashCode", "clone", "toString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1557#2:287\n1628#2,3:288\n2737#2,7:291\n543#2,6:298\n27#3,4:304\n27#3,4:308\n27#3,4:312\n27#3,4:317\n27#3,4:321\n33#3,4:325\n33#3,4:329\n27#3,4:333\n27#3,4:337\n27#3,4:341\n27#3,4:345\n27#3,4:349\n38#3:353\n1#4:316\n*S KotlinDebug\n*F\n+ 1 CommandBuilder.kt\ncom/maddyhome/idea/vim/command/CommandBuilder\n*L\n75#1:287\n75#1:288,3\n75#1:291,7\n87#1:298,6\n111#1:304,4\n118#1:308,4\n127#1:312,4\n135#1:317,4\n156#1:321,4\n166#1:325,4\n177#1:329,4\n186#1:333,4\n192#1:337,4\n194#1:341,4\n222#1:345,4\n235#1:349,4\n283#1:353\n*E\n"})
public final class CommandBuilder
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CommandPartNode<LazyVimCommand> currentCommandPartNode;
    @NotNull
    private final ArrayDeque<Command> commandParts;
    @NotNull
    private final List<KeyStroke> keyList;
    @NotNull
    private CurrentCommandState commandState;
    private int count;
    @Nullable
    private Argument.Type fallbackArgumentType;
    @NotNull
    private static final VimLogger logger;

    public CommandBuilder(@NotNull CommandPartNode<LazyVimCommand> currentCommandPartNode, @NotNull ArrayDeque<Command> commandParts, @NotNull List<KeyStroke> keyList, int initialUncommittedRawCount) {
        Intrinsics.checkNotNullParameter(currentCommandPartNode, (String)"currentCommandPartNode");
        Intrinsics.checkNotNullParameter(commandParts, (String)"commandParts");
        Intrinsics.checkNotNullParameter(keyList, (String)"keyList");
        this.currentCommandPartNode = currentCommandPartNode;
        this.commandParts = commandParts;
        this.keyList = keyList;
        this.commandState = CurrentCommandState.NEW_COMMAND;
        this.count = initialUncommittedRawCount;
    }

    public CommandBuilder(@NotNull CommandPartNode<LazyVimCommand> currentCommandPartNode, int initialUncommittedRawCount) {
        Intrinsics.checkNotNullParameter(currentCommandPartNode, (String)"currentCommandPartNode");
        this(currentCommandPartNode, (ArrayDeque<Command>)new ArrayDeque(), new ArrayList(), initialUncommittedRawCount);
    }

    public /* synthetic */ CommandBuilder(CommandPartNode commandPartNode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(commandPartNode, n);
    }

    @NotNull
    public final CurrentCommandState getCommandState() {
        return this.commandState;
    }

    public final void setCommandState(@NotNull CurrentCommandState currentCommandState) {
        Intrinsics.checkNotNullParameter((Object)((Object)currentCommandState), (String)"<set-?>");
        this.commandState = currentCommandState;
    }

    public final int getCount() {
        return this.count;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAggregatedUncommittedCount() {
        Object v0;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.commandParts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Command command = (Command)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCount());
        }
        Iterable $this$reduceOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void i;
                $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl = false;
                accumulator$iv = acc * i;
            }
            v0 = accumulator$iv;
        }
        Integer n = v0;
        return (n != null ? n : 1) * RangesKt.coerceAtLeast((int)this.count, (int)1);
    }

    @NotNull
    public final Iterable<KeyStroke> getKeys() {
        return this.keyList;
    }

    @Nullable
    public final Character getRegister() {
        Object v0;
        block1: {
            List $this$lastOrNull$iv = (List)this.commandParts;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                Command it = (Command)element$iv;
                boolean bl = false;
                if (!(it.getRegister() != null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Command command = v0;
        return command != null ? command.getRegister() : null;
    }

    @Nullable
    public final Argument.Type getExpectedArgumentType() {
        Argument.Type type = this.fallbackArgumentType;
        if (type == null) {
            Object object = (Command)this.commandParts.lastOrNull();
            type = object != null && (object = ((Command)object).getAction()) != null ? ((EditorActionHandlerBase)object).getArgumentType() : null;
        }
        return type;
    }

    public final boolean isReady() {
        return this.commandState == CurrentCommandState.READY;
    }

    public final boolean isEmpty() {
        return this.commandParts.isEmpty();
    }

    public final boolean isAtDefaultState() {
        return this.isEmpty() && this.count == 0 && this.getExpectedArgumentType() == null;
    }

    public final boolean isExpectingCount() {
        return this.commandState == CurrentCommandState.NEW_COMMAND && this.getExpectedArgumentType() != Argument.Type.CHARACTER && this.getExpectedArgumentType() != Argument.Type.DIGRAPH;
    }

    public final void pushCommandPart(@NotNull EditorActionHandlerBase action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("pushCommandPart is executed. action = " + action);
        }
        this.commandParts.add((Object)new Command(this.count, action, action.getType(), action.getFlags()));
        this.fallbackArgumentType = null;
        this.count = 0;
    }

    public final void pushCommandPart(char register) {
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("pushCommandPart is executed. register = " + register);
        }
        this.commandParts.add((Object)new Command(this.count, register));
        this.fallbackArgumentType = null;
        this.count = 0;
    }

    public final void fallbackToCharacterArgument() {
        boolean bl;
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl2 = false;
            vimLogger.trace("fallbackToCharacterArgument is executed");
        }
        boolean bl3 = bl = this.getExpectedArgumentType() == Argument.Type.DIGRAPH;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Cannot move state from " + this.getExpectedArgumentType() + " to CHARACTER";
            throw new AssertionError((Object)string);
        }
        this.fallbackArgumentType = Argument.Type.CHARACTER;
    }

    public final void addKey(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("added key to command builder");
        }
        this.keyList.add(key);
    }

    public final void addCountCharacter(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.count = this.count * 10 + (key.getKeyChar() - 48);
        if (this.count < 0) {
            this.count = 999999999;
        }
        this.addKey(key);
    }

    public final void deleteCountCharacter() {
        this.count /= 10;
        this.keyList.remove(this.keyList.size() - 1);
    }

    public final void setCurrentCommandPartNode(@NotNull CommandPartNode<LazyVimCommand> newNode) {
        Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("setCurrentCommandPartNode is executed");
        }
        this.currentCommandPartNode = newNode;
    }

    @Nullable
    public final Node<LazyVimCommand> getChildNode(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Node)this.currentCommandPartNode.get((Object)key);
    }

    public final boolean isAwaitingCharOrDigraphArgument() {
        boolean awaiting = this.getExpectedArgumentType() == Argument.Type.CHARACTER || this.getExpectedArgumentType() == Argument.Type.DIGRAPH;
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Awaiting char or digraph: " + awaiting);
        }
        return awaiting;
    }

    public final boolean isBuildingMultiKeyCommand() {
        boolean isMultikey = !(this.currentCommandPartNode instanceof RootNode);
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Building multikey command: " + isMultikey);
        }
        return isMultikey;
    }

    public final boolean isDone() {
        return this.commandParts.isEmpty();
    }

    public final void completeCommandPart(@NotNull Argument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("completeCommandPart is executed");
        }
        ((Command)this.commandParts.last()).setArgument(argument);
        this.commandState = CurrentCommandState.READY;
    }

    public final boolean isDuplicateOperatorKeyStroke(@NotNull KeyStroke key) {
        VimLogger vimLogger;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace22 = false;
        if ($this$trace$iv.isTrace()) {
            vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("entered isDuplicateOperatorKeyStroke");
        }
        EditorActionHandlerBase $i$f$trace22 = ((Command)this.commandParts.last()).getAction();
        DuplicableOperatorAction action = $i$f$trace22 instanceof DuplicableOperatorAction ? (DuplicableOperatorAction)((Object)$i$f$trace22) : null;
        VimLogger $this$trace$iv2 = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv2.isTrace()) {
            vimLogger = $this$trace$iv2;
            boolean bl = false;
            vimLogger.trace("action = " + action);
        }
        DuplicableOperatorAction duplicableOperatorAction = action;
        return duplicableOperatorAction != null ? duplicableOperatorAction.getDuplicateWith() == key.getKeyChar() : false;
    }

    public final boolean hasCurrentCommandPartArgument() {
        Command command = (Command)this.commandParts.lastOrNull();
        return (command != null ? command.getArgument() : null) != null;
    }

    @NotNull
    public final Command buildCommand() {
        Command command = (Command)this.commandParts.removeFirst();
        while (this.commandParts.size() > 0) {
            boolean bl;
            Command next = (Command)this.commandParts.removeFirst();
            next.setRawCount(command.getRawCount() == 0 && next.getRawCount() == 0 ? 0 : command.getCount() * next.getCount());
            command.setRawCount(0);
            if (command.getType() == Command.Type.SELECT_REGISTER) {
                next.setRegister(command.getRegister());
                command.setRegister(null);
                command = next;
                continue;
            }
            command.setArgument(new Argument(next));
            boolean bl2 = bl = this.commandParts.size() == 0;
            if (!_Assertions.ENABLED || bl) continue;
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.fallbackArgumentType = null;
        return command;
    }

    public final void resetAll(@NotNull CommandPartNode<LazyVimCommand> commandPartNode) {
        Intrinsics.checkNotNullParameter(commandPartNode, (String)"commandPartNode");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("resetAll is executed");
        }
        this.resetInProgressCommandPart(commandPartNode);
        this.commandState = CurrentCommandState.NEW_COMMAND;
        this.commandParts.clear();
        this.keyList.clear();
        this.fallbackArgumentType = null;
    }

    public final void resetCount() {
        this.count = 0;
    }

    public final void resetInProgressCommandPart(@NotNull CommandPartNode<LazyVimCommand> commandPartNode) {
        Intrinsics.checkNotNullParameter(commandPartNode, (String)"commandPartNode");
        VimLogger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTrace()) {
            VimLogger vimLogger = $this$trace$iv;
            boolean bl = false;
            vimLogger.trace("resetInProgressCommandPart is executed");
        }
        this.count = 0;
        this.setCurrentCommandPartNode(commandPartNode);
    }

    @TestOnly
    @NotNull
    public final CommandPartNode<LazyVimCommand> getCurrentTrie() {
        return this.currentCommandPartNode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.command.CommandBuilder");
        CommandBuilder cfr_ignored_0 = (CommandBuilder)other;
        if (!Intrinsics.areEqual(this.currentCommandPartNode, ((CommandBuilder)other).currentCommandPartNode)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.commandParts, ((CommandBuilder)other).commandParts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyList, ((CommandBuilder)other).keyList)) {
            return false;
        }
        if (this.commandState != ((CommandBuilder)other).commandState) {
            return false;
        }
        if (this.count != ((CommandBuilder)other).count) {
            return false;
        }
        if (this.getExpectedArgumentType() != ((CommandBuilder)other).getExpectedArgumentType()) {
            return false;
        }
        return this.fallbackArgumentType == ((CommandBuilder)other).fallbackArgumentType;
    }

    public int hashCode() {
        int result = this.currentCommandPartNode.hashCode();
        result = 31 * result + this.commandParts.hashCode();
        result = 31 * result + ((Object)this.keyList).hashCode();
        result = 31 * result + this.commandState.hashCode();
        result = 31 * result + this.count;
        Argument.Type type = this.getExpectedArgumentType();
        result = 31 * result + (type != null ? type.hashCode() : 0);
        Argument.Type type2 = this.fallbackArgumentType;
        result = 31 * result + (type2 != null ? type2.hashCode() : 0);
        return result;
    }

    @NotNull
    public CommandBuilder clone() {
        CommandBuilder result = new CommandBuilder(this.currentCommandPartNode, (ArrayDeque<Command>)new ArrayDeque((Collection)this.commandParts), CollectionsKt.toMutableList((Collection)this.keyList), this.count);
        result.commandState = this.commandState;
        result.fallbackArgumentType = this.fallbackArgumentType;
        return result;
    }

    @NotNull
    public String toString() {
        return "Command state = " + this.commandState + ", key list = " + VimInjectorKt.getInjector().getParser().toKeyNotation(this.keyList) + ", command parts = " + this.commandParts + ", count = " + this.count + "\ncommand part node - " + this.currentCommandPartNode;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandBuilder.class);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/command/CommandBuilder$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

