/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.MutableVimEditor;
import com.maddyhome.idea.vim.api.SubstituteCommandArguments;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimMessages;
import com.maddyhome.idea.vim.api.VimModalInput;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.helper.StringAndKeysKt;
import com.maddyhome.idea.vim.history.HistoryConstants;
import com.maddyhome.idea.vim.key.interceptors.VimInputInterceptorBase;
import com.maddyhome.idea.vim.regexp.CharPointer;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.functions.handlers.SubmatchFunctionHandler;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 \u0085\u00012\u00020\u0001:\u0010\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH$J\b\u0010\u000e\u001a\u00020\u0005H&J\b\u0010\u000f\u001a\u00020\u0005H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH$J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0005H$J\b\u0010\u0018\u001a\u00020\u0005H&J\n\u0010&\u001a\u0004\u0018\u00010\u0016H\u0014J\u001e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\tJ\u0010\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0016J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\"\u00102\u001a\u0004\u0018\u0001012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\tH\u0016J\"\u00105\u001a\u0004\u0018\u0001012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00104\u001a\u00020\t2\u0006\u00106\u001a\u00020\rH\u0016J0\u00107\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010:\u001a\u00020;H\u0016J \u0010<\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\u0006\u00104\u001a\u00020\tH\u0016J \u0010?\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\u0006\u00104\u001a\u00020\tH\u0016J>\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020B\u0018\u00010A2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020;H\u0016J0\u0010F\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\u0006\u00104\u001a\u00020\t2\u0006\u0010G\u001a\u00020\r2\u0006\u0010E\u001a\u00020;H\u0016J \u0010H\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\tH\u0016J\"\u0010L\u001a\u0004\u0018\u0001012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00104\u001a\u00020\t2\u0006\u00106\u001a\u00020\rH\u0002J \u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00106\u001a\u00020\rH\u0002J(\u0010O\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>2\u0006\u00104\u001a\u00020\t2\u0006\u0010E\u001a\u00020;H\u0002J\u0018\u0010P\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\tH\u0002J\u0018\u0010Q\u001a\u00020\t2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\tH\u0002J\u001a\u0010R\u001a\u0004\u0018\u0001012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020>H\u0002J@\u0010S\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\\H\u0016Jp\u0010]\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020\u00160A\u0018\u00010A2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020(2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020\r2\u0006\u0010c\u001a\u00020\u00162\f\u0010d\u001a\b\u0012\u0004\u0012\u00020f0eH\u0002JV\u0010g\u001a\u00020h2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010_\u001a\u00020(2\u0006\u0010`\u001a\u00020\u00162\u0006\u0010i\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010a\u001a\u00020\t2\u0006\u0010b\u001a\u00020\r2\u0006\u0010c\u001a\u00020\u00162\f\u0010d\u001a\b\u0012\u0004\u0012\u00020f0eH\u0002J\u0084\u0001\u0010j\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010[\u001a\u00020\\2\u0006\u0010_\u001a\u00020(2\u0006\u00108\u001a\u00020\u00162\u0006\u0010`\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010k\u001a\u00020\t2\u0006\u0010b\u001a\u00020\r2\u0006\u0010c\u001a\u00020\u00162\f\u0010l\u001a\b\u0012\u0004\u0012\u00020n0m2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020f0eH\u0002Jn\u0010o\u001a\u00020p2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020T2\u0006\u0010U\u001a\u00020V2\u0006\u0010[\u001a\u00020\\2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010q\u001a\u0002012\u0006\u0010r\u001a\u00020\r2\u0006\u0010i\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010b\u001a\u00020\r2\u0006\u0010c\u001a\u00020\u00162\f\u0010l\u001a\b\u0012\u0004\u0012\u00020n0mH\u0002J>\u0010s\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010=\u001a\u00020T2\u0006\u00108\u001a\u00020\u00162\u0006\u0010t\u001a\u00020\r2\u0006\u0010u\u001a\u00020\t2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020n0vH\u0002J6\u0010w\u001a\u00020\u00162\u0006\u0010x\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010U\u001a\u00020V2\u0006\u0010[\u001a\u00020\\2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020n0mH\u0002J*\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u0016H\u0002J \u0010{\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00162\u0006\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020\rH\u0002J\u0018\u0010\u007f\u001a\u0004\u0018\u00010\t2\u0006\u0010i\u001a\u00020\u0016H\u0016\u00a2\u0006\u0003\u0010\u0080\u0001J\t\u0010\u0081\u0001\u001a\u00020;H\u0016J7\u0010\u0082\u0001\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020B\u0018\u00010A2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u0010E\u001a\u00020;H\u0002J!\u0010\u0083\u0001\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00162\u0006\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;H\u0007J\t\u0010\u0084\u0001\u001a\u00020\u0005H\u0017R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"\u00a8\u0006\u008d\u0001"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase;", "Lcom/maddyhome/idea/vim/api/VimSearchGroup;", "<init>", "()V", "highlightSearchLines", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startLine", "", "endLine", "updateSearchHighlights", "force", "", "resetIncsearchHighlights", "updateSearchHighlightsAfterGlobalCommand", "addSubstitutionConfirmationHighlight", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "startOffset", "endOffset", "setLatestMatch", "match", "", "setShouldShowSearchHighlights", "clearSearchHighlight", "doAll", "doAsk", "doError", "doIgnorecase", "Ljava/lang/Boolean;", "lastSearchPattern", "getLastSearchPattern", "()Ljava/lang/String;", "setLastSearchPattern", "(Ljava/lang/String;)V", "lastSubstitutePattern", "getLastSubstitutePattern", "setLastSubstitutePattern", "getLastUsedPattern", "prepareRegex", "Lcom/maddyhome/idea/vim/regexp/VimRegex;", "pat", "Lcom/maddyhome/idea/vim/regexp/CharPointer;", "whichPattern", "patternSave", "parseGlobalCommand", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$GlobalCommandArguments;", "argument", "findUnderCaret", "Lcom/maddyhome/idea/vim/common/TextRange;", "searchBackward", "offset", "count", "getNextSearchRange", "forwards", "processSearchRange", "pattern", "patternOffset", "direction", "Lcom/maddyhome/idea/vim/common/Direction;", "searchNext", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "searchPrevious", "processSearchCommand", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/command/MotionType;", "command", "count1", "dir", "searchWord", "whole", "findEndOfPattern", "delimiter", "", "startIndex", "findNextSearchForGn", "atEdgeOfGnRange", "nextRange", "searchNextWithDirection", "findEndOfCollection", "findEndOfCharacterClass", "findWordUnderCursor", "processSubstituteCommand", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "excmd", "exarg", "parent", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getNextSubstitute", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult$Success;", "regex", "oldLastSubstituteString", "column", "hasExpression", "substituteString", "options", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/regexp/VimRegexOptions;", "prepareToSubstituteWithoutAsk", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult;", "line", "performSubstituteInLines", "startColumn", "exceptions", "", "Lcom/maddyhome/idea/vim/ex/ExException;", "performReplace", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceResult;", "matchRange", "doReplace", "postSubstitute", "gotQuit", "lastMatchLine", "", "evaluateExpression", "exprString", "parseSubstituteCommand", "Lcom/maddyhome/idea/vim/api/SubstituteCommandArguments;", "setLastUsedPattern", "patternType", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "isNewPattern", "findDecimalNumber", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLastSearchDirection", "findItOffset", "setLastSearchState", "resetState", "Companion", "GlobalCommandArguments", "SubstitutePreparationResult", "ReplaceResult", "SubstituteWithAskInputInterceptor", "SearchHighlight", "PatternType", "ReplaceConfirmationChoice", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimSearchGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSearchGroupBase.kt\ncom/maddyhome/idea/vim/api/VimSearchGroupBase\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1410:1\n47#2,2:1411\n23#2:1413\n49#2,2:1414\n51#2:1418\n37#3,2:1416\n*S KotlinDebug\n*F\n+ 1 VimSearchGroupBase.kt\ncom/maddyhome/idea/vim/api/VimSearchGroupBase\n*L\n646#1:1411,2\n646#1:1413\n646#1:1414,2\n646#1:1418\n646#1:1416,2\n*E\n"})
public abstract class VimSearchGroupBase
implements VimSearchGroup {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    private boolean doAll;
    private boolean doAsk;
    private boolean doError = true;
    @Nullable
    private Boolean doIgnorecase;
    @Nullable
    private String lastSearchPattern;
    @Nullable
    private String lastSubstitutePattern;
    private static boolean lastIgnoreSmartCase;
    @Nullable
    private static String lastPatternTrailing;
    @NotNull
    private static Direction lastDirection;
    @Nullable
    private static PatternType lastPatternType;
    @Nullable
    private static String lastSubstituteString;
    @Nullable
    private static String lastReplaceString;
    @NotNull
    private static final List<String> CLASS_NAMES;

    public abstract void highlightSearchLines(@NotNull VimEditor var1, int var2, int var3);

    protected abstract void updateSearchHighlights(boolean var1);

    public abstract void resetIncsearchHighlights();

    @Override
    public void updateSearchHighlightsAfterGlobalCommand() {
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(false);
    }

    @NotNull
    protected abstract SearchHighlight addSubstitutionConfirmationHighlight(@NotNull VimEditor var1, int var2, int var3);

    protected void setLatestMatch(@NotNull String match) {
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        SubmatchFunctionHandler.Companion.getInstance().setLatestMatch(match);
    }

    protected abstract void setShouldShowSearchHighlights();

    @Override
    public abstract void clearSearchHighlight();

    @Override
    @Nullable
    public String getLastSearchPattern() {
        return this.lastSearchPattern;
    }

    @Override
    public void setLastSearchPattern(@Nullable String string) {
        this.lastSearchPattern = string;
    }

    @Override
    @Nullable
    public String getLastSubstitutePattern() {
        return this.lastSubstitutePattern;
    }

    @Override
    public void setLastSubstitutePattern(@Nullable String string) {
        this.lastSubstitutePattern = string;
    }

    @Nullable
    protected String getLastUsedPattern() {
        PatternType patternType = lastPatternType;
        return switch (patternType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[patternType.ordinal()]) {
            case 1 -> this.getLastSearchPattern();
            case 2 -> this.getLastSubstitutePattern();
            default -> null;
        };
    }

    @NotNull
    public final VimRegex prepareRegex(@NotNull CharPointer pat, int whichPattern, int patternSave) {
        Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
        boolean isNewPattern = true;
        String pattern = "";
        if (pat.isNul()) {
            String errorMessage;
            isNewPattern = false;
            int which = whichPattern == 2 ? (lastPatternType == PatternType.SEARCH ? 0 : 1) : whichPattern;
            switch (which) {
                case 0: {
                    pattern = this.getLastSearchPattern();
                    String string = VimInjectorKt.getInjector().getMessages().message("e_nopresub", new Object[0]);
                    break;
                }
                case 1: {
                    pattern = this.getLastSubstitutePattern();
                    String string = VimInjectorKt.getInjector().getMessages().message("e_noprevre", new Object[0]);
                    break;
                }
                default: {
                    String string = errorMessage = null;
                }
            }
            if (pattern == null) {
                throw new ExException(errorMessage);
            }
        } else {
            pattern = pat.toString();
        }
        PatternType patSave = switch (patternSave) {
            case 0 -> PatternType.SEARCH;
            case 1 -> PatternType.SUBSTITUTE;
            case 2 -> PatternType.BOTH;
            default -> throw new ExException(VimInjectorKt.getInjector().getMessages().message("e_invcmd", new Object[0]));
        };
        this.setLastUsedPattern(pattern, patSave, isNewPattern);
        return new VimRegex(pattern);
    }

    @Nullable
    public final GlobalCommandArguments parseGlobalCommand(@NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        CharPointer cmd = new CharPointer(new StringBuffer(argument));
        CharPointer pat = null;
        char delimiter = '\u0000';
        int whichPat = 2;
        VimMessages messages = VimInjectorKt.getInjector().getMessages();
        if (((CharSequence)argument).length() == 0) {
            messages.showStatusBarMessage(null, messages.message("E148", new Object[0]));
            messages.indicateError();
            return null;
        }
        if (CharPointer.charAt$default(cmd, 0, 1, null) == '\\') {
            CharPointer.inc$default(cmd, 0, 1, null);
            if (StringsKt.indexOf$default((CharSequence)"/?&", (char)CharPointer.charAt$default(cmd, 0, 1, null), (int)0, (boolean)false, (int)6, null) == -1) {
                messages.showStatusBarMessage(null, messages.message("e_backslash", new Object[0]));
                return null;
            }
            whichPat = CharPointer.charAt$default(cmd, 0, 1, null) == '&' ? 1 : 0;
            CharPointer.inc$default(cmd, 0, 1, null);
            pat = new CharPointer("");
        } else {
            delimiter = CharPointer.charAt$default(cmd, 0, 1, null);
            CharPointer.inc$default(cmd, 0, 1, null);
            pat = cmd.ref(0);
            int endOfPattern = VimSearchGroup.findEndOfPattern$default(this, cmd.toString(), delimiter, 0, 4, null);
            if (cmd.charAt(endOfPattern) == delimiter) {
                cmd.set('\u0000', endOfPattern);
            }
            cmd.setPointer(endOfPattern + 2);
        }
        return new GlobalCommandArguments(pat, whichPat, cmd.toString());
    }

    @Nullable
    protected final TextRange findUnderCaret(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = this.searchBackward(editor, editor.primaryCaret().getOffset() + 1, 1);
        if (textRange == null) {
            return null;
        }
        TextRange backSearch = textRange;
        return backSearch.contains(editor.primaryCaret().getOffset()) ? backSearch : null;
    }

    @Override
    @Nullable
    public TextRange searchBackward(@NotNull VimEditor editor, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.WRAP, (Enum)SearchOptions.WHOLE_FILE, (Enum)SearchOptions.BACKWARDS);
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), offset, count, searchOptions);
        if (textRange == null) {
            return null;
        }
        TextRange foundBackward = textRange;
        int startOffset = foundBackward.getStartOffset() - 1;
        if (startOffset < 0) {
            startOffset = (int)editor.fileSize();
        }
        searchOptions.remove((Object)SearchOptions.BACKWARDS);
        return VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), startOffset, 1, searchOptions);
    }

    @Override
    @Nullable
    public TextRange getNextSearchRange(@NotNull VimEditor editor, int count, boolean forwards) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.removeSecondaryCarets();
        TextRange current = this.findUnderCaret(editor);
        if (current == null || EditorExtensionsKt.getInVisualMode(editor) && this.atEdgeOfGnRange(current, editor, forwards)) {
            current = this.findNextSearchForGn(editor, count, forwards);
        } else if (count > 1) {
            current = this.findNextSearchForGn(editor, count - 1, forwards);
        }
        return current;
    }

    @Override
    public int processSearchRange(@NotNull VimEditor editor, @NotNull String pattern, int patternOffset, int startOffset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.setLastUsedPattern(pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = "";
        lastDirection = direction;
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(true);
        Pair<Integer, MotionType> result = this.findItOffset(editor, startOffset, 1, lastDirection);
        lastPatternTrailing = patternOffset != 0 ? String.valueOf(patternOffset) : "";
        Pair<Integer, MotionType> pair = result;
        return pair != null ? ((Number)pair.getFirst()).intValue() : -1;
    }

    @Override
    public int searchNext(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.searchNextWithDirection(editor, caret, count, lastDirection);
    }

    @Override
    public int searchPrevious(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.searchNextWithDirection(editor, caret, count, lastDirection.reverse());
    }

    @Override
    @Nullable
    public Pair<Integer, MotionType> processSearchCommand(@NotNull VimEditor editor, @NotNull String command, int startOffset, int count1, @NotNull Direction dir) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        boolean isNewPattern = false;
        String pattern = null;
        String patternOffset = null;
        char type = dir == Direction.FORWARDS ? (char)'/' : '?';
        if (((CharSequence)command).length() > 0) {
            if (command.charAt(0) != type) {
                String string;
                int endOfPattern = VimSearchGroup.findEndOfPattern$default(this, command, type, 0, 4, null);
                String string2 = command.substring(0, endOfPattern);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                pattern = string2;
                isNewPattern = true;
                if (endOfPattern < command.length()) {
                    String string3 = command.substring(endOfPattern + 1);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = "";
                }
                patternOffset = string;
            } else if (command.length() == 1) {
                patternOffset = "";
            } else {
                String string = command.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                patternOffset = string;
            }
        }
        if ((charSequence = (CharSequence)pattern) == null || charSequence.length() == 0) {
            pattern = this.getLastSearchPattern();
            charSequence = pattern;
            if (charSequence == null || charSequence.length() == 0) {
                isNewPattern = true;
                pattern = this.getLastSubstitutePattern();
                charSequence = pattern;
                if (charSequence == null || charSequence.length() == 0) {
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E35: No previous regular expression");
                    return null;
                }
            }
            if ((charSequence = (CharSequence)patternOffset) == null || charSequence.length() == 0) {
                patternOffset = lastPatternTrailing;
            }
        }
        this.setLastUsedPattern(pattern, PatternType.SEARCH, isNewPattern);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = patternOffset;
        lastDirection = dir;
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(true);
        return this.findItOffset(editor, startOffset, count1, lastDirection);
    }

    @Override
    public int searchWord(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean whole, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        TextRange textRange = this.findWordUnderCursor(editor, caret);
        if (textRange == null) {
            return -1;
        }
        TextRange range = textRange;
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        Object pattern = whole ? "\\<" + EngineEditorHelperKt.getText(editor, start, end) + "\\>" : EngineEditorHelperKt.getText(editor, start, end);
        this.setLastUsedPattern((String)pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = true;
        lastPatternTrailing = "";
        lastDirection = dir;
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(true);
        Pair<Integer, MotionType> pair = this.findItOffset(editor, range.getStartOffset(), count, lastDirection);
        int offset = pair != null ? ((Number)pair.getFirst()).intValue() : -1;
        return offset == -1 ? range.getStartOffset() : offset;
    }

    @Override
    public int findEndOfPattern(@NotNull String command, char delimiter, int startIndex) {
        int i;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        boolean magic = true;
        for (i = startIndex; i < command.length() && command.charAt(i) != delimiter; ++i) {
            if (magic && command.charAt(i) == '[' || !magic && command.charAt(i) == '\\' && i + 1 < command.length() && command.charAt(i + 1) == '[') {
                i = this.findEndOfCollection(command, i);
                continue;
            }
            if (command.charAt(i) != '\\' || i + 1 >= command.length()) continue;
            if (command.charAt(++i) == 'v' || command.charAt(i) == 'm') {
                magic = true;
            }
            if (command.charAt(i) != 'V' && command.charAt(i) != 'M') continue;
            magic = false;
        }
        return i;
    }

    private final TextRange findNextSearchForGn(VimEditor editor, int count, boolean forwards) {
        TextRange textRange;
        if (forwards) {
            EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.WRAP, (Enum)SearchOptions.WHOLE_FILE);
            textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), editor.primaryCaret().getOffset(), count, searchOptions);
        } else {
            textRange = this.searchBackward(editor, editor.primaryCaret().getOffset(), count);
        }
        return textRange;
    }

    private final boolean atEdgeOfGnRange(TextRange nextRange, VimEditor editor, boolean forwards) {
        int currentPosition = editor.currentCaret().getOffset();
        return forwards ? nextRange.getEndOffset() - VimInjectorKt.getInjector().getVisualMotionGroup().getSelectionAdj() == currentPosition : nextRange.getStartOffset() == currentPosition;
    }

    private final int searchNextWithDirection(VimEditor editor, ImmutableVimCaret caret, int count, Direction dir) {
        int offset;
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(false);
        int startOffset = caret.getOffset();
        Pair<Integer, MotionType> pair = this.findItOffset(editor, startOffset, count, dir);
        int n = offset = pair != null ? ((Number)pair.getFirst()).intValue() : -1;
        if (offset == startOffset) {
            Pair<Integer, MotionType> pair2 = this.findItOffset(editor, startOffset, count + 1, dir);
            offset = pair2 != null ? ((Number)pair2.getFirst()).intValue() : -1;
        }
        return offset;
    }

    private final int findEndOfCollection(String command, int startIndex) {
        int i;
        for (i = startIndex; i < command.length() - 1 && command.charAt(i) != ']'; ++i) {
            if (command.charAt(i) == '\\' && i + 1 < command.length()) {
                ++i;
                continue;
            }
            if (i + 1 >= command.length() || command.charAt(i) != '[' || Intrinsics.compare((int)command.charAt(i + 1), (int)58) >= 0) continue;
            i = this.findEndOfCharacterClass(command, i + 2);
        }
        return i;
    }

    private final int findEndOfCharacterClass(String command, int startIndex) {
        for (String charClass : CLASS_NAMES) {
            if (startIndex + charClass.length() >= command.length()) continue;
            String string = command.substring(startIndex, startIndex + charClass.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)charClass)) continue;
            return startIndex + charClass.length() - 1;
        }
        return startIndex;
    }

    private final TextRange findWordUnderCursor(VimEditor editor, ImmutableVimCaret caret) {
        int stop = EngineEditorHelperKt.getLineEndOffset(editor, caret.getBufferPosition().getLine(), true);
        int pos = caret.getOffset();
        if (editor.text().length() == 0 || editor.text().length() <= pos) {
            return null;
        }
        int start = pos;
        CharacterHelper.CharacterType[] characterTypeArray = new CharacterHelper.CharacterType[]{CharacterHelper.CharacterType.KEYWORD, CharacterHelper.CharacterType.PUNCTUATION};
        CharacterHelper.CharacterType[] types = characterTypeArray;
        for (int i = 0; i < 2; ++i) {
            CharacterHelper.CharacterType type = CharacterHelper.charType(editor, editor.text().charAt(start), false);
            if (type == types[i]) {
                for (start = pos; start > 0 && CharacterHelper.charType(editor, editor.text().charAt(start - 1), false) == types[i]; --start) {
                }
            } else {
                while (start < stop && CharacterHelper.charType(editor, editor.text().charAt(start), false) != types[i]) {
                    ++start;
                }
            }
            if (start != stop) break;
        }
        if (start == stop) {
            return null;
        }
        int end = start < stop && (start >= editor.text().length() - 1 || CharacterHelper.charType(editor, editor.text().charAt(start + 1), false) != CharacterHelper.CharacterType.KEYWORD) ? start + 1 : VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, start, 1, false, false) + 1;
        return new TextRange(start, end);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processSubstituteCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull LineRange range, @NotNull String excmd, @NotNull String exarg, @NotNull VimLContext parent) {
        String oldLastSubstituteString;
        VimRegex $i$f$enumSetOf2;
        EnumSet<Object> enumSet;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)excmd, (String)"excmd");
        Intrinsics.checkNotNullParameter((Object)exarg, (String)"exarg");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List exceptions = new ArrayList();
        if (EditorExtensionsKt.getInVisualMode(editor)) {
            EngineModeExtensionsKt.exitVisualMode(editor);
        }
        SubstituteCommandArguments substituteCommandArguments = this.parseSubstituteCommand(editor, range, excmd, exarg);
        if (substituteCommandArguments == null) {
            return false;
        }
        SubstituteCommandArguments substituteCommandParse = substituteCommandArguments;
        String pattern = substituteCommandParse.getPattern();
        String substituteString = substituteCommandParse.getSubstituteString();
        int line1 = substituteCommandParse.getRange().startLine;
        int line2 = substituteCommandParse.getRange().endLine;
        Enum[] enumArray = new VimRegexOptions[0];
        boolean $i$f$enumSetOf2 = false;
        switch (((void)value$iv).length) {
            case 0: {
                boolean $i$f$noneOfEnum = false;
                EnumSet<VimRegexOptions> enumSet2 = EnumSet.noneOf(VimRegexOptions.class);
                enumSet = enumSet2;
                Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
                break;
            }
            case 1: {
                EnumSet<void> enumSet3 = EnumSet.of(value$iv[0]);
                enumSet = enumSet3;
                Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
                break;
            }
            default: {
                Collection $this$toTypedArray$iv$iv = ArraysKt.slice((Object[])value$iv, (IntRange)new IntRange(1, ArraysKt.getLastIndex((Object[])value$iv)));
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                Enum[] enumArray2 = thisCollection$iv$iv.toArray(new VimRegexOptions[0]);
                EnumSet<Enum[]> enumSet4 = EnumSet.of(value$iv[0], Arrays.copyOf(enumArray2, enumArray2.length));
                enumSet = enumSet4;
                Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
            }
        }
        EnumSet<Object> options = enumSet;
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase()) {
            options.add((Object)VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add((Object)VimRegexOptions.IGNORE_CASE);
        }
        try {
            $i$f$enumSetOf2 = new VimRegex(pattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return false;
        }
        VimRegex regex = $i$f$enumSetOf2;
        boolean hasExpression = substituteString.length() >= 2 && substituteString.charAt(0) == '\\' && substituteString.charAt(1) == '=';
        String string = lastSubstituteString;
        if (string == null) {
            string = oldLastSubstituteString = "";
        }
        if (!Intrinsics.areEqual((Object)substituteString, (Object)"~")) {
            lastSubstituteString = substituteString;
        }
        this.setShouldShowSearchHighlights();
        this.updateSearchHighlights(true);
        if (!this.doAsk) {
            this.performSubstituteInLines(editor, caret, context, parent, regex, pattern, oldLastSubstituteString, line1, line2, 0, hasExpression, substituteString, exceptions, options);
        } else {
            Pair<Integer, Pair<VimMatchResult.Success, String>> lineToNextSubstitute = this.getNextSubstitute(editor, regex, oldLastSubstituteString, line1, line2, 0, hasExpression, substituteString, options);
            if (lineToNextSubstitute == null) {
                VimInjectorKt.getInjector().getMessages().indicateError();
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E486: Pattern not found: " + pattern);
                return true;
            }
            int line = ((Number)lineToNextSubstitute.component1()).intValue();
            Pair nextSubstitute = (Pair)lineToNextSubstitute.component2();
            TextRange matchRange = ((VimMatchResult.Success)nextSubstitute.getFirst()).getRange();
            caret.moveToOffset(matchRange.getStartOffset());
            SearchHighlight highlight = this.addSubstitutionConfirmationHighlight(editor, matchRange.getStartOffset(), matchRange.getEndOffset());
            Object[] objectArray = new Object[]{((Pair)lineToNextSubstitute.getSecond()).getSecond()};
            VimInjectorKt.getInjector().getModalInput().create(editor, context, VimInjectorKt.getInjector().getMessages().message("replace.with.0", objectArray), new SubstituteWithAskInputInterceptor(editor, caret, (Pair<VimMatchResult.Success, String>)nextSubstitute, highlight, line, 0, parent, pattern, regex, oldLastSubstituteString, line2, hasExpression, substituteString, options, -1, new ArrayList()));
        }
        return true;
    }

    private final Pair<Integer, Pair<VimMatchResult.Success, String>> getNextSubstitute(VimEditor editor, VimRegex regex, String oldLastSubstituteString, int startLine, int endLine, int column, boolean hasExpression, String substituteString, EnumSet<VimRegexOptions> options) {
        int line = startLine;
        if (line <= endLine) {
            while (true) {
                int col;
                Pair<VimMatchResult.Success, String> result;
                if ((result = regex.substitute(editor, substituteString, oldLastSubstituteString, line, col = line == startLine ? column : 0, hasExpression, options)) != null) {
                    return TuplesKt.to((Object)line, result);
                }
                if (line == endLine) break;
                ++line;
            }
        }
        return null;
    }

    private final SubstitutePreparationResult prepareToSubstituteWithoutAsk(VimEditor editor, VimRegex regex, String oldLastSubstituteString, int line, int endLine, int column, boolean hasExpression, String substituteString, EnumSet<VimRegexOptions> options) {
        Pair<VimMatchResult.Success, String> pair = regex.substitute(editor, substituteString, oldLastSubstituteString, line, column, hasExpression, options);
        if (pair == null) {
            return new SubstitutePreparationResult.Skip(line + 1, 0);
        }
        Pair<VimMatchResult.Success, String> substituteResult = pair;
        TextRange matchRange = ((VimMatchResult.Success)substituteResult.getFirst()).getRange();
        String match = (String)substituteResult.getSecond();
        VimInjectorKt.getInjector().getJumpService().saveJumpLocation(editor);
        return new SubstitutePreparationResult.Prepared(match, matchRange, endLine, true, false);
    }

    private final void performSubstituteInLines(VimEditor editor, VimCaret caret, ExecutionContext context, VimLContext parent, VimRegex regex, String pattern, String oldLastSubstituteString, int startLine, int endLine, int startColumn, boolean hasExpression, String substituteString, List<ExException> exceptions, EnumSet<VimRegexOptions> options) {
        int column = startColumn;
        int line = startLine;
        int line2 = endLine;
        int lastMatchLine = -1;
        while (line <= line2) {
            SubstitutePreparationResult preparationResult = this.prepareToSubstituteWithoutAsk(editor, regex, oldLastSubstituteString, line, line2, column, hasExpression, substituteString, options);
            if (preparationResult instanceof SubstitutePreparationResult.Skip) {
                line = ((SubstitutePreparationResult.Skip)preparationResult).getNewLine();
                column = ((SubstitutePreparationResult.Skip)preparationResult).getNewColumn();
                continue;
            }
            Intrinsics.checkNotNull((Object)preparationResult, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.api.VimSearchGroupBase.SubstitutePreparationResult.Prepared");
            SubstitutePreparationResult.Prepared cfr_ignored_0 = (SubstitutePreparationResult.Prepared)preparationResult;
            lastMatchLine = line;
            ReplaceResult replaceResult = this.performReplace(editor, caret, context, parent, ((SubstitutePreparationResult.Prepared)preparationResult).getMatch(), ((SubstitutePreparationResult.Prepared)preparationResult).getMatchRange(), ((SubstitutePreparationResult.Prepared)preparationResult).getDoReplace(), line, ((SubstitutePreparationResult.Prepared)preparationResult).getNewEndLine(), hasExpression, substituteString, exceptions);
            line = replaceResult.getLine();
            column = replaceResult.getColumn();
            line2 = replaceResult.getEndLine();
        }
        this.postSubstitute(editor, caret, pattern, false, lastMatchLine, exceptions);
    }

    private final ReplaceResult performReplace(VimEditor editor, VimCaret caret, ExecutionContext context, VimLContext parent, String match, TextRange matchRange, boolean doReplace, int line, int endLine, boolean hasExpression, String substituteString, List<ExException> exceptions) {
        String string;
        caret.moveToOffset(matchRange.getStartOffset());
        this.setLatestMatch(EngineEditorHelperKt.getText(editor, new TextRange(matchRange.getStartOffset(), matchRange.getEndOffset())));
        if (hasExpression) {
            String string2 = substituteString.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = this.evaluateExpression(string2, editor, context, parent, exceptions);
        } else {
            string = match;
        }
        String finalMatch = string;
        int newColumn = 0;
        int newLine = line;
        int newEndLine = endLine;
        boolean didReplace = false;
        if (doReplace) {
            BufferPosition endPositionWithoutReplace = editor.offsetToBufferPosition(matchRange.getEndOffset());
            VimInjectorKt.getInjector().getApplication().runWriteAction(() -> VimSearchGroupBase.performReplace$lambda$0(editor, matchRange, finalMatch));
            didReplace = true;
            BufferPosition endPositionWithReplace = editor.offsetToBufferPosition(matchRange.getStartOffset() + finalMatch.length());
            newLine += Math.max(0, endPositionWithReplace.getLine() - endPositionWithoutReplace.getLine());
            newEndLine += endPositionWithReplace.getLine() - endPositionWithoutReplace.getLine();
        }
        if (this.doAll && matchRange.getStartOffset() != matchRange.getEndOffset()) {
            if (didReplace) {
                endPosition = editor.offsetToBufferPosition(matchRange.getStartOffset() + finalMatch.length());
                newLine = ((BufferPosition)endPosition).getLine();
                newColumn = ((BufferPosition)endPosition).getColumn();
            } else {
                endPosition = editor.offsetToVisualPosition(matchRange.getEndOffset());
                newColumn = ((VimVisualPosition)endPosition).getColumn();
            }
        } else {
            newColumn = 0;
            ++newLine;
        }
        return new ReplaceResult(newLine, newColumn, newEndLine);
    }

    private final void postSubstitute(VimEditor editor, VimCaret caret, String pattern, boolean gotQuit, int lastMatchLine, List<? extends ExException> exceptions) {
        if (!gotQuit) {
            if (lastMatchLine != -1) {
                caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, lastMatchLine));
            } else {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E486: Pattern not found: " + pattern);
            }
        }
        this.setLatestMatch("");
        if (!((Collection)exceptions).isEmpty()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, exceptions.get(0).toString());
        }
    }

    private final String evaluateExpression(String exprString, VimEditor editor, ExecutionContext context, VimLContext parent, List<ExException> exceptions) {
        String string;
        Expression expression = VimInjectorKt.getInjector().getVimscriptParser().parseExpression(exprString);
        if (expression == null) {
            exceptions.add(new ExException("E15: Invalid expression: " + exprString));
            string = "";
        } else {
            String string2;
            try {
                string2 = expression.evaluate(editor, context, parent).toInsertableString();
            }
            catch (Exception e) {
                Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ex.ExException");
                exceptions.add((ExException)e);
                string2 = "";
            }
            string = string2;
        }
        return string;
    }

    private final SubstituteCommandArguments parseSubstituteCommand(VimEditor editor, LineRange range, String excmd, String exarg) {
        Object object;
        int i;
        PatternType patternType = Intrinsics.areEqual((Object)"~", (Object)excmd) ? lastPatternType : PatternType.SUBSTITUTE;
        Object pattern = "";
        Object sub = null;
        char delimiter = '\u0000';
        int trailingOptionsStartIndex = 0;
        if (excmd.charAt(0) == 's' && ((CharSequence)exarg).length() > 0 && !CharsKt.isWhitespace((char)StringsKt.first((CharSequence)exarg)) && !StringsKt.contains$default((CharSequence)"0123456789cegriIp|\"", (char)StringsKt.first((CharSequence)exarg), (boolean)false, (int)2, null)) {
            if (Character.isLetter(StringsKt.first((CharSequence)exarg))) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E146: Regular expressions can't be delimited by letters");
                return null;
            }
            int substituteStringStartIndex = 0;
            if (StringsKt.first((CharSequence)exarg) == '\\') {
                if (exarg.length() < 2 || !StringsKt.contains$default((CharSequence)"/?&", (char)exarg.charAt(1), (boolean)false, (int)2, null)) {
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E10: \\ should be followed by /, ? or &");
                    return null;
                }
                if (exarg.charAt(1) != '&') {
                    patternType = PatternType.SEARCH;
                }
                delimiter = exarg.charAt(1);
                substituteStringStartIndex += 2;
            } else {
                patternType = lastPatternType;
                delimiter = StringsKt.first((CharSequence)exarg);
                int endOfPattern = this.findEndOfPattern(exarg, delimiter, 1);
                String string = exarg.substring(1, endOfPattern);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pattern = string;
                if (((CharSequence)pattern).length() == 0) {
                    pattern = null;
                }
                substituteStringStartIndex = endOfPattern;
                if (endOfPattern < exarg.length() && exarg.charAt(endOfPattern) == delimiter) {
                    ++substituteStringStartIndex;
                }
            }
            int substituteStringEndIndex = exarg.length();
            for (i = substituteStringStartIndex; i < exarg.length(); ++i) {
                if (exarg.charAt(i) == delimiter) {
                    substituteStringEndIndex = i;
                    break;
                }
                if (exarg.charAt(i) != '\\' || i + 1 >= exarg.length()) continue;
                ++i;
            }
            String string = exarg.substring(substituteStringStartIndex, substituteStringEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sub = string;
            trailingOptionsStartIndex = substituteStringEndIndex + 1;
        } else {
            if (lastSubstituteString == null) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E33: No previous substitute regular expression");
                return null;
            }
            pattern = null;
            String string = lastSubstituteString;
            Intrinsics.checkNotNull((Object)string);
            sub = string;
        }
        if (trailingOptionsStartIndex < exarg.length() && exarg.charAt(trailingOptionsStartIndex) == '&') {
            ++trailingOptionsStartIndex;
        } else {
            this.doAll = VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getGdefault();
            this.doAsk = false;
            this.doError = true;
            this.doIgnorecase = null;
        }
        int trailingOptionsEndIndex = trailingOptionsStartIndex;
        i = exarg.length();
        for (int i2 = trailingOptionsStartIndex; i2 < i; ++i2) {
            if (exarg.charAt(i2) == 'g') {
                this.doAll = !this.doAll;
            } else if (exarg.charAt(i2) == 'c') {
                this.doAsk = !this.doAsk;
            } else if (exarg.charAt(i2) == 'e') {
                this.doError = !this.doError;
            } else if (exarg.charAt(i2) == 'r') {
                patternType = lastPatternType;
            } else if (exarg.charAt(i2) == 'i') {
                this.doIgnorecase = true;
            } else if (exarg.charAt(i2) == 'I') {
                this.doIgnorecase = false;
            } else if (exarg.charAt(i2) != 'p' && exarg.charAt(i2) != 'l' && exarg.charAt(i2) != '#' && exarg.charAt(i2) != 'n') break;
            ++trailingOptionsEndIndex;
        }
        int line1 = range.startLine;
        int line2 = range.endLine;
        if (line1 < 0 || line2 < 0) {
            return null;
        }
        int n = exarg.length();
        for (int i3 = trailingOptionsEndIndex; i3 < n; ++i3) {
            if (!CharsKt.isWhitespace((char)exarg.charAt(i3))) continue;
            ++trailingOptionsEndIndex;
        }
        if (trailingOptionsEndIndex < exarg.length() && Character.isDigit(exarg.charAt(trailingOptionsEndIndex))) {
            int count = 0;
            while (trailingOptionsEndIndex < exarg.length() && Character.isDigit(exarg.charAt(trailingOptionsEndIndex))) {
                count = count * 10 + CharsKt.digitToInt((char)exarg.charAt(trailingOptionsEndIndex));
                ++trailingOptionsEndIndex;
            }
            if (count <= 0 && this.doError) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Zero count");
                return null;
            }
            line1 = line2;
            line2 = EngineEditorHelperKt.normalizeLine(editor, line1 + count - 1);
        }
        if (trailingOptionsEndIndex < exarg.length() && exarg.charAt(trailingOptionsEndIndex) != '\"') {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Trailing characters");
            return null;
        }
        if (trailingOptionsEndIndex < exarg.length() && exarg.charAt(trailingOptionsEndIndex) != '\"') {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Trailing characters");
            return null;
        }
        boolean isNewPattern = true;
        if (pattern == null) {
            String errorMessage;
            isNewPattern = false;
            PatternType patternType2 = patternType;
            switch (patternType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[patternType2.ordinal()]) {
                case 1: {
                    pattern = this.getLastSearchPattern();
                    String string = "E33: No previous substitute regular expression";
                    break;
                }
                case 2: {
                    pattern = this.getLastSubstitutePattern();
                    String string = "E35: No previous regular expression";
                    break;
                }
                default: {
                    String string = errorMessage = null;
                }
            }
            if (pattern == null) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, errorMessage);
                return null;
            }
        }
        this.setLastUsedPattern((String)pattern, PatternType.SUBSTITUTE, isNewPattern);
        lastReplaceString = sub;
        lastIgnoreSmartCase = false;
        Boolean bl = this.doIgnorecase;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            object = "\\c" + (String)pattern;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            object = "\\C" + (String)pattern;
        } else if (bl == null) {
            object = pattern;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        pattern = object;
        return new SubstituteCommandArguments((String)pattern, (String)sub, new LineRange(line1, line2));
    }

    private final void setLastUsedPattern(String pattern, PatternType patternType, boolean isNewPattern) {
        if (isNewPattern) {
            if (patternType == PatternType.SEARCH || patternType == PatternType.BOTH) {
                this.setLastSearchPattern(pattern);
                lastPatternType = PatternType.SEARCH;
            }
            if (patternType == PatternType.SUBSTITUTE || patternType == PatternType.BOTH) {
                this.setLastSubstitutePattern(pattern);
                lastPatternType = PatternType.SUBSTITUTE;
            }
        }
        VimInjectorKt.getInjector().getRegisterGroup().storeTextSpecial('/', pattern);
        VimInjectorKt.getInjector().getHistoryGroup().addEntry(HistoryConstants.SEARCH, pattern);
    }

    @Override
    @Nullable
    public Integer findDecimalNumber(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Regex regex = new Regex("\\d+");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getRange()) == null) {
            return null;
        }
        MatchResult range = matchResult;
        String string = line.substring(range.getFirst(), range.getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return Integer.parseInt(string);
    }

    @Override
    @NotNull
    public Direction getLastSearchDirection() {
        return lastDirection;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<Integer, MotionType> findItOffset(VimEditor editor, int startOffset, int count, Direction dir) {
        String pattern;
        CharSequence charSequence;
        MotionType motionType;
        ParsePosition pp;
        boolean hasEndOffset;
        boolean offsetIsLineOffset;
        int offset;
        int startOffsetMutable;
        block27: {
            NumberFormat nf;
            Number num;
            block29: {
                block30: {
                    block28: {
                        startOffsetMutable = startOffset;
                        offset = 0;
                        offsetIsLineOffset = false;
                        hasEndOffset = false;
                        pp = new ParsePosition(0);
                        String string = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string);
                        if (!(((CharSequence)string).length() > 0)) break block27;
                        String string2 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string2);
                        if (Character.isDigit(string2.charAt(0))) break block28;
                        String string3 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string3);
                        if (string3.charAt(0) == '+') break block28;
                        String string4 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string4);
                        if (string4.charAt(0) != '-') break block29;
                    }
                    offsetIsLineOffset = true;
                    if (!Intrinsics.areEqual((Object)lastPatternTrailing, (Object)"+")) break block30;
                    offset = 1;
                    break block27;
                }
                if (Intrinsics.areEqual((Object)lastPatternTrailing, (Object)"-")) {
                    offset = -1;
                    break block27;
                } else {
                    String string = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string);
                    if (string.charAt(0) == '+') {
                        String string5 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string5);
                        String string6 = string5.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        lastPatternTrailing = string6;
                    }
                    if ((num = (nf = NumberFormat.getIntegerInstance()).parse(lastPatternTrailing, pp = new ParsePosition(0))) != null) {
                        offset = num.intValue();
                    }
                }
                break block27;
            }
            CharSequence charSequence2 = "ebs";
            String string = lastPatternTrailing;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.indexOf$default((CharSequence)charSequence2, (char)string.charAt(0), (int)0, (boolean)false, (int)6, null) != -1) {
                String string7 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string7);
                if (string7.length() >= 2) {
                    CharSequence charSequence3 = "+-";
                    String string8 = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string8);
                    if (StringsKt.indexOf$default((CharSequence)charSequence3, (char)string8.charAt(1), (int)0, (boolean)false, (int)6, null) != -1) {
                        offset = 1;
                    }
                    nf = NumberFormat.getIntegerInstance();
                    String string9 = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string9);
                    pp = new ParsePosition(string9.charAt(1) == '+' ? 2 : 1);
                    num = nf.parse(lastPatternTrailing, pp);
                    if (num != null) {
                        offset = num.intValue();
                    }
                }
                String string10 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string10);
                hasEndOffset = string10.charAt(0) == 'e';
            }
        }
        MotionType motionType2 = offset != 0 && !hasEndOffset ? MotionType.LINE_WISE : (motionType = hasEndOffset ? MotionType.INCLUSIVE : MotionType.EXCLUSIVE);
        if (!offsetIsLineOffset && offset != 0) {
            startOffsetMutable = Math.max(0, Math.min(startOffsetMutable - offset, editor.text().length() - 1));
        }
        EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.SHOW_MESSAGES, (Enum)SearchOptions.WHOLE_FILE);
        if (dir == Direction.BACKWARDS) {
            searchOptions.add(SearchOptions.BACKWARDS);
        }
        if (lastIgnoreSmartCase) {
            searchOptions.add(SearchOptions.IGNORE_SMARTCASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getWrapscan()) {
            searchOptions.add(SearchOptions.WRAP);
        }
        if (hasEndOffset) {
            searchOptions.add(SearchOptions.WANT_ENDPOS);
        }
        if (!((charSequence = (CharSequence)(pattern = this.getLastUsedPattern())) == null || charSequence.length() == 0)) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, (dir == Direction.FORWARDS ? "/" : "?") + pattern);
        }
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, pattern, startOffsetMutable, count, searchOptions);
        if (textRange == null) {
            return null;
        }
        TextRange range = textRange;
        int res = range.getStartOffset();
        if (offsetIsLineOffset) {
            int line = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
            int newLine = EngineEditorHelperKt.normalizeLine(editor, line + offset);
            res = VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, newLine);
        } else if (hasEndOffset || offset != 0) {
            int base = hasEndOffset ? range.getEndOffset() - 1 : range.getStartOffset();
            res = Math.max(0, Math.min(base + offset, editor.text().length() - 1));
        }
        int ppos = pp.getIndex();
        String string = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string);
        if (ppos < string.length() - 1) {
            String string11 = lastPatternTrailing;
            Intrinsics.checkNotNull((Object)string11);
            if (string11.charAt(ppos) == ';') {
                Direction direction;
                String string12 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string12);
                if (string12.charAt(ppos + 1) == '/') {
                    direction = Direction.FORWARDS;
                } else {
                    String string13 = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string13);
                    if (string13.charAt(ppos + 1) == '?') {
                        direction = Direction.BACKWARDS;
                    } else {
                        if (res == -1) {
                            return null;
                        }
                        Pair pair = new Pair((Object)res, (Object)motionType);
                        return pair;
                    }
                }
                Direction nextDir = direction;
                String string14 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string14);
                if (string14.length() - ppos > 2) {
                    ++ppos;
                }
                String string15 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string15);
                String string16 = string15.substring(ppos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"substring(...)");
                Pair<Integer, MotionType> pair = this.processSearchCommand(editor, string16, res, 1, nextDir);
                if (pair == null) return null;
                int n = ((Number)pair.getFirst()).intValue();
                res = n;
            }
        }
        if (res == -1) {
            return null;
        }
        Pair pair = new Pair((Object)res, (Object)motionType);
        return pair;
    }

    @TestOnly
    public final void setLastSearchState(@NotNull String pattern, @NotNull String patternOffset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)patternOffset, (String)"patternOffset");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.setLastUsedPattern(pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = patternOffset;
        lastDirection = direction;
    }

    @TestOnly
    public void resetState() {
        lastPatternType = PatternType.SEARCH;
        this.setLastSubstitutePattern(null);
        this.setLastSearchPattern(null);
        lastPatternTrailing = "";
        lastIgnoreSmartCase = false;
        lastDirection = Direction.FORWARDS;
    }

    private static final Unit performReplace$lambda$0(VimEditor $editor, TextRange $matchRange, String $finalMatch) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$matchRange, (String)"$matchRange");
        Intrinsics.checkNotNullParameter((Object)$finalMatch, (String)"$finalMatch");
        ((MutableVimEditor)$editor).replaceString($matchRange.getStartOffset(), $matchRange.getEndOffset(), $finalMatch);
        return Unit.INSTANCE;
    }

    protected static final boolean getLastIgnoreSmartCase() {
        return Companion.getLastIgnoreSmartCase();
    }

    protected static final void setLastIgnoreSmartCase(boolean bl) {
        Companion.setLastIgnoreSmartCase(bl);
    }

    static {
        lastPatternTrailing = "";
        lastDirection = Direction.FORWARDS;
        Object[] objectArray = new String[]{"alnum:]", "alpha:]", "blank:]", "cntrl:]", "digit:]", "graph:]", "lower:]", "print:]", "punct:]", "space:]", "upper:]", "xdigit:]", "tab:]", "return:]", "backspace:]", "escape:]"};
        CLASS_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$Companion;", "", "<init>", "()V", "lastIgnoreSmartCase", "", "getLastIgnoreSmartCase$annotations", "getLastIgnoreSmartCase", "()Z", "setLastIgnoreSmartCase", "(Z)V", "lastPatternTrailing", "", "getLastPatternTrailing", "()Ljava/lang/String;", "setLastPatternTrailing", "(Ljava/lang/String;)V", "lastDirection", "Lcom/maddyhome/idea/vim/common/Direction;", "getLastDirection", "()Lcom/maddyhome/idea/vim/common/Direction;", "setLastDirection", "(Lcom/maddyhome/idea/vim/common/Direction;)V", "lastPatternType", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "getLastPatternType", "()Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "setLastPatternType", "(Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;)V", "lastSubstituteString", "lastReplaceString", "getLastReplaceString", "setLastReplaceString", "CLASS_NAMES", "", "vim-engine"})
    protected static final class Companion {
        private Companion() {
        }

        protected final boolean getLastIgnoreSmartCase() {
            return lastIgnoreSmartCase;
        }

        protected final void setLastIgnoreSmartCase(boolean bl) {
            lastIgnoreSmartCase = bl;
        }

        @JvmStatic
        protected static /* synthetic */ void getLastIgnoreSmartCase$annotations() {
        }

        @Nullable
        public final String getLastPatternTrailing() {
            return lastPatternTrailing;
        }

        public final void setLastPatternTrailing(@Nullable String string) {
            lastPatternTrailing = string;
        }

        @NotNull
        public final Direction getLastDirection() {
            return lastDirection;
        }

        public final void setLastDirection(@NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
            lastDirection = direction;
        }

        @Nullable
        public final PatternType getLastPatternType() {
            return lastPatternType;
        }

        public final void setLastPatternType(@Nullable PatternType patternType) {
            lastPatternType = patternType;
        }

        @Nullable
        public final String getLastReplaceString() {
            return lastReplaceString;
        }

        public final void setLastReplaceString(@Nullable String string) {
            lastReplaceString = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$GlobalCommandArguments;", "", "pattern", "Lcom/maddyhome/idea/vim/regexp/CharPointer;", "whichPattern", "", "command", "", "<init>", "(Lcom/maddyhome/idea/vim/regexp/CharPointer;ILjava/lang/String;)V", "getPattern", "()Lcom/maddyhome/idea/vim/regexp/CharPointer;", "getWhichPattern", "()I", "getCommand", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "vim-engine"})
    public static final class GlobalCommandArguments {
        @NotNull
        private final CharPointer pattern;
        private final int whichPattern;
        @NotNull
        private final String command;

        public GlobalCommandArguments(@NotNull CharPointer pattern, int whichPattern, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.pattern = pattern;
            this.whichPattern = whichPattern;
            this.command = command;
        }

        @NotNull
        public final CharPointer getPattern() {
            return this.pattern;
        }

        public final int getWhichPattern() {
            return this.whichPattern;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final CharPointer component1() {
            return this.pattern;
        }

        public final int component2() {
            return this.whichPattern;
        }

        @NotNull
        public final String component3() {
            return this.command;
        }

        @NotNull
        public final GlobalCommandArguments copy(@NotNull CharPointer pattern, int whichPattern, @NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return new GlobalCommandArguments(pattern, whichPattern, command);
        }

        public static /* synthetic */ GlobalCommandArguments copy$default(GlobalCommandArguments globalCommandArguments, CharPointer charPointer, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                charPointer = globalCommandArguments.pattern;
            }
            if ((n2 & 2) != 0) {
                n = globalCommandArguments.whichPattern;
            }
            if ((n2 & 4) != 0) {
                string = globalCommandArguments.command;
            }
            return globalCommandArguments.copy(charPointer, n, string);
        }

        @NotNull
        public String toString() {
            return "GlobalCommandArguments(pattern=" + this.pattern + ", whichPattern=" + this.whichPattern + ", command=" + this.command + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + Integer.hashCode(this.whichPattern);
            result = result * 31 + this.command.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GlobalCommandArguments)) {
                return false;
            }
            GlobalCommandArguments globalCommandArguments = (GlobalCommandArguments)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)globalCommandArguments.pattern)) {
                return false;
            }
            if (this.whichPattern != globalCommandArguments.whichPattern) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.command, (Object)globalCommandArguments.command);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "", "<init>", "(Ljava/lang/String;I)V", "SEARCH", "SUBSTITUTE", "BOTH", "vim-engine"})
    protected static final class PatternType
    extends Enum<PatternType> {
        public static final /* enum */ PatternType SEARCH = new PatternType();
        public static final /* enum */ PatternType SUBSTITUTE = new PatternType();
        public static final /* enum */ PatternType BOTH = new PatternType();
        private static final /* synthetic */ PatternType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PatternType[] values() {
            return (PatternType[])$VALUES.clone();
        }

        public static PatternType valueOf(String value) {
            return Enum.valueOf(PatternType.class, value);
        }

        @NotNull
        public static EnumEntries<PatternType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = patternTypeArray = new PatternType[]{PatternType.SEARCH, PatternType.SUBSTITUTE, PatternType.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceConfirmationChoice;", "", "<init>", "(Ljava/lang/String;I)V", "SUBSTITUTE_THIS", "SKIP", "SUBSTITUTE_ALL", "QUIT", "SUBSTITUTE_LAST", "vim-engine"})
    protected static final class ReplaceConfirmationChoice
    extends Enum<ReplaceConfirmationChoice> {
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_THIS = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SKIP = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_ALL = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice QUIT = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_LAST = new ReplaceConfirmationChoice();
        private static final /* synthetic */ ReplaceConfirmationChoice[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReplaceConfirmationChoice[] values() {
            return (ReplaceConfirmationChoice[])$VALUES.clone();
        }

        public static ReplaceConfirmationChoice valueOf(String value) {
            return Enum.valueOf(ReplaceConfirmationChoice.class, value);
        }

        @NotNull
        public static EnumEntries<ReplaceConfirmationChoice> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = replaceConfirmationChoiceArray = new ReplaceConfirmationChoice[]{ReplaceConfirmationChoice.SUBSTITUTE_THIS, ReplaceConfirmationChoice.SKIP, ReplaceConfirmationChoice.SUBSTITUTE_ALL, ReplaceConfirmationChoice.QUIT, ReplaceConfirmationChoice.SUBSTITUTE_LAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceResult;", "", "line", "", "column", "endLine", "<init>", "(III)V", "getLine", "()I", "getColumn", "getEndLine", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "vim-engine"})
    private static final class ReplaceResult {
        private final int line;
        private final int column;
        private final int endLine;

        public ReplaceResult(int line, int column, int endLine) {
            this.line = line;
            this.column = column;
            this.endLine = endLine;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getColumn() {
            return this.column;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        public final int component1() {
            return this.line;
        }

        public final int component2() {
            return this.column;
        }

        public final int component3() {
            return this.endLine;
        }

        @NotNull
        public final ReplaceResult copy(int line, int column, int endLine) {
            return new ReplaceResult(line, column, endLine);
        }

        public static /* synthetic */ ReplaceResult copy$default(ReplaceResult replaceResult, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = replaceResult.line;
            }
            if ((n4 & 2) != 0) {
                n2 = replaceResult.column;
            }
            if ((n4 & 4) != 0) {
                n3 = replaceResult.endLine;
            }
            return replaceResult.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ReplaceResult(line=" + this.line + ", column=" + this.column + ", endLine=" + this.endLine + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.line);
            result = result * 31 + Integer.hashCode(this.column);
            result = result * 31 + Integer.hashCode(this.endLine);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReplaceResult)) {
                return false;
            }
            ReplaceResult replaceResult = (ReplaceResult)other;
            if (this.line != replaceResult.line) {
                return false;
            }
            if (this.column != replaceResult.column) {
                return false;
            }
            return this.endLine == replaceResult.endLine;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b$\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "", "<init>", "()V", "remove", "", "vim-engine"})
    protected static abstract class SearchHighlight {
        public abstract void remove();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult;", "", "Skip", "Prepared", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult$Prepared;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult$Skip;", "vim-engine"})
    private static interface SubstitutePreparationResult {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult$Prepared;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult;", "match", "", "matchRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "newEndLine", "", "doReplace", "", "gotQuit", "<init>", "(Ljava/lang/String;Lcom/maddyhome/idea/vim/common/TextRange;IZZ)V", "getMatch", "()Ljava/lang/String;", "getMatchRange", "()Lcom/maddyhome/idea/vim/common/TextRange;", "getNewEndLine", "()I", "getDoReplace", "()Z", "getGotQuit", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "vim-engine"})
        public static final class Prepared
        implements SubstitutePreparationResult {
            @NotNull
            private final String match;
            @NotNull
            private final TextRange matchRange;
            private final int newEndLine;
            private final boolean doReplace;
            private final boolean gotQuit;

            public Prepared(@NotNull String match, @NotNull TextRange matchRange, int newEndLine, boolean doReplace, boolean gotQuit) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter((Object)matchRange, (String)"matchRange");
                this.match = match;
                this.matchRange = matchRange;
                this.newEndLine = newEndLine;
                this.doReplace = doReplace;
                this.gotQuit = gotQuit;
            }

            @NotNull
            public final String getMatch() {
                return this.match;
            }

            @NotNull
            public final TextRange getMatchRange() {
                return this.matchRange;
            }

            public final int getNewEndLine() {
                return this.newEndLine;
            }

            public final boolean getDoReplace() {
                return this.doReplace;
            }

            public final boolean getGotQuit() {
                return this.gotQuit;
            }

            @NotNull
            public final String component1() {
                return this.match;
            }

            @NotNull
            public final TextRange component2() {
                return this.matchRange;
            }

            public final int component3() {
                return this.newEndLine;
            }

            public final boolean component4() {
                return this.doReplace;
            }

            public final boolean component5() {
                return this.gotQuit;
            }

            @NotNull
            public final Prepared copy(@NotNull String match, @NotNull TextRange matchRange, int newEndLine, boolean doReplace, boolean gotQuit) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter((Object)matchRange, (String)"matchRange");
                return new Prepared(match, matchRange, newEndLine, doReplace, gotQuit);
            }

            public static /* synthetic */ Prepared copy$default(Prepared prepared, String string, TextRange textRange, int n, boolean bl, boolean bl2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = prepared.match;
                }
                if ((n2 & 2) != 0) {
                    textRange = prepared.matchRange;
                }
                if ((n2 & 4) != 0) {
                    n = prepared.newEndLine;
                }
                if ((n2 & 8) != 0) {
                    bl = prepared.doReplace;
                }
                if ((n2 & 0x10) != 0) {
                    bl2 = prepared.gotQuit;
                }
                return prepared.copy(string, textRange, n, bl, bl2);
            }

            @NotNull
            public String toString() {
                return "Prepared(match=" + this.match + ", matchRange=" + this.matchRange + ", newEndLine=" + this.newEndLine + ", doReplace=" + this.doReplace + ", gotQuit=" + this.gotQuit + ")";
            }

            public int hashCode() {
                int result = this.match.hashCode();
                result = result * 31 + this.matchRange.hashCode();
                result = result * 31 + Integer.hashCode(this.newEndLine);
                result = result * 31 + Boolean.hashCode(this.doReplace);
                result = result * 31 + Boolean.hashCode(this.gotQuit);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Prepared)) {
                    return false;
                }
                Prepared prepared = (Prepared)other;
                if (!Intrinsics.areEqual((Object)this.match, (Object)prepared.match)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.matchRange, (Object)prepared.matchRange)) {
                    return false;
                }
                if (this.newEndLine != prepared.newEndLine) {
                    return false;
                }
                if (this.doReplace != prepared.doReplace) {
                    return false;
                }
                return this.gotQuit == prepared.gotQuit;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult$Skip;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstitutePreparationResult;", "newLine", "", "newColumn", "<init>", "(II)V", "getNewLine", "()I", "getNewColumn", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "vim-engine"})
        public static final class Skip
        implements SubstitutePreparationResult {
            private final int newLine;
            private final int newColumn;

            public Skip(int newLine, int newColumn) {
                this.newLine = newLine;
                this.newColumn = newColumn;
            }

            public final int getNewLine() {
                return this.newLine;
            }

            public final int getNewColumn() {
                return this.newColumn;
            }

            public final int component1() {
                return this.newLine;
            }

            public final int component2() {
                return this.newColumn;
            }

            @NotNull
            public final Skip copy(int newLine, int newColumn) {
                return new Skip(newLine, newColumn);
            }

            public static /* synthetic */ Skip copy$default(Skip skip, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = skip.newLine;
                }
                if ((n3 & 2) != 0) {
                    n2 = skip.newColumn;
                }
                return skip.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Skip(newLine=" + this.newLine + ", newColumn=" + this.newColumn + ")";
            }

            public int hashCode() {
                int result = Integer.hashCode(this.newLine);
                result = result * 31 + Integer.hashCode(this.newColumn);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Skip)) {
                    return false;
                }
                Skip skip = (Skip)other;
                if (this.newLine != skip.newLine) {
                    return false;
                }
                return this.newColumn == skip.newColumn;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u009f\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\n\u0012\u0006\u0010\u0016\u001a\u00020\u000e\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\n\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0006\u0010\u001d\u001a\u00020\u000e\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0012\u0010I\u001a\u0004\u0018\u00010\u00022\u0006\u0010J\u001a\u00020KH\u0016J \u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020MH\u0002J\b\u0010R\u001a\u00020MH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010,\"\u0004\b0\u0010.R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00104R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010,\"\u0004\b9\u0010.R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u0019\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00104R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001a\u0010\u001d\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010,\"\u0004\b@\u0010.R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SubstituteWithAskInputInterceptor;", "Lcom/maddyhome/idea/vim/key/interceptors/VimInputInterceptorBase;", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceConfirmationChoice;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "nextSubstitute", "Lkotlin/Pair;", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult$Success;", "", "highlight", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "line", "", "column", "parent", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "pattern", "regex", "Lcom/maddyhome/idea/vim/regexp/VimRegex;", "oldLastSubstituteString", "endLine", "hasExpression", "", "substituteString", "options", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/regexp/VimRegexOptions;", "lastMatchLine", "exceptions", "", "Lcom/maddyhome/idea/vim/ex/ExException;", "<init>", "(Lcom/maddyhome/idea/vim/api/VimSearchGroupBase;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/VimCaret;Lkotlin/Pair;Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;IILcom/maddyhome/idea/vim/vimscript/model/VimLContext;Ljava/lang/String;Lcom/maddyhome/idea/vim/regexp/VimRegex;Ljava/lang/String;IZLjava/lang/String;Ljava/util/EnumSet;ILjava/util/List;)V", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "getCaret", "()Lcom/maddyhome/idea/vim/api/VimCaret;", "getNextSubstitute", "()Lkotlin/Pair;", "getHighlight", "()Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$SearchHighlight;", "getLine", "()I", "setLine", "(I)V", "getColumn", "setColumn", "getParent", "()Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getPattern", "()Ljava/lang/String;", "getRegex", "()Lcom/maddyhome/idea/vim/regexp/VimRegex;", "getOldLastSubstituteString", "getEndLine", "setEndLine", "getHasExpression", "()Z", "getSubstituteString", "getOptions", "()Ljava/util/EnumSet;", "getLastMatchLine", "setLastMatchLine", "getExceptions", "()Ljava/util/List;", "modalInput", "Lcom/maddyhome/idea/vim/api/VimModalInput;", "getModalInput", "()Lcom/maddyhome/idea/vim/api/VimModalInput;", "gotQuit", "doReplace", "buildInput", "key", "Ljavax/swing/KeyStroke;", "executeInput", "", "input", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "goToNextIteration", "afterAllSubstitutes", "vim-engine"})
    private final class SubstituteWithAskInputInterceptor
    extends VimInputInterceptorBase<ReplaceConfirmationChoice> {
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final VimCaret caret;
        @NotNull
        private final Pair<VimMatchResult.Success, String> nextSubstitute;
        @NotNull
        private final SearchHighlight highlight;
        private int line;
        private int column;
        @NotNull
        private final VimLContext parent;
        @NotNull
        private final String pattern;
        @NotNull
        private final VimRegex regex;
        @NotNull
        private final String oldLastSubstituteString;
        private int endLine;
        private final boolean hasExpression;
        @NotNull
        private final String substituteString;
        @NotNull
        private final EnumSet<VimRegexOptions> options;
        private int lastMatchLine;
        @NotNull
        private final List<ExException> exceptions;
        private boolean gotQuit;
        private boolean doReplace;

        public SubstituteWithAskInputInterceptor(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull Pair<VimMatchResult.Success, String> nextSubstitute, SearchHighlight highlight, int line, @NotNull int column, @NotNull VimLContext parent, @NotNull String pattern, @NotNull VimRegex regex, String oldLastSubstituteString, int endLine, @NotNull boolean hasExpression, @NotNull String substituteString, EnumSet<VimRegexOptions> options, @NotNull int lastMatchLine, List<ExException> exceptions) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter(nextSubstitute, (String)"nextSubstitute");
            Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            Intrinsics.checkNotNullParameter((Object)oldLastSubstituteString, (String)"oldLastSubstituteString");
            Intrinsics.checkNotNullParameter((Object)substituteString, (String)"substituteString");
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            this.editor = editor;
            this.caret = caret;
            this.nextSubstitute = nextSubstitute;
            this.highlight = highlight;
            this.line = line;
            this.column = column;
            this.parent = parent;
            this.pattern = pattern;
            this.regex = regex;
            this.oldLastSubstituteString = oldLastSubstituteString;
            this.endLine = endLine;
            this.hasExpression = hasExpression;
            this.substituteString = substituteString;
            this.options = options;
            this.lastMatchLine = lastMatchLine;
            this.exceptions = exceptions;
            this.doReplace = true;
        }

        @NotNull
        public final VimEditor getEditor() {
            return this.editor;
        }

        @NotNull
        public final VimCaret getCaret() {
            return this.caret;
        }

        @NotNull
        public final Pair<VimMatchResult.Success, String> getNextSubstitute() {
            return this.nextSubstitute;
        }

        @NotNull
        public final SearchHighlight getHighlight() {
            return this.highlight;
        }

        public final int getLine() {
            return this.line;
        }

        public final void setLine(int n) {
            this.line = n;
        }

        public final int getColumn() {
            return this.column;
        }

        public final void setColumn(int n) {
            this.column = n;
        }

        @NotNull
        public final VimLContext getParent() {
            return this.parent;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final VimRegex getRegex() {
            return this.regex;
        }

        @NotNull
        public final String getOldLastSubstituteString() {
            return this.oldLastSubstituteString;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        public final void setEndLine(int n) {
            this.endLine = n;
        }

        public final boolean getHasExpression() {
            return this.hasExpression;
        }

        @NotNull
        public final String getSubstituteString() {
            return this.substituteString;
        }

        @NotNull
        public final EnumSet<VimRegexOptions> getOptions() {
            return this.options;
        }

        public final int getLastMatchLine() {
            return this.lastMatchLine;
        }

        public final void setLastMatchLine(int n) {
            this.lastMatchLine = n;
        }

        @NotNull
        public final List<ExException> getExceptions() {
            return this.exceptions;
        }

        private final VimModalInput getModalInput() {
            VimModalInput vimModalInput = VimInjectorKt.getInjector().getModalInput().getCurrentModalInput();
            Intrinsics.checkNotNull((Object)vimModalInput);
            return vimModalInput;
        }

        @Override
        @Nullable
        public ReplaceConfirmationChoice buildInput(@NotNull KeyStroke key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (StringAndKeysKt.isCloseKeyStroke(key)) {
                return ReplaceConfirmationChoice.QUIT;
            }
            char c = key.getKeyChar();
            return c == 'q' ? ReplaceConfirmationChoice.QUIT : (c == 'y' ? ReplaceConfirmationChoice.SUBSTITUTE_THIS : (c == 'l' ? ReplaceConfirmationChoice.SUBSTITUTE_LAST : (c == 'n' ? ReplaceConfirmationChoice.SKIP : (c == 'a' ? ReplaceConfirmationChoice.SUBSTITUTE_ALL : null))));
        }

        @Override
        public void executeInput(@NotNull ReplaceConfirmationChoice input, @NotNull VimEditor editor, @NotNull ExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            VimInjectorKt.getInjector().getApplication().runWriteCommand(editor, "substitute-with-confirmation", this.getModalInput(), () -> SubstituteWithAskInputInterceptor.executeInput$lambda$0(this, editor, input, VimSearchGroupBase.this, context));
        }

        private final void goToNextIteration() {
            if (this.gotQuit) {
                this.afterAllSubstitutes();
                return;
            }
            Pair lineToNextSubstitute = VimSearchGroupBase.this.getNextSubstitute(this.editor, this.regex, this.oldLastSubstituteString, this.line, this.endLine, this.column, this.hasExpression, this.substituteString, this.options);
            if (lineToNextSubstitute == null) {
                this.afterAllSubstitutes();
            } else {
                TextRange matchRange = ((VimMatchResult.Success)((Pair)lineToNextSubstitute.getSecond()).getFirst()).getRange();
                this.caret.moveToOffset(matchRange.getStartOffset());
                SearchHighlight highlight = VimSearchGroupBase.this.addSubstitutionConfirmationHighlight(this.editor, matchRange.getStartOffset(), matchRange.getEndOffset());
                this.getModalInput().setInputInterceptor(new SubstituteWithAskInputInterceptor(this.editor, this.caret, (Pair<VimMatchResult.Success, String>)((Pair)lineToNextSubstitute.getSecond()), highlight, ((Number)lineToNextSubstitute.getFirst()).intValue(), this.column, this.parent, this.pattern, this.regex, this.oldLastSubstituteString, this.endLine, this.hasExpression, this.substituteString, this.options, this.lastMatchLine, this.exceptions));
            }
        }

        private final void afterAllSubstitutes() {
            VimSearchGroupBase.this.postSubstitute(this.editor, this.caret, this.pattern, this.gotQuit, this.lastMatchLine, this.exceptions);
            this.closeModalInputPrompt();
        }

        private static final void executeInput$lambda$0(SubstituteWithAskInputInterceptor this$0, VimEditor $editor, ReplaceConfirmationChoice $input, VimSearchGroupBase this$1, ExecutionContext $context) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
            Intrinsics.checkNotNullParameter((Object)((Object)$input), (String)"$input");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            this$0.highlight.remove();
            VimInjectorKt.getInjector().getJumpService().saveJumpLocation($editor);
            TextRange matchRange = ((VimMatchResult.Success)this$0.nextSubstitute.getFirst()).getRange();
            String match = (String)this$0.nextSubstitute.getSecond();
            switch (WhenMappings.$EnumSwitchMapping$0[$input.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this$0.doReplace = false;
                    break;
                }
                case 3: {
                    this$1.doAsk = false;
                    this$1.performSubstituteInLines($editor, this$0.caret, $context, this$0.parent, this$0.regex, this$0.pattern, this$0.oldLastSubstituteString, this$0.line, this$0.endLine, this$0.column, this$0.hasExpression, this$0.substituteString, this$0.exceptions, this$0.options);
                    this$0.closeModalInputPrompt();
                    return;
                }
                case 4: {
                    this$0.doReplace = false;
                    this$0.gotQuit = true;
                    break;
                }
                case 5: {
                    this$1.doAll = false;
                    this$0.endLine = this$0.line;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this$0.lastMatchLine = this$0.line;
            ReplaceResult replaceResult = this$1.performReplace($editor, this$0.caret, $context, this$0.parent, match, matchRange, this$0.doReplace, this$0.line, this$0.endLine, this$0.hasExpression, this$0.substituteString, this$0.exceptions);
            this$0.line = replaceResult.getLine();
            this$0.endLine = replaceResult.getEndLine();
            this$0.column = replaceResult.getColumn();
            this$0.goToNextIteration();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReplaceConfirmationChoice.values().length];
                try {
                    nArray[ReplaceConfirmationChoice.SUBSTITUTE_THIS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplaceConfirmationChoice.SKIP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplaceConfirmationChoice.SUBSTITUTE_ALL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplaceConfirmationChoice.QUIT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReplaceConfirmationChoice.SUBSTITUTE_LAST.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PatternType.values().length];
            try {
                nArray[PatternType.SEARCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatternType.SUBSTITUTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

