/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptFunctionService;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.vimscript.model.CommandLineVimLContext;
import com.maddyhome.idea.vim.vimscript.model.Script;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.expressions.Scope;
import com.maddyhome.idea.vim.vimscript.model.functions.DefinedFunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.FunctionHandler;
import com.maddyhome.idea.vim.vimscript.model.functions.LazyVimscriptFunction;
import com.maddyhome.idea.vim.vimscript.model.functions.VimscriptFunctionProvider;
import com.maddyhome.idea.vim.vimscript.model.statements.FunctionDeclaration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\"\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000eH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase;", "Lcom/maddyhome/idea/vim/api/VimscriptFunctionService;", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "functionProviders", "", "Lcom/maddyhome/idea/vim/vimscript/model/functions/VimscriptFunctionProvider;", "getFunctionProviders", "()Ljava/util/List;", "globalFunctions", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/statements/FunctionDeclaration;", "builtInFunctions", "Lcom/maddyhome/idea/vim/vimscript/model/functions/LazyVimscriptFunction;", "deleteFunction", "", "name", "scope", "Lcom/maddyhome/idea/vim/vimscript/model/expressions/Scope;", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "storeFunction", "declaration", "getFunctionHandler", "Lcom/maddyhome/idea/vim/vimscript/model/functions/FunctionHandler;", "getFunctionHandlerOrNull", "getUserDefinedFunction", "getBuiltInFunction", "storeScriptFunction", "functionDeclaration", "getScriptFunction", "deleteScriptFunction", "getDefaultFunctionScope", "registerHandlers", "addHandler", "handler", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimScriptFunctionServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimScriptFunctionServiceBase.kt\ncom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n38#2:172\n1863#3,2:173\n*S KotlinDebug\n*F\n+ 1 VimScriptFunctionServiceBase.kt\ncom/maddyhome/idea/vim/api/VimScriptFunctionServiceBase\n*L\n24#1:172\n165#1:173,2\n*E\n"})
public abstract class VimScriptFunctionServiceBase
implements VimscriptFunctionService {
    @NotNull
    private final VimLogger logger;
    @NotNull
    private final Map<String, FunctionDeclaration> globalFunctions;
    @NotNull
    private final Map<String, LazyVimscriptFunction> builtInFunctions;

    public VimScriptFunctionServiceBase() {
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(VimScriptFunctionServiceBase.class);
        this.globalFunctions = new LinkedHashMap();
        this.builtInFunctions = new LinkedHashMap();
    }

    @NotNull
    protected abstract List<VimscriptFunctionProvider> getFunctionProviders();

    @Override
    public void deleteFunction(@NotNull String name, @Nullable Scope scope, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        if (Character.isLowerCase(name.charAt(0)) && scope != Scope.SCRIPT_VARIABLE) {
            throw new ExException("E128: Function name must start with a capital or \"s:\": " + name);
        }
        if (scope != null) {
            Scope scope2 = scope;
            switch (WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
                case 1: {
                    if (this.globalFunctions.containsKey(name)) {
                        FunctionDeclaration functionDeclaration = this.globalFunctions.get(name);
                        Intrinsics.checkNotNull((Object)functionDeclaration);
                        functionDeclaration.setDeleted(true);
                        this.globalFunctions.remove(name);
                        return;
                    }
                    throw new ExException("E130: Unknown function: " + scope.getC() + ":" + name);
                }
                case 2: {
                    if (!(vimContext.getFirstParentContext() instanceof Script)) {
                        throw new ExException("E81: Using <SID> not in a script context");
                    }
                    if (this.getScriptFunction(name, vimContext) != null) {
                        this.deleteScriptFunction(name, vimContext);
                        return;
                    }
                    throw new ExException("E130: Unknown function: " + scope.getC() + ":" + name);
                }
            }
            throw new ExException("E130: Unknown function: " + scope.getC() + ":" + name);
        }
        if (this.globalFunctions.containsKey(name)) {
            FunctionDeclaration functionDeclaration = this.globalFunctions.get(name);
            Intrinsics.checkNotNull((Object)functionDeclaration);
            functionDeclaration.setDeleted(true);
            this.globalFunctions.remove(name);
            return;
        }
        VimLContext firstParentContext = vimContext.getFirstParentContext();
        if (firstParentContext instanceof Script && this.getScriptFunction(name, vimContext) != null) {
            this.deleteScriptFunction(name, vimContext);
            return;
        }
        throw new ExException("E130: Unknown function: " + name);
    }

    @Override
    public void storeFunction(@NotNull FunctionDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Scope scope = declaration.getScope();
        if (scope == null) {
            scope = this.getDefaultFunctionScope();
        }
        Scope scope2 = scope;
        switch (WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
            case 1: {
                if (this.globalFunctions.containsKey(declaration.getName()) && !declaration.getReplaceExisting()) {
                    throw new ExException("E122: Function " + declaration.getName() + " already exists, add ! to replace it");
                }
                this.globalFunctions.put(declaration.getName(), declaration);
                break;
            }
            case 2: {
                if (!(declaration.getFirstParentContext() instanceof Script)) {
                    throw new ExException("E81: Using <SID> not in a script context");
                }
                if (this.getScriptFunction(declaration.getName(), declaration) != null && !declaration.getReplaceExisting()) {
                    throw new ExException("E122: Function " + declaration.getName() + " already exists, add ! to replace it");
                }
                this.storeScriptFunction(declaration);
                break;
            }
            default: {
                throw new ExException("E884: Function name cannot contain a colon: " + scope2.getC() + ":" + declaration.getName());
            }
        }
    }

    @Override
    @NotNull
    public FunctionHandler getFunctionHandler(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        FunctionHandler functionHandler = this.getFunctionHandlerOrNull(scope, name, vimContext);
        if (functionHandler == null) {
            Object object = scope;
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            throw new ExException("E117: Unknown function: " + (String)object + name);
        }
        return functionHandler;
    }

    @Override
    @Nullable
    public FunctionHandler getFunctionHandlerOrNull(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        FunctionHandler builtInFunction;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        if (scope == null && (builtInFunction = this.getBuiltInFunction(name)) != null) {
            return builtInFunction;
        }
        FunctionDeclaration definedFunction = this.getUserDefinedFunction(scope, name, vimContext);
        if (definedFunction != null) {
            return new DefinedFunctionHandler(definedFunction);
        }
        return null;
    }

    @Override
    @Nullable
    public FunctionDeclaration getUserDefinedFunction(@Nullable Scope scope, @NotNull String name, @NotNull VimLContext vimContext) {
        FunctionDeclaration functionDeclaration;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vimContext, (String)"vimContext");
        Scope scope2 = scope;
        switch (scope2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scope2.ordinal()]) {
            case 1: {
                functionDeclaration = this.globalFunctions.get(name);
                break;
            }
            case 2: {
                functionDeclaration = this.getScriptFunction(name, vimContext);
                break;
            }
            case -1: {
                VimLContext firstParentContext;
                VimLContext vimLContext = firstParentContext = vimContext.getFirstParentContext();
                if (vimLContext instanceof CommandLineVimLContext) {
                    functionDeclaration = this.globalFunctions.get(name);
                    break;
                }
                if (vimLContext instanceof Script) {
                    functionDeclaration = this.globalFunctions.get(name);
                    if (functionDeclaration != null) break;
                    functionDeclaration = this.getScriptFunction(name, vimContext);
                    break;
                }
                throw new RuntimeException("Unknown parent context");
            }
            default: {
                functionDeclaration = null;
            }
        }
        return functionDeclaration;
    }

    @Override
    @Nullable
    public FunctionHandler getBuiltInFunction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LazyVimscriptFunction lazyVimscriptFunction = this.builtInFunctions.get(name);
        return lazyVimscriptFunction != null ? lazyVimscriptFunction.getInstance() : null;
    }

    private final void storeScriptFunction(FunctionDeclaration functionDeclaration) {
        Script script = functionDeclaration.getScript();
        if (script == null) {
            throw new ExException("E81: Using <SID> not in a script context");
        }
        Script script2 = script;
        script2.getScriptFunctions().put(functionDeclaration.getName(), functionDeclaration);
    }

    private final FunctionDeclaration getScriptFunction(String name, VimLContext vimContext) {
        Script script = vimContext.getScript();
        if (script == null) {
            throw new ExException("E120: Using <SID> not in a script context: s:" + name);
        }
        Script script2 = script;
        return script2.getScriptFunctions().get(name);
    }

    private final void deleteScriptFunction(String name, VimLContext vimContext) {
        Script script = vimContext.getScript();
        if (script == null) {
            throw new ExException("E81: Using <SID> not in a script context");
        }
        Script script2 = script;
        if (script2.getScriptFunctions().get(name) != null) {
            FunctionDeclaration functionDeclaration = script2.getScriptFunctions().get(name);
            Intrinsics.checkNotNull((Object)functionDeclaration);
            functionDeclaration.setDeleted(true);
        }
        script2.getScriptFunctions().remove(name);
    }

    private final Scope getDefaultFunctionScope() {
        return Scope.GLOBAL_VARIABLE;
    }

    @Override
    public void registerHandlers() {
        Iterable $this$forEach$iv = this.getFunctionProviders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimscriptFunctionProvider provider = (VimscriptFunctionProvider)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = provider.getFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LazyVimscriptFunction it = (LazyVimscriptFunction)element$iv2;
                boolean bl2 = false;
                this.addHandler(it);
            }
        }
    }

    @Override
    public void addHandler(@NotNull LazyVimscriptFunction handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.builtInFunctions.put(handler.getName(), handler);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.GLOBAL_VARIABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.SCRIPT_VARIABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

