/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.VimCommandLineCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.history.HistoryEntry;
import com.maddyhome.idea.vim.history.VimHistory;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u0000 F2\u00020\u0001:\u0001FJ\b\u0010(\u001a\u00020\u0005H&J\u001a\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00042\b\b\u0002\u00104\u001a\u00020\u0018H&J\u0018\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u0004H\u0016J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209H&J\u0010\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\tH\u0016J\b\u0010<\u001a\u00020\u0005H\u0016J\b\u0010=\u001a\u00020\u0005H&J\u0018\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\u0018H&J\u0018\u0010A\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u00182\u0006\u0010@\u001a\u00020\u0018H\u0016J\b\u0010B\u001a\u00020\u0005H&J\u0018\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020\u0018H\u0016R \u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0016R\u0012\u0010+\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0016R\u001a\u0010-\u001a\u0004\u0018\u00010\u001bX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006G\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/api/VimCommandLine;", "", "inputProcessing", "Lkotlin/Function1;", "", "", "getInputProcessing", "()Lkotlin/jvm/functions/Function1;", "finishOn", "", "getFinishOn", "()Ljava/lang/Character;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getEditor", "()Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCommandLineCaret;", "getCaret", "()Lcom/maddyhome/idea/vim/api/VimCommandLineCaret;", "label", "getLabel", "()Ljava/lang/String;", "isReplaceMode", "", "()Z", "histIndex", "", "getHistIndex", "()I", "setHistIndex", "(I)V", "lastEntry", "getLastEntry", "setLastEntry", "(Ljava/lang/String;)V", "historyType", "Lcom/maddyhome/idea/vim/history/VimHistory$Type;", "getHistoryType", "()Lcom/maddyhome/idea/vim/history/VimHistory$Type;", "toggleReplaceMode", "actualText", "getActualText", "visibleText", "getVisibleText", "promptCharacterOffset", "getPromptCharacterOffset", "()Ljava/lang/Integer;", "setPromptCharacterOffset", "(Ljava/lang/Integer;)V", "setText", "string", "updateLastEntry", "insertText", "offset", "handleKey", "key", "Ljavax/swing/KeyStroke;", "setPromptCharacter", "char", "clearPromptCharacter", "clearCurrentAction", "deactivate", "refocusOwningEditor", "resetCaret", "close", "focus", "selectHistory", "isUp", "filter", "Companion", "vim-engine"})
public interface VimCommandLine {
    @NotNull
    public static final Companion Companion = com.maddyhome.idea.vim.api.VimCommandLine$Companion.$$INSTANCE;

    @Nullable
    public Function1<String, Unit> getInputProcessing();

    @Nullable
    public Character getFinishOn();

    @NotNull
    public VimEditor getEditor();

    @NotNull
    public VimCommandLineCaret getCaret();

    @NotNull
    public String getLabel();

    public boolean isReplaceMode();

    public int getHistIndex();

    public void setHistIndex(int var1);

    @NotNull
    public String getLastEntry();

    public void setLastEntry(@NotNull String var1);

    @NotNull
    default public VimHistory.Type getHistoryType() {
        return VimHistory.Type.Companion.getTypeByLabel(this.getLabel());
    }

    public void toggleReplaceMode();

    @NotNull
    default public String getActualText() {
        String string;
        if (this.getPromptCharacterOffset() == null) {
            string = this.getVisibleText();
        } else {
            String string2 = this.getVisibleText();
            Integer n = this.getPromptCharacterOffset();
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = this.getPromptCharacterOffset();
            Intrinsics.checkNotNull((Object)n3);
            int n4 = n3 + 1;
            string = ((Object)StringsKt.removeRange((CharSequence)string2, (int)n2, (int)n4)).toString();
        }
        return string;
    }

    @NotNull
    public String getVisibleText();

    @Nullable
    public Integer getPromptCharacterOffset();

    public void setPromptCharacterOffset(@Nullable Integer var1);

    public void setText(@NotNull String var1, boolean var2);

    public static /* synthetic */ void setText$default(VimCommandLine vimCommandLine, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setText");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        vimCommandLine.setText(string, bl);
    }

    default public void insertText(int offset, @NotNull String string) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (this.isReplaceMode()) {
            int endOffset = Math.min(offset + string.length(), this.getActualText().length());
            stringBuilder = new StringBuilder(this.getActualText()).replace(offset, endOffset, string);
        } else {
            stringBuilder = new StringBuilder(this.getActualText()).insert(offset, string);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String newText = string2;
        VimCommandLine.setText$default(this, newText, false, 2, null);
    }

    public void handleKey(@NotNull KeyStroke var1);

    default public void setPromptCharacter(char c) {
        StringBuilder stringBuilder = new StringBuilder(this.getActualText());
        Integer n = this.getPromptCharacterOffset();
        int offset = n != null ? n.intValue() : this.getCaret().getOffset();
        this.setPromptCharacterOffset(offset);
        stringBuilder.insert(offset, c);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        VimCommandLine.setText$default(this, string, false, 2, null);
        this.getCaret().setOffset(offset);
    }

    default public void clearPromptCharacter() {
        if (this.getPromptCharacterOffset() == null) {
            return;
        }
        VimCommandLine.setText$default(this, this.getActualText(), false, 2, null);
        this.getCaret().setOffset(Math.min(this.getCaret().getOffset(), this.getVisibleText().length()));
        this.setPromptCharacterOffset(null);
    }

    public void clearCurrentAction();

    public void deactivate(boolean var1, boolean var2);

    default public void close(boolean refocusOwningEditor, boolean resetCaret) {
        this.getEditor().setMode(ModeExtensionsKt.returnTo(this.getEditor().getMode()));
        KeyHandler.Companion.getInstance().getKeyHandlerState().leaveCommandLine();
        this.deactivate(refocusOwningEditor, resetCaret);
    }

    public void focus();

    default public void selectHistory(boolean isUp, boolean filter) {
        int dir;
        List<HistoryEntry> history = VimInjectorKt.getInjector().getHistoryGroup().getEntries(this.getHistoryType(), 0, 0);
        int n = dir = isUp ? -1 : 1;
        if (this.getHistIndex() + dir < 0 || this.getHistIndex() + dir > history.size()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            return;
        }
        if (filter) {
            for (int i = this.getHistIndex() + dir; i >= 0 && i <= history.size(); i += dir) {
                String txt = null;
                if (i == history.size()) {
                    txt = this.getLastEntry();
                } else {
                    HistoryEntry entry = history.get(i);
                    txt = entry.getEntry();
                }
                if (!StringsKt.startsWith$default((String)txt, (String)this.getLastEntry(), (boolean)false, (int)2, null)) continue;
                this.setText(txt, false);
                this.getCaret().setOffset(txt.length());
                this.setHistIndex(i);
                return;
            }
            VimInjectorKt.getInjector().getMessages().indicateError();
        } else {
            this.setHistIndex(this.getHistIndex() + dir);
            String txt = null;
            if (this.getHistIndex() == history.size()) {
                txt = this.getLastEntry();
            } else {
                HistoryEntry entry = history.get(this.getHistIndex());
                txt = entry.getEntry();
            }
            this.setText(txt, false);
            this.getCaret().setOffset(txt.length());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/VimCommandLine$Companion;", "", "<init>", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVimCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimCommandLine.kt\ncom/maddyhome/idea/vim/api/VimCommandLine$Companion\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,168:1\n38#2:169\n*S KotlinDebug\n*F\n+ 1 VimCommandLine.kt\ncom/maddyhome/idea/vim/api/VimCommandLine$Companion\n*L\n29#1:169\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final VimLogger logger;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$vimLogger = false;
            logger = VimInjectorKt.getInjector().getLogger(VimCommandLine.class);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static VimHistory.Type getHistoryType(@NotNull VimCommandLine $this) {
            return $this.getHistoryType();
        }

        @Deprecated
        @NotNull
        public static String getActualText(@NotNull VimCommandLine $this) {
            return $this.getActualText();
        }

        public static /* synthetic */ void setText$default(VimCommandLine vimCommandLine, String string, boolean bl, int n, Object object) {
            VimCommandLine.setText$default(vimCommandLine, string, bl, n, object);
        }

        @Deprecated
        public static void insertText(@NotNull VimCommandLine $this, int offset, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            $this.insertText(offset, string);
        }

        @Deprecated
        public static void setPromptCharacter(@NotNull VimCommandLine $this, char c) {
            $this.setPromptCharacter(c);
        }

        @Deprecated
        public static void clearPromptCharacter(@NotNull VimCommandLine $this) {
            $this.clearPromptCharacter();
        }

        @Deprecated
        public static void close(@NotNull VimCommandLine $this, boolean refocusOwningEditor, boolean resetCaret) {
            $this.close(refocusOwningEditor, resetCaret);
        }

        @Deprecated
        public static void selectHistory(@NotNull VimCommandLine $this, boolean isUp, boolean filter) {
            $this.selectHistory(isUp, filter);
        }
    }
}

