/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.CaretRegisterStorage;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.register.Register;
import com.maddyhome.idea.vim.register.VimRegisterGroup;
import com.maddyhome.idea.vim.register.VimRegisterGroupBase;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0018\u0010'\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lcom/maddyhome/idea/vim/api/CaretRegisterStorageBase;", "Lcom/maddyhome/idea/vim/api/CaretRegisterStorage;", "Lcom/maddyhome/idea/vim/register/VimRegisterGroupBase;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "<init>", "(Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;)V", "getCaret", "()Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "setCaret", "_", "", "lastRegisterChar", "getLastRegisterChar", "()C", "setLastRegisterChar", "(C)V", "", "isRegisterSpecifiedExplicitly", "()Z", "setRegisterSpecifiedExplicitly", "(Z)V", "storeText", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "range", "Lcom/maddyhome/idea/vim/common/TextRange;", "type", "Lcom/maddyhome/idea/vim/state/mode/SelectionType;", "isDelete", "getRegister", "Lcom/maddyhome/idea/vim/register/Register;", "r", "setKeys", "", "register", "keys", "", "Ljavax/swing/KeyStroke;", "saveRegister", "Companion", "vim-engine"})
public class CaretRegisterStorageBase
extends VimRegisterGroupBase
implements CaretRegisterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ImmutableVimCaret caret;
    @NotNull
    private static final String ALLOWED_TO_STORE_REGISTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"-_./";

    public CaretRegisterStorageBase(@NotNull ImmutableVimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        this.caret = caret;
    }

    @Override
    @NotNull
    public ImmutableVimCaret getCaret() {
        return this.caret;
    }

    public void setCaret(@NotNull ImmutableVimCaret immutableVimCaret) {
        Intrinsics.checkNotNullParameter((Object)immutableVimCaret, (String)"<set-?>");
        this.caret = immutableVimCaret;
    }

    @Override
    public char getLastRegisterChar() {
        return VimInjectorKt.getInjector().getRegisterGroup().getLastRegisterChar();
    }

    @Override
    public void setLastRegisterChar(char c) {
    }

    @Override
    public boolean isRegisterSpecifiedExplicitly() {
        return VimInjectorKt.getInjector().getRegisterGroup().isRegisterSpecifiedExplicitly();
    }

    @Override
    public void setRegisterSpecifiedExplicitly(boolean bl) {
    }

    @Override
    public boolean storeText(@NotNull VimEditor editor, @NotNull TextRange range, @NotNull SelectionType type, boolean isDelete) {
        char registerChar;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        char c = registerChar = this.getCaret().getEditor().carets().size() == 1 ? this.getCurrentRegister() : this.getCurrentRegisterForMulticaret();
        if (this.getCaret().isPrimary()) {
            VimRegisterGroup registerService = VimInjectorKt.getInjector().getRegisterGroup();
            registerService.setLastRegisterChar(registerChar);
            return registerService.storeText(editor, this.getCaret(), range, type, isDelete);
        }
        if (!StringsKt.contains$default((CharSequence)ALLOWED_TO_STORE_REGISTERS, (char)registerChar, (boolean)false, (int)2, null)) {
            return false;
        }
        String text = this.preprocessTextBeforeStoring(EngineEditorHelperKt.getText(editor, range), type);
        return this.storeTextInternal(editor, this.getCaret(), range, text, type, registerChar, isDelete);
    }

    @Override
    @Nullable
    public Register getRegister(char r) {
        if (this.getCaret().isPrimary() || !StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"", (char)r, (boolean)false, (int)2, null)) {
            return VimInjectorKt.getInjector().getRegisterGroup().getRegister(r);
        }
        Register register = super.getRegister(r);
        if (register == null) {
            register = VimInjectorKt.getInjector().getRegisterGroup().getRegister(r);
        }
        return register;
    }

    @Override
    public void setKeys(char register, @NotNull List<? extends KeyStroke> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (this.getCaret().isPrimary()) {
            VimInjectorKt.getInjector().getRegisterGroup().setKeys(register, keys);
        }
        if (!StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"", (char)register, (boolean)false, (int)2, null)) {
            return;
        }
        super.setKeys(register, keys);
    }

    @Override
    public void saveRegister(char r, @NotNull Register register) {
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        if (this.getCaret().isPrimary()) {
            VimInjectorKt.getInjector().getRegisterGroup().saveRegister(r, register);
        }
        if (!StringsKt.contains$default((CharSequence)"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\"", (char)r, (boolean)false, (int)2, null)) {
            return;
        }
        super.saveRegister(r, register);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/api/CaretRegisterStorageBase$Companion;", "", "<init>", "()V", "ALLOWED_TO_STORE_REGISTERS", "", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

