/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.action.ex;

import com.maddyhome.idea.vim.action.ex.ProcessExEntryAction;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.MotionType;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.handler.Motion;
import com.maddyhome.idea.vim.handler.MotionActionHandler;
import com.maddyhome.idea.vim.handler.MotionKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/action/ex/ProcessSearchEntryAction;", "Lcom/maddyhome/idea/vim/handler/MotionActionHandler$ForEachCaret;", "parentAction", "Lcom/maddyhome/idea/vim/action/ex/ProcessExEntryAction;", "<init>", "(Lcom/maddyhome/idea/vim/action/ex/ProcessExEntryAction;)V", "motionType", "Lcom/maddyhome/idea/vim/command/MotionType;", "getMotionType", "()Lcom/maddyhome/idea/vim/command/MotionType;", "getOffset", "Lcom/maddyhome/idea/vim/handler/Motion;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "argument", "Lcom/maddyhome/idea/vim/command/Argument;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
public final class ProcessSearchEntryAction
extends MotionActionHandler.ForEachCaret {
    @NotNull
    private final ProcessExEntryAction parentAction;

    public ProcessSearchEntryAction(@NotNull ProcessExEntryAction parentAction) {
        Intrinsics.checkNotNullParameter((Object)parentAction, (String)"parentAction");
        this.parentAction = parentAction;
    }

    @Override
    @NotNull
    public MotionType getMotionType() {
        throw new RuntimeException("Parent motion type should be used, as only it is accessed by other code");
    }

    @Override
    @NotNull
    public Motion getOffset(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, @NotNull ExecutionContext context, @Nullable Argument argument, @NotNull OperatorArguments operatorArguments) {
        Pair<Integer, MotionType> pair;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (argument == null) {
            return Motion.Error.INSTANCE;
        }
        char c = argument.getCharacter();
        if (c == '/') {
            pair = VimInjectorKt.getInjector().getSearchGroup().processSearchCommand(editor, argument.getString(), caret.getOffset(), operatorArguments.getCount1(), Direction.FORWARDS);
        } else if (c == '?') {
            pair = VimInjectorKt.getInjector().getSearchGroup().processSearchCommand(editor, argument.getString(), caret.getOffset(), operatorArguments.getCount1(), Direction.BACKWARDS);
        } else {
            throw new ExException("Unexpected search label " + argument.getCharacter());
        }
        Pair<Integer, MotionType> offsetAndMotion = pair;
        if (offsetAndMotion == null) {
            return Motion.NoMotion.INSTANCE;
        }
        this.parentAction.setMotionType((MotionType)((Object)offsetAndMotion.getSecond()));
        return MotionKt.toMotionOrError(((Number)offsetAndMotion.getFirst()).intValue());
    }
}

