/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.caches;

import androidx.compose.ui.text.caches.ContainerHelpersKt;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\"\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0013\b\u0017\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001f\b\u0016\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0005H\u0004J\b\u0010\u0019\u001a\u00020\u0005H\u0004J\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0005J\u0013\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\u0017\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010&\u001a\u00020\u001f2\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010 J\u0018\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010(J\u001b\u0010)\u001a\u00028\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010*\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00020\u0005\u00a2\u0006\u0002\u0010.J\u0013\u0010/\u001a\u00028\u00012\u0006\u0010-\u001a\u00020\u0005\u00a2\u0006\u0002\u0010.J\u001b\u00100\u001a\u00028\u00012\u0006\u0010-\u001a\u00020\u00052\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020\u001fJ\u001d\u00103\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J\u001e\u00104\u001a\u00020\u001b2\u0016\u00105\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0000J\u001d\u00106\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J\u0015\u00107\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010(J\u001b\u00107\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u00108J\u0015\u00109\u001a\u0004\u0018\u00018\u00012\u0006\u0010-\u001a\u00020\u0005\u00a2\u0006\u0002\u0010.J\u001d\u0010:\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J#\u0010:\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010;\u001a\u00028\u00012\u0006\u0010<\u001a\u00028\u0001\u00a2\u0006\u0002\u0010=J\u0013\u0010>\u001a\u00020\u001f2\b\u0010?\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010@\u001a\u00020\u0005H\u0016J\b\u0010A\u001a\u00020BH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0007R\u0017\u0010\u0013\u001a\u00020\u00058G\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006C"}, d2={"Landroidx/compose/ui/text/caches/SimpleArrayMap;", "K", "V", "", "capacity", "", "<init>", "(I)V", "map", "(Landroidx/compose/ui/text/caches/SimpleArrayMap;)V", "hashes", "", "keyValues", "", "[Ljava/lang/Object;", "_size", "get_size", "()I", "set_size", "size", "size$annotations", "()V", "indexOf", "key", "hash", "indexOfNull", "clear", "", "ensureCapacity", "minimumCapacity", "containsKey", "", "(Ljava/lang/Object;)Z", "indexOfKey", "indexOfValue", "value", "indexOfValue$fleet_noria_ui", "(Ljava/lang/Object;)I", "containsValue", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "keyAt", "index", "(I)Ljava/lang/Object;", "valueAt", "setValueAt", "(ILjava/lang/Object;)Ljava/lang/Object;", "isEmpty", "put", "putAll", "array", "putIfAbsent", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeAt", "replace", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "equals", "other", "hashCode", "toString", "", "fleet.noria.ui"})
public final class SimpleArrayMap<K, V> {
    @NotNull
    private int[] hashes;
    @NotNull
    private Object[] keyValues;
    private int _size;

    protected final int get_size() {
        return this._size;
    }

    protected final void set_size(int n) {
        this._size = n;
    }

    @JvmName(name="size")
    public final int size() {
        return this._size;
    }

    public static /* synthetic */ void size$annotations() {
    }

    protected final int indexOf(@NotNull Object key, int hash) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearchInternal(this.hashes, N, hash);
        if (index2 < 0) {
            return index2;
        }
        if (Intrinsics.areEqual((Object)key, (Object)this.keyValues[index2 << 1])) {
            return index2;
        }
        int end2 = 0;
        for (end2 = index2 + 1; end2 < N && this.hashes[end2] == hash; ++end2) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[end2 << 1])) continue;
            return end2;
        }
        for (int i = index2 - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual((Object)key, (Object)this.keyValues[i << 1])) continue;
            return i;
        }
        return ~end2;
    }

    protected final int indexOfNull() {
        int N = this._size;
        if (N == 0) {
            return -1;
        }
        int index2 = ContainerHelpersKt.binarySearchInternal(this.hashes, N, 0);
        if (index2 < 0) {
            return index2;
        }
        if (this.keyValues[index2 << 1] == null) {
            return index2;
        }
        int end2 = 0;
        for (end2 = index2 + 1; end2 < N && this.hashes[end2] == 0; ++end2) {
            if (this.keyValues[end2 << 1] != null) continue;
            return end2;
        }
        for (int i = index2 - 1; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.keyValues[i << 1] != null) continue;
            return i;
        }
        return ~end2;
    }

    @JvmOverloads
    public SimpleArrayMap(int capacity) {
        if (capacity == 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
        } else {
            this.hashes = new int[capacity];
            this.keyValues = new Object[capacity << 1];
        }
        this._size = 0;
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public SimpleArrayMap(@Nullable SimpleArrayMap<K, V> map) {
        this(0, 1, null);
        if (map != null) {
            this.putAll(map);
        }
    }

    public final void clear() {
        if (this._size > 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.keyValues = ContainerHelpersKt.EMPTY_OBJECTS;
            this._size = 0;
        }
        if (this._size > 0) {
            throw new ConcurrentModificationException();
        }
    }

    public final void ensureCapacity(int minimumCapacity) {
        int osize = this._size;
        if (this.hashes.length < minimumCapacity) {
            int[] nArray = Arrays.copyOf(this.hashes, minimumCapacity);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.keyValues, minimumCapacity << 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.keyValues = objectArray;
        }
        if (this._size != osize) {
            throw new ConcurrentModificationException();
        }
    }

    public final boolean containsKey(K key) {
        return this.indexOfKey(key) >= 0;
    }

    public final int indexOfKey(@Nullable Object key) {
        Object object = key;
        return object == null ? this.indexOfNull() : this.indexOf(object, key.hashCode());
    }

    public final int indexOfValue$fleet_noria_ui(V value2) {
        int N = this._size << 1;
        Object[] array = this.keyValues;
        if (value2 == null) {
            for (int i = 1; i < N; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!Intrinsics.areEqual(value2, (Object)array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    public final boolean containsValue(V value2) {
        return this.indexOfValue$fleet_noria_ui(value2) >= 0;
    }

    @Nullable
    public final V get(K key) {
        int index2 = this.indexOfKey(key);
        return (V)(index2 >= 0 ? this.keyValues[(index2 << 1) + 1] : null);
    }

    public final V getOrDefault(K key, V defaultValue) {
        int index2 = this.indexOfKey(key);
        return (V)(index2 >= 0 ? this.keyValues[(index2 << 1) + 1] : defaultValue);
    }

    public final K keyAt(int index2) {
        return (K)this.keyValues[index2 << 1];
    }

    public final V valueAt(int index2) {
        return (V)this.keyValues[(index2 << 1) + 1];
    }

    public final V setValueAt(int index2, V value2) {
        int actualIndex = (index2 << 1) + 1;
        Object old = this.keyValues[actualIndex];
        this.keyValues[actualIndex] = value2;
        return (V)old;
    }

    public final boolean isEmpty() {
        return this._size <= 0;
    }

    @Nullable
    public final V put(K key, V value2) {
        int osize = this._size;
        int hash = 0;
        int index2 = 0;
        if (key == null) {
            hash = 0;
            index2 = this.indexOfNull();
        } else {
            hash = key.hashCode();
            index2 = this.indexOf(key, hash);
        }
        if (index2 >= 0) {
            index2 = (index2 << 1) + 1;
            Object old = this.keyValues[index2];
            this.keyValues[index2] = value2;
            return (V)old;
        }
        index2 ^= 0xFFFFFFFF;
        if (osize >= this.hashes.length) {
            int n = osize >= 8 ? osize + (osize >> 1) : (osize >= 4 ? 8 : 4);
            int[] nArray = Arrays.copyOf(this.hashes, n);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.keyValues, n << 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.keyValues = objectArray;
            if (osize != this._size) {
                throw new ConcurrentModificationException();
            }
        }
        if (index2 < osize) {
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(index2 + 1), (int)index2, (int)osize);
            ArraysKt.copyInto((Object[])this.keyValues, (Object[])this.keyValues, (int)(index2 + 1 << 1), (int)(index2 << 1), (int)(this._size << 1));
        }
        if (osize != this._size || index2 >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index2] = hash;
        this.keyValues[index2 << 1] = key;
        this.keyValues[(index2 << 1) + 1] = value2;
        int n = this._size;
        this._size = n + 1;
        return null;
    }

    public final void putAll(@NotNull SimpleArrayMap<? extends K, ? extends V> array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        int N = array._size;
        this.ensureCapacity(this._size + N);
        if (this._size == 0) {
            if (N > 0) {
                ArraysKt.copyInto((int[])array.hashes, (int[])this.hashes, (int)0, (int)0, (int)N);
                ArraysKt.copyInto((Object[])array.keyValues, (Object[])this.keyValues, (int)0, (int)0, (int)(N << 1));
                this._size = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.put(array.keyAt(i), array.valueAt(i));
            }
        }
    }

    @Nullable
    public final V putIfAbsent(K key, V value2) {
        V mapValue = this.get(key);
        if (mapValue == null) {
            mapValue = this.put(key, value2);
        }
        return mapValue;
    }

    @Nullable
    public final V remove(K key) {
        int index2 = this.indexOfKey(key);
        return index2 >= 0 ? (V)this.removeAt(index2) : null;
    }

    public final boolean remove(K key, V value2) {
        V mapValue;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0 && Intrinsics.areEqual(value2, mapValue = this.valueAt(index2))) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    @Nullable
    public final V removeAt(int index2) {
        Object old = this.keyValues[(index2 << 1) + 1];
        int osize = this._size;
        if (osize <= 1) {
            this.clear();
        } else {
            int nsize = osize - 1;
            if (this.hashes.length > 8 && osize < this.hashes.length / 3) {
                int n = osize > 8 ? osize + (osize >> 1) : 8;
                int[] ohashes = this.hashes;
                Object[] oarray = this.keyValues;
                this.hashes = new int[n];
                this.keyValues = new Object[n << 1];
                if (osize != this._size) {
                    throw new ConcurrentModificationException();
                }
                if (index2 > 0) {
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)index2);
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.keyValues, (int)0, (int)0, (int)(index2 << 1));
                }
                if (index2 < nsize) {
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)index2, (int)(index2 + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.keyValues, (int)(index2 << 1), (int)(index2 + 1 << 1), (int)(nsize + 1 << 1));
                }
            } else {
                if (index2 < nsize) {
                    ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)index2, (int)(index2 + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])this.keyValues, (Object[])this.keyValues, (int)(index2 << 1), (int)(index2 + 1 << 1), (int)(nsize + 1 << 1));
                }
                this.keyValues[nsize << 1] = null;
                this.keyValues[(nsize << 1) + 1] = null;
            }
            if (osize != this._size) {
                throw new ConcurrentModificationException();
            }
            this._size = nsize;
        }
        return (V)old;
    }

    @Nullable
    public final V replace(K key, V value2) {
        int index2 = this.indexOfKey(key);
        return index2 >= 0 ? (V)this.setValueAt(index2, value2) : null;
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        V mapValue;
        int index2 = this.indexOfKey(key);
        if (index2 >= 0 && (mapValue = this.valueAt(index2)) == oldValue) {
            this.setValueAt(index2, newValue);
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        try {
            if (other instanceof SimpleArrayMap) {
                SimpleArrayMap map = (SimpleArrayMap)other;
                if (this._size != map._size) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    V theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
            if (other instanceof Map) {
                Object map = other;
                if (this._size != ((Map)map).size()) {
                    return false;
                }
                int n = this._size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)map).get(key);
                    if (!(mine == null ? theirs != null || !((Map)map).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        int[] hashes = this.hashes;
        Object[] array = this.keyValues;
        int result2 = 0;
        int i = 0;
        int v = 1;
        int s = this._size;
        while (i < s) {
            Object value2 = array[v];
            Object object = value2;
            result2 += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return result2;
    }

    @NotNull
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this._size * 28);
        buffer.append('{');
        int n = this._size;
        for (int i = 0; i < n; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            StringBuilder stringBuilder = (key = this.keyAt(i)) != this ? buffer.append(key) : buffer.append("(this Map)");
            buffer.append('=');
            V value2 = this.valueAt(i);
            StringBuilder stringBuilder2 = value2 != this ? buffer.append(value2) : buffer.append("(this Map)");
        }
        buffer.append('}');
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1, null);
    }
}

