/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.layout;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import noria.ui.node.NoriaLayoutCoordinates;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u000f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\u000f\u0010\b\u001a\u00020\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\n\u0010\t\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0002*\u00020\u0002\u00a8\u0006\u000b"}, d2={"positionInRoot", "Landroidx/compose/ui/geometry/Offset;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "(Landroidx/compose/ui/layout/LayoutCoordinates;)J", "positionInWindow", "boundsInRoot", "Landroidx/compose/ui/geometry/Rect;", "boundsInWindow", "positionInParent", "boundsInParent", "findRootCoordinates", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nLayoutCoordinates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutCoordinates.kt\nandroidx/compose/ui/layout/LayoutCoordinatesKt\n+ 2 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n*L\n1#1,197:1\n157#2:198\n*S KotlinDebug\n*F\n+ 1 LayoutCoordinates.kt\nandroidx/compose/ui/layout/LayoutCoordinatesKt\n*L\n161#1:198\n*E\n"})
public final class LayoutCoordinatesKt {
    public static final long positionInRoot(@NotNull LayoutCoordinates $this$positionInRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInRoot, (String)"<this>");
        return $this$positionInRoot.localToRoot-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    public static final long positionInWindow(@NotNull LayoutCoordinates $this$positionInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInWindow, (String)"<this>");
        return $this$positionInWindow.localToWindow-MK-Hz9U(Offset.Companion.getZero-F1C5BW0());
    }

    @NotNull
    public static final Rect boundsInRoot(@NotNull LayoutCoordinates $this$boundsInRoot) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInRoot, (String)"<this>");
        return LayoutCoordinates.DefaultImpls.localBoundingBoxOf$default(LayoutCoordinatesKt.findRootCoordinates($this$boundsInRoot), $this$boundsInRoot, false, 2, null);
    }

    @NotNull
    public static final Rect boundsInWindow(@NotNull LayoutCoordinates $this$boundsInWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInWindow, (String)"<this>");
        LayoutCoordinates root2 = LayoutCoordinatesKt.findRootCoordinates($this$boundsInWindow);
        Rect bounds2 = LayoutCoordinatesKt.boundsInRoot($this$boundsInWindow);
        float rootWidth = IntSize.getWidth-impl(root2.getSize-YbymL2g());
        float rootHeight = IntSize.getHeight-impl(root2.getSize-YbymL2g());
        float boundsLeft = RangesKt.coerceIn((float)bounds2.getLeft(), (float)0.0f, (float)rootWidth);
        float boundsTop = RangesKt.coerceIn((float)bounds2.getTop(), (float)0.0f, (float)rootHeight);
        float boundsRight = RangesKt.coerceIn((float)bounds2.getRight(), (float)0.0f, (float)rootWidth);
        float boundsBottom = RangesKt.coerceIn((float)bounds2.getBottom(), (float)0.0f, (float)rootHeight);
        if (boundsLeft == boundsRight || boundsTop == boundsBottom) {
            return Rect.Companion.getZero();
        }
        long topLeft = root2.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsLeft, boundsTop));
        long topRight = root2.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsRight, boundsTop));
        long bottomRight = root2.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsRight, boundsBottom));
        long bottomLeft = root2.localToWindow-MK-Hz9U(OffsetKt.Offset(boundsLeft, boundsBottom));
        float[] fArray = new float[]{Offset.getX-impl(topRight), Offset.getX-impl(bottomLeft), Offset.getX-impl(bottomRight)};
        float left2 = ComparisonsKt.minOf((float)Offset.getX-impl(topLeft), (float[])fArray);
        float[] fArray2 = new float[]{Offset.getY-impl(topRight), Offset.getY-impl(bottomLeft), Offset.getY-impl(bottomRight)};
        float top = ComparisonsKt.minOf((float)Offset.getY-impl(topLeft), (float[])fArray2);
        float[] fArray3 = new float[]{Offset.getX-impl(topRight), Offset.getX-impl(bottomLeft), Offset.getX-impl(bottomRight)};
        float right2 = ComparisonsKt.maxOf((float)Offset.getX-impl(topLeft), (float[])fArray3);
        float[] fArray4 = new float[]{Offset.getY-impl(topRight), Offset.getY-impl(bottomLeft), Offset.getY-impl(bottomRight)};
        float bottom = ComparisonsKt.maxOf((float)Offset.getY-impl(topLeft), (float[])fArray4);
        return new Rect(left2, top, right2, bottom);
    }

    public static final long positionInParent(@NotNull LayoutCoordinates $this$positionInParent) {
        Intrinsics.checkNotNullParameter((Object)$this$positionInParent, (String)"<this>");
        long $this$toOffset_u2d_u2dgyyYBs$iv = ((NoriaLayoutCoordinates)$this$positionInParent).getPosition-nOcc-ac();
        boolean bl = false;
        return OffsetKt.Offset(IntOffset.getX-impl($this$toOffset_u2d_u2dgyyYBs$iv), IntOffset.getY-impl($this$toOffset_u2d_u2dgyyYBs$iv));
    }

    @NotNull
    public static final Rect boundsInParent(@NotNull LayoutCoordinates $this$boundsInParent) {
        Intrinsics.checkNotNullParameter((Object)$this$boundsInParent, (String)"<this>");
        Object object = $this$boundsInParent.getParentLayoutCoordinates();
        if (object == null || (object = LayoutCoordinates.DefaultImpls.localBoundingBoxOf$default((LayoutCoordinates)object, $this$boundsInParent, false, 2, null)) == null) {
            object = new Rect(0.0f, 0.0f, IntSize.getWidth-impl($this$boundsInParent.getSize-YbymL2g()), IntSize.getHeight-impl($this$boundsInParent.getSize-YbymL2g()));
        }
        return object;
    }

    @NotNull
    public static final LayoutCoordinates findRootCoordinates(@NotNull LayoutCoordinates $this$findRootCoordinates) {
        Intrinsics.checkNotNullParameter((Object)$this$findRootCoordinates, (String)"<this>");
        LayoutCoordinates root2 = $this$findRootCoordinates;
        LayoutCoordinates parent = root2.getParentLayoutCoordinates();
        while (parent != null) {
            root2 = parent;
            parent = root2.getParentLayoutCoordinates();
        }
        return root2;
    }
}

