/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.layout;

import androidx.compose.ui.layout.FixedSizeIntrinsicsPlaceable;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMinMax;
import androidx.compose.ui.layout.IntrinsicWidthHeight;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Landroidx/compose/ui/layout/DefaultIntrinsicMeasurable;", "Landroidx/compose/ui/layout/Measurable;", "measurable", "Landroidx/compose/ui/layout/IntrinsicMeasurable;", "minMax", "Landroidx/compose/ui/layout/IntrinsicMinMax;", "widthHeight", "Landroidx/compose/ui/layout/IntrinsicWidthHeight;", "<init>", "(Landroidx/compose/ui/layout/IntrinsicMeasurable;Landroidx/compose/ui/layout/IntrinsicMinMax;Landroidx/compose/ui/layout/IntrinsicWidthHeight;)V", "getMeasurable", "()Landroidx/compose/ui/layout/IntrinsicMeasurable;", "getMinMax", "()Landroidx/compose/ui/layout/IntrinsicMinMax;", "getWidthHeight", "()Landroidx/compose/ui/layout/IntrinsicWidthHeight;", "parentData", "", "getParentData", "()Ljava/lang/Object;", "measure", "Landroidx/compose/ui/layout/Placeable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "minIntrinsicWidth", "", "height", "maxIntrinsicWidth", "minIntrinsicHeight", "width", "maxIntrinsicHeight", "fleet.noria.ui"})
public final class DefaultIntrinsicMeasurable
implements Measurable {
    @NotNull
    private final IntrinsicMeasurable measurable;
    @NotNull
    private final IntrinsicMinMax minMax;
    @NotNull
    private final IntrinsicWidthHeight widthHeight;

    public DefaultIntrinsicMeasurable(@NotNull IntrinsicMeasurable measurable, @NotNull IntrinsicMinMax minMax, @NotNull IntrinsicWidthHeight widthHeight) {
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Intrinsics.checkNotNullParameter((Object)((Object)minMax), (String)"minMax");
        Intrinsics.checkNotNullParameter((Object)((Object)widthHeight), (String)"widthHeight");
        this.measurable = measurable;
        this.minMax = minMax;
        this.widthHeight = widthHeight;
    }

    @NotNull
    public final IntrinsicMeasurable getMeasurable() {
        return this.measurable;
    }

    @NotNull
    public final IntrinsicMinMax getMinMax() {
        return this.minMax;
    }

    @NotNull
    public final IntrinsicWidthHeight getWidthHeight() {
        return this.widthHeight;
    }

    @Override
    @Nullable
    public Object getParentData() {
        return this.measurable.getParentData();
    }

    @Override
    @NotNull
    public Placeable measure(@NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (this.widthHeight == IntrinsicWidthHeight.Width) {
            int width2 = this.minMax == IntrinsicMinMax.Max ? this.measurable.maxIntrinsicWidth(constraints.getMaxHeight()) : this.measurable.minIntrinsicWidth(constraints.getMaxHeight());
            return new FixedSizeIntrinsicsPlaceable(width2, constraints.getMaxHeight());
        }
        int height2 = this.minMax == IntrinsicMinMax.Max ? this.measurable.maxIntrinsicHeight(constraints.getMaxWidth()) : this.measurable.minIntrinsicHeight(constraints.getMaxWidth());
        return new FixedSizeIntrinsicsPlaceable(constraints.getMaxWidth(), height2);
    }

    @Override
    public int minIntrinsicWidth(int height2) {
        return this.measurable.minIntrinsicWidth(height2);
    }

    @Override
    public int maxIntrinsicWidth(int height2) {
        return this.measurable.maxIntrinsicWidth(height2);
    }

    @Override
    public int minIntrinsicHeight(int width2) {
        return this.measurable.minIntrinsicHeight(width2);
    }

    @Override
    public int maxIntrinsicHeight(int width2) {
        return this.measurable.maxIntrinsicHeight(width2);
    }
}

