/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.VelocityTrackerKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u001d\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0012J$\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D;", "", "isDataDifferential", "", "strategy", "Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "<init>", "(ZLandroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;)V", "(Z)V", "()Z", "minSampleSize", "", "samples", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "[Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "addDataPoint", "", "timeMillis", "", "dataPoint", "", "calculateVelocity", "resetTracking", "calculateLeastSquaresVelocity", "dataPoints", "", "time", "Strategy", "fleet.noria.ui"})
public final class VelocityTracker1D {
    private final boolean isDataDifferential;
    @NotNull
    private final Strategy strategy;
    private final int minSampleSize;
    @NotNull
    private final DataPointAtTime[] samples;
    private int index;

    public VelocityTracker1D(boolean isDataDifferential, @NotNull Strategy strategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        this.isDataDifferential = isDataDifferential;
        this.strategy = strategy;
        if (this.isDataDifferential && this.strategy.equals((Object)Strategy.Lsq2)) {
            throw new IllegalStateException("Lsq2 not (yet) supported for differential axes");
        }
        this.minSampleSize = switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
            case 1 -> 2;
            case 2 -> 3;
            default -> throw new NoWhenBranchMatchedException();
        };
        int n = 0;
        DataPointAtTime[] dataPointAtTimeArray = new DataPointAtTime[20];
        VelocityTracker1D velocityTracker1D = this;
        while (n < 20) {
            int n2 = n++;
            dataPointAtTimeArray[n2] = null;
        }
        velocityTracker1D.samples = dataPointAtTimeArray;
    }

    public /* synthetic */ VelocityTracker1D(boolean bl, Strategy strategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            strategy = Strategy.Lsq2;
        }
        this(bl, strategy);
    }

    public final boolean isDataDifferential() {
        return this.isDataDifferential;
    }

    public VelocityTracker1D(boolean isDataDifferential) {
        this(isDataDifferential, Strategy.Impulse);
    }

    public final void addDataPoint(long timeMillis, float dataPoint) {
        this.index = (this.index + 1) % 20;
        VelocityTrackerKt.access$set(this.samples, this.index, timeMillis, dataPoint);
    }

    public final float calculateVelocity() {
        DataPointAtTime newestSample;
        List dataPoints = new ArrayList();
        List time = new ArrayList();
        int sampleCount = 0;
        int index2 = this.index;
        DataPointAtTime dataPointAtTime = this.samples[index2];
        if (dataPointAtTime == null) {
            return 0.0f;
        }
        DataPointAtTime previousSample = newestSample = dataPointAtTime;
        while (this.samples[index2] != null) {
            DataPointAtTime sample;
            float age = newestSample.getTime() - sample.getTime();
            float delta = Math.abs(sample.getTime() - previousSample.getTime());
            previousSample = sample;
            if (age > 100.0f || delta > 40.0f) break;
            dataPoints.add(Float.valueOf(sample.getDataPoint()));
            time.add(Float.valueOf(-age));
            index2 = (index2 == 0 ? 20 : index2) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount >= this.minSampleSize) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.strategy.ordinal()]) {
                case 1 -> VelocityTrackerKt.access$calculateImpulseVelocity(dataPoints, time, this.isDataDifferential) * (float)1000;
                case 2 -> this.calculateLeastSquaresVelocity(dataPoints, time) * (float)1000;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return 0.0f;
    }

    public final void resetTracking() {
        ArraysKt.fill$default((Object[])this.samples, null, (int)0, (int)0, (int)6, null);
        this.index = 0;
    }

    private final float calculateLeastSquaresVelocity(List<Float> dataPoints, List<Float> time) {
        try {
            return ((Number)VelocityTrackerKt.polyFitLeastSquares(time, dataPoints, 2).get(1)).floatValue();
        }
        catch (IllegalArgumentException exception) {
            return 0.0f;
        }
    }

    public VelocityTracker1D() {
        this(false, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/compose/ui/input/pointer/util/VelocityTracker1D$Strategy;", "", "<init>", "(Ljava/lang/String;I)V", "Lsq2", "Impulse", "fleet.noria.ui"})
    public static final class Strategy
    extends Enum<Strategy> {
        public static final /* enum */ Strategy Lsq2 = new Strategy();
        public static final /* enum */ Strategy Impulse = new Strategy();
        private static final /* synthetic */ Strategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Strategy[] values() {
            return (Strategy[])$VALUES.clone();
        }

        public static Strategy valueOf(String value2) {
            return Enum.valueOf(Strategy.class, value2);
        }

        @NotNull
        public static EnumEntries<Strategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = strategyArray = new Strategy[]{Strategy.Lsq2, Strategy.Impulse};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Strategy.values().length];
            try {
                nArray[Strategy.Impulse.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Strategy.Lsq2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

